/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicElement;
import org.gvsig.sldsupport.impl.sld.parsing.ParameterValueElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicStroke;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GraphicStrokeElement {
    public static void append(SLDGraphicStroke obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("GraphicStroke");
        if (obj.getGraphic() == null) {
            throw new InvalidSLDObjectException("GraphicStroke", "No graphic found.");
        }
        GraphicElement.append(obj.getGraphic(), xb, version);
        if (version != null && version.compareToIgnoreCase("1.1.0") == 0) {
            if (obj.getGap() != null) {
                ParameterValueElement.append("Gap", obj.getGap(), xb, version);
            }
            if (obj.getInitialGap() != null) {
                ParameterValueElement.append("InitialGap", obj.getInitialGap(), xb, version);
            }
        }
        xb.closeTag();
    }

    public static SLDGraphicStroke parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "GraphicStroke");
        int tag = 0;
        SLDGraphicStroke resp = new SLDGraphicStroke();
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, "GraphicStroke") || tag != 3) {
            switch (tag) {
                case 2: {
                    SLDParameterValue sp;
                    if (SLDUtils.isStr(name, "Graphic")) {
                        SLDGraphic gra = GraphicElement.parse(parser, version);
                        resp.setGraphic(gra);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Gap")) {
                        sp = ParameterValueElement.parse(parser, version);
                        resp.setGap(sp);
                        break;
                    }
                    if (SLDUtils.isStr(name, "InitialGap")) {
                        sp = ParameterValueElement.parse(parser, version);
                        resp.setInitialGap(sp);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in graphic stroke: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

