/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.LayerFeatureConstraintsElement;
import org.gvsig.sldsupport.impl.sld.parsing.RemoteOWSElement;
import org.gvsig.sldsupport.impl.sld.parsing.UserStyleElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.constraints.SLDLayerFeatureConstraints;
import org.gvsig.sldsupport.sld.layer.SLDUserLayer;
import org.gvsig.sldsupport.sld.ows.SLDRemoteOWS;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UserLayerElement {
    public static void append(SLDUserLayer obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("UserLayer");
        if (obj.getName() != null) {
            xb.writeTag("Name", obj.getName());
        }
        if (obj.getRemoteOWS() != null) {
            RemoteOWSElement.append(obj.getRemoteOWS(), xb, version);
        }
        if (obj.getLayerFeatureConstraints() == null) {
            throw new InvalidSLDObjectException("UserLayer", "LayerFeatureConstraints not found");
        }
        LayerFeatureConstraintsElement.append(obj.getLayerFeatureConstraints(), xb, version);
        List stys = obj.getStyles();
        if (stys == null || stys.size() == 0) {
            throw new InvalidSLDObjectException("UserLayer", "No styles found");
        }
        for (int i = 0; i < stys.size(); ++i) {
            UserStyleElement.append((SLDUserStyle)stys.get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDUserLayer parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "UserLayer");
        int tag = 0;
        SLDUserLayer resp = new SLDUserLayer();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "UserLayer") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Name")) {
                        txt = parser.nextText();
                        resp.setName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "RemoteOWS")) {
                        SLDRemoteOWS ows = RemoteOWSElement.parse(parser, version);
                        resp.setRemoteOWS(ows);
                        break;
                    }
                    if (SLDUtils.isStr(name, "LayerFeatureConstraints")) {
                        SLDLayerFeatureConstraints cons = null;
                        cons = LayerFeatureConstraintsElement.parse(parser, version);
                        resp.setLayerFeatureConstraints(cons);
                        break;
                    }
                    if (SLDUtils.isStr(name, "UserStyle")) {
                        SLDUserStyle usty = UserStyleElement.parse(parser, version);
                        resp.getStyles().add(usty);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in user layer: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

