/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.expression;

import java.io.IOException;
import java.util.HashMap;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.expression.ExpressionElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDFunction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FunctionElement {
    public static void append(SLDFunction obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("name", obj.getFunctionName());
        xb.openTag("Function", atts);
        for (int i = 0; i < obj.getArguments().size(); ++i) {
            ExpressionElement.append((SLDExpression)obj.getArguments().get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDFunction parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Function");
        String fname = parser.getAttributeValue(null, "name");
        if (fname == null) {
            throw new SLDReadException("Attribute 'name' not found in SLD function");
        }
        SLDFunction resp = new SLDFunction();
        resp.setFunctionName(fname);
        int tag = parser.nextTag();
        String name = parser.getName();
        SLDExpression expre = null;
        while (!SLDUtils.isStr(name, "Function") || tag != 3) {
            expre = ExpressionElement.parse(parser, version);
            resp.getArguments().add(expre);
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

