/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.filteroperator.logic;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.FilterOperatorElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.operator.logic.SLDBinaryLogicOperator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryLogicOperatorElement {
    public static void append(SLDBinaryLogicOperator obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag(obj.getBinaryOperatorType());
        List list = obj.getOperators();
        if (list == null || list.size() < 2) {
            throw new InvalidSLDObjectException(obj.getBinaryOperatorType(), "Binary operator needs at least 2 operands");
        }
        for (int i = 0; i < list.size(); ++i) {
            FilterOperatorElement.append((SLDFilterOperator)obj.getOperators().get(i), xb, version);
        }
        xb.closeTag();
    }

    public static SLDBinaryLogicOperator parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        SLDBinaryLogicOperator resp = new SLDBinaryLogicOperator();
        String txt = parser.getName();
        resp.setBinaryOperatorType(txt);
        int tag = 0;
        tag = parser.nextTag();
        String name = parser.getName();
        SLDFilterOperator foper = null;
        while (!SLDUtils.isStr(name, resp.getBinaryOperatorType()) || tag != 3) {
            switch (tag) {
                case 2: {
                    foper = FilterOperatorElement.parse(parser, version);
                    resp.getOperators().add(foper);
                    break;
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        if (resp.getOperators().size() < 2) {
            throw new SLDReadException("Binary operator must have at least 2 elements, found: " + resp.getOperators().size());
        }
        parser.nextTag();
        return resp;
    }
}

