/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.filteroperator.logic;

import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.FilterOperatorElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.gvsig.sldsupport.sld.filter.operator.logic.SLDUnaryLogicOperator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UnaryLogicOperatorElement {
    public static void append(SLDUnaryLogicOperator obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag(obj.getOperatorType());
        if (obj.getOperator() == null) {
            throw new InvalidSLDObjectException(obj.getOperatorType(), "No operand found in unary operator");
        }
        FilterOperatorElement.append(obj.getOperator(), xb, version);
        xb.closeTag();
    }

    public static SLDUnaryLogicOperator parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        SLDUnaryLogicOperator resp = new SLDUnaryLogicOperator();
        String op_type = parser.getName();
        if (!SLDUtils.isStr(op_type, "Not")) {
            throw new SLDReadException("Unknwon unary operator: " + op_type);
        }
        resp.setOperatorType("Not");
        parser.nextTag();
        SLDFilterOperator foper = FilterOperatorElement.parse(parser, version);
        resp.setOperator(foper);
        parser.require(3, null, "Not");
        parser.nextTag();
        return resp;
    }
}

