/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.symbol;

import java.io.IOException;
import java.util.Map;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GeometryElement;
import org.gvsig.sldsupport.impl.sld.parsing.ParameterValueElement;
import org.gvsig.sldsupport.impl.sld.parsing.StrokeElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.symbol.SLDLineSymbol;
import org.gvsig.sldsupport.sld.symbol.misc.SLDGeometry;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LineSymbolElement {
    public static void append(SLDLineSymbol obj, XmlBuilder xb, Map<String, String> atts) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        SLDParameterValue pv;
        SLDStroke stro;
        String v = obj.getVersion();
        if (v == null && atts != null) {
            v = atts.get("version");
        }
        if (v == null) {
            v = "1.0.0";
        }
        String ent = "";
        ent = v.compareToIgnoreCase("1.0.0") == 0 ? "LineSymbolizer" : "LineSymbol";
        if (atts == null) {
            xb.openTag(ent);
        } else {
            xb.openTag(ent, atts);
        }
        String gn = obj.getGeometryPropertyName();
        if (gn != null) {
            GeometryElement.append(new SLDGeometry(gn), xb, v);
        }
        if ((stro = obj.getStroke()) != null) {
            StrokeElement.append(stro, xb, v);
        }
        if (v.compareToIgnoreCase("1.1.0") == 0 && (pv = obj.getPerpendicularOffset()) != null) {
            ParameterValueElement.append("PerpendicularOffset", pv, xb, v);
        }
        xb.closeTag();
    }

    public static SLDLineSymbol parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String ent_name = parser.getName();
        SLDLineSymbol resp = new SLDLineSymbol();
        resp.setVersion(version);
        int tag = 0;
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        while (!SLDUtils.isStr(name, ent_name) || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Geometry")) {
                        SLDGeometry geom = GeometryElement.parse(parser, version);
                        resp.setGeometryPropertyName(geom.getPropertyName());
                        break;
                    }
                    if (SLDUtils.isStr(name, "Stroke")) {
                        SLDStroke st = StrokeElement.parse(parser, version);
                        resp.setStroke(st);
                        break;
                    }
                    if (SLDUtils.isStr(name, "PerpendicularOffset")) {
                        resp.setVersion("1.1.0");
                        SLDParameterValue pv = ParameterValueElement.parse(parser, version);
                        resp.setPerpendicularOffset(pv);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in line symbol: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

