/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.regularpolygon;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.regularpolygon.RegularPolygonEditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class FilledRegularPolygonEditingProvider
extends RegularPolygonEditingProvider
implements EditingProvider {
    public FilledRegularPolygonEditingProvider(DynObject services, ProviderServices parameters) {
        super(parameters, services);
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            Integer sidesValue = (Integer)this.values.get(this.polygonSides);
            String modeValue = (String)this.values.get(this.mode);
            Point centerValue = (Point)this.values.get(this.center);
            Point pointOfCircleValue = (Point)this.values.get(this.pointOfCircle);
            try {
                Polygon polygon = this.calculateFilledPolygon(modeValue, centerValue, pointOfCircleValue, sidesValue);
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)polygon);
            }
            catch (Exception e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        return null;
    }

    private Polygon calculateFilledPolygon(String modeValue, Point centerValue, Point pointOfCircleValue, int sides) throws BaseException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        Polygon filledPolygon = GeometryLocator.getGeometryManager().createPolygon(subtype);
        Curve polygon = this.calculateRegularPolygon(modeValue, centerValue, pointOfCircleValue, sides);
        if (polygon == null) {
            return null;
        }
        Object vertexAnt = null;
        for (int i = 0; i < polygon.getNumVertices(); ++i) {
            if (vertexAnt != null && vertexAnt.equals(polygon.getVertex(i))) continue;
            filledPolygon.addVertex(polygon.getVertex(i));
            vertexAnt = filledPolygon.getVertex(i);
        }
        filledPolygon = (Polygon)this.closeGeometry((Geometry)filledPolygon);
        return filledPolygon;
    }

    @Override
    public String getName() {
        return "insert-filled-regular-polygon";
    }
}

