/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.geo;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.geo.Projected;
import org.cresques.px.Extent;

public class ViewPortData
implements Projected {
    IProjection proj = null;
    IProjection cs = null;
    Extent extent = null;
    Dimension size = null;
    public AffineTransform mat = null;
    int dpi = Toolkit.getDefaultToolkit().getScreenResolution();

    public ViewPortData() {
    }

    public ViewPortData(IProjection proj, Extent extent, Dimension size) {
        this.proj = proj;
        this.extent = extent;
        this.size = size;
        this.mat = new AffineTransform();
        this.mat.scale(1.0, -1.0);
    }

    @Override
    public IProjection getProjection() {
        return this.proj;
    }

    public void setProjection(IProjection proj) {
        this.proj = proj;
    }

    @Override
    public void reProject(ICoordTrans rp) {
    }

    public void setCoordSys(IProjection cs) {
        this.cs = cs;
    }

    public AffineTransform getMat() {
        return this.mat;
    }

    public void setMat(AffineTransform mat) {
        this.mat = mat;
    }

    public Object clone() {
        ViewPortData vp = new ViewPortData();
        if (this.mat != null) {
            vp.mat = new AffineTransform(this.mat);
        }
        if (this.extent != null) {
            vp.extent = new Extent(this.extent);
        }
        vp.proj = this.proj;
        vp.size = this.size;
        vp.dpi = this.dpi;
        return vp;
    }

    public double getWidth() {
        return this.size.width;
    }

    public double getHeight() {
        return this.size.height;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(double w, double h) {
        this.setSize(new Dimension((int)w, (int)h));
    }

    public void setSize(Dimension sz) {
        this.size = sz;
        this.reExtent();
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Dimension sz) {
        Point2D.Double pt0 = new Point2D.Double(0.0, 0.0);
        Point2D.Double ptSz = new Point2D.Double(sz.width, sz.height);
        try {
            this.mat.inverseTransform(pt0, pt0);
            this.mat.inverseTransform(ptSz, ptSz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.extent = new Extent(pt0, ptSz);
    }

    public void reExtent() {
        this.setExtent(this.size);
    }

    public void setDPI(int dpi) {
        this.dpi = dpi;
    }

    public int getDPI() {
        return this.dpi;
    }

    public void zoom(Extent extent) {
        double[] scale = extent.getScale(this.getWidth(), this.getHeight());
        double escala = Math.min(scale[0], scale[1]);
        this.mat.setToIdentity();
        this.mat.scale(escala, -escala);
        this.mat.translate(-extent.minX(), -extent.maxY());
        this.extent = extent;
        this.reExtent();
    }

    public void zoom(double zoom, Point2D pt) {
        this.zoom(zoom, zoom, pt);
    }

    public void zoom(double zx, double zy, Point2D pt) {
        this.centerAt(pt);
        this.mat.scale(zx, zy);
        this.centerAt(pt);
        this.reExtent();
    }

    public void zoomToGeoScale(double scale) {
        double actual = this.getGeoScale();
        double f = actual / scale;
        this.zoomToCenter(f);
    }

    public void zoomToCenter(double f) {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.zoom(f, ptCenter);
    }

    public void centerAt(Point2D pt) {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
            this.mat.translate(ptCenter.x - pt.getX(), ptCenter.y - pt.getY());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reExtent();
    }

    public void pan(Point2D ptIni, Point2D ptFin) {
        this.mat.translate(ptFin.getX() - ptIni.getX(), ptFin.getY() - ptIni.getY());
        this.reExtent();
    }

    public Point2D getCenter() {
        Point2D.Double ptCenter = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        try {
            this.mat.inverseTransform(ptCenter, ptCenter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ptCenter;
    }

    public double getGeoScale() {
        return this.proj.getScale(this.extent.minX(), this.extent.maxX(), this.getWidth(), this.dpi);
    }

    public String getGeoScaleAsString(String fmt) {
        DecimalFormat format = new DecimalFormat(fmt);
        return "1:" + format.format(this.getGeoScale());
    }
}

