/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PageOffsets;
import org.jpedal.PdfPanel;
import org.jpedal.SingleDisplay;
import org.jpedal.color.ColorSpaces;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseHandler;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.external.CustomPrintHintingHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.JPedalHelper;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.rendering.DefaultAcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.MEUtils;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.w3c.dom.Document;

public class PdfDecoder
extends PdfPanel
implements Printable,
Pageable {
    static final boolean debugLinearization = false;
    private static boolean java3DAvailable = true;
    private static boolean java3DTested = false;
    public static boolean usePageFlow3D = true;
    private int E = -1;
    private static final long serialVersionUID = 1107156907326450528L;
    public static final String version = "4.37b36-OS";
    public static boolean debugHiRes = false;
    public static final boolean optimiseType3Rendering = false;
    private PageObject linObject = null;
    private Map linObjects = new Hashtable();
    boolean converToRGB = false;
    int mouseMode = 0;
    boolean isLinearizationTested = false;
    PdfObject linearObj = null;
    private int tempPageCount;
    public static JPedalHelper Helper = null;
    public static final int MOUSE_MODE_TEXT_SELECT = 0;
    public static final int MOUSE_MODE_PANNING = 1;
    private int logicalPageOffset = 0;
    ScrollListener scrollListener;
    private boolean allowDifferentPrintPageSizes = false;
    private int OCpageNumber = -1;
    boolean oldSetup = false;
    boolean useARGBFix = true;
    private DPIFactory scalingdpi = new DPIFactory();
    boolean docIsLandscaped = false;
    boolean printOnlyVisible = false;
    private int duplexGapEven = 0;
    private int duplexGapOdd = 0;
    private boolean isPDf = false;
    private boolean isMultiPageTiff = false;
    private final Map overlayType = new HashMap();
    private final Map overlayColors = new HashMap();
    private final Map overlayObj = new HashMap();
    private final Map overlayTypeG = new HashMap();
    private final Map overlayColorsG = new HashMap();
    private final Map overlayObjG = new HashMap();
    private Javascript javascript = null;
    ImageHandler customImageHandler = null;
    ColorHandler customColorHandler = null;
    CustomMessageHandler customMessageHandler = null;
    CustomPrintHintingHandler customPrintHintingHandler = null;
    Object swingGUI = null;
    PdfObjectReader currentPdfFile;
    private static boolean debugFonts = false;
    private static Integer bestQualityMaxScaling = null;
    private Integer instance_bestQualityMaxScaling = null;
    private static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    private int[] instance_formsNoPrint = null;
    private static int[] formsNoPrint = null;
    private static String[] extactionPageSize = null;
    private String[] instance_extactionPageSize = null;
    private static Boolean overridePageSize = null;
    private Boolean instance_overridePageSize = null;
    private Boolean instance_allowPagesSmallerThanPageSize = Boolean.FALSE;
    private Iterator colorSpacesUsed;
    private PageLookup pageLookup = new PageLookup();
    private boolean isBackgroundDecoding = false;
    private OutlineData outlineData = null;
    PdfObject metadataObj = null;
    PdfObject nameObj = null;
    PdfObject structTreeRootObj = null;
    PdfObject markInfoObj = null;
    PdfObject acroFormObj = null;
    PdfObject OutlinesObj = null;
    PdfObject PropertiesObj = null;
    PdfObject OCProperties = null;
    private final MarkedContentGenerator content = new MarkedContentGenerator();
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    public static PdfHeightTable currentHeightLookupData = null;
    public static boolean isRunningOnMac = false;
    public static boolean isRunningOnWindows = false;
    public static boolean isRunningOnAIX = false;
    public static boolean isRunningOnLinux = false;
    public static float javaVersion = 0.0f;
    public static boolean clipOnMac = false;
    public static boolean debugPrint = false;
    private boolean hasViewListener = false;
    private RefreshLayout viewListener = new RefreshLayout();
    private boolean oddPagesOnly = false;
    private boolean evenPagesOnly = false;
    private boolean pagesPrintedInReverse = false;
    private boolean stopPrinting = false;
    private String pdfVersion = "";
    private int lastWidth;
    private int lastPage;
    public static boolean isDraft = true;
    private Graphics2D g2 = null;
    private boolean hasEmbeddedFonts = false;
    LinearizedHintTable linHintTable = null;
    private String fontsInFile = "";
    public static int dpi = 72;
    public static boolean embedWidthData = false;
    private boolean hasOutline = false;
    private int start = 0;
    private int end = -1;
    public static final boolean inDemo = false;
    private float multiplyer = 1.0f;
    public static boolean hires = false;
    private PdfStreamDecoder currentPrintDecoder = null;
    private DynamicVectorRenderer printRender = null;
    private int lastPrintedPage = -1;
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int COLOR = 512;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    public static final int REMOVE_RENDERSHAPES = 16;
    public static final int OCR_PDF = 32;
    private int extractionMode = 7;
    protected int renderMode = 7;
    private PdfStreamDecoder current;
    private PdfStreamDecoder currentImageDecoder;
    Map pagesReferences = new Hashtable();
    PdfObject globalResources;
    public static boolean enforceFontSubstitution = false;
    private boolean showImageable = false;
    public static String defaultFont = null;
    private Map pageFormats = new Hashtable();
    private static final String separator = System.getProperty("file.separator");
    private static boolean isXMLExtraction = true;
    private StatusBar statusBar = null;
    private boolean usePageScaling = false;
    boolean useHiResImageForDisplay = false;
    private boolean operationSuccessful = true;
    private String pageErrorMessages = "";
    String filename;
    private ObjectStore backgroundObjectStoreRef = new ObjectStore();
    private SetOfIntegerSyntax range;
    private int[] listOfPages;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int TEXTSTRINGPRINT = 2;
    public static final int STANDARDTEXTSTRINGPRINT = 3;
    private LinearThread linearizedBackgroundReaderer = null;
    private int lastPageDecoded = -1;
    private boolean isCustomPrinting = false;
    public static final int SUBSTITUTE_FONT_USING_FILE_NAME = 1;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME = 2;
    public static final int SUBSTITUTE_FONT_USING_FAMILY_NAME = 3;
    public static final int SUBSTITUTE_FONT_USING_FULL_FONT_NAME = 4;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME_USE_FAMILY_NAME_IF_DUPLICATES = 5;
    private static int fontSubstitutionMode = 1;
    ObjectStore objectPrintStoreRef = new ObjectStore();
    public static final int BORDER_SHOW = 1;
    public static final int BORDER_HIDE = 0;
    public static int CURRENT_BORDER_STYLE = 1;
    public static boolean showErrorMessages;
    protected int specialMode = -1;
    private boolean isOpen = false;
    private int textPrint = 0;
    private int minimumCacheSize = -1;
    String decodeStatus = "";
    private int currentPrintPage = 0;
    private boolean imagesProcessedFully = true;
    private boolean hasNonEmbeddedCIDFonts;
    private boolean hasYCCKimages;
    private boolean ttHintingRequired;
    private boolean timeout = false;
    private String nonEmbeddedCIDFonts = "";
    private Object customSwingHandle;
    private CustomFormPrint customFormPrint;
    private Object userExpressionEngine;
    private boolean generateGlyphOnRender;
    private boolean thumbnailsBeingDrawn;
    private float oldScaling = -1.0f;
    private boolean useJavascript = true;
    private boolean centerOnScaling = true;
    BufferedImage printImage = null;
    private int printScale = 4;
    private int pageMode = 1;
    private Map jpedalActionHandlers;

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int n) {
        this.mouseMode = n;
    }

    public void setAllowDifferentPrintPageSizes(boolean bl) {
        this.allowDifferentPrintPageSizes = bl;
    }

    public int getPageFromObjectRef(String string) {
        return this.pageLookup.convertObjectToPageNumber(string);
    }

    public static void setBorderStyle(int n) {
        CURRENT_BORDER_STYLE = n;
    }

    public static int getBorderStyle() {
        return CURRENT_BORDER_STYLE;
    }

    protected void setMultiPageOffsets(int[] nArray, int[] nArray2) {
        if (this.formRenderer != null) {
            this.formRenderer.getCompData().setPageDisplacements(nArray, nArray2);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Document getMarkedContent() {
        this.content.setRootValues(this.structTreeRootObj, this.markInfoObj);
        return this.content.getMarkedContentTree(this.currentPdfFile, this, this.pageLookup);
    }

    public void setPageData(PdfPageData pdfPageData) {
        this.pageData = pdfPageData;
    }

    public void addAdditionalPage(DynamicVectorRenderer dynamicVectorRenderer, int n, int n2) {
        this.pages.addAdditionalPage(dynamicVectorRenderer, n, n2);
        if (this.additionalPageCount == 0) {
            this.lastWidth = this.xOffset + n2;
            this.xOffset += n;
        } else {
            this.xOffset += n;
            this.lastWidth += this.lastPage;
        }
        ++this.additionalPageCount;
        this.lastPage = n;
        this.updateUI();
    }

    public int getXDisplacement() {
        return this.lastWidth;
    }

    public int getAdditionalPageCount() {
        return this.additionalPageCount;
    }

    public void updatePageNumberDisplayed(int n) {
        if (n != -1 && this.customSwingHandle != null) {
            ((GUIFactory)this.customSwingHandle).setPage(n);
        }
    }

    public int getlastPageDecoded() {
        return this.lastPageDecoded;
    }

    public void setlastPageDecoded(int n) {
        this.lastPageDecoded = n;
    }

    public void setupPage(PdfStreamDecoder pdfStreamDecoder, boolean bl) {
        try {
            if (this.nameObj != null) {
                this.currentPdfFile.readNames(this.nameObj, this.javascript, false);
                this.nameObj = null;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception reading Names  " + this.objectStoreRef.fullFileName);
        }
        if (this.OCProperties != null && (this.pageNumber != this.OCpageNumber || bl)) {
            this.currentPdfFile.checkResolved(this.OCProperties);
            if (this.layers == null) {
                this.layers = new PdfLayerList();
            }
            this.layers.init(this.OCProperties, this.PropertiesObj, this.currentPdfFile);
            this.OCpageNumber = this.pageNumber;
        }
        pdfStreamDecoder.setLayers(this.layers);
    }

    public static boolean isHires() {
        return hires;
    }

    public Iterator getPageInfo(int n) {
        switch (n) {
            case 1: {
                return this.colorSpacesUsed;
            }
        }
        return null;
    }

    public void resetFormsForPageFlow(int n) {
        if (this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
            this.add((Component)this.scroll, "South");
            this.lastFormPage = -1;
            this.formRenderer.displayComponentsOnscreen(n, n);
            if (this.formRenderer.getCompData().getStartComponentCountForPage(n) != -1) {
                this.lastFormPage = n;
            }
        }
    }

    public OutlineData getOutlineData() {
        return this.outlineData;
    }

    public boolean isLoadingLinearizedPDF() {
        return false;
    }

    public static void setSubstitutedFontAliases(String string, String[] stringArray) {
        if (stringArray != null) {
            String string2 = string.toLowerCase();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[i].toLowerCase();
                if (string3.equals(string2)) continue;
                FontMappings.fontSubstitutionAliasTable.put(string3, string2);
            }
        }
    }

    private static String addFonts(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.endsWith("/") & !string3.endsWith("\\")) {
                string3 = string3 + separator;
            }
            PdfDecoder.addTTDir(string3, string2);
        }
        return string2;
    }

    public void resetViewableArea() {
        if (this.viewableArea != null) {
            this.viewableArea = null;
            this.setPageRotation(this.displayRotation);
            this.repaint();
        }
    }

    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        if (rectangle != null) {
            double d = rectangle.getX();
            double d2 = rectangle.getY();
            double d3 = rectangle.getWidth();
            double d4 = rectangle.getHeight();
            double d5 = this.pageData.getCropBoxWidth(this.pageNumber);
            double d6 = this.pageData.getCropBoxHeight(this.pageNumber);
            if (d < 0.0 || d2 < 0.0 || d + d3 > d5 || d2 + d4 > d6) {
                throw new PdfException("Viewport is not totally enclosed within displayed panel.");
            }
            if (d5 != d3 || d6 != d4) {
                this.viewableArea = rectangle;
                this.currentDisplay.setOptimiseDrawing(false);
                this.setPageRotation(this.displayRotation);
                this.repaint();
            }
        } else {
            this.resetViewableArea();
        }
        return this.viewScaling;
    }

    public static String setFontDirs(String[] stringArray) {
        String string = null;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        try {
            if (stringArray == null) {
                LogWriter.writeLog("Null font parameter passed");
                FontMappings.fontSubstitutionAliasTable.clear();
                FontMappings.fontSubstitutionLocation.clear();
                FontMappings.fontSubstitutionTable.clear();
                FontMappings.fontSubstitutionFontID.clear();
                FontMappings.fontPossDuplicates.clear();
                FontMappings.fontPropertiesTable.clear();
            } else {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = stringArray[i];
                    if (!string2.endsWith("/") & !string2.endsWith("\\")) {
                        string2 = string2 + separator;
                    }
                    if (debugFonts) {
                        System.out.println("Looking in " + string2 + " for fonts");
                    }
                    string = PdfDecoder.addTTDir(string2, string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to run setFontDirs " + exception.getMessage());
        }
        return string;
    }

    private static String addTTDir(String string, String string2) {
        File file;
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if ((file = new File(string)).exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray[i];
                    PdfDecoder.addFontFile(string3, string);
                }
            }
        } else {
            string2 = string2 == null ? string : string2 + ',' + string;
        }
        return string2;
    }

    public static void setFontSubstitutionMode(int n) {
        fontSubstitutionMode = n;
    }

    public static int getFontSubstitutionMode() {
        return fontSubstitutionMode;
    }

    public static void addFontFile(String string, String string2) {
        if (FontMappings.fontSubstitutionTable == null) {
            FontMappings.fontSubstitutionTable = new HashMap();
            FontMappings.fontSubstitutionFontID = new HashMap();
            FontMappings.fontPossDuplicates = new HashMap();
            FontMappings.fontPropertiesTable = new HashMap();
        }
        if (string2 != null && !string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + separator;
        }
        String string3 = string.toLowerCase();
        int n = StandardFonts.getFontType(string3);
        if (debugFonts) {
            System.out.println(n + " " + string3);
        }
        if (n != 8) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string2 + string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                fileInputStream = null;
            }
            catch (Error error) {
                error.printStackTrace();
                fileInputStream = null;
            }
            if (fileInputStream != null) {
                int n2 = string.indexOf(46);
                String string4 = n2 == -1 ? string.toLowerCase() : string.substring(0, n2).toLowerCase();
                if (debugFonts) {
                    System.out.println("Looking at  " + string4 + " fontSubstitutionMode=" + fontSubstitutionMode);
                }
                if (fontSubstitutionMode == 1 || n == 6) {
                    if (n == 1228944677) {
                        FontMappings.fontSubstitutionTable.put(string4, "/Type1");
                    } else {
                        FontMappings.fontSubstitutionTable.put(string4, "/TrueType");
                    }
                    FontMappings.fontSubstitutionLocation.put(string4, string2 + string);
                    FontMappings.fontPropertiesTable.put(string4 + "_type", new Integer(n));
                    FontMappings.fontPropertiesTable.put(string4 + "_path", string2 + string);
                    if (debugFonts) {
                        System.out.println("Added  PdfDecoder.SUBSTITUTE_FONT_USING_FILE_NAME " + StandardFonts.getFontDetails(n, string2 + string));
                    }
                } else if (n == 7 || n == 1217103210) {
                    if (fontSubstitutionMode == 5) {
                        String[] stringArray = null;
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, 2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        String[] stringArray2 = null;
                        try {
                            stringArray2 = StandardFonts.readNamesFromFont(n, string2 + string, 3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        int n3 = 0;
                        if (stringArray != null) {
                            n3 = stringArray.length;
                        }
                        for (int i = 0; i < n3; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            if (stringArray2[i] == null) {
                                stringArray2[i] = Strip.stripAllSpaces(string4);
                            }
                            Object v = FontMappings.fontSubstitutionTable.get(stringArray[i]);
                            Object v2 = FontMappings.fontPossDuplicates.get(stringArray[i]);
                            if (v == null && v2 == null) {
                                FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                                FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                                FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                                FontMappings.fontPossDuplicates.put(stringArray[i], stringArray2[i]);
                                if (!debugFonts) continue;
                                System.out.println("Added  2");
                                continue;
                            }
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            FontMappings.fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                            FontMappings.fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            if (debugFonts) {
                                System.out.println("Added  3");
                            }
                            if (v2.equals("DONE")) continue;
                            FontMappings.fontPossDuplicates.put(stringArray[i], "DONE");
                            FontMappings.fontSubstitutionTable.remove(stringArray[i]);
                            FontMappings.fontSubstitutionTable.put(stringArray2[i], "/TrueType");
                            String string5 = (String)FontMappings.fontSubstitutionLocation.get(stringArray[i]);
                            FontMappings.fontSubstitutionLocation.remove(stringArray[i]);
                            FontMappings.fontSubstitutionLocation.put(stringArray2[i], string5);
                            FontMappings.fontSubstitutionFontID.remove(stringArray[i]);
                            FontMappings.fontSubstitutionFontID.put(stringArray2[i], new Integer(i));
                            FontMappings.fontPropertiesTable.remove(stringArray2[i] + "_path");
                            FontMappings.fontPropertiesTable.remove(stringArray2[i] + "_type");
                            FontMappings.fontPropertiesTable.put(stringArray2[i] + "_type", new Integer(n));
                            FontMappings.fontPropertiesTable.put(stringArray2[i] + "_path", string2 + string);
                        }
                    } else {
                        String[] stringArray = new String[]{};
                        try {
                            stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i] == null) {
                                stringArray[i] = Strip.stripAllSpaces(string4);
                            }
                            FontMappings.fontSubstitutionTable.put(stringArray[i], "/TrueType");
                            FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                            FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                            FontMappings.fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                            FontMappings.fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                            if (!debugFonts) continue;
                            System.out.println("Added  4");
                        }
                    }
                } else if (n == 1228944677) {
                    String[] stringArray = new String[]{};
                    try {
                        stringArray = StandardFonts.readNamesFromFont(n, string2 + string, fontSubstitutionMode);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            stringArray[i] = Strip.stripAllSpaces(string4);
                        }
                        FontMappings.fontSubstitutionTable.put(stringArray[i], "/Type1");
                        FontMappings.fontSubstitutionLocation.put(stringArray[i], string2 + string);
                        FontMappings.fontSubstitutionFontID.put(stringArray[i], new Integer(i));
                        FontMappings.fontPropertiesTable.put(stringArray[i] + "_type", new Integer(n));
                        FontMappings.fontPropertiesTable.put(stringArray[i] + "_path", string2 + string);
                        if (!debugFonts) continue;
                        System.out.println("Added  5");
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + string2);
            }
        }
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public static void init(boolean bl) {
        embedWidthData = bl;
    }

    public PdfDecoder(boolean bl) {
        this.pages = new SingleDisplay(this);
        this.renderPage = bl;
        this.setLayout(null);
        this.startup();
    }

    private void startup() {
        Object object;
        String string;
        this.formRenderer = new DefaultAcroRenderer();
        this.formRenderer.resetHandler(null, this, 5);
        this.formRenderer.resetHandler(null, this, 7);
        String string2 = System.getProperty("debug");
        if (string2 != null) {
            LogWriter.setupLogFile(true, 1, "", "v", false);
        }
        try {
            string = System.getProperty("org.jpedal.fontmaps");
            if (string != null) {
                object = new StringTokenizer(string, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "=:");
                    int n = stringTokenizer.countTokens() - 1;
                    String[] stringArray = new String[n];
                    String string4 = stringTokenizer.nextToken();
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = stringTokenizer.nextToken();
                    }
                    PdfDecoder.setSubstitutedFontAliases(string4, stringArray);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read org.jpedal.fontmaps " + exception.getMessage());
        }
        try {
            string = System.getProperty("org.jpedal.fontdirs");
            object = null;
            if (string != null) {
                object = PdfDecoder.addFonts(string, (String)object);
            }
            if (object != null) {
                LogWriter.writeLog("Could not find " + (String)object);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to read FontDirs " + exception.getMessage());
        }
        if (this.renderPage) {
            this.highlightFont = new Font("Lucida", 1, this.size);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public PdfDecoder() {
        this.pages = new SingleDisplay(this);
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
    }

    public static final void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    public final void dispose() {
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
        this.pdfData = null;
        if (this.pages != null) {
            this.pages.dispose();
        }
        this.pages = null;
        defaultFont = null;
        if (this.currentDisplay != null) {
            this.currentDisplay.dispose();
        }
        this.currentDisplay = null;
        if (this.current != null) {
            this.current.dispose();
        }
        this.current = null;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        if (this.formRenderer != null) {
            this.formRenderer.dispose();
        }
        this.formRenderer = null;
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    public final void closePdfFile() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        if (this.linearObj != null) {
            this.waitForDecodingToFinish();
        }
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        this.displayScaling = null;
        this.lastPageDecoded = -1;
        this.checkImagesFinished();
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && !this.linearizedBackgroundReaderer.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.pages.disableScreen();
        this.overlayType.clear();
        this.overlayColors.clear();
        this.overlayObj.clear();
        this.overlayTypeG.clear();
        this.overlayColorsG.clear();
        this.overlayObjG.clear();
        if (this.formRenderer != null) {
            this.formRenderer.openFile(this.pageCount);
            this.formRenderer.resetFormData(this.pageLookup, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.acroFormObj);
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.pages.flushPageCaches();
            this.removeComponentListener(this.viewListener);
        }
        if (this.linHintTable != null) {
            this.linHintTable = null;
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.closePdfFile();
            this.currentPdfFile = null;
        }
        this.pages.disableScreen();
        this.currentDisplay.flush();
        this.objectStoreRef.flush();
        ObjectStore.flushPages();
        this.objectStoreRef.flush();
        this.objectPrintStoreRef.flush();
        this.oldScaling = -1.0f;
        this.pageCount = 0;
        this.metadataObj = null;
        this.nameObj = null;
        this.structTreeRootObj = null;
        this.markInfoObj = null;
        this.acroFormObj = null;
        this.OutlinesObj = null;
        this.PropertiesObj = null;
        this.layers = null;
        this.OCProperties = null;
        this.OCpageNumber = -1;
        this.setDisplayView(1, 2);
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfDecoder.this.validate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void checkImagesFinished() {
        while (this.isGeneratingPage) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.isGeneratingPage = false;
            }
        }
    }

    public final byte[] getPdfBuffer() {
        byte[] byArray = null;
        if (this.currentPdfFile != null) {
            byArray = this.currentPdfFile.getPdfBuffer();
        }
        return byArray;
    }

    public final PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    public final PdfData getPdfData() throws PdfException {
        if ((this.extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoder.TEXT | other values");
        }
        return this.pdfData;
    }

    public final boolean hasOutline() {
        return this.hasOutline;
    }

    public final Document getOutlineAsXML() {
        if (this.outlineData == null && this.OutlinesObj != null) {
            try {
                this.currentPdfFile.checkResolved(this.OutlinesObj);
                this.outlineData = new OutlineData(this.pageCount);
                this.outlineData.readOutlineFileMetadata(this.OutlinesObj, this.currentPdfFile, this.pageLookup);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " accessing outline ");
                this.outlineData = null;
            }
        }
        if (this.outlineData != null) {
            return this.outlineData.getList();
        }
        return null;
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public Point getPageOffsets(int n) {
        return new Point(this.pages.getXCordForPage(n), this.pages.getYCordForPage(n));
    }

    public void setPagePrintRange(int n, int n2) throws PdfException {
        this.start = n;
        this.end = n2;
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.pageCount;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n < 1 || n2 < 1 || n > this.pageCount || n2 > this.pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + n + ' ' + n2);
        }
    }

    public void setPrintPageMode(int n) {
        this.oddPagesOnly = (n & 0x10) == 16;
        this.evenPagesOnly = (n & 0x20) == 32;
        this.pagesPrintedInReverse = (n & 0x40) == 64;
    }

    public void setPagePrintRange(SetOfIntegerSyntax setOfIntegerSyntax) throws PdfException {
        int n;
        int n2;
        if (setOfIntegerSyntax == null) {
            throw new PdfException("[PDF] null page range entered");
        }
        this.range = setOfIntegerSyntax;
        this.start = setOfIntegerSyntax.next(0);
        int n3 = 0;
        for (n2 = 0; n2 < this.pageCount; ++n2) {
            if (!setOfIntegerSyntax.contains(n2)) continue;
            ++n3;
        }
        this.listOfPages = new int[n3 + 1];
        n2 = this.start;
        this.end = this.start;
        if (setOfIntegerSyntax.contains(Integer.MAX_VALUE)) {
            this.end = this.pageCount;
        } else {
            while (setOfIntegerSyntax.next(n2) != -1) {
                ++n2;
            }
            this.end = n2;
        }
        if (this.start > this.end) {
            n = this.start;
            this.start = this.end;
            this.end = n;
        }
        n = 0;
        for (int i = this.start; i < this.end + 1; ++i) {
            if (!setOfIntegerSyntax.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
            this.listOfPages[n] = i - this.start;
            ++n;
        }
        if (this.start < 1 || this.end < 1 || this.start > this.pageCount || this.end > this.pageCount) {
            throw new PdfException(Messages.getMessage("PdfViewerPrint.InvalidPageRange") + ' ' + this.start + ' ' + this.end);
        }
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public void setCenterOnScaling(boolean bl) {
        this.centerOnScaling = bl;
    }

    public void useLogicalPrintOffset(int n) {
        this.logicalPageOffset = n;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        boolean bl = false;
        n -= this.logicalPageOffset;
        return 1;
    }

    private static Map toMap(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n = nArray.length;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(new Integer(nArray[i]), "x");
        }
        return hashMap;
    }

    private Rectangle workoutClipping(int n, float f, Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = null;
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = rectangle.getWidth();
        double d4 = rectangle.getHeight();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n) {
            case 0: {
                n4 = (int)((float)(rectangle.x - this.insetW) / this.scaling);
                n5 = (int)((float)n3 - (float)(rectangle.y + rectangle.height - this.insetH) / this.scaling);
                n6 = (int)((float)rectangle.width / this.scaling) - 1;
                n7 = (int)((float)rectangle.height / this.scaling);
                break;
            }
            case 90: {
                n4 = (int)((d2 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((d - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
                break;
            }
            case 180: {
                n5 = (int)(d2 / (double)this.scaling - (double)((float)this.insetH / this.scaling));
                n4 = (int)((double)n2 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d3 / (double)this.scaling);
                n7 = (int)(d4 / (double)this.scaling);
                break;
            }
            case 270: {
                n4 = (int)((double)n2 - (d2 + d4 - (double)this.insetH) / (double)this.scaling);
                n5 = (int)((double)n3 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                n6 = (int)(d4 / (double)this.scaling);
                n7 = (int)(d3 / (double)this.scaling);
            }
        }
        rectangle2 = new Rectangle(n4, n5, n6, n7);
        return rectangle2;
    }

    private double[] workoutParameters(int n, float f, Rectangle rectangle, int n2, int n3) {
        double[] dArray = new double[4];
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = rectangle.getWidth();
        double d4 = rectangle.getHeight();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        switch (n) {
            case 0: {
                d5 = -((d - (double)this.insetW) / (double)this.scaling);
                d6 = -((double)n3 - (d2 + d4 - (double)this.insetH) / (double)this.scaling);
                d7 = d3 / (double)this.scaling;
                d8 = d4 / (double)this.scaling;
                break;
            }
            case 90: {
                d5 = -((d2 - (double)this.insetH) / (double)this.scaling);
                d6 = -((d - (double)this.insetW) / (double)this.scaling);
                d7 = d4 / (double)this.scaling;
                d8 = d3 / (double)this.scaling;
                break;
            }
            case 180: {
                d6 = -((d2 - (double)this.insetH) / (double)this.scaling);
                d5 = -((double)n2 - (d + d3 - (double)this.insetW) / (double)this.scaling);
                d7 = d3 / (double)this.scaling;
                d8 = d4 / (double)this.scaling;
                break;
            }
            case 270: {
                d5 = -((double)n2 - (d2 + d4 - (double)this.insetW) / (double)this.scaling);
                d6 = -((double)n3 - (d + d3 - (double)this.insetH) / (double)this.scaling);
                d7 = d4 / (double)this.scaling;
                d8 = d3 / (double)this.scaling;
            }
        }
        dArray[0] = d5;
        dArray[1] = d6;
        dArray[2] = d7;
        dArray[3] = d8;
        return dArray;
    }

    private void createCustomPaper(PageFormat pageFormat, int n, int n2) {
        Paper paper = new Paper();
        if (this.pageCount == 1 || this.allowDifferentPrintPageSizes) {
            paper.setSize(n, n2);
            paper.setImageableArea(0.0, 0.0, n, n2);
        } else {
            int n3 = 0;
            int n4 = 0;
            for (int i = this.start; i <= this.end; ++i) {
                if (n > this.pageData.getMediaBoxWidth(i) + 1 || n2 > this.pageData.getMediaBoxHeight(i) + 1) continue;
                n3 = this.pageData.getMediaBoxWidth(i) + 1;
                n4 = this.pageData.getMediaBoxHeight(i) + 1;
            }
            paper.setSize(n3, n4);
            paper.setImageableArea(0.0, 0.0, n, n2);
        }
        pageFormat.setPaper(paper);
    }

    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        if (n > this.pageCount | n < 1) {
            LogWriter.writeLog("Page " + n + " not in range");
        } else {
            try {
                this.isGeneratingPage = true;
                this.timeout = false;
                String string = (String)this.pagesReferences.get(new Integer(n));
                if (string != null) {
                    int n2;
                    int n3;
                    int n4;
                    Object object;
                    if (this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    PageObject pageObject = new PageObject(string);
                    this.currentPdfFile.readObject(pageObject);
                    PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                    ObjectStore objectStore = new ObjectStore();
                    this.currentImageDecoder = new PdfStreamDecoder(pdfObject);
                    this.currentImageDecoder.setExternalImageRender(this.customImageHandler);
                    this.currentImageDecoder.setName(this.filename);
                    this.currentImageDecoder.setStore(objectStore);
                    this.currentImageDecoder.setMultiplier(this.multiplyer);
                    if (bl) {
                        object = new DynamicVectorRenderer(this.pageNumber, false, 5000, objectStore);
                        this.currentImageDecoder.init(true, this.renderPage, this.renderMode, 0, this.pageData, n, (DynamicVectorRenderer)object, this.currentPdfFile);
                    } else {
                        this.currentImageDecoder.init(true, this.renderPage, this.renderMode, 0, this.pageData, n, null, this.currentPdfFile);
                    }
                    if (this.globalResources != null) {
                        this.currentPdfFile.checkResolved(this.globalResources);
                        this.currentImageDecoder.readResources(this.globalResources, true);
                        object = this.globalResources.getDictionary(-2089186617);
                        if (object != null) {
                            this.PropertiesObj = object;
                        }
                    }
                    if (pdfObject != null) {
                        this.currentPdfFile.checkResolved(pdfObject);
                        this.currentImageDecoder.readResources(pdfObject, true);
                        object = pdfObject.getDictionary(-2089186617);
                        if (object != null) {
                            this.PropertiesObj = object;
                        }
                    }
                    this.setupPage(this.currentImageDecoder, true);
                    if (this.multiplyer == -2.0f) {
                        this.multiplyer = -1.0f;
                        object = new PdfStreamDecoder(pdfObject);
                        ((PdfStreamDecoder)object).setName(this.filename);
                        ((PdfStreamDecoder)object).setStore(objectStore);
                        ((PdfStreamDecoder)object).setMultiplier(this.multiplyer);
                        this.currentImageDecoder.setMultiplier(this.multiplyer);
                        if (bl) {
                            DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(this.pageNumber, false, 5000, objectStore);
                            ((PdfStreamDecoder)object).init(true, this.renderPage, this.renderMode, 0, this.pageData, n, dynamicVectorRenderer, this.currentPdfFile);
                        } else {
                            ((PdfStreamDecoder)object).init(true, this.renderPage, this.renderMode, 0, this.pageData, n, null, this.currentPdfFile);
                        }
                        if (this.globalResources != null) {
                            ((PdfStreamDecoder)object).readResources(this.globalResources, true);
                        }
                        if (pdfObject != null) {
                            ((PdfStreamDecoder)object).readResources(pdfObject, true);
                        }
                        this.setupPage((PdfStreamDecoder)object, true);
                        this.multiplyer = ((PdfStreamDecoder)object).decodePageContentForImageSampling(pageObject, 0, 0, null, null);
                        if (debugHiRes) {
                            System.out.println("-----Multipier=" + this.multiplyer);
                        }
                        n4 = 0;
                        if (this.instance_bestQualityMaxScaling != null) {
                            n4 = this.instance_bestQualityMaxScaling;
                        } else if (bestQualityMaxScaling != null) {
                            n4 = bestQualityMaxScaling;
                        }
                        if (n4 > 0 && this.multiplyer > (float)n4) {
                            this.multiplyer = n4;
                            if (debugHiRes) {
                                System.out.println("Use max");
                            }
                        }
                        ((PdfStreamDecoder)object).setMultiplier(this.multiplyer);
                        this.currentImageDecoder.setMultiplier(this.multiplyer);
                    }
                    if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
                        this.multiplyer = 1.0f;
                    }
                    if (this.multiplyer == -1.0f) {
                        this.multiplyer = 1.0f;
                    }
                    object = this.setPageParametersForImage(this.scaling * this.multiplyer, n);
                    n4 = (int)(this.scaling * (float)this.pageData.getMediaBoxWidth(n));
                    int n5 = (int)(this.scaling * (float)this.pageData.getMediaBoxHeight(n));
                    int n6 = this.pageData.getRotation(n);
                    int n7 = (int)(this.scaling * (float)this.pageData.getCropBoxWidth(n));
                    int n8 = (int)(this.scaling * (float)this.pageData.getCropBoxHeight(n));
                    int n9 = (int)(this.scaling * (float)this.pageData.getCropBoxX(n));
                    int n10 = (int)(this.scaling * (float)this.pageData.getCropBoxY(n));
                    boolean bl2 = false;
                    if (n6 == 90 || n6 == 270) {
                        n3 = (int)((float)n7 * this.multiplyer);
                        n2 = (int)((float)n8 * this.multiplyer);
                        bl2 = true;
                    } else {
                        n2 = (int)((float)n7 * this.multiplyer);
                        n3 = (int)((float)n8 * this.multiplyer);
                    }
                    bufferedImage = new BufferedImage(n2, n3, 2);
                    Graphics graphics = bufferedImage.getGraphics();
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    if (!bl) {
                        graphics2D.setColor(Color.white);
                        graphics2D.fillRect(0, 0, n2, n3);
                    }
                    this.currentImageDecoder.getRenderer().setScalingValues((float)n9 * this.multiplyer, (float)n8 * this.multiplyer + (float)n10, this.multiplyer * this.scaling);
                    graphics2D.setRenderingHints(ColorSpaces.hints);
                    graphics2D.transform((AffineTransform)object);
                    if (bl2) {
                        if (n6 == 90) {
                            if (this.multiplyer < 1.0f) {
                                n10 = (int)(((AffineTransform)object).getTranslateX() + (double)n10);
                                n9 = (int)(((AffineTransform)object).getTranslateY() + (double)n9);
                            } else {
                                n10 = (int)(((AffineTransform)object).getTranslateX() / (double)this.multiplyer + (double)n10);
                                n9 = (int)(((AffineTransform)object).getTranslateY() / (double)this.multiplyer + (double)n9);
                            }
                            graphics2D.translate(-n9, -n10);
                        } else if (n10 < 0) {
                            graphics2D.translate(-n9, n5 - n8 + n10);
                        } else {
                            graphics2D.translate(-n9, n5 - n8 - n10);
                        }
                    }
                    this.currentImageDecoder.setDirectRendering(graphics2D);
                    if (pageObject != null) {
                        this.currentImageDecoder.decodePageContent(pageObject, 0, 0, null, null);
                    }
                    graphics2D.setClip(null);
                    this.colorSpacesUsed = this.currentImageDecoder.getPageInfo(1);
                    this.timeout = this.currentImageDecoder.getPageDecodeStatus(16);
                    if (this.formRenderer != null && this.formRenderer.hasFormsOnPage(n)) {
                        this.colorSpacesUsed = null;
                        this.formRenderer.createDisplayComponentsForPage(n);
                        this.formRenderer.getCompData().renderFormsOntoG2(graphics2D, n, this.scaling, 0, this.displayRotation, null, null, this.currentPdfFile);
                        this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
                    }
                    objectStore.flush();
                }
                if (!(isRunningOnAIX || this.converToRGB || bl || bufferedImage == null)) {
                    bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                }
                Object var22_22 = null;
                this.isGeneratingPage = false;
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                this.isGeneratingPage = false;
                throw throwable;
            }
        }
        return bufferedImage;
    }

    public float getHiResUpscaleFactor() {
        return this.multiplyer;
    }

    public final void flushObjectValues(boolean bl) {
        if (this.pdfData != null) {
            this.pdfData.flushTextList(bl);
        }
        if (this.pdfImages != null && bl) {
            this.pdfImages.clearImageData();
        }
    }

    public final PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    public final void setRenderMode(int n) {
        this.renderMode = n;
        this.extractionMode = n;
    }

    public final void setExtractionMode(int n) {
        this.extractionMode = n;
    }

    protected void readObjectForPage(PdfObject pdfObject, String string, int n, boolean bl) {
        this.currentPdfFile.readObject(pdfObject);
        if (this.renderPage) {
            if (this.formRenderer != null && this.acroFormObj != null) {
                this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, 0, 0, 0, 1, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
                this.formRenderer.createDisplayComponentsForPage(n);
            }
            if (bl) {
                this.lastFormPage = -1;
                this.lastEnd = -1;
                this.lastStart = -1;
            }
        }
    }

    public final PdfFileInformation getFileInformationData() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.readPdfFileMetadata(this.metadataObj);
        }
        return null;
    }

    public final void setExtractionMode(int n, int n2, float f) {
        boolean bl;
        if (dpi % 72 != 0) {
            LogWriter.writeLog("Dpi is not a factor of 72- this may cause problems");
        }
        dpi = n2;
        this.scaling = f;
        this.pageData.setScalingValue(f);
        this.extractionMode = n;
        if (this.layers != null && (bl = this.layers.setZoom(f))) {
            try {
                this.decodePage(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    public final void setPageParameters(float f, int n) {
        int n2;
        this.pageNumber = n;
        if (this.displayView == 6 && f == -100.0f) {
            return;
        }
        if (f > 0.0f) {
            this.scaling = f;
        } else {
            f = this.scaling;
        }
        if (this.pages != null) {
            this.pages.setScaling(f);
        }
        if (this.layers != null && (n2 = this.layers.setZoom(this.scalingdpi.removeScaling(f))) != 0) {
            try {
                this.decodePage(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.pageData.setScalingValue(f);
        n2 = this.pageData.getMediaBoxWidth(n);
        this.max_y = this.pageData.getMediaBoxHeight(n);
        this.max_x = this.pageData.getMediaBoxWidth(n);
        int n3 = this.pageData.getCropBoxWidth(n);
        int n4 = this.pageData.getCropBoxHeight(n);
        this.x_size_cropped = (int)((float)n3 * f);
        this.y_size_cropped = (int)((float)n4 * f);
        this.x_size = (int)((float)n3 * f);
        this.y_size = (int)((float)n4 * f);
        if (!this.isNewRotationSet && this.displayView != 6) {
            this.displayRotation = this.pageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(n2, this.max_y, this.displayRotation);
        this.setPageRotation(this.displayRotation);
    }

    protected final AffineTransform setPageParametersForImage(float f, int n) {
        boolean bl;
        if (this.layers != null && (bl = this.layers.setZoom(f))) {
            try {
                this.decodePage(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AffineTransform affineTransform = new AffineTransform();
        int n2 = this.pageData.getCropBoxWidth(n);
        int n3 = this.pageData.getCropBoxHeight(n);
        int n4 = this.pageData.getCropBoxX(n);
        int n5 = this.pageData.getCropBoxY(n);
        int n6 = (int)((float)n2 * f);
        int n7 = (int)((float)n3 * f);
        int n8 = this.pageData.getRotation(n);
        affineTransform.translate((float)(-n4) * f, (float)n5 * f);
        if (n8 == 270) {
            affineTransform.rotate(-1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.translate((double)n7 - d2, -d);
            affineTransform.translate((float)(2 * n5) * f, 0.0);
            affineTransform.translate(0.0, -f * (float)(this.pageData.getCropBoxHeight(n) - this.pageData.getMediaBoxHeight(n)));
        } else if (n8 == 180) {
            affineTransform.rotate(Math.PI, n6 / 2, n7 / 2);
        } else if (n8 == 90) {
            affineTransform.rotate(1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate(-d3, (double)n6 - d);
        }
        if (f < 1.0f) {
            affineTransform.translate(n6, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n6, 0.0);
            affineTransform.scale(f, f);
        } else {
            affineTransform.translate(n6, n7);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-n6, 0.0);
            affineTransform.scale(f, f);
        }
        return affineTransform;
    }

    public final void setPageParameters(float f, int n, int n2) {
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        if (this.displayView != 6) {
            this.setPageParameters(f, n);
        }
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void waitForDecodingToFinish() {
        while (this.isDecoding) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.isDecoding = false;
            }
        }
    }

    public final void stopPrinting() {
        this.stopPrinting = true;
    }

    public DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public DynamicVectorRenderer getDynamicRenderer(boolean bl) {
        DynamicVectorRenderer dynamicVectorRenderer = this.currentDisplay;
        if (bl) {
            this.currentDisplay = new DynamicVectorRenderer(0, this.objectStoreRef, false);
        }
        return dynamicVectorRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decodePageForMarkedContent(int n, PdfObject pdfObject, Object object) throws Exception {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
        } else {
            Object object2;
            if (pdfObject == null) {
                object2 = (String)this.pagesReferences.get(new Integer(n));
                pdfObject = new PageObject((String)object2);
                this.currentPdfFile.readObject(pdfObject);
            } else {
                n = this.pageLookup.convertObjectToPageNumber(new String(pdfObject.getUnresolvedData()));
                this.currentPdfFile.checkResolved(pdfObject);
            }
            try {
                try {
                    this.isDecoding = true;
                    object2 = pdfObject.getDictionary(2004251818);
                    if (pdfObject != null) {
                        Object object3;
                        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.useHiResImageForDisplay, this.layers, (PdfObject)object2);
                        pdfStreamDecoder.setName(this.filename);
                        pdfStreamDecoder.setStore(this.objectStoreRef);
                        pdfStreamDecoder.setStatusBar(this.statusBar);
                        int n2 = 7;
                        pdfStreamDecoder.init(true, false, this.renderMode, n2, this.pageData, n, null, this.currentPdfFile);
                        if (this.globalResources != null) {
                            this.currentPdfFile.checkResolved(this.globalResources);
                            pdfStreamDecoder.readResources(this.globalResources, true);
                            object3 = this.globalResources.getDictionary(-2089186617);
                            if (object3 != null) {
                                this.PropertiesObj = object3;
                            }
                        }
                        if (object2 != null) {
                            this.currentPdfFile.checkResolved((PdfObject)object2);
                            pdfStreamDecoder.readResources((PdfObject)object2, true);
                            object3 = ((PdfObject)object2).getDictionary(-2089186617);
                            if (object3 != null) {
                                this.PropertiesObj = object3;
                            }
                        }
                        this.setupPage(pdfStreamDecoder, false);
                        pdfStreamDecoder.setMapForMarkedContent(object);
                        if (DynamicVectorRenderer.textBasedHighlight) {
                            this.setLineAreas(null);
                        }
                        pdfStreamDecoder.decodePageContent(pdfObject, 0, 0, null, null);
                        object3 = pdfStreamDecoder.getTextAreas();
                        ((Vector_Rectangle)object3).trim();
                        Rectangle[] rectangleArray = ((Vector_Rectangle)object3).get();
                        Vector_Int vector_Int = pdfStreamDecoder.getTextDirections();
                        vector_Int.trim();
                        int[] nArray = vector_Int.get();
                        for (int i = 0; i != rectangleArray.length; ++i) {
                            this.addToLineAreas(rectangleArray[i], nArray[i], n);
                        }
                    }
                    Object var13_13 = null;
                    this.isDecoding = false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var13_14 = null;
                    this.isDecoding = false;
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                this.isDecoding = false;
                throw throwable;
            }
        }
    }

    public final void decodeOtherPages(int n) {
        this.pages.decodeOtherPages(this.pageNumber, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void decodePage(int n) throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n == -1) {
            n = this.lastPageDecoded;
            bl3 = true;
        }
        boolean bl4 = false;
        if (n == this.lastPageDecoded) {
            bl4 = true;
        }
        final int n2 = n;
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
        } else {
            boolean bl5 = this.isPageAvailable(n);
            PageObject pageObject = this.linObject;
            if (bl5 && pageObject != null) {
                this.isDecoding = true;
                this.tempPageCount = n;
                this.readAllPageReferences(true, pageObject, new HashMap(), new HashMap());
            }
            if (!bl5) {
                this.isDecoding = false;
                return;
            }
            this.timeout = false;
            try {
                this.isDecoding = true;
                if (this.layers != null && this.layers.getChangesMade()) {
                    this.lastPageDecoded = -1;
                    this.layers.setChangesMade(false);
                    this.formRenderer.getCompData().setLayerData(this.layers);
                }
                if (this.displayView != 1) {
                    this.isDecoding = false;
                    Object var23_9 = null;
                    if (bl2) return;
                    this.isDecoding = false;
                    if (this.statusBar != null) {
                        this.statusBar.percentageDone = 100.0f;
                    }
                    this.currentDisplay.flagDecodingFinished();
                    return;
                }
                this.lastPageDecoded = n2;
                this.decodeStatus = "";
                this.cursorBoxOnScreen = null;
                if (!bl4 && this.renderPage && this.formRenderer != null) {
                    this.formRenderer.removeDisplayComponentsFromScreen();
                    this.lastFormPage = -1;
                }
                this.currentDisplay.flush();
                this.pages.refreshDisplay();
                if (n2 > this.pageCount || n2 < 1) {
                    LogWriter.writeLog("Page out of bounds");
                    this.isDecoding = false;
                } else {
                    Object object;
                    Object object2;
                    Timer timer = null;
                    if (this.statusBar != null) {
                        object2 = new ProgressListener();
                        timer = new Timer(150, (ActionListener)object2);
                        timer.start();
                    }
                    this.pageNumber = n2;
                    object2 = (String)this.pagesReferences.get(new Integer(n2));
                    if (object2 != null && this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    if (pageObject == null) {
                        pageObject = new PageObject((String)object2);
                        this.currentPdfFile.readObject(pageObject);
                    }
                    PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                    if (pageObject != null && ((object = ((PdfObject)pageObject).getKeyArray(1216184967)) != null || this.nameObj != null)) {
                        PdfObject pdfObject2;
                        this.current = new PdfStreamDecoder(this.useHiResImageForDisplay, this.layers, pdfObject);
                        this.current.setExternalImageRender(this.customImageHandler);
                        this.current.setName(this.filename);
                        this.current.setPageNumber(n2);
                        this.currentDisplay.setPrintPage(n2);
                        this.currentDisplay.setCustomColorHandler(this.customColorHandler);
                        this.current.setStore(this.objectStoreRef);
                        this.current.setStatusBar(this.statusBar);
                        this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        this.current.init(true, this.renderPage, this.renderMode, this.extractionMode, this.pageData, n2, this.currentDisplay, this.currentPdfFile);
                        if (this.globalResources != null) {
                            this.currentPdfFile.checkResolved(this.globalResources);
                            this.current.readResources(this.globalResources, true);
                            pdfObject2 = this.globalResources.getDictionary(-2089186617);
                            if (pdfObject2 != null) {
                                this.PropertiesObj = pdfObject2;
                            }
                        }
                        if (pdfObject != null) {
                            this.currentPdfFile.checkResolved(pdfObject);
                            this.current.readResources(pdfObject, true);
                            pdfObject2 = pdfObject.getDictionary(-2089186617);
                            if (pdfObject2 != null) {
                                this.PropertiesObj = pdfObject2;
                            }
                        }
                        this.setupPage(this.current, false);
                        this.current.setStatusBar(this.statusBar);
                        int n3 = this.pageData.getMediaBoxWidth(this.pageNumber);
                        int n4 = this.pageData.getMediaBoxHeight(this.pageNumber);
                        int n5 = this.pageData.getRotation(this.pageNumber);
                        this.currentDisplay.init(n3, n4, n5);
                        if (this.g2 != null) {
                            this.current.setDirectRendering(this.g2);
                        }
                        try {
                            if (DynamicVectorRenderer.textBasedHighlight) {
                                this.setLineAreas(null);
                            }
                            this.current.decodePageContent(pageObject, 0, 0, null, null);
                            Vector_Rectangle vector_Rectangle = this.current.getTextAreas();
                            vector_Rectangle.trim();
                            Rectangle[] rectangleArray = vector_Rectangle.get();
                            Vector_Int vector_Int = this.current.getTextDirections();
                            vector_Int.trim();
                            int[] nArray = vector_Int.get();
                            for (int i = 0; i != rectangleArray.length; ++i) {
                                this.addToLineAreas(rectangleArray[i], nArray[i], n2);
                            }
                        }
                        catch (Error error) {
                            this.decodeStatus = this.decodeStatus + "Error in decoding page " + error.toString();
                        }
                        this.hasEmbeddedFonts = this.current.hasEmbeddedFonts();
                        this.fontsInFile = this.current.getFontsInFile();
                        this.pdfData = this.current.getText();
                        if (embedWidthData) {
                            this.pdfData.widthIsEmbedded();
                        }
                        this.pdfData.maxX = n3;
                        this.pdfData.maxY = n4;
                        this.pdfImages = this.current.getImages();
                        this.hasYCCKimages = this.current.getPageDecodeStatus(8);
                        this.imagesProcessedFully = this.current.getPageDecodeStatus(2);
                        this.hasNonEmbeddedCIDFonts = this.current.getPageDecodeStatus(4);
                        this.nonEmbeddedCIDFonts = this.current.getPageDecodeStatusReport(4);
                        this.ttHintingRequired = this.current.getPageDecodeStatus(32);
                        this.timeout = this.current.getPageDecodeStatus(16);
                        this.colorSpacesUsed = this.current.getPageInfo(1);
                    }
                    if (timer != null) {
                        timer.stop();
                        this.statusBar.setProgress(100);
                    }
                    if (this.renderPage) {
                        bl = false;
                        if (!bl3 && this.formRenderer != null && !this.formRenderer.ignoreForms() && this.formRenderer.hasFormsOnPage(n2)) {
                            if (!SwingUtilities.isEventDispatchThread() && this.formRenderer.getFormFactory().getType() == 1) {
                                object = pageObject;
                                Runnable runnable = new Runnable((PdfObject)object){
                                    private final /* synthetic */ PdfObject val$pdfObject2;
                                    {
                                        this.val$pdfObject2 = pdfObject;
                                    }

                                    public void run() {
                                        PdfDecoder.this.createFormComponents(n2, false, this.val$pdfObject2);
                                        PdfDecoder.this.isDecoding = false;
                                        PdfDecoder.this.currentDisplay.flagDecodingFinished();
                                    }
                                };
                                bl2 = true;
                                SwingUtilities.invokeLater(runnable);
                                this.waitForDecodingToFinish();
                            } else {
                                this.createFormComponents(n2, false, pageObject);
                                this.isDecoding = false;
                            }
                        }
                    }
                }
                if (!bl) {
                }
            }
            catch (Throwable throwable) {
                Object var23_11 = null;
                if (!bl2) {
                    this.isDecoding = false;
                    if (this.statusBar != null) {
                        this.statusBar.percentageDone = 100.0f;
                    }
                    this.currentDisplay.flagDecodingFinished();
                }
                throw throwable;
            }
            Object var23_10 = null;
            if (!bl2) {
                this.isDecoding = false;
                if (this.statusBar != null) {
                    this.statusBar.percentageDone = 100.0f;
                }
                this.currentDisplay.flagDecodingFinished();
            }
        }
        if (TTGlyph.redecodePage) {
            TTGlyph.redecodePage = false;
            this.decodePage(n);
        }
    }

    public synchronized boolean isPageAvailable(int n) {
        boolean bl = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && n > 1 && this.linHintTable != null) {
                Integer n2 = new Integer(n);
                if (this.linObjects.containsKey(n2)) {
                    this.linObject = (PageObject)this.linObjects.get(n2);
                    return true;
                }
                int n3 = this.linHintTable.getPageObjectRef(n);
                byte[] byArray = this.linHintTable.getObjData(n3);
                if (byArray != null) {
                    this.linObject = new PageObject(n3 + " 0 R");
                    this.linObject.setStatus(2);
                    this.linObject.setUnresolvedData(byArray, 540096309);
                    this.linObject.isDataExternal(true);
                    if (!this.currentPdfFile.resolveFully(this.linObject)) {
                        bl = false;
                    } else {
                        byte[][] byArray2 = null;
                        if (this.linObject != null) {
                            byArray2 = this.linObject.getKeyArray(1216184967);
                            byte[] byArray3 = null;
                            if (this.current != null) {
                                byArray3 = this.current.readPageIntoStream(this.linObject);
                            }
                            if (byArray3 == null) {
                                bl = false;
                            } else {
                                PdfObject pdfObject = this.linObject.getDictionary(2004251818);
                                if (pdfObject == null) {
                                    this.linObject = null;
                                    bl = false;
                                } else if (!this.currentPdfFile.resolveFully(pdfObject)) {
                                    this.linObject = null;
                                    bl = false;
                                } else {
                                    pdfObject.isDataExternal(true);
                                    this.current.readResources(pdfObject, true);
                                    if (!pdfObject.isFullyResolved()) {
                                        this.linObject = null;
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl && this.linObject != null) {
                            this.linObjects.put(n2, this.linObject);
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFormComponents(int n, boolean bl, PdfObject pdfObject) {
        this.formsDecoding = true;
        try {
            if (bl) {
                System.out.println("14b");
            }
            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, 0, 0, 1, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
            if (bl) {
                System.out.println("14c");
            }
            this.formRenderer.createDisplayComponentsForPage(n);
            if (bl) {
                System.out.println("14d");
            }
            if (bl) {
                System.out.println("14e");
            }
            if (bl) {
                System.out.println("15");
            }
            Object var5_4 = null;
            this.formsDecoding = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.formsDecoding = false;
            throw throwable;
        }
    }

    public void printAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        Integer n2 = new Integer(n);
        if (objectArray == null) {
            this.overlayType.remove(n2);
            this.overlayColors.remove(n2);
            this.overlayObj.remove(n2);
        } else {
            int n3;
            int[] nArray2 = (int[])this.overlayType.get(n2);
            if (nArray2 == null) {
                this.overlayType.put(n2, nArray);
            } else {
                int n4 = nArray2.length;
                n3 = nArray.length;
                int[] nArray3 = new int[n4 + n3];
                System.arraycopy(nArray2, 0, nArray3, 0, n4);
                System.arraycopy(nArray, 0, nArray3, n4, n3);
                this.overlayType.put(n2, nArray3);
            }
            Color[] colorArray2 = (Color[])this.overlayColors.get(n2);
            if (colorArray2 == null) {
                this.overlayColors.put(n2, colorArray);
            } else {
                n3 = colorArray2.length;
                int n5 = colorArray.length;
                Color[] colorArray3 = new Color[n3 + n5];
                System.arraycopy(colorArray2, 0, colorArray3, 0, n3);
                System.arraycopy(colorArray, 0, colorArray3, n3, n5);
                this.overlayColors.put(n2, colorArray3);
            }
            Object[] objectArray2 = (Object[])this.overlayObj.get(n2);
            if (nArray2 == null) {
                this.overlayObj.put(n2, objectArray);
            } else {
                int n6 = objectArray2.length;
                int n7 = objectArray.length;
                Object[] objectArray3 = new Object[n6 + n7];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n6);
                System.arraycopy(objectArray, 0, objectArray3, n6, n7);
                this.overlayObj.put(n2, objectArray3);
            }
        }
    }

    public void printAdditionalObjectsOverAllPages(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        Integer n = new Integer(-1);
        if (objectArray == null) {
            this.overlayTypeG.remove(n);
            this.overlayColorsG.remove(n);
            this.overlayObjG.remove(n);
        } else {
            int n2;
            int[] nArray2 = (int[])this.overlayTypeG.get(n);
            if (nArray2 == null) {
                this.overlayTypeG.put(n, nArray);
            } else {
                int n3 = nArray2.length;
                n2 = nArray.length;
                int[] nArray3 = new int[n3 + n2];
                System.arraycopy(nArray2, 0, nArray3, 0, n3);
                System.arraycopy(nArray, 0, nArray3, n3, n2);
                this.overlayTypeG.put(n, nArray3);
            }
            Color[] colorArray2 = (Color[])this.overlayColorsG.get(n);
            if (colorArray2 == null) {
                this.overlayColorsG.put(n, colorArray);
            } else {
                n2 = colorArray2.length;
                int n4 = colorArray.length;
                Color[] colorArray3 = new Color[n2 + n4];
                System.arraycopy(colorArray2, 0, colorArray3, 0, n2);
                System.arraycopy(colorArray, 0, colorArray3, n2, n4);
                this.overlayColorsG.put(n, colorArray3);
            }
            Object[] objectArray2 = (Object[])this.overlayObjG.get(n);
            if (nArray2 == null) {
                this.overlayObjG.put(n, objectArray);
            } else {
                int n5 = objectArray2.length;
                int n6 = objectArray.length;
                Object[] objectArray3 = new Object[n5 + n6];
                System.arraycopy(objectArray2, 0, objectArray3, 0, n5);
                System.arraycopy(objectArray, 0, objectArray3, n5, n6);
                this.overlayObjG.put(n, objectArray3);
            }
        }
    }

    public void useHiResScreenDisplay(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decodePageInBackground(int n) throws Exception {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in foreground");
            LogWriter.writeLog("[PDF]Multiple access not recommended - use  waitForDecodingToFinish() to check");
        } else if (this.isBackgroundDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
        } else {
            try {
                block18: {
                    try {
                        Object object;
                        this.isBackgroundDecoding = true;
                        if (n > this.pageCount) {
                            LogWriter.writeLog("Page out of bounds");
                            break block18;
                        }
                        String string = (String)this.pagesReferences.get(new Integer(n));
                        if (string == null) break block18;
                        if (this.currentPdfFile == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        PageObject pageObject = new PageObject(string);
                        this.currentPdfFile.readObject(pageObject);
                        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                        if (pageObject == null) break block18;
                        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(pdfObject);
                        pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
                        pdfStreamDecoder.setName(this.filename);
                        pdfStreamDecoder.setStore(this.backgroundObjectStoreRef);
                        pdfStreamDecoder.init(true, false, 0, this.extractionMode, this.pageData, n, null, this.currentPdfFile);
                        if (this.globalResources != null) {
                            this.currentPdfFile.checkResolved(this.globalResources);
                            pdfStreamDecoder.readResources(this.globalResources, true);
                            object = this.globalResources.getDictionary(-2089186617);
                            if (object != null) {
                                this.PropertiesObj = object;
                            }
                        }
                        if (pdfObject != null) {
                            this.currentPdfFile.checkResolved(pdfObject);
                            pdfStreamDecoder.readResources(pdfObject, true);
                            object = pdfObject.getDictionary(-2089186617);
                            if (object != null) {
                                this.PropertiesObj = object;
                            }
                        }
                        this.setupPage(pdfStreamDecoder, false);
                        if (DynamicVectorRenderer.textBasedHighlight) {
                            this.setLineAreas(null);
                        }
                        pdfStreamDecoder.decodePageContent(pageObject, 0, 0, null, null);
                        if (this.current != null) {
                            object = this.current.getTextAreas();
                            ((Vector_Rectangle)object).trim();
                            Rectangle[] rectangleArray = ((Vector_Rectangle)object).get();
                            Vector_Int vector_Int = this.current.getTextDirections();
                            vector_Int.trim();
                            int[] nArray = vector_Int.get();
                            for (int i = 0; i != rectangleArray.length; ++i) {
                                this.addToLineAreas(rectangleArray[i], nArray[i], this.pageNumber);
                            }
                        }
                        this.pdfBackgroundData = pdfStreamDecoder.getText();
                        if (embedWidthData) {
                            this.pdfBackgroundData.widthIsEmbedded();
                        }
                        int n2 = this.pageData.getMediaBoxWidth(n);
                        int n3 = this.pageData.getMediaBoxHeight(n);
                        this.pdfBackgroundData.maxX = n2;
                        this.pdfBackgroundData.maxY = n3;
                        this.pdfBackgroundImages = pdfStreamDecoder.getImages();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var12_15 = null;
                        this.isBackgroundDecoding = false;
                    }
                }
                Object var12_14 = null;
                this.isBackgroundDecoding = false;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.isBackgroundDecoding = false;
                throw throwable;
            }
        }
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isEncrypted();
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isPasswordSupplied();
        }
        return false;
    }

    public boolean isFileViewable() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isFileViewable();
        }
        return false;
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.isExtractionAllowed();
        }
        return false;
    }

    public int getPDFflag(Integer n) {
        if (this.currentPdfFile != null) {
            return this.currentPdfFile.getPDFflag(n);
        }
        return -1;
    }

    private void verifyAccess() {
        if (this.currentPdfFile != null) {
            try {
                this.openPdfFile();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " opening file");
            }
        }
    }

    public static void setDefaultDisplayFont(String string) throws PdfFontException {
        boolean bl = false;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            defaultFont = stringArray[i];
            i = n;
        }
        if (!bl) {
            throw new PdfFontException("Font " + string + " is not available.");
        }
    }

    public final void setEncryptionPassword(String string) throws PdfException {
        if (this.currentPdfFile == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.currentPdfFile.setEncryptionPassword(string);
        this.verifyAccess();
    }

    public final void openPdfArray(byte[] byArray) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        LogWriter.writeMethod("{openPdfArray}", 0);
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.globalResources = null;
        this.pagesReferences.clear();
        try {
            this.currentPdfFile = new PdfReader();
            this.currentPdfFile.openPdfFile(byArray);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + exception.getMessage());
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        LogWriter.writeMethod("{openPdfFile " + string + '}', 0);
        this.filename = string;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfReader();
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    public final void openPdfFile(String string, String string2) throws PdfException {
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        LogWriter.writeMethod("{openPdfFile " + string + '}', 0);
        this.filename = string;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfReader(string2);
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    public final boolean openPdfFileFromURL(String string, boolean bl) throws PdfException {
        LogWriter.writeMethod("{openPdfFileFromURL " + string + '}', 0);
        InputStream inputStream = null;
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.readFile(bl, inputStream, string2);
    }

    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl) throws PdfException {
        LogWriter.writeMethod("{openPdfFileFromInputStream }", 0);
        String string = "inputstream" + System.currentTimeMillis() + ".pdf";
        return this.readFile(bl, inputStream, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readFile(boolean bl, InputStream inputStream, String string) throws PdfException {
        this.displayScaling = null;
        this.globalResources = null;
        this.pagesReferences.clear();
        this.currentPdfFile = new PdfReader();
        if (inputStream != null) {
            try {
                FileChannel fileChannel;
                int n;
                String string2 = string;
                File file = File.createTempFile(string2.substring(0, string2.lastIndexOf(46)), string2.substring(string2.lastIndexOf(46)), new File(ObjectStore.temp_dir));
                FileChannel fileChannel2 = new RandomAccessFile(file, "rws").getChannel();
                fileChannel2.force(true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                byte[] byArray = new byte[4096];
                int n2 = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    if (n > 0) {
                        fileChannel = fileChannel2;
                        synchronized (fileChannel) {
                            byte[] byArray2 = new byte[n];
                            System.arraycopy(byArray, 0, byArray2, 0, n);
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                            fileChannel2.write(byteBuffer);
                        }
                    }
                    n2 += n;
                }
                inputStream.close();
                fileChannel = fileChannel2;
                synchronized (fileChannel) {
                    fileChannel2.close();
                }
                this.openPdfFile(file.getAbsolutePath());
                this.objectStoreRef.storeFileName(file.getName().substring(0, file.getName().lastIndexOf(46)));
            }
            catch (IOException iOException) {
                LogWriter.writeLog("[PDF] Exception " + iOException + " opening URL ");
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public final boolean isPDFLinearized(String string) throws PdfException {
        LogWriter.writeMethod("{isPDFLinearized " + string + '}', 0);
        if (string.startsWith("jar")) {
            return false;
        }
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[128];
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("[PDF] Exception " + iOException + " scanning URL " + string);
            iOException.printStackTrace();
        }
        return bl;
    }

    private void openPdfFile() throws PdfException {
        LogWriter.writeMethod("{openPdfFile}", 0);
        this.pageNumber = 1;
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        PdfObject pdfObject = null;
        if (this.filename != null && this.filename.toLowerCase().endsWith(".fdf")) {
            String string;
            int n = this.filename.lastIndexOf(47);
            if (n == -1) {
                n = this.filename.lastIndexOf(92);
            }
            String string2 = "";
            if (n != -1) {
                string2 = this.filename.substring(0, n + 1);
            }
            if ((pdfObject = this.currentPdfFile.readFDF()) != null && (string = pdfObject.getTextStreamValue(22)) != null) {
                this.filename = string2 + string;
            }
            this.objectStoreRef.storeFileName(this.filename);
            this.currentPdfFile.openPdfFile(this.filename);
        } else {
            pdfObject = null;
        }
        try {
            this.isDecoding = true;
            this.pages.resetCachedValues();
            if (this.hasViewListener) {
                this.pages.flushPageCaches();
                this.removeComponentListener(this.viewListener);
            }
            this.currentPdfFile.setCacheSize(this.minimumCacheSize);
            this.lastPrintedPage = -1;
            this.currentPrintDecoder = null;
            if (this.formRenderer != null) {
                this.formRenderer.getCompData().setRootDisplayComponent(this);
            }
            this.pageData = new PdfPageData();
            this.pdfVersion = this.currentPdfFile.getType();
            LogWriter.writeLog("Pdf version : " + this.pdfVersion);
            if (this.pdfVersion == null) {
                this.currentPdfFile = null;
                this.isDecoding = false;
                throw new PdfException("No version on first line ");
            }
            LogWriter.writeMethod("{about to read ref table}", 0);
            int n = -1;
            long l = -1L;
            PdfObject pdfObject2 = this.currentPdfFile.readReferenceTable(null);
            LogWriter.writeMethod("{about to read catalog} root_id=" + pdfObject2.getObjectRefAsString(), 0);
            if (!this.isEncrypted() || this.isPasswordSupplied()) {
                PdfObject pdfObject3;
                int n2;
                if (pdfObject2 != null) {
                    pdfObject2.ignoreRecursion(true);
                    this.currentPdfFile.checkResolved(pdfObject2);
                    this.metadataObj = pdfObject2.getDictionary(1365674082);
                    this.structTreeRootObj = pdfObject2.getDictionary(-2000237823);
                    this.markInfoObj = pdfObject2.getDictionary(913275002);
                    this.acroFormObj = pdfObject2.getDictionary(661816444);
                    this.OutlinesObj = pdfObject2.getDictionary(1485011327);
                    this.nameObj = pdfObject2.getDictionary(826094945);
                    this.OCProperties = pdfObject2.getDictionary(-1567847737);
                }
                if ((n2 = pdfObject2.getParameterConstant(608780341)) != 540096309 && (pdfObject3 = pdfObject2.getDictionary(825701731)) != null) {
                    pdfObject2 = new PageObject(pdfObject3.getObjectRefAsString());
                    this.currentPdfFile.readObject(pdfObject2);
                    if (pdfObject2.getParameterConstant(608780341) == -1) {
                        pdfObject2 = pdfObject3;
                    }
                }
                if (pdfObject2 != null) {
                    LogWriter.writeLog("Pages being read from " + pdfObject2 + " " + pdfObject2.getObjectRefAsString());
                    this.pageNumber = 1;
                    this.tempPageCount = 1;
                    this.pageLookup = new PageLookup();
                    if (this.formRenderer != null) {
                        this.formRenderer.resetAnnotData(this.pageLookup, this.insetW, this.insetH, this.pageData, 1, this.currentPdfFile, null);
                    }
                    this.readAllPageReferences(true, pdfObject2, new HashMap(), new HashMap());
                    this.pageCount = n > 0 ? n : this.tempPageCount - 1;
                    this.pageNumber = 0;
                    if (this.pageCount == 0) {
                        LogWriter.writeLog("No pages found");
                    }
                }
                this.outlineData = null;
                boolean bl = this.hasOutline = this.OutlinesObj != null;
                if (this.formRenderer != null) {
                    this.formRenderer.openFile(this.pageCount);
                    this.currentPdfFile.checkResolved(this.acroFormObj);
                    this.formRenderer.resetFormData(this.pageLookup, this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.acroFormObj);
                }
            }
            this.currentOffset = null;
            this.pages.disableScreen();
            this.pages.stopGeneratingPage();
            this.displayView = this.pageCount < 2 ? 1 : this.pageMode;
            this.setDisplayView(this.displayView, this.alignment);
            this.isOpen = true;
        }
        catch (PdfException pdfException) {
            this.isDecoding = false;
            this.isOpen = true;
            this.closePdfFile();
            this.isOpen = false;
            this.isDecoding = false;
            throw new PdfException(pdfException.getMessage() + " opening file");
        }
        this.isDecoding = false;
    }

    public PdfLayerList getLayers() {
        return this.layers;
    }

    public Object getJPedalObject(int n) {
        switch (n) {
            case 826881374: {
                return this.layers;
            }
            case 2004845231: {
                if (!this.isLinearizationTested) {
                    // empty if block
                }
                return this.linearObj;
            }
            case -1276915978: {
                return this.linearizedBackgroundReaderer;
            }
        }
        return null;
    }

    public void setPageMode(int n) {
        this.pageMode = n;
    }

    private void readAllPageReferences(boolean bl, PdfObject pdfObject, Map map, Map map2) {
        Object object;
        String string = pdfObject.getObjectRefAsString();
        LogWriter.writeMethod("{readAllPageReferences} currentPageOffset=" + string, 0);
        int n = 0;
        int n2 = pdfObject.getParameterConstant(608780341);
        if (n2 == -1) {
            n2 = 825701731;
        }
        int n3 = pdfObject.getInt(1144088180);
        String string2 = pdfObject.getStringKey(1110793845);
        if (n3 == -1) {
            while (string2 != null && n3 == -1) {
                if (string2 != null && (object = map.get(string2)) != null) {
                    n3 = (Integer)object;
                }
                if (n3 != -1) continue;
                string2 = (String)map2.get(string2);
            }
            if (n3 != -1) {
                map.put(string, new Integer(n3));
                map2.put(string, string2);
            }
        } else {
            map.put(string, new Integer(n3));
            map2.put(string, string2);
        }
        if (n3 != -1) {
            n = n3;
        }
        this.pageData.setPageRotation(n, this.tempPageCount);
        object = pdfObject.getFloatArray(1313305473);
        float[] fArray = pdfObject.getFloatArray(1076199815);
        if (object != null) {
            this.pageData.setMediaBox((float[])object);
        }
        if (fArray != null) {
            this.pageData.setCropBox(fArray);
        }
        if (n2 == 825701731) {
            this.globalResources = pdfObject.getDictionary(2004251818);
            byte[][] byArray = pdfObject.getKeyArray(456733763);
            int n4 = 0;
            if (byArray != null) {
                n4 = byArray.length;
            }
            if (n4 > 0) {
                for (int i = 0; i < n4; ++i) {
                    String string3 = new String(byArray[i]);
                    PageObject pageObject = new PageObject(string3);
                    pageObject.ignoreRecursion(bl);
                    pageObject.ignoreStream(true);
                    this.currentPdfFile.readObject(pageObject);
                    this.readAllPageReferences(bl, pageObject, map, map2);
                }
            }
        } else if (n2 == 540096309) {
            this.pagesReferences.put(new Integer(this.tempPageCount), string);
            this.pageLookup.put(string, this.tempPageCount);
            this.pageData.checkSizeSet(this.tempPageCount);
            if (this.formRenderer != null) {
                byte[][] byArray = pdfObject.getKeyArray(1044338049);
                if (byArray != null && byArray.length == 1 && byArray[0] == null) {
                    byArray = null;
                }
                if (byArray != null) {
                    this.formRenderer.resetAnnotData(this.pageLookup, this.insetW, this.insetH, this.pageData, this.tempPageCount, this.currentPdfFile, byArray);
                }
            }
            ++this.tempPageCount;
        }
    }

    private static ArrayList getDirectoryMatches(String string) throws IOException {
        MEUtils.replaceAll(string, "\\.", "/");
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        ArrayList<String> arrayList = new ArrayList<String>(0);
        String string2 = uRL.toString();
        System.out.println("scanning " + string2);
        if (string2.startsWith("jar:") && string2.endsWith(string)) {
            int n = string2.lastIndexOf(string);
            string2 = string2.substring(0, n);
            System.out.println("entry= " + string2);
            URL uRL2 = new URL(string2);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!(!jarEntry.isDirectory() & jarEntry.getName().startsWith(string))) continue;
                String string3 = jarEntry.getName();
                int n2 = string3.lastIndexOf(47);
                string3 = string3.substring(n2 + 1);
                arrayList.add(string3);
            }
        } else {
            LogWriter.writeLog("Path: " + string2);
        }
        return arrayList;
    }

    private static ArrayList readIndirectValues(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>(0);
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        return arrayList;
    }

    public boolean addSubstituteFonts(String string, boolean bl) {
        boolean bl2 = false;
        try {
            String[] stringArray = new String[]{"tt", "t1c", "t1"};
            String[] stringArray2 = new String[]{"/TrueType", "/Type1C", "/Type1"};
            enforceFontSubstitution = bl;
            ClassLoader classLoader = this.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            LogWriter.writeLog("Looking for root " + string);
            if (inputStream != null) {
                LogWriter.writeLog("Adding fonts fonts found in  tt,t1c,t1 sub-directories of " + string);
                bl2 = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    if (!string.endsWith("/")) {
                        string = string + '/';
                    }
                    if ((inputStream = classLoader.getResourceAsStream(string2 = string + stringArray[i] + '/')) == null) continue;
                    System.out.println("Found  " + string2 + ' ' + inputStream);
                    try {
                        String string3;
                        ArrayList arrayList = inputStream instanceof ByteArrayInputStream ? PdfDecoder.readIndirectValues(inputStream) : PdfDecoder.getDirectoryMatches(string2);
                        int n = arrayList.size();
                        for (int j = 0; j < n && (string3 = (String)arrayList.get(j)) != null; ++j) {
                            int n2 = string3.indexOf(46);
                            String string4 = n2 == -1 ? string3 : string3.substring(0, n2);
                            FontMappings.fontSubstitutionTable.put(string4.toLowerCase(), stringArray2[i]);
                            FontMappings.fontSubstitutionLocation.put(string4.toLowerCase(), string2 + string3);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " reading substitute fonts");
                        System.out.println("Exception " + exception + " reading substitute fonts");
                    }
                }
            } else {
                LogWriter.writeLog("No fonts found at " + string);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception adding substitute fonts " + exception.getMessage());
        }
        return bl2;
    }

    public void setThumbnailsDrawing(boolean bl) {
        this.thumbnailsBeingDrawn = bl;
        this.pages.setThumbnailsDrawing(bl);
    }

    public void showImageableArea() {
        this.showImageable = true;
    }

    public int getNumberOfPages() {
        if (this.range != null) {
            int n = 0;
            for (int i = 1; i < this.pageCount + 1; ++i) {
                if (!this.range.contains(i) || this.oddPagesOnly && (i & 1) != 1 || this.evenPagesOnly && (i & 1) != 0) continue;
                ++n;
            }
            return n;
        }
        int n = 1;
        if (this.end != -1 && (n = this.end - this.start + 1) < 0) {
            n = 2 - n;
        }
        if (this.oddPagesOnly || this.evenPagesOnly) {
            return (n + 1) / 2;
        }
        return n;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (this.listOfPages != null) {
            n = this.listOfPages[n];
        }
        int n2 = this.end == -1 ? n + 1 : (this.end > this.start ? this.start + n : this.start - n);
        Object v = this.pageFormats.get(new Integer(n2));
        if (debugPrint) {
            System.out.println("======================================================\nspecific for page=" + v + " Get page format for page p=" + n + " start=" + this.start + " pf=" + this.pageFormats + ' ' + this.pageFormats.keySet());
        }
        if (v == null) {
            v = this.pageFormats.get("standard");
        }
        PageFormat pageFormat = new PageFormat();
        if (this.usePDFPaperSize) {
            int n3 = this.pageData.getCropBoxWidth(n2);
            int n4 = this.pageData.getCropBoxHeight(n2);
            this.createCustomPaper(pageFormat, n3, n4);
        } else if (v != null) {
            pageFormat = (PageFormat)v;
        }
        if (!this.isPrintAutoRotateAndCenter) {
            pageFormat.setOrientation(1);
        }
        if (debugPrint) {
            System.out.println("Page format used=" + pageFormat);
            System.out.println("Orientation=" + pageFormat.getOrientation());
            System.out.println("Width=" + pageFormat.getWidth() + " imageableW=" + pageFormat.getImageableWidth());
            System.out.println("Height=" + pageFormat.getHeight() + " imageableH=" + pageFormat.getImageableHeight());
        }
        return pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPageFormat(int n, PageFormat pageFormat) {
        if (debugPrint) {
            System.out.println("Set page format for page " + n);
        }
        this.pageFormats.put(new Integer(n), pageFormat);
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (debugPrint) {
            System.out.println("Set page format Standard for page");
            System.out.println("---------------------------------");
            System.out.println("Page format used=" + pageFormat);
            System.out.println("Orientation=" + pageFormat.getOrientation());
            System.out.println("Width=" + pageFormat.getWidth() + " imageableW=" + pageFormat.getImageableWidth());
            System.out.println("Height=" + pageFormat.getHeight() + " imageableH=" + pageFormat.getImageableHeight());
            System.out.println("---------------------------------");
        }
        this.pageFormats.put("standard", pageFormat);
    }

    public static boolean isXMLExtraction() {
        return isXMLExtraction;
    }

    public static void useTextExtraction() {
        isXMLExtraction = false;
    }

    public static void useXMLExtraction() {
        isXMLExtraction = true;
    }

    public void clearScreen() {
        this.currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    public void setStreamCacheSize(int n) {
        this.minimumCacheSize = n;
    }

    public void addImage(BufferedImage bufferedImage) {
        this.currentDisplay.drawImage(bufferedImage);
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public final boolean PDFContainsEmbeddedFonts() throws Exception {
        boolean bl = false;
        for (int i = 1; i < this.pageCount + 1; ++i) {
            PdfObject pdfObject;
            String string = (String)this.pagesReferences.get(new Integer(i));
            if (string == null) continue;
            PageObject pageObject = new PageObject(string);
            pageObject.ignoreStream(true);
            this.currentPdfFile.readObject(pageObject);
            PdfObject pdfObject2 = ((PdfObject)pageObject).getDictionary(2004251818);
            byte[][] byArray = ((PdfObject)pageObject).getKeyArray(1216184967);
            if (byArray == null) continue;
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(pdfObject2);
            pdfStreamDecoder.setExternalImageRender(this.customImageHandler);
            pdfStreamDecoder.init(true, this.renderPage, this.renderMode, this.extractionMode, this.pageData, i, this.currentDisplay, this.currentPdfFile);
            if (this.globalResources != null) {
                this.currentPdfFile.checkResolved(this.globalResources);
                pdfStreamDecoder.readResources(this.globalResources, true);
                pdfObject = this.globalResources.getDictionary(-2089186617);
                if (pdfObject != null) {
                    this.PropertiesObj = pdfObject;
                }
            }
            if (pdfObject2 != null) {
                this.currentPdfFile.checkResolved(pdfObject2);
                pdfStreamDecoder.readResources(pdfObject2, true);
                pdfObject = pdfObject2.getDictionary(-2089186617);
                if (pdfObject != null) {
                    this.PropertiesObj = pdfObject;
                }
            }
            this.setupPage(pdfStreamDecoder, false);
            bl = pdfStreamDecoder.hasEmbeddedFonts();
            if (!bl) continue;
            i = this.pageCount;
        }
        return bl;
    }

    public String getFontsInFile() {
        if (this.fontsInFile == null) {
            return "No fonts defined";
        }
        return this.fontsInFile;
    }

    public AcroRenderer getFormRenderer() {
        return this.formRenderer;
    }

    public boolean isPageSuccessful() {
        return this.operationSuccessful;
    }

    public String getPageDecodeReport() {
        return this.decodeStatus;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5) {
        int n = this.pageData.getMediaBoxHeight(this.pageNumber);
        int n2 = this.pageData.getCropBoxWidth(this.pageNumber);
        int n3 = this.pageData.getCropBoxHeight(this.pageNumber);
        int n4 = this.pageData.getCropBoxX(this.pageNumber);
        int n5 = this.pageData.getCropBoxY(this.pageNumber);
        if (f4 < (float)n5) {
            f4 = n5;
        }
        if (f < (float)n4) {
            f = n4;
        }
        if (f2 > (float)(n3 + n5)) {
            f2 = n3 + n5;
        }
        if (f3 > (float)(n4 + n2)) {
            f3 = n4 + n2;
        }
        if (f3 - f < 1.0f || f2 - f4 < 1.0f) {
            return null;
        }
        float f6 = f5 / 100.0f;
        float f7 = f3 - f;
        float f8 = f2 - f4;
        BufferedImage bufferedImage = new BufferedImage((int)(f7 * f6), (int)(f8 * f6), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (n5 > 0) {
            n5 = n - n3 - n5;
        }
        AffineTransform affineTransform = this.getScalingForImage(this.pageNumber, 0, f6);
        int n6 = -n4;
        int n7 = -n5;
        affineTransform.translate(n6, -n7);
        affineTransform.translate(-(f - (float)n4), (float)n - f2 - (float)n5);
        AffineTransform affineTransform2 = graphics2D.getTransform();
        graphics2D.transform(affineTransform);
        if (this.currentDisplay.addBackground()) {
            graphics2D.setColor(this.currentDisplay.getBackgroundColor());
            graphics2D.fill(new Rectangle(n4, n5, n2, n3));
        }
        this.currentDisplay.setOptimsePainting(true);
        this.currentDisplay.paint(graphics2D, null, null, null, false, false);
        if (this.formRenderer != null && this.formRenderer.hasFormsOnPage(this.pageNumber)) {
            this.formRenderer.getCompData().renderFormsOntoG2(graphics2D, this.pageNumber, f5, 0, this.displayRotation, null, null, this.currentPdfFile);
            this.formRenderer.getCompData().resetScaledLocation(this.oldScaling, this.displayRotation, 0);
        }
        graphics2D.setTransform(affineTransform2);
        graphics2D.dispose();
        return bufferedImage;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        if (this.lastPageDecoded == -1) {
            throw new RuntimeException("No pages decoded - call decodePage(pageNumber) first");
        }
        PdfData pdfData = this.getPdfData();
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData, this.pageData);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        PdfData pdfData = this.pdfBackgroundData;
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData, this.pageData);
    }

    public final String getPDFVersion() {
        return this.pdfVersion;
    }

    public void resetForNonPDFPage() {
        this.displayScaling = null;
        this.currentDisplay.setHiResImageForDisplayMode(false);
        this.fontsInFile = "";
        this.pageCount = 1;
        this.hasOutline = false;
        if (this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageData = new PdfPageData();
    }

    public static void setDebugPrint(boolean bl) {
        debugPrint = bl;
    }

    public void setDisplayView(int n, int n2) {
        boolean bl;
        this.alignment = n2;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        boolean bl2 = bl = n != 1 || this.displayView != 1;
        if (bl && (this.displayView == 3 || n == 3)) {
            bl = false;
        }
        if (n != 1) {
            bl = true;
        }
        boolean bl3 = n != this.displayView;
        int n3 = this.displayView;
        this.displayView = n;
        switch (n) {
            case 1: {
                if (this.pages != null && !bl3) break;
                this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
            }
        }
        if (this.hasViewListener) {
            this.hasViewListener = false;
            this.removeComponentListener(this.viewListener);
        }
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(this.pageCount, this.pageData);
        }
        this.pages.setup(this.useAcceleration, this.currentOffset, this);
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, true, this.pageData, this.insetW, this.insetH);
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
        this.pages.refreshDisplay();
        this.updateUI();
        if (!this.hasViewListener) {
            this.hasViewListener = true;
            this.addComponentListener(this.viewListener);
        }
        if (this.pageNumber > 0) {
            if (bl3 && n == 1) {
                try {
                    this.unsetScaling();
                    this.setPageParameters(this.scaling, this.pageNumber, this.displayRotation);
                    this.invalidate();
                    this.updateUI();
                    this.decodePage(this.pageNumber);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n != 1 && n != 6) {
                throw new RuntimeException("Only SINGLE_PAGE is available in LGPL release");
            }
        }
    }

    public int getCurrentPrintPage() {
        return this.currentPrintPage;
    }

    public void resetCurrentPrintPage() {
        this.currentPrintPage = 0;
        this.formRenderer.getCompData().resetAfterPrinting();
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public void setPageDecodeStatus(int n, Object object) {
        if (n == 16) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (bl && this.current != null) {
                    this.current.reqestTimeout(null);
                }
                if (bl && this.currentImageDecoder != null) {
                    this.currentImageDecoder.reqestTimeout(null);
                }
            } else if (object instanceof Integer) {
                if (this.current != null) {
                    this.current.reqestTimeout(object);
                }
                if (this.currentImageDecoder != null) {
                    this.currentImageDecoder.reqestTimeout(object);
                }
            }
        } else {
            new RuntimeException("Unknown parameter");
        }
    }

    public boolean getPageDecodeStatus(int n) {
        if (n == 4) {
            return this.hasNonEmbeddedCIDFonts;
        }
        if (n == 2) {
            return this.imagesProcessedFully;
        }
        if (n == 16) {
            return this.timeout;
        }
        if (n == 8) {
            return this.hasYCCKimages;
        }
        if (n == 32) {
            return this.ttHintingRequired;
        }
        new RuntimeException("Unknown parameter");
        return false;
    }

    public String getPageDecodeStatusReport(int n) {
        if (n == 4) {
            return this.nonEmbeddedCIDFonts;
        }
        new RuntimeException("Unknown parameter");
        return "";
    }

    public void setPrintAutoRotateAndCenter(boolean bl) {
        this.isPrintAutoRotateAndCenter = bl;
    }

    public void setPrintCurrentView(boolean bl) {
        this.printOnlyVisible = bl;
    }

    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 11: {
                this.swingGUI = object;
                break;
            }
            case 1: {
                this.customImageHandler = (ImageHandler)object;
                break;
            }
            case 19: {
                this.customColorHandler = (ColorHandler)object;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.formRenderer.setFormFactory((FormFactory)object);
                break;
            }
            case 4: {
                this.customSwingHandle = object;
                break;
            }
            case 7: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(object, this, 7);
                break;
            }
            case 5: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(object, this, 5);
                break;
            }
            case 10: {
                if (this.formRenderer == null) break;
                this.formRenderer.getActionHandler().setMouseHandler((SwingMouseHandler)object);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)object);
                break;
            }
            case 9: {
                this.jpedalActionHandlers = (Map)object;
                break;
            }
            case 15: {
                this.customMessageHandler = (CustomMessageHandler)object;
                break;
            }
            case 18: {
                this.customPrintHintingHandler = (CustomPrintHintingHandler)object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + n);
            }
        }
    }

    public Object getExternalHandler(int n) {
        switch (n) {
            case 1: {
                return this.customImageHandler;
            }
            case 19: {
                return this.customColorHandler;
            }
            case 11: {
                return this.swingGUI;
            }
            case 2: {
                return null;
            }
            case 3: {
                return this.formRenderer.getFormFactory();
            }
            case 4: {
                return this.customSwingHandle;
            }
            case 9: {
                return this.jpedalActionHandlers;
            }
            case 15: {
                return this.customMessageHandler;
            }
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.currentOffset;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public int getYCordForPage(int n, float f) {
        if (f == -2.0f || f != -1.0f && f != this.oldScaling) {
            this.oldScaling = f;
            this.pages.setPageOffsets(this.pageCount, n);
        }
        return this.pages.getYCordForPage(n);
    }

    public void unsetScaling() {
        this.displayScaling = null;
    }

    public int getXCordForPage(int n, float f) {
        if (this.displayView == 5) {
            this.scroll.setValue(n - 1);
            return 0;
        }
        if (f == -2.0f || f != -1.0f && f != this.oldScaling) {
            this.oldScaling = f;
            this.pages.setPageOffsets(this.pageCount, n);
        }
        return this.pages.getXCordForPage(n);
    }

    public Object getFormDataForField(String string) {
        Object object = null;
        if (this.formRenderer != null) {
            object = this.formRenderer.getFormDataAsObject(string);
        }
        return object;
    }

    public Set getNamesForAllFields() throws PdfException {
        if (this.formRenderer == null) {
            System.out.println("================No DATA=====================");
            return new HashSet();
        }
        HashSet hashSet = new HashSet();
        List list = this.formRenderer.getComponentNameList();
        if (list != null) {
            hashSet.addAll(list);
        }
        return hashSet;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public boolean isThumbnailsDrawing() {
        return this.thumbnailsBeingDrawn;
    }

    public void setPageCount(int n) {
        this.pageCount = n;
    }

    public boolean isPDF() {
        return this.isPDf;
    }

    public void setPDF(boolean bl) {
        this.isPDf = bl;
    }

    public boolean isMultiPageTiff() {
        return this.isMultiPageTiff;
    }

    public void setMultiPageTiff(boolean bl) {
        this.isMultiPageTiff = bl;
    }

    public String getFileName() {
        return this.filename;
    }

    public int getObjectUnderneath(int n, int n2) {
        if (!this.extractingAsImage && this.displayView == 1) {
            int n3 = this.currentDisplay.getObjectUnderneath(n, n2);
            switch (n3) {
                case -1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(1));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 5: {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                case 6: {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
            return n3;
        }
        return -1;
    }

    public static void setFontReplacements(PdfDecoder pdfDecoder) {
        String[] stringArray = new String[]{"acarialunicodems__cn"};
        PdfDecoder.setSubstitutedFontAliases("adobeheitistd-regular", stringArray);
        if (isRunningOnMac) {
            PdfDecoder.setSubstitutedFontAliases("Courier italic", new String[]{"Courier-Oblique"});
            PdfDecoder.setSubstitutedFontAliases("Courier bold", new String[]{"Courier-Bold"});
            PdfDecoder.setSubstitutedFontAliases("Courier bold italic", new String[]{"Courier-BoldOblique"});
            PdfDecoder.setSubstitutedFontAliases("Courier new italic", new String[]{"CourierNew,italic"});
            PdfDecoder.setSubstitutedFontAliases("Courier new bold", new String[]{"CourierNew,Bold", "Courier-Bold"});
            PdfDecoder.setSubstitutedFontAliases("Courier new bold italic", new String[]{"CourierNew-BoldOblique"});
            PdfDecoder.setSubstitutedFontAliases("Courier new", new String[]{"CourierNew", "Courier"});
            PdfDecoder.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            PdfDecoder.setSubstitutedFontAliases("arial italic", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            PdfDecoder.setSubstitutedFontAliases("arial bold", new String[]{"arial-boldmt", "Helvetica-Bold", "Arial,bold"});
            PdfDecoder.setSubstitutedFontAliases("arial bold italic", new String[]{"Arial-BoldItalicMT"});
            PdfDecoder.setSubstitutedFontAliases("arial Narrow", new String[]{"ArialNarrow"});
            PdfDecoder.setSubstitutedFontAliases("arial Narrow italic", new String[]{"ArialNarrow-italic"});
            PdfDecoder.setSubstitutedFontAliases("arial Narrow bold", new String[]{"ArialNarrow-bold"});
            PdfDecoder.setSubstitutedFontAliases("arial Narrow bold italic", new String[]{"ArialNarrow-bolditalic"});
            PdfDecoder.setSubstitutedFontAliases("times new roman bold", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            PdfDecoder.setSubstitutedFontAliases("times new roman bold italic", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalicMT"});
            PdfDecoder.setSubstitutedFontAliases("times new roman italic", new String[]{"Times-Italic", "TimesNewRoman,Italic", "TimesNewRomanPS-ItalicMT"});
            PdfDecoder.setSubstitutedFontAliases("times new roman", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            PdfDecoder.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        } else {
            PdfDecoder.setSubstitutedFontAliases("Couri", new String[]{"Courier-Oblique", "CourierNew,italic"});
            PdfDecoder.setSubstitutedFontAliases("Courbd", new String[]{"Courier-Bold", "CourierNew,Bold"});
            PdfDecoder.setSubstitutedFontAliases("Courbi", new String[]{"Courier-BoldOblique", "CourierNew-BoldOblique"});
            PdfDecoder.setSubstitutedFontAliases("Cour", new String[]{"CourierNew", "Courier"});
            PdfDecoder.setSubstitutedFontAliases("arial", new String[]{"Helvetica", "arialmt"});
            PdfDecoder.setSubstitutedFontAliases("ariali", new String[]{"arial-italic", "arial-italicmt", "Helvetica-Oblique", "Arial,Italic"});
            PdfDecoder.setSubstitutedFontAliases("arialbd", new String[]{"arial-boldmt", "Helvetica-Bold", "Arial,bold", "arial bold"});
            PdfDecoder.setSubstitutedFontAliases("arialn", new String[]{"ArialNarrow"});
            PdfDecoder.setSubstitutedFontAliases("arialni", new String[]{"ArialNarrow-italic"});
            PdfDecoder.setSubstitutedFontAliases("arialnb", new String[]{"ArialNarrow-bold"});
            PdfDecoder.setSubstitutedFontAliases("arialnbi", new String[]{"ArialNarrow-bolditalic"});
            PdfDecoder.setSubstitutedFontAliases("timesbd", new String[]{"Times-Bold", "TimesNewRoman,Bold", "TimesNewRomanPS-BoldMT"});
            PdfDecoder.setSubstitutedFontAliases("timesi", new String[]{"Times-BoldItalic", "TimesNewRoman,BoldItalic"});
            PdfDecoder.setSubstitutedFontAliases("timesbi", new String[]{"Times-Italic", "TimesNewRoman,Italic"});
            PdfDecoder.setSubstitutedFontAliases("times", new String[]{"Times-Roman", "TimesNewRoman", "Times", "TimesNewRomanPSMT"});
            PdfDecoder.setSubstitutedFontAliases("wingdings", new String[]{"ZapfDingbats", "ZaDb"});
        }
        PdfDecoder.setFontDirs(new String[]{"C:/windows/fonts/", "C:/winNT/fonts/", "/System/Library/Fonts/", "/Library/Fonts/"});
    }

    public Map getJPedalActionHandlers() {
        return this.jpedalActionHandlers;
    }

    public boolean isForm() {
        return this.acroFormObj != null;
    }

    public void goBackAView() {
    }

    public void goForwardAView() {
    }

    static {
        try {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                isRunningOnMac = true;
            } else if (string.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (string.startsWith("AIX")) {
                isRunningOnAIX = true;
            } else if (string.equals("Linux")) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        showErrorMessages = false;
    }

    public class LinearThread
    extends Thread {
        public int percentageDone = 0;
        FileChannel fos;
        PdfObject linearObj;
        InputStream is;
        File tempURLFile;
        LinearizedHintTable linHintTable;
        final byte[] startObj = "obj".getBytes();
        final byte[] endObj = "endobj".getBytes();
        int startCharReached = 0;
        int endCharReached = 0;
        int startObjPtr = 0;
        int endObjPtr = 0;
        int bufSize = 8192;
        int lastBytes = 8192;
        int generation = 0;
        int ref = 0;
        int firstObjLength = 0;

        public LinearThread(InputStream inputStream, FileChannel fileChannel, File file, PdfObject pdfObject, byte[] byArray, LinearizedHintTable linearizedHintTable) {
            this.fos = fileChannel;
            this.linearObj = pdfObject;
            this.is = inputStream;
            this.tempURLFile = file;
            this.linHintTable = linearizedHintTable;
            this.firstObjLength = byArray.length;
            this.scanStreamForObjects(0, null, byArray);
        }

        public int getPercentageLoaded() {
            return this.percentageDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block18: {
                int n;
                int n2 = this.linearObj.getInt(28);
                int n3 = 0;
                byte[] byArray = new byte[this.lastBytes];
                byte[] byArray2 = new byte[this.bufSize];
                while ((n = this.is.read(byArray2)) != -1 && !this.isInterrupted() && this.isAlive()) {
                    if (n > 0) {
                        FileChannel fileChannel = this.fos;
                        synchronized (fileChannel) {
                            byte[] byArray3 = new byte[n];
                            System.arraycopy(byArray2, 0, byArray3, 0, n);
                            byArray2 = byArray3;
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
                            this.fos.write(byteBuffer);
                        }
                    }
                    if (n > 0) {
                        this.scanStreamForObjects(this.firstObjLength + n3, byArray, byArray2);
                        n3 += n;
                        int n4 = 30;
                        int n5 = byArray2.length;
                        if (n4 > n5 - 1) {
                            n4 = n5 - 1;
                        }
                        byArray = new byte[n4];
                        System.arraycopy(byArray2, n5 - n4, byArray, 0, n4);
                    }
                    this.percentageDone = (int)(100.0f * ((float)n3 / (float)n2));
                }
                this.linHintTable.setFinishedReading();
                Object var11_13 = null;
                try {
                    this.is.close();
                    PdfDecoder.this.pagesReferences.clear();
                    PdfDecoder.this.currentPdfFile = new PdfReader();
                    if (this.isAlive() && !this.isInterrupted()) {
                        PdfDecoder.this.openPdfFile(this.tempURLFile.getAbsolutePath());
                        PdfDecoder.this.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
                    }
                    break block18;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block18;
                {
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var11_14 = null;
                        try {
                            this.is.close();
                            PdfDecoder.this.pagesReferences.clear();
                            PdfDecoder.this.currentPdfFile = new PdfReader();
                            if (this.isAlive() && !this.isInterrupted()) {
                                PdfDecoder.this.openPdfFile(this.tempURLFile.getAbsolutePath());
                                PdfDecoder.this.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
                            }
                            break block18;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    try {
                        this.is.close();
                        PdfDecoder.this.pagesReferences.clear();
                        PdfDecoder.this.currentPdfFile = new PdfReader();
                        if (this.isAlive() && !this.isInterrupted()) {
                            PdfDecoder.this.openPdfFile(this.tempURLFile.getAbsolutePath());
                            PdfDecoder.this.objectStoreRef.storeFileName(this.tempURLFile.getName().substring(0, this.tempURLFile.getName().lastIndexOf(46)));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }

        private void scanStreamForObjects(int n, byte[] byArray, byte[] byArray2) {
            int n2 = byArray2.length;
            for (int i = 0; i < n2; ++i) {
                if (this.startCharReached == 0) {
                    if (byArray2[i] != 32 && byArray2[i] != 0 && byArray2[i] != 10 && byArray2[i] != 32) continue;
                    ++this.startCharReached;
                    continue;
                }
                if (this.startCharReached < 4) {
                    if (byArray2[i] == this.startObj[this.startCharReached - 1]) {
                        if (this.startCharReached == 3) {
                            int n3;
                            this.startObjPtr = n + i - 4;
                            int n4 = i - 4;
                            byte[] byArray3 = null;
                            if (byArray != null && n4 < 30) {
                                n3 = byArray.length;
                                int n5 = byArray2.length;
                                byArray3 = new byte[n3 + n5];
                                System.arraycopy(byArray, 0, byArray3, 0, n3);
                                System.arraycopy(byArray2, 0, byArray3, n3, n5);
                                n4 += n3;
                            } else {
                                byArray3 = byArray2;
                            }
                            n3 = n4;
                            while (byArray3[n4] != 10 && byArray3[n4] != 13 && byArray3[n4] != 32 && byArray3[n4] != 9) {
                                --n4;
                                --this.startObjPtr;
                            }
                            this.generation = PdfReader.parseInt(n4 + 1, n3, byArray3);
                            while (byArray3[n4] == 10 || byArray3[n4] == 13 || byArray3[n4] == 32 || byArray3[n4] == 47 || byArray3[n4] == 60) {
                                --n4;
                                --this.startObjPtr;
                            }
                            n3 = n4 + 1;
                            while (byArray3[n4] != 10 && byArray3[n4] != 13 && byArray3[n4] != 32 && byArray3[n4] != 47 && byArray3[n4] != 60 && byArray3[n4] != 62) {
                                --n4;
                                --this.startObjPtr;
                            }
                            this.ref = PdfReader.parseInt(n4 + 1, n3, byArray3);
                        }
                        ++this.startCharReached;
                        continue;
                    }
                    this.startCharReached = 0;
                    continue;
                }
                if (byArray2[i] == this.endObj[this.endCharReached]) {
                    ++this.endCharReached;
                    if (this.endCharReached != 6) continue;
                    this.endObjPtr = n + i;
                    this.linHintTable.storeOffset(this.ref, this.startObjPtr, this.endObjPtr);
                    this.startCharReached = 0;
                    this.endCharReached = 0;
                    continue;
                }
                this.endCharReached = 0;
            }
        }
    }

    private class ScrollListener
    implements AdjustmentListener {
        java.util.Timer t = null;
        int pNum = 0;

        private ScrollListener() {
        }

        private void startTimer() {
            if (this.t != null) {
                this.t.cancel();
            }
            PageListener pageListener = new PageListener();
            this.t = new java.util.Timer();
            this.t.schedule((TimerTask)pageListener, 100L);
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            PdfDecoder.this.pages.stopGeneratingPage();
            PdfDecoder.this.pages.drawBorder();
            this.pNum = adjustmentEvent.getAdjustable().getValue() + 1;
            this.startTimer();
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            public void run() {
                ((ScrollListener)ScrollListener.this).PdfDecoder.this.pages.stopGeneratingPage();
                ((ScrollListener)ScrollListener.this).PdfDecoder.this.pages.decodeOtherPages(ScrollListener.this.pNum, ((ScrollListener)ScrollListener.this).PdfDecoder.this.pageCount);
            }
        }
    }

    private class ProgressListener
    implements ActionListener {
        private ProgressListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDecoder.this.statusBar.setProgress((int)((PdfDecoder)PdfDecoder.this).statusBar.percentageDone);
        }
    }

    private class RefreshLayout
    extends ComponentAdapter {
        java.util.Timer t2 = null;

        private RefreshLayout() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.startTimer();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.startTimer();
        }

        private void startTimer() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
            PageListener pageListener = new PageListener();
            this.t2 = new java.util.Timer();
            this.t2.schedule((TimerTask)pageListener, 500L);
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            public void run() {
                ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pages.stopGeneratingPage();
                ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pages.decodeOtherPages(((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageNumber, ((RefreshLayout)RefreshLayout.this).PdfDecoder.this.pageCount);
            }
        }
    }
}

