/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public class RotatedTexturePaint
implements Paint,
PdfPaint {
    DynamicVectorRenderer patternOnTile = null;
    private float[][] matrix;
    private float xStep;
    private float yStep;
    private float offsetXOnCanvas;
    private float offsetYOnCanvas;
    private float tileXoffset;
    private float tileYoffset;
    private AffineTransform imageScale;
    boolean cacheToTile;
    boolean isSideways;
    boolean isSkewed = false;
    boolean isUpsideDown = false;
    boolean isRotated;
    boolean debug = false;
    BufferedImage img;
    PdfObject patternObj = null;

    public RotatedTexturePaint(boolean bl, float[][] fArray, PdfObject pdfObject, boolean bl2, DynamicVectorRenderer dynamicVectorRenderer, float[][] fArray2, float f, float f2, float f3, float f4, AffineTransform affineTransform) {
        this.patternObj = pdfObject;
        this.isSideways = bl;
        this.isSkewed = fArray != null && fArray[0][0] > 0.0f && fArray[0][1] < 0.0f && fArray[1][0] > 0.0f && fArray[1][1] > 0.0f;
        this.cacheToTile = bl2;
        this.patternOnTile = dynamicVectorRenderer;
        this.matrix = fArray2;
        this.xStep = f;
        this.yStep = f2;
        this.offsetXOnCanvas = f3;
        this.offsetYOnCanvas = f4;
        this.imageScale = affineTransform;
        if (this.debug) {
            System.out.println("=======PatternObj=" + pdfObject.getObjectRefAsString());
            System.out.println("isSideways=" + bl + " isSkewed=" + this.isSkewed);
            System.out.println("cacheToTile=" + bl2);
            System.out.println("patternOnTile=" + dynamicVectorRenderer);
            System.out.println("xStep=" + f + " yStep=" + f2);
            System.out.println("offsetXOnCanvas=" + f3 + " offsetYOnCanvas=" + f4);
            System.out.println("imageScale=" + affineTransform);
            Matrix.show(fArray2);
        }
        if (fArray2[0][0] != 0.0f && fArray2[1][1] != 0.0f) {
            this.tileXoffset = f * fArray2[0][1];
            this.tileYoffset = f2 * fArray2[1][0];
            if (this.debug) {
                System.out.println("set tileXoffset=" + this.tileXoffset + " tileYoffset=" + this.tileYoffset);
            }
        }
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        int n;
        int n2;
        float f;
        float f2;
        Graphics2D graphics2D = null;
        AffineTransform affineTransform2 = null;
        if (this.debug) {
            this.img = new BufferedImage(1000, 1000, 1);
            graphics2D = this.img.createGraphics();
            graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
            graphics2D.setPaint(Color.CYAN);
            graphics2D.fillRect(0, 0, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            affineTransform2 = graphics2D.getTransform();
        }
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        if (this.debug) {
            System.out.println("area to fill w=" + n3 + " h=" + n4);
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        AffineTransform affineTransform3 = graphics2D2.getTransform();
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.isSkewed) {
            f2 = this.xStep * this.matrix[0][0] + this.yStep * this.matrix[1][0];
            f = this.yStep * this.matrix[1][1] - this.xStep * this.matrix[0][1];
        } else {
            f2 = this.xStep * this.matrix[0][0] - this.yStep * this.matrix[1][0];
            f = -(this.yStep * this.matrix[1][1]) - this.xStep * this.matrix[0][1];
        }
        float f5 = rectangle2D.getBounds().width;
        float f6 = rectangle2D.getBounds().height;
        int n5 = (int)(f6 / f);
        if (this.debug) {
            System.out.println(n5 + " shapeW=" + f5 + " shapeH=" + f6 + " rotatedWidth=" + f2 + " rotatedHeight=" + f);
        }
        if (n5 > 1) {
            f3 = f5 - f * (float)n5;
            f4 = 5.0f - (f6 - f2 * (float)n5);
            if (this.debug) {
                System.out.println("Multiple Rows OffsetX=" + f3 + " offsetY=" + f4);
            }
        } else if (f > f5) {
            f3 = f - f5;
            f4 = f6 - f2;
            if (this.debug) {
                System.out.println("rotatedHeight>shapeW OffsetX=" + f3 + " offsetY=" + f4);
            }
        } else {
            f3 = f6 - f;
            f4 = f5 - f2;
            if (this.debug) {
                System.out.println("general case OffsetX=" + f3 + " offsetY=" + f4);
            }
        }
        Rectangle rectangle2 = this.patternOnTile.getOccupiedArea().getBounds();
        int n6 = 0;
        int n7 = 0;
        if (rectangle2.x < 0) {
            n2 = rectangle2.width - rectangle2.x;
            n6 = rectangle2.x;
        } else {
            n2 = rectangle2.width + rectangle2.x;
        }
        if (rectangle2.y < 0) {
            n = rectangle2.height - rectangle2.y;
            n7 = rectangle2.y;
        } else {
            n = rectangle2.height + rectangle2.y;
        }
        BufferedImage bufferedImage2 = null;
        if (this.isSideways) {
            this.imageScale = new AffineTransform();
            this.imageScale.scale(-1.0, 1.0);
            this.imageScale.translate(-((double)this.offsetXOnCanvas / affineTransform.getScaleX()), 0.0);
            if (this.debug) {
                System.out.println("isSideWay imageScale=" + this.imageScale);
            }
        } else if (this.matrix[0][0] >= 0.0f && this.matrix[1][0] >= 0.0f && this.matrix[0][1] <= 0.0f && this.matrix[1][1] >= 0.0f) {
            this.imageScale = new AffineTransform();
            this.imageScale.scale(-1.0, -1.0);
            if (!this.isSkewed) {
                this.imageScale.translate(0.0, this.patternOnTile.getOccupiedArea().height - this.patternOnTile.getOccupiedArea().y);
            } else {
                this.imageScale.translate(0.0, -(this.patternOnTile.getOccupiedArea().height - this.patternOnTile.getOccupiedArea().y));
            }
            if (this.debug) {
                System.out.println("LHS fit imageScale=" + this.imageScale);
            }
        }
        if (rectangle2D.getBounds().width < this.patternOnTile.getOccupiedArea().width && rectangle2D.getBounds().height < this.patternOnTile.getOccupiedArea().height) {
            double d;
            double d2;
            if (this.isSideways) {
                d2 = -graphics2D2.getTransform().getTranslateX() - (double)(this.offsetXOnCanvas - (float)rectangle.width);
                d = -graphics2D2.getTransform().getTranslateY() + (double)(this.tileYoffset - this.offsetYOnCanvas);
                graphics2D2.translate(d2, d);
                if (this.debug) {
                    System.out.println("isSideways translate=" + d2 + " " + d);
                    graphics2D.translate(d2, d);
                }
            } else {
                d2 = (float)n2 - f3 + 5.0f;
                d = -graphics2D2.getTransform().getTranslateY() + (double)(this.tileYoffset - this.offsetYOnCanvas);
                graphics2D2.translate(d2, d);
                if (this.debug) {
                    System.out.println("translate=" + d2 + " " + d);
                    graphics2D.translate(d2, d);
                }
            }
            this.patternOnTile.paint(graphics2D2, null, this.imageScale, null, false, false);
            if (this.debug) {
                this.patternOnTile.paint(graphics2D, null, this.imageScale, null, false, false);
            }
        } else {
            if (this.cacheToTile) {
                if (this.debug) {
                    System.out.println("cached to tile size " + n2 + " " + n + " " + this.xStep + " " + this.yStep);
                }
                bufferedImage2 = new BufferedImage(n2, n, 2);
                Graphics2D graphics2D3 = bufferedImage2.createGraphics();
                graphics2D3.translate(-n6, -n7);
                this.patternOnTile.paint(graphics2D3, null, null, null, false, false);
            }
            float f7 = (float)n4 + this.yStep + this.offsetYOnCanvas;
            if (this.cacheToTile) {
                f7 += (float)(bufferedImage2.getHeight() * 2);
                if (this.debug) {
                    System.out.println("adjust maxYY to " + f7);
                }
            }
            float f8 = 0.0f;
            float f9 = 0.0f;
            for (float f10 = 0.0f; f10 < f7; f10 += this.offsetYOnCanvas) {
                f9 = -this.tileYoffset - this.tileYoffset;
                for (float f11 = -this.offsetXOnCanvas; f11 < (float)n3 + this.xStep + this.offsetXOnCanvas; f11 += this.offsetXOnCanvas) {
                    graphics2D2.translate(f3 + f11 + f8, f4 + f10 + f9);
                    if (this.debug) {
                        graphics2D.translate(f3 + f11 + f8, f4 + f10 + f9);
                    }
                    if (this.cacheToTile) {
                        AffineTransform affineTransform4 = new AffineTransform();
                        affineTransform4.scale(1.0, -1.0);
                        affineTransform4.translate(0.0, bufferedImage2.getHeight());
                        ColorSpaceConvertor.drawImage(graphics2D2, bufferedImage2, affineTransform4, null);
                        if (this.debug) {
                            ColorSpaceConvertor.drawImage(graphics2D, bufferedImage2, affineTransform4, null);
                        }
                    } else {
                        this.patternOnTile.paint(graphics2D2, null, this.imageScale, null, false, false);
                        if (this.debug) {
                            this.patternOnTile.paint(graphics2D, null, this.imageScale, null, false, false);
                        }
                    }
                    graphics2D2.setTransform(affineTransform3);
                    if (this.debug) {
                        graphics2D.setTransform(affineTransform2);
                    }
                    if (this.isSkewed) {
                        f9 -= this.tileYoffset;
                        continue;
                    }
                    f9 += this.tileYoffset;
                }
                f8 -= this.tileXoffset;
            }
        }
        Rectangle rectangle3 = rectangle2D.getBounds();
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height));
        if (this.debug) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.setTransform(new AffineTransform());
            graphics2D.draw(rectangle2D);
            try {
                ImageIO.write((RenderedImage)this.img, "PNG", new File("/Users/markee/Desktop/Pattern-" + this.patternObj.getObjectRefAsString() + "-" + rectangle3.x + "-" + rectangle3.y + ".png"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bufferedImage2 != null) {
                BufferedImage bufferedImage3 = new BufferedImage(1000, 1000, 1);
                Graphics2D graphics2D4 = bufferedImage3.createGraphics();
                graphics2D4.setPaint(Color.CYAN);
                graphics2D4.fill(rectangle2D);
                graphics2D4.setPaint(Color.RED);
                graphics2D4.draw(rectangle2D);
                graphics2D4.drawImage(bufferedImage, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, null);
                try {
                    ImageIO.write((RenderedImage)bufferedImage3, "PNG", new File("/Users/markee/Desktop/Pattern-" + this.patternObj.getObjectRefAsString() + "-" + rectangle3.x + "-" + rectangle3.y + "-wholeImage.png"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return texturePaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
    }

    public void setScaling(double d, double d2, float f, float f2, float f3) {
    }

    public boolean isPattern() {
        return false;
    }

    public void setPattern(int n) {
    }

    public int getRGB() {
        return 0;
    }

    public int getTransparency() {
        return 0;
    }
}

