/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    private static final int Black = 1009857357;
    private static final int Cyan = 323563838;
    private static final int Magenta = 895186280;
    public static final int Yellow = 1010591868;
    protected ColorMapping colorMapper;
    protected Map cachedValues = new HashMap();
    private float[] domain;
    protected int cmykMapping = -1;
    protected boolean isProcess = false;
    protected static final int NOCMYK = -1;
    protected static final int MYK = 1;
    protected static final int CMY = 2;
    protected static final int CMK = 4;
    protected static final int CY = 5;
    protected static final int MY = 6;
    protected static final int CMYK = 7;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader pdfObjectReader, PdfObject pdfObject, PdfObject pdfObject2, Map map) {
        this.value = -2073385820;
        if (map != null) {
            this.cachedValues = map;
        }
        this.processColorToken(pdfObjectReader, pdfObject, pdfObject2);
    }

    protected void processColorToken(PdfObjectReader pdfObjectReader, PdfObject pdfObject, PdfObject pdfObject2) {
        PdfObject pdfObject3;
        PdfObject pdfObject4;
        int n;
        Object object;
        this.domain = null;
        if (pdfObject2.getDictionary(861242754) != null) {
            this.isProcess = true;
        }
        byte[] byArray = null;
        byte[][] byArray2 = null;
        if (this.value == -2073385820) {
            byArray = pdfObject2.getStringValueAsByte(506543413);
            this.componentCount = 1;
        } else {
            byArray2 = pdfObject2.getStringArray(1920898752);
            this.componentCount = byArray2.length;
        }
        this.cmykMapping = -1;
        if (this.componentCount == 6) {
            object = new int[6];
            for (n = 0; n < 6; ++n) {
                object[n] = PdfDictionary.generateChecksum(1, byArray2[n].length - 1, byArray2[n]);
            }
            if (object[0] == 323563838 && object[1] == 895186280 && object[2] == 1010591868 && object[3] == 1009857357) {
                this.cmykMapping = 7;
            }
        } else if (this.componentCount == 3) {
            object = new int[3];
            for (n = 0; n < 3; ++n) {
                object[n] = PdfDictionary.generateChecksum(1, byArray2[n].length - 1, byArray2[n]);
            }
            if (object[0] == 895186280 && object[1] == 1010591868 && object[2] == 1009857357) {
                this.cmykMapping = 1;
            } else if (object[0] == 323563838 && object[1] == 895186280 && object[2] == 1010591868) {
                this.cmykMapping = 2;
            } else if (object[0] == 323563838 && object[1] == 895186280 && object[2] == 1009857357) {
                this.cmykMapping = 4;
            }
        } else if (this.componentCount == 2) {
            object = new int[2];
            for (n = 0; n < 2; ++n) {
                object[n] = PdfDictionary.generateChecksum(1, byArray2[n].length - 1, byArray2[n]);
            }
            if (object[0] == 323563838 && object[1] == 1010591868) {
                this.cmykMapping = 5;
            } else if (object[0] == 895186280 && object[1] == 1010591868) {
                this.cmykMapping = 6;
            }
        }
        if (this.cmykMapping != -1) {
            this.altCS = new DeviceCMYKColorSpace();
        } else {
            pdfObject = pdfObject.getDictionary(-1247101998);
            object = pdfObject.getObjectRefAsString();
            this.altCS = ColorspaceFactory.getColorSpaceInstance(false, pdfObjectReader, pdfObject, this.cachedValues, null, false);
            if (this.altCS.getID() == 1247168582 && pdfObject.getParameterConstant(2054519176) == 1498837125) {
                this.altCS = new DeviceCMYKColorSpace();
            }
        }
        if (byArray != null) {
            int n2 = byArray.length;
            n = 0;
            byte[] byArray3 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] == 35) {
                    int n3;
                    if ((n3 = byArray[++i]) >= 65 && n3 <= 70) {
                        n3 -= 55;
                    } else if (n3 >= 97 && n3 <= 102) {
                        n3 -= 87;
                    } else if (n3 >= 48 && n3 <= 57) {
                        n3 -= 48;
                    }
                    ++i;
                    while (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) {
                        ++i;
                    }
                    int n4 = byArray[i];
                    if (n4 >= 65 && n4 <= 70) {
                        n4 -= 55;
                    } else if (n4 >= 97 && n4 <= 102) {
                        n4 -= 87;
                    } else if (n4 >= 48 && n4 <= 57) {
                        n4 -= 48;
                    }
                    byArray3[n] = (byte)(n4 + (n3 << 4));
                } else {
                    byArray3[n] = byArray[i];
                }
                ++n;
            }
            if (n != n2) {
                byArray = new byte[n];
                System.arraycopy(byArray3, 0, byArray, 0, n);
            }
            this.pantoneName = new String(byArray);
        }
        if ((pdfObject4 = pdfObject2.getDictionary(-1313946392)) == null) {
            pdfObject.getDictionary(-1313946392);
        }
        if (pdfObject4 == null && (pdfObject3 = pdfObject2.getDictionary(895578984)) != null) {
            pdfObject4 = pdfObject3.getDictionary(-1313946392);
        }
        this.colorMapper = new ColorMapping(pdfObjectReader, pdfObject4);
        this.domain = pdfObject4.getFloatArray(1026641277);
    }

    private void setColor(float f) {
        try {
            int n = 1;
            if (this.domain != null) {
                n = this.domain.length / 2;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = f;
            }
            float[] fArray2 = this.colorMapper.getOperandFloat(fArray);
            this.altCS.setColor(fArray2, fArray2.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor(float[] fArray, int n) {
        this.setColor(fArray[0]);
    }

    public void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{Float.parseFloat(stringArray[0])};
        this.setColor(fArray, 1);
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            Object object;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(imageReader = (object = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            object = imageReader.readRaster(0, null);
            object = SeparationColorSpace.cleanupRaster((Raster)object, n3, n4, 1);
            int n5 = ((Raster)object).getWidth();
            int n6 = ((Raster)object).getHeight();
            DataBufferByte dataBufferByte = (DataBufferByte)((Raster)object).getDataBuffer();
            byte[] byArray2 = dataBufferByte.getData();
            bufferedImage = this.createImage(n5, n6, byArray2, bl);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.createImage(n, n2, byArray, false);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, byte[] byArray, boolean bl) {
        int n3;
        int n4 = 3 * n * n2;
        byte[] byArray2 = new byte[n4];
        int n5 = byArray.length;
        int n6 = 0;
        float[][] fArray = new float[3][256];
        for (n3 = 0; n3 < 255; ++n3) {
            fArray[0][n3] = -1.0f;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = byArray[n3] & 0xFF;
            if (fArray[0][n7] == -1.0f) {
                if (bl) {
                    this.setColor(1.0f - (float)n7 / 255.0f);
                } else {
                    this.setColor((float)n7 / 255.0f);
                }
                fArray[0][n7] = ((Color)((Object)this.getColor())).getRed();
                fArray[1][n7] = ((Color)((Object)this.getColor())).getGreen();
                fArray[2][n7] = ((Color)((Object)this.getColor())).getBlue();
            }
            for (int i = 0; i < 3; ++i) {
                byArray2[n6] = (byte)fArray[i][n7];
                ++n6;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        byte[] byArray2 = new byte[768];
        try {
            int n = 0;
            float[] fArray = new float[1];
            Color color = null;
            int n2 = byArray.length;
            float[] fArray2 = new float[this.componentCount];
            for (int i = 0; i < n2; i += this.componentCount) {
                if (this.componentCount == 1 && this.value == -2073385820 && this.colorMapper == null) {
                    fArray = new float[1];
                    fArray[1] = byArray[i] & 0xFF;
                    this.setColor(fArray, 1);
                    color = (Color)((Object)this.getColor());
                } else {
                    for (int j = 0; j < this.componentCount; ++j) {
                        fArray2[j] = (float)(byArray[i + j] & 0xFF) / 255.0f;
                    }
                    float[] fArray3 = this.colorMapper.getOperandFloat(fArray2);
                    this.altCS.setColor(fArray3, fArray3.length);
                    color = (Color)((Object)this.altCS.getColor());
                }
                byArray2[n] = (byte)color.getRed();
                byArray2[++n] = (byte)color.getGreen();
                byArray2[++n] = (byte)color.getBlue();
                ++n;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray2;
    }

    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

