/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.MultiViewListener;
import org.jpedal.examples.simpleviewer.RecentDocuments;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DownloadProgress;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ErrorDialog;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.Save;
import org.jpedal.examples.simpleviewer.gui.popups.SaveBitmap;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.examples.simpleviewer.gui.popups.SignWizardModel;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.TipOfTheDay;
import org.jpedal.examples.simpleviewer.gui.popups.UpdateDialog;
import org.jpedal.examples.simpleviewer.gui.popups.Wizard;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMousePanning;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseSelection;
import org.jpedal.examples.simpleviewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.simpleviewer.objects.SignData;
import org.jpedal.examples.simpleviewer.utils.Exporter;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.examples.simpleviewer.utils.ItextFunctions;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalActionHandler;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.JAITiffHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class Commands {
    public static final int INFO = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int TIP = 20;
    public static final int CASCADE = 21;
    public static final int TILE = 22;
    public static final int UPDATE = 23;
    public static final int PREFERENCES = 24;
    public static final int COPY = 25;
    public static final int SELECTALL = 26;
    public static final int DESELECTALL = 27;
    public static final int UPDATEGUILAYOUT = 28;
    public static final int MOUSEMODE = 29;
    public static final int PANMODE = 30;
    public static final int TEXTSELECT = 31;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int PAGEFLOW = 62;
    public static final int FULLSCREEN = 61;
    public static final int RSS = 997;
    public static final int HELP = 998;
    public static final int BUY = 999;
    public static final int QUALITY = 250;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int SAVEFORM = 500;
    public static final int PDF = 501;
    public static final int ROTATE = 502;
    public static final int DELETE = 503;
    public static final int ADD = 504;
    public static final int SECURITY = 505;
    public static final int ADDHEADERFOOTER = 506;
    public static final int STAMPTEXT = 507;
    public static final int STAMPIMAGE = 508;
    public static final int SETCROP = 509;
    public static final int NUP = 510;
    public static final int HANDOUTS = 511;
    public static final int SIGN = 512;
    public static final int HIGHLIGHT = 600;
    public static final int SCROLL = 601;
    public static final int ADDVIEW = 700;
    public static final int FORWARD = 701;
    public static final int BACK = 702;
    public static final int PAGECOUNT = 703;
    public static final int CURRENTPAGE = 704;
    public static final int GETOUTLINEPANEL = 705;
    public static final int GETTHUMBNAILPANEL = 706;
    public static final int GETPAGECOUNTER = 707;
    public static final int PAGEGROUPING = 708;
    public static final Integer FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN = new Integer(1);
    public static final Integer SEARCH_RETURNED_TO_START = new Integer(2);
    public static final Integer SEARCH_NOT_FOUND = new Integer(3);
    private boolean allHighlightsShown = false;
    private Values commonValues;
    private SwingGUI currentGUI;
    private PdfDecoder decode_pdf;
    private GUIThumbnailPanel thumbnails;
    Window win;
    private Point screenPosition = null;
    private int tiffImageToLoad = 0;
    public InputStream inputStream = null;
    private JAITiffHelper tiffHelper = null;
    private BufferedImage img = null;
    private int noOfRecentDocs;
    private RecentDocuments recent;
    private JMenuItem[] recentDocuments;
    private final Font headFont = new Font("SansSerif", 1, 10);
    private boolean display = true;
    private PropertiesFile properties;
    private final GUISearchWindow searchFrame;
    private SearchList results;
    private Printer currentPrinter;
    private boolean isOpening;
    private boolean fileIsURL;
    private int lastSearchIndex = 0;
    private boolean openingTransferedFile;
    int startX = 0;
    int startY = 0;
    private MultiViewListener multiViewListener;

    public Commands(Values values, SwingGUI swingGUI, PdfDecoder pdfDecoder, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow, Printer printer) {
        this.commonValues = values;
        this.currentGUI = swingGUI;
        this.decode_pdf = pdfDecoder;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
        this.currentPrinter = printer;
        this.noOfRecentDocs = propertiesFile.getNoRecentDocumentsToDisplay();
        this.recentDocuments = new JMenuItem[this.noOfRecentDocs];
        this.recent = new RecentDocuments(this.noOfRecentDocs, propertiesFile);
        this.searchFrame = gUISearchWindow;
    }

    public void addToRecentDocuments(String string) {
        this.recent.addToFileList(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object executeCommand(int n, Object[] objectArray) {
        Object object;
        Object object2 = null;
        Map map = this.decode_pdf.getJPedalActionHandlers();
        if (map != null && (object = (JPedalActionHandler)map.get(new Integer(n))) != null) {
            object.actionPerformed(this.currentGUI, this);
            return null;
        }
        switch (n) {
            case 600: {
                this.decode_pdf.clearHighlights();
                if (objectArray == null) return object2;
                object = (Rectangle[])objectArray[0];
                int n2 = (Integer)objectArray[1];
                this.decode_pdf.clearHighlights();
                if (((Object)object).length != 1 || object[0] != null) {
                    this.decode_pdf.addHighlights(new Rectangle[]{object[0]}, true, n2);
                }
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                return object2;
            }
            case 601: {
                if (objectArray == null) return object2;
                object = (Rectangle)objectArray[0];
                int n3 = this.commonValues.getCurrentPage();
                if (objectArray.length > 1 && objectArray[1] != null) {
                    n3 = (Integer)objectArray[1];
                }
                if (object == null) return object2;
                this.decode_pdf.scrollRectToHighlight((Rectangle)object, n3);
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                return object2;
            }
            case 1: {
                if (objectArray != null) return object2;
                this.currentGUI.getInfoBox();
                return object2;
            }
            case 2: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.OpenFile"));
                    return object2;
                }
                object = new SaveBitmap(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n4 = ((Save)object).display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.SaveAsBitmap"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return object2;
                }
                if (n4 != 0) return object2;
            }
            case 3: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                object = new SaveImage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n5 = ((Save)object).display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveImagesFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return object2;
                }
                if (n5 != 0) return object2;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractImagesOnPages((SaveImage)object);
                return object2;
            }
            case 4: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                if (!this.decode_pdf.isExtractionAllowed()) {
                    this.currentGUI.showMessageDialog("Not allowed");
                    return object2;
                }
                object = new SaveText(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n6 = ((Save)object).display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveTextFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return object2;
                }
                if (n6 != 0) return object2;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractTextOnPages((SaveText)object);
                return object2;
            }
            case 5: {
                if (objectArray != null) return object2;
                this.saveFile();
                return object2;
            }
            case 6: {
                this.currentGUI.showMessageDialog("OS version does not support printing");
                return object2;
            }
            case 7: {
                if (objectArray != null) return object2;
                Commands commands = this;
                if (commands.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerStillPrinting.text"));
                    return object2;
                }
                this.exit();
                return object2;
            }
            case 8: {
                if (objectArray != null) return object2;
                this.currentGUI.toogleAutoScrolling();
                return object2;
            }
            case 9: {
                if (objectArray != null) return object2;
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                    return object2;
                }
                this.currentGUI.showDocumentProperties(this.commonValues.getSelectedFile(), this.commonValues.getInputDir(), this.commonValues.getFileSize(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                return object2;
            }
            case 10: {
                this.inputStream = null;
                if (objectArray == null) {
                    this.handleUnsaveForms();
                    Commands commands = this;
                    if (commands.currentPrinter.isPrinting()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                        return object2;
                    }
                    Commands commands2 = this;
                    if (commands2.commonValues.isProcessing() || this.isOpening) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                        return object2;
                    }
                    if (this.commonValues.isContentExtractor()) {
                        this.currentGUI.setPDFOutlineVisible(false);
                    }
                    this.selectFile();
                    this.fileIsURL = false;
                    return object2;
                }
                if (objectArray.length == 2 && objectArray[0] instanceof byte[] && objectArray[1] instanceof String) {
                    object = (byte[])objectArray[0];
                    String string = (String)objectArray[1];
                    this.commonValues.setFileSize(((Rectangle[])object).length);
                    this.commonValues.setSelectedFile(string);
                    this.currentGUI.setViewerTitle(null);
                    if (this.commonValues.getSelectedFile() == null) return object2;
                    Commands commands = this;
                    if (commands.commonValues.isProcessing()) return object2;
                    this.decode_pdf.resetViewableArea();
                    try {
                        String string2;
                        this.decode_pdf.setPDF(true);
                        this.decode_pdf.setMultiPageTiff(false);
                        String string3 = System.getProperty("org.jpedal.hires");
                        if (PdfDecoder.hires || string3 != null) {
                            this.commonValues.setUseHiresImage(true);
                        }
                        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
                            this.commonValues.setUseHiresImage(false);
                        }
                        this.thumbnails.resetToDefault();
                        this.currentGUI.setNoPagesDecoded();
                        if (this.searchFrame != null) {
                            this.searchFrame.removeSearchWindow(false);
                        }
                        this.commonValues.maxViewY = 0;
                        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
                        this.commonValues.setCurrentPage(1);
                        if (this.currentGUI.isSingle()) {
                            this.decode_pdf.closePdfFile();
                        }
                        this.decode_pdf.openPdfArray((byte[])object);
                        this.currentGUI.updateStatusMessage("opening file");
                        boolean bl = true;
                        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                            bl = false;
                            String string4 = System.getProperty("org.jpedal.password");
                            if (string4 == null) {
                                string4 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                            }
                            if (string4 != null) {
                                this.decode_pdf.setEncryptionPassword(string4);
                                if (this.decode_pdf.isFileViewable()) {
                                    bl = true;
                                }
                            }
                            if (!bl) {
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                            }
                        }
                        if (bl) {
                            if (this.properties.getValue("Recentdocuments").equals("true")) {
                                this.properties.addRecentDocument(this.commonValues.getSelectedFile());
                                this.updateRecentDocuments(this.properties.getRecentDocuments());
                            }
                            this.addToRecentDocuments(this.commonValues.getSelectedFile());
                            this.commonValues.setCurrentPage(1);
                        }
                        this.processPage();
                        return object2;
                    }
                    catch (PdfException pdfException) {}
                    return object2;
                }
                if (objectArray.length != 1) return object2;
                if (objectArray[0] instanceof InputStream) {
                    this.inputStream = (InputStream)objectArray[0];
                    this.currentGUI.resetNavBar();
                    object = "InputStream-" + System.currentTimeMillis() + ".pdf";
                    this.commonValues.setSelectedFile((String)object);
                    this.fileIsURL = true;
                    if (this.inputStream != null) {
                        try {
                            this.commonValues.setFileSize(0L);
                            this.currentGUI.setViewerTitle(null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        Commands commands = this;
                        if (commands.commonValues.isProcessing()) return object2;
                        this.thumbnails.terminateDrawing();
                        this.decode_pdf.flushObjectValues(true);
                        this.decode_pdf.resetViewableArea();
                        this.currentGUI.stopThumbnails();
                        try {
                            this.currentGUI.setUseDownloadWindow(false);
                            this.openFile(this.commonValues.getSelectedFile());
                            while (true) {
                                Commands commands3 = this;
                                if (!commands3.commonValues.isProcessing()) return object2;
                                Thread.sleep(1000L);
                            }
                        }
                        catch (Exception exception) {
                            return object2;
                        }
                    }
                    this.decode_pdf.repaint();
                    return object2;
                }
                object = objectArray[0] instanceof File ? (File)objectArray[0] : (objectArray[0] instanceof String ? new File((String)objectArray[0]) : null);
                if (object != null) {
                    try {
                        this.commonValues.setInputDir(((File)object).getParentFile().getCanonicalPath());
                        this.open(((File)object).getAbsolutePath());
                        while (true) {
                            Commands commands = this;
                            if (!commands.commonValues.isProcessing()) return object2;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        return object2;
                    }
                }
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                return object2;
            }
            case 13: {
                if (objectArray != null) return object2;
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                    return object2;
                }
                this.decode_pdf.setExtractingAsImage(true);
                this.decode_pdf.setCursor(Cursor.getPredefinedCursor(1));
                return object2;
            }
            case 12: {
                boolean bl;
                boolean bl2;
                int n7;
                if (objectArray == null) {
                    if (this.commonValues.getSelectedFile() == null) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                        return object2;
                    }
                    if (!this.commonValues.isPDF()) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                        return object2;
                    }
                    if (this.decode_pdf.getDisplayView() != 1 && this.decode_pdf.getDisplayView() != 2 && this.decode_pdf.getDisplayView() != 4 && this.decode_pdf.getDisplayView() != 3) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SingleContfacingFacingPageOnly"));
                        return object2;
                    }
                    if (!this.searchFrame.isSearchVisible()) {
                        this.searchFrame.find(this.decode_pdf, this.commonValues);
                        return object2;
                    }
                    this.searchFrame.grabFocusInInput();
                    return object2;
                }
                String string = (String)objectArray[0];
                if (objectArray.length > 1) {
                    n7 = (Integer)objectArray[1];
                    bl2 = (Boolean)objectArray[2];
                    bl = (Boolean)objectArray[3];
                } else {
                    n7 = 0;
                    bl2 = false;
                    bl = false;
                }
                this.allHighlightsShown = (n7 & 0x10) == 16;
                this.searchFrame.findWithoutWindow(this.decode_pdf, this.commonValues, n7, bl2, bl, string);
                return object2;
            }
            case 708: {
                if (objectArray == null) return object2;
                int n8 = (Integer)objectArray[0];
                if (n8 == this.decode_pdf.getlastPageDecoded()) {
                    try {
                        object2 = this.decode_pdf.getGroupingObject();
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                } else {
                    try {
                        this.decode_pdf.decodePageInBackground(n8);
                        object2 = this.decode_pdf.getBackgroundGroupingObject();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.decode_pdf.waitForDecodingToFinish();
                return object2;
            }
            case 14: {
                this.inputStream = null;
                if (objectArray == null) {
                    this.handleUnsaveForms();
                    this.currentGUI.resetNavBar();
                    object = this.selectURL();
                    if (object == null) return object2;
                    this.commonValues.setSelectedFile((String)object);
                    this.fileIsURL = true;
                    return object2;
                }
                this.currentGUI.resetNavBar();
                object = (String)objectArray[0];
                if (object == null) return object2;
                this.commonValues.setSelectedFile((String)object);
                this.fileIsURL = true;
                boolean bl = false;
                try {
                    URL uRL = new URL((String)object);
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection.getContent() == null) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (bl) {
                    object = null;
                }
                if (object != null) {
                    try {
                        this.commonValues.setFileSize(0L);
                        this.currentGUI.setViewerTitle(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (object == null) return object2;
                    Commands commands = this;
                    if (commands.commonValues.isProcessing()) return object2;
                    this.thumbnails.terminateDrawing();
                    this.decode_pdf.flushObjectValues(true);
                    this.decode_pdf.resetViewableArea();
                    this.currentGUI.stopThumbnails();
                    if (!this.currentGUI.isSingle()) {
                        this.openNewMultiplePage(this.commonValues.getSelectedFile());
                    }
                    try {
                        this.currentGUI.setUseDownloadWindow(false);
                        this.openFile(this.commonValues.getSelectedFile());
                        while (true) {
                            Commands commands4 = this;
                            if (!commands4.commonValues.isProcessing()) return object2;
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception exception) {
                        return object2;
                    }
                }
                this.decode_pdf.repaint();
                return object2;
            }
            case 998: {
                if (objectArray != null) return object2;
                this.currentGUI.getHelpBox();
                return object2;
            }
            case 999: {
                if (objectArray != null) return object2;
                try {
                    BrowserLauncher.openURL("http://www.jpedal.org/pricing.php");
                    return object2;
                }
                catch (IOException iOException) {
                    this.currentGUI.showMessageDialog("Please visit http://www.jpedal.org/pricing.php");
                }
                return object2;
            }
            case 997: {
                if (objectArray != null) return object2;
                this.currentGUI.getRSSBox();
                return object2;
            }
            case 15: {
                if (objectArray != null) return object2;
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    return object2;
                }
                catch (IOException iOException) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
                return object2;
            }
            case 20: {
                if (objectArray != null) return object2;
                object = new TipOfTheDay(this.currentGUI.getFrame(), "/org/jpedal/examples/simpleviewer/res/tips", this.properties);
                ((Dialog)object).setVisible(true);
                return object2;
            }
            case 21: {
                if (objectArray != null) return object2;
                this.cascade();
                return object2;
            }
            case 22: {
                if (objectArray != null) return object2;
                this.tile();
                return object2;
            }
            case 23: {
                if (objectArray != null) return object2;
                this.checkForUpdates(true);
                return object2;
            }
            case 24: {
                this.currentGUI.showMessageDialog("OS version does not support preferences");
                return object2;
            }
            case 25: {
                object = this.copySelectedText();
                StringSelection stringSelection = new StringSelection((String)object);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
                return object2;
            }
            case 26: {
                if (this.decode_pdf.getDisplayView() == 1) {
                    int n9;
                    Rectangle[] rectangleArray = this.decode_pdf.getLineAreas(this.commonValues.getCurrentPage());
                    int n10 = 0;
                    int n11 = 0;
                    for (n9 = 0; n9 != rectangleArray.length; ++n9) {
                        if (rectangleArray[n9].y > rectangleArray[n10].y) {
                            n10 = n9;
                        }
                        if (rectangleArray[n9].y >= rectangleArray[n11].y) continue;
                        n11 = n9;
                    }
                    n9 = rectangleArray[n10].x;
                    int n12 = rectangleArray[n10].y + rectangleArray[n10].height / 2;
                    int n13 = rectangleArray[n11].y + rectangleArray[n11].height / 2 - n12;
                    int n14 = rectangleArray[n11].x + rectangleArray[n11].width - n9;
                    this.commonValues.m_x1 = n9;
                    this.commonValues.m_x2 = n9 + n14;
                    this.commonValues.m_y1 = n12;
                    this.commonValues.m_y2 = n12 + n13;
                    Rectangle rectangle = new Rectangle(n9, n12, n14, n13);
                    this.decode_pdf.updateCursorBoxOnScreen(null, null);
                    this.decode_pdf.clearHighlights();
                    this.decode_pdf.setHighlightedImage(null);
                    this.currentGUI.setRectangle(rectangle);
                    this.decode_pdf.updateCursorBoxOnScreen(rectangle, PdfDecoder.highlightColor);
                    this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, false, this.commonValues.getCurrentPage());
                    this.decode_pdf.repaint();
                    return object2;
                }
                this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                return object2;
            }
            case 27: {
                this.currentGUI.setRectangle(null);
                this.decode_pdf.updateCursorBoxOnScreen(null, null);
                this.decode_pdf.clearHighlights();
                this.decode_pdf.setHighlightedImage(null);
                return object2;
            }
            case 28: {
                if (objectArray == null) return object2;
                String string = null;
                boolean bl = false;
                if (objectArray[0] instanceof String) {
                    string = (String)objectArray[0];
                }
                if (objectArray[1] instanceof Boolean) {
                    bl = (Boolean)objectArray[1];
                }
                if (string == null) throw new RuntimeException("String input was null");
                this.currentGUI.alterProperty(string, bl);
                return object2;
            }
            case 29: {
                int n15;
                if (objectArray != null) return object2;
                MouseMotionListener[] mouseMotionListenerArray = this.decode_pdf.getMouseMotionListeners();
                MouseListener[] mouseListenerArray = this.decode_pdf.getMouseListeners();
                if (mouseMotionListenerArray != null && mouseMotionListenerArray.length > 0) {
                    for (n15 = 0; n15 != mouseMotionListenerArray.length; ++n15) {
                        if (!(mouseMotionListenerArray[n15] instanceof SwingMousePanning) && !(mouseMotionListenerArray[n15] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseMotionListener(mouseMotionListenerArray[n15]);
                    }
                }
                if (mouseListenerArray != null && mouseListenerArray.length > 0) {
                    for (n15 = 0; n15 != mouseListenerArray.length; ++n15) {
                        if (!(mouseListenerArray[n15] instanceof SwingMousePanning) && !(mouseListenerArray[n15] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseListener(mouseListenerArray[n15]);
                    }
                }
                if (this.decode_pdf.getMouseMode() == 0) {
                    SwingMousePanning swingMousePanning = new SwingMousePanning(this.decode_pdf);
                    swingMousePanning.setupMouse();
                    this.decode_pdf.setMouseMode(1);
                    URL uRL = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_pan.png");
                    if (uRL != null) {
                        ImageIcon imageIcon = new ImageIcon(uRL);
                        this.currentGUI.mouseMode.setIcon(imageIcon);
                    }
                    this.currentGUI.snapshotButton.setEnabled(false);
                    return object2;
                }
                if (this.decode_pdf.getMouseMode() != 1) return object2;
                SwingMouseSelection swingMouseSelection = new SwingMouseSelection(this.decode_pdf, this.commonValues, ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler());
                swingMouseSelection.setupMouse();
                this.decode_pdf.setMouseMode(0);
                this.decode_pdf.setCursor(Cursor.getDefaultCursor());
                URL uRL = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_select.png");
                if (uRL != null) {
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    this.currentGUI.mouseMode.setIcon(imageIcon);
                }
                this.currentGUI.snapshotButton.setEnabled(true);
                return object2;
            }
            case 31: {
                int n16;
                if (objectArray != null) return object2;
                MouseMotionListener[] mouseMotionListenerArray = this.decode_pdf.getMouseMotionListeners();
                MouseListener[] mouseListenerArray = this.decode_pdf.getMouseListeners();
                if (mouseMotionListenerArray != null && mouseMotionListenerArray.length > 0) {
                    for (n16 = 0; n16 != mouseMotionListenerArray.length; ++n16) {
                        if (!(mouseMotionListenerArray[n16] instanceof SwingMousePanning)) continue;
                        this.decode_pdf.removeMouseMotionListener(mouseMotionListenerArray[n16]);
                    }
                }
                if (mouseListenerArray != null && mouseListenerArray.length > 0) {
                    for (n16 = 0; n16 != mouseListenerArray.length; ++n16) {
                        if (!(mouseListenerArray[n16] instanceof SwingMousePanning)) continue;
                        this.decode_pdf.removeMouseListener(mouseListenerArray[n16]);
                    }
                }
                SwingMouseSelection swingMouseSelection = new SwingMouseSelection(this.decode_pdf, this.commonValues, ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler());
                swingMouseSelection.setupMouse();
                this.decode_pdf.setMouseMode(0);
                URL uRL = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_select.png");
                if (uRL == null) return object2;
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.currentGUI.mouseMode.setIcon(imageIcon);
                return object2;
            }
            case 30: {
                int n17;
                if (objectArray != null) return object2;
                MouseMotionListener[] mouseMotionListenerArray = this.decode_pdf.getMouseMotionListeners();
                MouseListener[] mouseListenerArray = this.decode_pdf.getMouseListeners();
                if (mouseMotionListenerArray != null && mouseMotionListenerArray.length > 0) {
                    for (n17 = 0; n17 != mouseMotionListenerArray.length; ++n17) {
                        if (!(mouseMotionListenerArray[n17] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseMotionListener(mouseMotionListenerArray[n17]);
                    }
                }
                if (mouseListenerArray != null && mouseListenerArray.length > 0) {
                    for (n17 = 0; n17 != mouseListenerArray.length; ++n17) {
                        if (!(mouseListenerArray[n17] instanceof SwingMouseSelection)) continue;
                        this.decode_pdf.removeMouseListener(mouseListenerArray[n17]);
                    }
                }
                SwingMousePanning swingMousePanning = new SwingMousePanning(this.decode_pdf);
                swingMousePanning.setupMouse();
                this.decode_pdf.setMouseMode(1);
                URL uRL = this.currentGUI.getURLForImage(this.currentGUI.getIconLocation() + "mouse_pan.png");
                if (uRL == null) return object2;
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.currentGUI.mouseMode.setIcon(imageIcon);
                return object2;
            }
            case 16: {
                if (objectArray != null) return object2;
                Commands commands = this;
                if (commands.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    return object2;
                }
                Commands commands5 = this;
                if (commands5.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    return object2;
                }
                String string = this.recent.getPreviousDocument();
                if (string == null) return object2;
                this.open(string);
                return object2;
            }
            case 17: {
                if (objectArray != null) return object2;
                Commands commands = this;
                if (commands.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    return object2;
                }
                Commands commands6 = this;
                if (commands6.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    return object2;
                }
                String string = this.recent.getNextDocument();
                if (string == null) return object2;
                this.open(string);
                return object2;
            }
            case 18: {
                if (objectArray == null) {
                    int n18;
                    object2 = null;
                    if (this.results == null) {
                        this.results = this.searchFrame.getResults(this.commonValues.getCurrentPage());
                    }
                    if ((n18 = this.results.getSelectedIndex()) < 0) {
                        n18 = 0;
                        this.results.setSelectedIndex(n18);
                    }
                    Integer n19 = new Integer(this.commonValues.getCurrentPage());
                    if (n18 == 0) {
                        int n20;
                        this.results = this.searchFrame.getResults(n20);
                        for (n20 = this.commonValues.getCurrentPage() - 1; this.results.getResultCount() < 1 && n20 > 0 && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; --n20) {
                            this.results = this.searchFrame.getResults(n20);
                        }
                        if (this.results.getResultCount() < 1 && n20 == 0) {
                            this.results = this.searchFrame.getResults(n20);
                            object2 = SEARCH_RETURNED_TO_START;
                            for (n20 = this.commonValues.getPageCount(); this.results.getResultCount() < 1 && n20 > this.commonValues.getCurrentPage() && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; --n20) {
                                this.results = this.searchFrame.getResults(n20);
                            }
                        }
                        n18 = this.results.getResultCount() - 1;
                        if (this.results.getResultCount() < 1) {
                            object2 = SEARCH_NOT_FOUND;
                        }
                    } else {
                        --n18;
                    }
                    this.results.setSelectedIndex(n18);
                    Commands commands = this;
                    if (!commands.commonValues.isProcessing()) {
                        float f = this.currentGUI.getScaling();
                        int n21 = this.results.getSelectedIndex();
                        if (!this.allHighlightsShown) {
                            this.decode_pdf.clearHighlights();
                        }
                        if (n21 != -1) {
                            Integer n22 = new Integer(n21);
                            Object v = this.results.getTextPages().get(n22);
                            if (v != null) {
                                int n23 = (Integer)v;
                                if (this.commonValues.getCurrentPage() != n23) {
                                    this.commonValues.setCurrentPage(n23);
                                    this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                                    this.decode_pdf.setPageParameters(f, this.commonValues.getCurrentPage());
                                    this.currentGUI.decodePage(false);
                                    this.decode_pdf.invalidate();
                                }
                                do {
                                    Commands commands7 = this;
                                } while (commands7.commonValues.isProcessing());
                                Rectangle[] rectangleArray = null;
                                Rectangle rectangle = (Rectangle)this.searchFrame.getTextRectangles().get(n22);
                                if (n19 != n23 && this.allHighlightsShown) {
                                    Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                                    for (int i = 0; i != this.results.getModel().getSize(); ++i) {
                                        Integer n24 = new Integer(i);
                                        if ((Integer)this.results.getTextPages().get(n24) != n23) continue;
                                        Object v2 = this.searchFrame.getTextRectangles().get(n24);
                                        if (v2 instanceof Rectangle) {
                                            vector_Rectangle.addElement((Rectangle)v2);
                                        }
                                        if (!(v2 instanceof Rectangle[])) continue;
                                        Rectangle[] rectangleArray2 = (Rectangle[])v2;
                                        for (int j = 0; j != rectangleArray2.length; ++j) {
                                            vector_Rectangle.addElement(rectangleArray2[j]);
                                        }
                                    }
                                    vector_Rectangle.trim();
                                    rectangleArray = vector_Rectangle.get();
                                    this.decode_pdf.addHighlights(rectangleArray, true, n23);
                                }
                                this.decode_pdf.scrollRectToHighlight(rectangle, this.commonValues.getCurrentPage());
                                if (!this.allHighlightsShown) {
                                    this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, true, n23);
                                }
                                this.decode_pdf.invalidate();
                                this.decode_pdf.repaint();
                            }
                        }
                    }
                    this.currentGUI.hideRedundentNavButtons();
                }
                if (this.commonValues.getCurrentPage() != this.searchFrame.getFirstPageWithResults()) return object2;
                if (this.results.getSelectedIndex() != 0) return object2;
                return FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
            }
            case 19: {
                if (objectArray == null) {
                    int n25;
                    object2 = null;
                    if (this.results == null) {
                        this.results = this.searchFrame.getResults(this.commonValues.getCurrentPage());
                    }
                    if ((n25 = this.results.getSelectedIndex()) < 0) {
                        n25 = 0;
                        this.results.setSelectedIndex(n25);
                    }
                    Integer n26 = new Integer(this.commonValues.getCurrentPage());
                    if (n25 == this.results.getResultCount() - 1 || this.results.getResultCount() == 0) {
                        int n27;
                        n25 = 0;
                        this.results = this.searchFrame.getResults(n27);
                        for (n27 = this.commonValues.getCurrentPage() + 1; this.results.getResultCount() < 1 && n27 < this.commonValues.getPageCount() + 1 && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; ++n27) {
                            this.results = this.searchFrame.getResults(n27);
                        }
                        if (this.results.getResultCount() < 1 && n27 == this.commonValues.getPageCount() + 1) {
                            object2 = SEARCH_RETURNED_TO_START;
                            for (n27 = 1; this.results.getResultCount() < 1 && n27 < this.commonValues.getCurrentPage() && this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_MENU_BAR; ++n27) {
                                this.results = this.searchFrame.getResults(n27);
                            }
                            if (this.results.getResultCount() < 1) {
                                object2 = SEARCH_NOT_FOUND;
                            }
                        }
                    } else {
                        ++n25;
                    }
                    this.results.setSelectedIndex(n25);
                    float f = this.currentGUI.getScaling();
                    int n28 = this.results.getSelectedIndex();
                    if (!this.allHighlightsShown) {
                        this.decode_pdf.clearHighlights();
                    }
                    if (n28 != -1) {
                        Integer n29 = new Integer(n28);
                        Object v = this.results.getTextPages().get(n29);
                        if (v != null) {
                            int n30 = (Integer)v;
                            if (this.commonValues.getCurrentPage() != n30) {
                                this.commonValues.setCurrentPage(n30);
                                this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                                this.decode_pdf.setPageParameters(f, this.commonValues.getCurrentPage());
                                this.currentGUI.decodePage(false);
                                this.decode_pdf.invalidate();
                            }
                            while (true) {
                                Commands commands = this;
                                if (!commands.commonValues.isProcessing()) break;
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                            Rectangle[] rectangleArray = null;
                            Rectangle rectangle = (Rectangle)this.results.textAreas().get(n29);
                            int n31 = (Integer)this.results.getTextPages().get(n29);
                            if (n26 != null && n26 != n30 && this.allHighlightsShown) {
                                Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                                for (int i = 0; i != this.results.getModel().getSize(); ++i) {
                                    Integer n32 = new Integer(i);
                                    if ((Integer)this.results.getTextPages().get(n32) != n30) continue;
                                    Object v3 = this.searchFrame.getTextRectangles().get(n32);
                                    if (v3 instanceof Rectangle) {
                                        vector_Rectangle.addElement((Rectangle)v3);
                                    }
                                    if (!(v3 instanceof Rectangle[])) continue;
                                    Rectangle[] rectangleArray3 = (Rectangle[])v3;
                                    for (int j = 0; j != rectangleArray3.length; ++j) {
                                        vector_Rectangle.addElement(rectangleArray3[j]);
                                    }
                                }
                                vector_Rectangle.trim();
                                rectangleArray = vector_Rectangle.get();
                                this.decode_pdf.addHighlights(rectangleArray, true, n30);
                            }
                            this.decode_pdf.scrollRectToHighlight(rectangle, this.commonValues.getCurrentPage());
                            if (!this.allHighlightsShown) {
                                this.decode_pdf.addHighlights(new Rectangle[]{rectangle}, true, n30);
                            }
                            this.decode_pdf.invalidate();
                            this.decode_pdf.repaint();
                        }
                    }
                    this.currentGUI.hideRedundentNavButtons();
                }
                if (this.commonValues.getCurrentPage() != this.searchFrame.getFirstPageWithResults()) return object2;
                if (this.results.getSelectedIndex() != 0) return object2;
                return FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN;
            }
            case 50: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) return object2;
                if (this.commonValues.getPageCount() <= 1) return object2;
                if (this.commonValues.getCurrentPage() == 1) return object2;
                this.navigatePages(-(this.commonValues.getCurrentPage() - 1));
                return object2;
            }
            case 51: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) return object2;
                if (this.commonValues.getCurrentPage() < 10) {
                    this.navigatePages(-(this.commonValues.getCurrentPage() - 1));
                    return object2;
                }
                this.navigatePages(-10);
                return object2;
            }
            case 52: {
                if (objectArray == null) {
                    if (this.commonValues.getSelectedFile() == null) return object2;
                    this.navigatePages(-1);
                    return object2;
                }
                if (this.commonValues.getSelectedFile() != null) {
                    this.navigatePages(-Integer.parseInt((String)objectArray[0]));
                }
                while (true) {
                    Commands commands = this;
                    if (!commands.commonValues.isProcessing()) return object2;
                }
            }
            case 53: {
                if (objectArray == null) {
                    if (this.commonValues.getSelectedFile() == null) return object2;
                    this.navigatePages(1);
                    return object2;
                }
                if (this.commonValues.getSelectedFile() != null) {
                    this.navigatePages(Integer.parseInt((String)objectArray[0]));
                }
                while (true) {
                    Commands commands = this;
                    if (!commands.commonValues.isProcessing()) return object2;
                }
            }
            case 54: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) return object2;
                if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage() + 10) {
                    this.navigatePages(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                    return object2;
                }
                this.navigatePages(10);
                return object2;
            }
            case 55: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) return object2;
                if (this.commonValues.getPageCount() <= 1) return object2;
                if (this.commonValues.getPageCount() - this.commonValues.getCurrentPage() <= 0) return object2;
                this.navigatePages(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                return object2;
            }
            case 56: {
                if (objectArray == null) {
                    String string = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
                    if (string == null) return object2;
                    this.gotoPage(string);
                    return object2;
                }
                this.gotoPage((String)objectArray[0]);
                return object2;
            }
            case 57: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (objectArray != null) return object2;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.mouseMode.setEnabled(true);
                this.currentGUI.snapshotButton.setEnabled(true);
                this.currentGUI.alignLayoutMenuOption(1);
                this.decode_pdf.setDisplayView(1, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.resetRotationBox();
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                this.currentGUI.zoom(false);
                return object2;
            }
            case 58: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (objectArray != null) return object2;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.mouseMode.setEnabled(true);
                this.currentGUI.snapshotButton.setEnabled(true);
                this.currentGUI.alignLayoutMenuOption(2);
                this.decode_pdf.setDisplayView(2, 2);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return object2;
            }
            case 59: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (objectArray != null) return object2;
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.mouseMode.setEnabled(true);
                this.currentGUI.snapshotButton.setEnabled(true);
                this.currentGUI.getCombo(252).setID(-1);
                this.currentGUI.setSelectedComboIndex(252, 0);
                this.currentGUI.getCombo(252).setID(252);
                this.currentGUI.zoom(false);
                this.currentGUI.alignLayoutMenuOption(4);
                this.decode_pdf.setDisplayView(4, 2);
                int n33 = this.commonValues.getCurrentPage();
                if ((n33 & 1) == 1 && n33 != 1) {
                    --n33;
                }
                this.commonValues.setCurrentPage(n33);
                this.currentGUI.setPage(n33);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return object2;
            }
            case 60: {
                if (!this.decode_pdf.isOpen()) {
                    return null;
                }
                if (objectArray != null) return object2;
                if (this.decode_pdf.turnoverOn && this.decode_pdf.getPdfPageData().hasMultipleSizes()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.PageDragIrregularSizes"));
                }
                this.currentGUI.getCombo(252).setEnabled(true);
                this.currentGUI.mouseMode.setEnabled(true);
                this.currentGUI.snapshotButton.setEnabled(true);
                this.currentGUI.setSelectedComboIndex(252, 0);
                this.currentGUI.zoom(false);
                this.currentGUI.alignLayoutMenuOption(3);
                this.decode_pdf.setDisplayView(3, 2);
                int n34 = this.commonValues.getCurrentPage();
                if ((n34 & 1) == 1 && n34 != 1) {
                    --n34;
                }
                this.commonValues.setCurrentPage(n34);
                this.currentGUI.setPage(n34);
                this.currentGUI.hideRedundentNavButtons();
                this.currentGUI.decodePage(false);
                this.currentGUI.setSelectedComboIndex(251, 0);
                this.currentGUI.getFrame().setMinimumSize(new Dimension(0, 0));
                return object2;
            }
            case 61: {
                Component component;
                if (objectArray != null) return object2;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                if (graphicsDevice.isFullScreenSupported()) {
                    // empty if block
                }
                if (this.win == null) {
                    component = new Frame(graphicsDevice.getDefaultConfiguration());
                    this.win = new Window((Frame)component);
                } else if (graphicsDevice.getFullScreenWindow() != null && graphicsDevice.getFullScreenWindow().equals(this.win)) {
                    this.exitFullScreen();
                    return object2;
                }
                if (this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)this.currentGUI.getFrame()).getContentPane().remove(this.currentGUI.getDisplayPane());
                    this.currentGUI.getFrame().setVisible(false);
                } else {
                    this.currentGUI.getFrame().remove(this.currentGUI.getDisplayPane());
                }
                this.win.add((Component)this.currentGUI.getDisplayPane(), "Center");
                component = new Button("Return");
                this.win.add(component, "North");
                ((Button)component).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Commands.this.exitFullScreen();
                    }
                });
                try {
                    this.screenPosition = this.currentGUI.getFrame().getLocation();
                    graphicsDevice.setFullScreenWindow(this.win);
                    this.win.validate();
                    this.currentGUI.zoom(false);
                    return object2;
                }
                catch (Error error) {
                    this.currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit");
                    this.exit();
                }
                return object2;
            }
            case 252: {
                if (objectArray == null) {
                    Commands commands = this;
                    if (commands.commonValues.isProcessing()) return object2;
                    if (this.commonValues.getSelectedFile() == null) return object2;
                    final Rectangle rectangle = this.decode_pdf.getVisibleRect();
                    final double d = (rectangle.getX() + rectangle.getWidth() / 2.0) / this.decode_pdf.getBounds().getWidth();
                    final double d2 = (rectangle.getY() + rectangle.getHeight() / 2.0) / this.decode_pdf.getBounds().getHeight();
                    this.currentGUI.zoom(false);
                    Thread thread = new Thread(){

                        public void run() {
                            try {
                                Commands.this.decode_pdf.scrollRectToVisible(new Rectangle((int)(d * (double)Commands.this.decode_pdf.getWidth() - rectangle.getWidth() / 2.0), (int)(d2 * (double)Commands.this.decode_pdf.getHeight() - rectangle.getHeight() / 2.0), (int)Commands.this.decode_pdf.getVisibleRect().getWidth(), (int)Commands.this.decode_pdf.getVisibleRect().getHeight()));
                                Commands.this.decode_pdf.repaint();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(thread);
                    return object2;
                }
                this.currentGUI.setScalingFromExternal((String)objectArray[0]);
                this.currentGUI.zoom(true);
                while (true) {
                    Commands commands = this;
                    if (!commands.commonValues.isProcessing()) return object2;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            case 251: {
                if (objectArray == null) {
                    if (this.commonValues.getSelectedFile() == null) return object2;
                    this.currentGUI.rotate();
                    return object2;
                }
                int n35 = Integer.parseInt((String)objectArray[0]);
                while (true) {
                    Commands commands = this;
                    if (!commands.commonValues.isProcessing()) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                this.currentGUI.setRotationFromExternal(n35);
                this.currentGUI.zoom(true);
                return object2;
            }
            case 500: {
                if (objectArray != null) return object2;
                this.saveChangedForm();
                return object2;
            }
            case 501: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                SavePDF savePDF = new SavePDF(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n36 = savePDF.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SavePagesAsPdf"));
                if (n36 != 0) return object2;
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.extractPagesToNewPDF(savePDF);
                return object2;
            }
            case 502: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                RotatePDFPages rotatePDFPages = new RotatePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n37 = rotatePDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerRotation.text"));
                if (n37 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.rotate(this.commonValues.getPageCount(), pdfPageData, rotatePDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 509: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                CropPDFPages cropPDFPages = new CropPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n38 = cropPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTooltip.PDFCropPages"));
                if (n38 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.setCrop(this.commonValues.getPageCount(), pdfPageData, cropPDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 510: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                ExtractPDFPagesNup extractPDFPagesNup = new ExtractPDFPagesNup(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n39 = extractPDFPagesNup.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerNUP.titlebar"));
                if (n39 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.nup(this.commonValues.getPageCount(), pdfPageData, extractPDFPagesNup);
                return object2;
            }
            case 511: {
                if (objectArray != null) return object2;
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                }
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                if (this.fileIsURL) return object2;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                int n40 = jFileChooser.showSaveDialog(null);
                if (n40 != 0) return object2;
                File file = jFileChooser.getSelectedFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.handouts(file.getAbsolutePath());
                return object2;
            }
            case 512: {
                if (objectArray != null) return object2;
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    return object2;
                }
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                if (!this.decode_pdf.isExtractionAllowed()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.ExtractionNotAllowed"));
                    return object2;
                }
                SignData signData = new SignData();
                SignWizardModel signWizardModel = new SignWizardModel(signData, this.commonValues.getSelectedFile(), this.commonValues.getInputDir());
                Wizard wizard = new Wizard((Frame)this.currentGUI.getFrame(), signWizardModel);
                if (wizard.showModalDialog() != 0) return object2;
                if (!signData.validate()) {
                    this.currentGUI.showMessageDialog(signData.toString());
                    return object2;
                }
                int n41 = JOptionPane.showConfirmDialog(this.currentGUI.getFrame(), signData.toString(), Messages.getMessage("PdfViewerGeneral.IsThisCorrect"), 2, 3);
                if (n41 == 0) {
                    ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                    itextFunctions.Sign(signData);
                    return object2;
                }
                JOptionPane.showMessageDialog(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerMessage.SigningOperationCancelled"), Messages.getMessage("PdfViewerGeneral.Warning"), 2);
                return object2;
            }
            case 503: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                DeletePDFPages deletePDFPages = new DeletePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n42 = deletePDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerDelete.text"));
                if (n42 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.delete(this.commonValues.getPageCount(), pdfPageData, deletePDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 506: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                AddHeaderFooterToPDFPages addHeaderFooterToPDFPages = new AddHeaderFooterToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n43 = addHeaderFooterToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.AddHeaderAndFooters"));
                if (n43 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.addHeaderFooter(this.commonValues.getPageCount(), pdfPageData, addHeaderFooterToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 507: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                StampTextToPDFPages stampTextToPDFPages = new StampTextToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n44 = stampTextToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampText.text"));
                if (n44 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampText(this.commonValues.getPageCount(), pdfPageData, stampTextToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 508: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                StampImageToPDFPages stampImageToPDFPages = new StampImageToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n45 = stampImageToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampImage.text"));
                if (n45 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampImage(this.commonValues.getPageCount(), pdfPageData, stampImageToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 504: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                InsertBlankPDFPage insertBlankPDFPage = new InsertBlankPDFPage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n46 = insertBlankPDFPage.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.BlankPage"));
                if (n46 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.add(this.commonValues.getPageCount(), pdfPageData, insertBlankPDFPage);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 505: {
                if (objectArray != null) return object2;
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    return object2;
                }
                EncryptPDFDocument encryptPDFDocument = new EncryptPDFDocument(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n47 = encryptPDFDocument.display(this.currentGUI.getFrame(), "Standard Security");
                if (n47 != 0) return object2;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.encrypt(this.commonValues.getPageCount(), pdfPageData, encryptPDFDocument);
                this.open(this.commonValues.getSelectedFile());
                return object2;
            }
            case 702: {
                this.decode_pdf.goBackAView();
                return object2;
            }
            case 701: {
                this.decode_pdf.goForwardAView();
                return object2;
            }
            case 700: {
                this.decode_pdf.addAView((Integer)objectArray[0], (Rectangle)objectArray[1], (Integer)objectArray[2]);
                return object2;
            }
            case 704: {
                if (this.decode_pdf != null) return new Integer(this.currentGUI.getPageNumber());
                return new Integer(-1);
            }
            case 703: {
                if (this.decode_pdf != null) return new Integer(this.decode_pdf.getPageCount());
                return new Integer(-1);
            }
            case 707: {
                return this.currentGUI.pageCounter2;
            }
            case 706: {
                this.currentGUI.setBookmarks(true);
                return this.currentGUI.getThumbnailPanel();
            }
            case 705: {
                this.currentGUI.setBookmarks(true);
                return this.currentGUI.getOutlinePanel();
            }
            default: {
                System.out.println("No menu item set");
            }
        }
        return object2;
    }

    protected void exitFullScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                graphicsDevice.setFullScreenWindow(null);
                Commands.this.win.remove(Commands.this.currentGUI.getDisplayPane());
                if (Commands.this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)Commands.this.currentGUI.getFrame()).getContentPane().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                    Commands.this.currentGUI.getFrame().setVisible(true);
                    if (Commands.this.screenPosition != null) {
                        Commands.this.currentGUI.getFrame().setLocation(Commands.this.screenPosition);
                    }
                    Commands.this.screenPosition = null;
                } else {
                    Commands.this.currentGUI.getFrame().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                }
                Commands.this.currentGUI.getDisplayPane().invalidate();
                Commands.this.currentGUI.getDisplayPane().updateUI();
                if (Commands.this.currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)Commands.this.currentGUI.getFrame()).getContentPane().validate();
                } else {
                    Commands.this.currentGUI.getFrame().validate();
                }
                Commands.this.win.dispose();
                Commands.this.win = null;
                Commands.this.currentGUI.zoom(false);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void cascade() {
        int n;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
        int n2 = 0;
        for (n = jInternalFrameArray.length - 1; n2 < n; ++n2, --n) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n2];
            jInternalFrameArray[n2] = jInternalFrameArray[n];
            jInternalFrameArray[n] = jInternalFrame;
        }
        n2 = 0;
        n = 0;
        int n3 = jDesktopPane.getWidth() / 2;
        int n4 = jDesktopPane.getHeight() / 2;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
                jInternalFrameArray[i].reshape(n2, n, n3, n4);
                jInternalFrameArray[i].setSelected(true);
                n += 25;
                if ((n2 += 25) + n3 > jDesktopPane.getWidth()) {
                    n2 = 0;
                }
                if (n + n4 <= jDesktopPane.getHeight()) continue;
                n = 0;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void tile() {
        int n;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
        int n2 = 0;
        for (n = 0; n < jInternalFrameArray.length; ++n) {
            if (jInternalFrameArray[n].isIcon()) continue;
            ++n2;
        }
        n = (int)Math.sqrt(n2);
        int n3 = n2 / n;
        int n4 = n2 % n;
        int n5 = jDesktopPane.getWidth() / n3;
        int n6 = jDesktopPane.getHeight() / n;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (jInternalFrameArray[i].isIcon()) continue;
            try {
                jInternalFrameArray[i].setMaximum(false);
                jInternalFrameArray[i].reshape(n8 * n5, n7 * n6, n5, n6);
                if (++n7 != n) continue;
                n7 = 0;
                if (++n8 != n3 - n4) continue;
                n6 = jDesktopPane.getHeight() / ++n;
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private PdfDecoder openNewMultiplePage(String string) {
        PdfDecoder pdfDecoder;
        JDesktopPane jDesktopPane = this.currentGUI.getMultiViewerFrames();
        this.decode_pdf = pdfDecoder = new PdfDecoder(true);
        this.currentGUI.setPdfDecoder(this.decode_pdf);
        this.decode_pdf.setDisplayView(1, 2);
        PdfDecoder.init(true);
        this.decode_pdf.setExtractionMode(0, 72, 1.0f);
        Commands commands = this;
        int n = commands.currentGUI.getPDFDisplayInset();
        this.decode_pdf.setInset(n, n);
        if (this.decode_pdf.useNewGraphicsMode) {
            this.decode_pdf.setBackground(new Color(55, 55, 65));
        } else {
            this.decode_pdf.setBackground(new Color(190, 190, 190));
        }
        this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage(), this.currentGUI.getRotation());
        JInternalFrame jInternalFrame = new JInternalFrame(string, true, true, true, true);
        String string2 = String.valueOf(this.startX);
        jInternalFrame.setName(string2);
        jInternalFrame.setSize(250, 250);
        jInternalFrame.setVisible(true);
        jInternalFrame.setLocation(this.startX, this.startY);
        this.startX += 25;
        this.startY += 25;
        this.multiViewListener = new MultiViewListener(this.decode_pdf, this.currentGUI, this.commonValues, this);
        jInternalFrame.addInternalFrameListener(this.multiViewListener);
        jInternalFrame.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Container container = component.getParent();
                if (component.getLocation().y < 0) {
                    component.setLocation(component.getLocation().x, 0);
                } else if (component.getLocation().y + component.getSize().height > container.getSize().height + component.getSize().height / 2) {
                    component.setLocation(component.getLocation().x, container.getSize().height - component.getSize().height / 2);
                }
                if (component.getLocation().x < -(component.getSize().width / 2)) {
                    component.setLocation(-(component.getSize().width / 2), component.getLocation().y);
                } else if (component.getLocation().x + component.getSize().width > container.getSize().width + component.getSize().width / 2) {
                    component.setLocation(container.getSize().width - component.getSize().width / 2, component.getLocation().y);
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                if (Commands.this.decode_pdf.getParent() != null && Commands.this.currentGUI.getSelectedComboIndex(252) < 3) {
                    Commands.this.currentGUI.zoom(false);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(pdfDecoder);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        jInternalFrame.getContentPane().add(jScrollPane);
        jDesktopPane.add(string, jInternalFrame);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        jInternalFrame.toFront();
        jInternalFrame.requestFocusInWindow();
        return this.decode_pdf;
    }

    public void openTransferedFile(String string) throws PdfException {
        while (true) {
            if (!this.openingTransferedFile) {
                Commands commands = this;
                if (!commands.commonValues.isProcessing()) break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.openingTransferedFile = true;
        this.currentGUI.resetNavBar();
        boolean bl = string.startsWith("http:") || string.startsWith("file:");
        try {
            if (!bl) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(string).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(string);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(this.commonValues.getSelectedFile());
        if (!bl && !file.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null) {
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (this.currentGUI.isSingle()) {
                    this.decode_pdf.flushObjectValues(true);
                } else {
                    this.decode_pdf = this.openNewMultiplePage(this.commonValues.getSelectedFile());
                }
                this.decode_pdf.resetViewableArea();
                try {
                    this.openFile(this.commonValues.getSelectedFile());
                }
                catch (PdfException pdfException) {
                    this.openingTransferedFile = false;
                    throw pdfException;
                }
                if (this.commonValues.isPDF()) {
                    this.openingTransferedFile = false;
                }
            }
        }
    }

    public boolean openingTransferedFiles() {
        return this.openingTransferedFile;
    }

    private void saveChangedForm() {
        AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
        if (acroRenderer == null) {
            return;
        }
        List list = null;
        try {
            list = acroRenderer.getComponentNameList();
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        if (list == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            Object object;
            File file = null;
            String string = "";
            boolean bl = false;
            while (!bl) {
                object = new JFileChooser(this.commonValues.getInputDir());
                ((JFileChooser)object).setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                ((JFileChooser)object).setFileSelectionMode(0);
                int n = ((JFileChooser)object).showSaveDialog(null);
                if (n == 0) {
                    int n2;
                    file = ((JFileChooser)object).getSelectedFile();
                    string = file.getAbsolutePath();
                    if (!string.endsWith(".pdf")) {
                        string = string + ".pdf";
                        file = new File(string);
                    }
                    if (string.equals(this.commonValues.getSelectedFile())) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    bl = true;
                    continue;
                }
                return;
            }
            object = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
            ((ItextFunctions)object).saveFormsData(string);
            this.commonValues.setFormsChanged(false);
            this.currentGUI.setViewerTitle(null);
        }
    }

    public void handleUnsaveForms() {
        int n;
        if (this.commonValues.isFormsChanged() && this.commonValues.isItextOnClasspath() && (n = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            this.saveChangedForm();
        }
        this.commonValues.setFormsChanged(false);
    }

    public void extractSelectedScreenAsImage() {
        int n = this.commonValues.m_x1;
        int n2 = this.commonValues.m_x2;
        int n3 = this.commonValues.m_y1;
        int n4 = this.commonValues.m_y2;
        if (this.commonValues.m_y1 < this.commonValues.m_y2) {
            n4 = this.commonValues.m_y1;
            n3 = this.commonValues.m_y2;
        }
        if (this.commonValues.m_x1 > this.commonValues.m_x2) {
            n2 = this.commonValues.m_x1;
            n = this.commonValues.m_x2;
        }
        float f = 100.0f;
        if (PdfDecoder.isRunningOnWindows) {
            f = 100.0f * this.currentGUI.getScaling();
        }
        BufferedImage bufferedImage = this.decode_pdf.getSelectedRectangleOnscreen(n, n3, n2, n4, f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bufferedImage == null) {
            return;
        }
        Object object = new IconiseImage(bufferedImage);
        jPanel.add((Component)new JLabel((Icon)object), "Center");
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jPanel);
        int n5 = bufferedImage.getWidth();
        if (n5 < bufferedImage.getHeight()) {
            n5 = bufferedImage.getHeight();
        }
        if ((n5 += 50) > 450) {
            n5 = 450;
        }
        Container container = this.currentGUI.getFrame();
        final JDialog jDialog = new JDialog((Frame)null, true);
        if (this.commonValues.getModeOfOperation() != 1) {
            jDialog.setLocationRelativeTo(null);
            jDialog.setLocation(container.getLocationOnScreen().x + 10, container.getLocationOnScreen().y + 10);
        }
        jDialog.setSize(n5, n5);
        jDialog.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
        jButton.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener((JScrollPane)object, bufferedImage){
            private final /* synthetic */ JScrollPane val$image_scroll;
            private final /* synthetic */ BufferedImage val$snapShot;
            {
                this.val$image_scroll = jScrollPane;
                this.val$snapShot = bufferedImage;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                File file = null;
                String string = "";
                boolean bl = false;
                while (!bl) {
                    JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int n = jFileChooser.showSaveDialog(this.val$image_scroll);
                    if (n == 0) {
                        int n2;
                        file = jFileChooser.getSelectedFile();
                        string = file.getAbsolutePath();
                        String string2 = jFileChooser.getFileFilter().getDescription();
                        if (string2.equals("All Files")) {
                            string2 = "TIFF";
                        }
                        if (!string.toLowerCase().endsWith(('.' + string2).toLowerCase())) {
                            string = string + '.' + string2;
                            file = new File(string);
                        }
                        if (file.exists() && (n2 = Commands.this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (this.val$snapShot != null) {
                            if (JAIHelper.isJAIused()) {
                                JAI.create((String)"filestore", (RenderedImage)this.val$snapShot, (Object)string, (Object)string2);
                            } else if (string2.toLowerCase().startsWith("tif")) {
                                Commands.this.currentGUI.showMessageDialog("Please setup JAI library for Tiffs");
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)this.val$snapShot, string2, new File(string));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        }
                        bl = true;
                        continue;
                    }
                    return;
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
        jButton2.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton2, "East");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }

    private static Rectangle adjustHighlightForExtraction(Rectangle rectangle) {
        int n = rectangle.x - 3;
        int n2 = rectangle.y - 3;
        int n3 = rectangle.width + 6;
        int n4 = rectangle.height + 6;
        return new Rectangle(n, n2, n3, n4);
    }

    public String copySelectedText() {
        int n;
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return "";
        }
        if (DynamicVectorRenderer.textBasedHighlight) {
            String string = "";
            Rectangle[] rectangleArray = this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
            if (rectangleArray == null) {
                return "";
            }
            boolean bl = rectangleArray.length > 1;
            for (int i = 0; i != rectangleArray.length; ++i) {
                int n2;
                rectangleArray[i] = Commands.adjustHighlightForExtraction(rectangleArray[i]);
                int n3 = rectangleArray[i].x;
                int n4 = rectangleArray[i].x + rectangleArray[i].width;
                int n5 = rectangleArray[i].y + rectangleArray[i].height;
                int n6 = rectangleArray[i].y;
                if (n5 < n6) {
                    n2 = n6;
                    n6 = n5;
                    n5 = n2;
                }
                if (n3 > n4) {
                    n2 = n4;
                    n4 = n3;
                    n3 = n2;
                }
                if (n3 < this.currentGUI.cropX) {
                    n3 = this.currentGUI.cropX;
                }
                if (n3 > this.currentGUI.cropW - this.currentGUI.cropX) {
                    n3 = this.currentGUI.cropW - this.currentGUI.cropX;
                }
                if (n4 < this.currentGUI.cropX) {
                    n4 = this.currentGUI.cropX;
                }
                if (n4 > this.currentGUI.cropW - this.currentGUI.cropX) {
                    n4 = this.currentGUI.cropW - this.currentGUI.cropX;
                }
                if (n5 < this.currentGUI.cropY) {
                    n5 = this.currentGUI.cropY;
                }
                if (n5 > this.currentGUI.cropH - this.currentGUI.cropY) {
                    n5 = this.currentGUI.cropH - this.currentGUI.cropY;
                }
                if (n6 < this.currentGUI.cropY) {
                    n6 = this.currentGUI.cropY;
                }
                if (n6 > this.currentGUI.cropH - this.currentGUI.cropY) {
                    n6 = this.currentGUI.cropH - this.currentGUI.cropY;
                }
                this.display = true;
                while (this.display) {
                    String string2 = null;
                    try {
                        PdfGroupingAlgorithms pdfGroupingAlgorithms = null;
                        pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
                        this.display = false;
                        string2 = pdfGroupingAlgorithms.extractTextInRectangle(n3, n5, n4, n6, this.commonValues.getCurrentPage(), false, true);
                        if (string2 == null || string2.length() == 0) {
                            if (!bl) {
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                            }
                        } else {
                            string2 = Strip.stripXML(string2).toString();
                        }
                        if (string2 == null) continue;
                        string = string + string2 + '\r' + '\n';
                    }
                    catch (PdfException pdfException) {
                        System.err.println("Exception " + pdfException.getMessage() + " in file " + this.commonValues.getSelectedFile());
                        pdfException.printStackTrace();
                    }
                }
            }
            if (string.length() > 2) {
                return string.substring(0, string.length() - 2);
            }
            return "";
        }
        int n7 = this.commonValues.m_x1;
        int n8 = this.commonValues.m_x2;
        int n9 = this.commonValues.m_y1;
        int n10 = this.commonValues.m_y2;
        if (n9 < n10) {
            n = n10;
            n10 = n9;
            n9 = n;
        }
        if (n7 > n8) {
            n = n8;
            n8 = n7;
            n7 = n;
        }
        if (n7 < this.currentGUI.cropX) {
            n7 = this.currentGUI.cropX;
        }
        if (n7 > this.currentGUI.cropW - this.currentGUI.cropX) {
            n7 = this.currentGUI.cropW - this.currentGUI.cropX;
        }
        if (n8 < this.currentGUI.cropX) {
            n8 = this.currentGUI.cropX;
        }
        if (n8 > this.currentGUI.cropW - this.currentGUI.cropX) {
            n8 = this.currentGUI.cropW - this.currentGUI.cropX;
        }
        if (n9 < this.currentGUI.cropY) {
            n9 = this.currentGUI.cropY;
        }
        if (n9 > this.currentGUI.cropH - this.currentGUI.cropY) {
            n9 = this.currentGUI.cropH - this.currentGUI.cropY;
        }
        if (n10 < this.currentGUI.cropY) {
            n10 = this.currentGUI.cropY;
        }
        if (n10 > this.currentGUI.cropH - this.currentGUI.cropY) {
            n10 = this.currentGUI.cropH - this.currentGUI.cropY;
        }
        this.display = true;
        while (this.display) {
            String string = null;
            try {
                PdfGroupingAlgorithms pdfGroupingAlgorithms = null;
                pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
                this.display = false;
                string = pdfGroupingAlgorithms.extractTextInRectangle(n7, n9, n8, n10, this.commonValues.getCurrentPage(), false, true);
                if (string == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                } else {
                    string = Strip.stripXML(string).toString();
                }
                if (string != null) {
                    return string;
                }
                return "";
            }
            catch (PdfException pdfException) {
                System.err.println("Exception " + pdfException.getMessage() + " in file " + this.commonValues.getSelectedFile());
                pdfException.printStackTrace();
            }
        }
        return "";
    }

    private JScrollPane updateExtractionExample(AbstractButton abstractButton, boolean bl) throws PdfException {
        int n;
        int n2;
        Rectangle[] rectangleArray = this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
        if (!DynamicVectorRenderer.textBasedHighlight) {
            rectangleArray = new Rectangle[]{this.currentGUI.getRectangle()};
        }
        JScrollPane jScrollPane = new JScrollPane();
        String string = "";
        for (int i = 0; i != rectangleArray.length; ++i) {
            int n3;
            if (rectangleArray[i] == null) continue;
            rectangleArray[i] = Commands.adjustHighlightForExtraction(rectangleArray[i]);
            n2 = rectangleArray[i].x;
            int n4 = rectangleArray[i].x + rectangleArray[i].width;
            int n5 = rectangleArray[i].y + rectangleArray[i].height;
            n = rectangleArray[i].y;
            if (n5 < n) {
                n3 = n;
                n = n5;
                n5 = n3;
            }
            if (n2 > n4) {
                n3 = n4;
                n4 = n2;
                n2 = n3;
            }
            if (n2 < this.currentGUI.cropX) {
                n2 = this.currentGUI.cropX;
            }
            if (n2 > this.currentGUI.cropX + this.currentGUI.cropW) {
                n2 = this.currentGUI.cropX + this.currentGUI.cropW;
            }
            if (n4 < this.currentGUI.cropX) {
                n4 = this.currentGUI.cropX;
            }
            if (n4 > this.currentGUI.cropX + this.currentGUI.cropW) {
                n4 = this.currentGUI.cropX + this.currentGUI.cropW;
            }
            if (n5 < this.currentGUI.cropY) {
                n5 = this.currentGUI.cropY;
            }
            if (n5 > this.currentGUI.cropY + this.currentGUI.cropH) {
                n5 = this.currentGUI.cropY + this.currentGUI.cropH;
            }
            if (n < this.currentGUI.cropY) {
                n = this.currentGUI.cropY;
            }
            if (n > this.currentGUI.cropY + this.currentGUI.cropH) {
                n = this.currentGUI.cropY + this.currentGUI.cropH;
            }
            if (abstractButton.getText().equals("Table")) {
                string = string + this.extractTextTable(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n);
            }
            if (abstractButton.getText().equals("Rectangle")) {
                string = string + this.extractTextRectangle(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n) + " ";
            }
            if (!abstractButton.getText().equals("WordList")) continue;
            string = string + this.extractTextList(this.decode_pdf.getGroupingObject(), bl, n2, n4, n5, n);
        }
        if (string.length() != 0) {
            if (abstractButton.getText().equals("Table")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (abstractButton.getText().equals("Rectangle")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (abstractButton.getText().equals("WordList")) {
                try {
                    jScrollPane = this.currentGUI.createPane(new JTextPane(), string, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            jScrollPane.setPreferredSize(new Dimension(315, 150));
            jScrollPane.setMinimumSize(new Dimension(315, 150));
            Component[] componentArray = jScrollPane.getComponents();
            for (n2 = 0; n2 != componentArray.length; ++n2) {
                if (!(jScrollPane.getComponent(n2) instanceof JViewport)) continue;
                JViewport jViewport = (JViewport)jScrollPane.getComponent(n2);
                Component[] componentArray2 = jViewport.getComponents();
                for (n = 0; n != componentArray2.length; ++n) {
                    if (!(componentArray2[n] instanceof JTextPane)) continue;
                    ((JTextPane)componentArray2[n]).setEditable(false);
                }
            }
            return jScrollPane;
        }
        return null;
    }

    public void extractSelectedText() {
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return;
        }
        Rectangle[] rectangleArray = !DynamicVectorRenderer.textBasedHighlight ? new Rectangle[]{this.currentGUI.getRectangle()} : this.decode_pdf.getHighlightedAreas(this.commonValues.getCurrentPage());
        final Rectangle[] rectangleArray2 = rectangleArray;
        if (rectangleArray2 == null) {
            JOptionPane.showMessageDialog(this.decode_pdf, "There is no text selected.\nPlease highlight the text you wish to extract.", "No Text selected", 0);
            return;
        }
        JScrollPane jScrollPane = new JScrollPane();
        final JPanel jPanel = new JPanel();
        final ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton("Extract as Text");
        final JRadioButton jRadioButton2 = new JRadioButton("Extract  as  XML");
        JRadioButton jRadioButton3 = new JRadioButton(Messages.getMessage("PdfViewerRect.label"));
        final JRadioButton jRadioButton4 = new JRadioButton(Messages.getMessage("PdfViewerTable.label"));
        JRadioButton jRadioButton5 = new JRadioButton(Messages.getMessage("PdfViewerWordList.label"));
        final SpringLayout springLayout = new SpringLayout();
        final JFrame jFrame = new JFrame(Messages.getMessage("PdfViewerCoords.message") + ' ' + this.commonValues.m_x1 + " , " + this.commonValues.m_y1 + " , " + (this.commonValues.m_x2 - this.commonValues.m_x1) + " , " + (this.commonValues.m_y2 - this.commonValues.m_y1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerDemo.message"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Object[] objectArray = new Object[]{Messages.getMessage("PdfViewerHelpMenu.text"), Messages.getMessage("PdfViewerCancel.text"), Messages.getMessage("PdfViewerextract.text")};
        JButton jButton = new JButton((String)objectArray[0]);
        JButton jButton2 = new JButton((String)objectArray[1]);
        JButton jButton3 = new JButton((String)objectArray[2]);
        jPanel.setLayout(springLayout);
        final Runnable runnable = new Runnable(){

            public void run() {
                Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    if (!abstractButton.isSelected()) continue;
                    try {
                        Component[] componentArray = jPanel.getComponents();
                        for (int i = 0; i != componentArray.length; ++i) {
                            if (!(componentArray[i] instanceof JScrollPane)) continue;
                            jPanel.remove(componentArray[i]);
                        }
                        JScrollPane jScrollPane = Commands.this.updateExtractionExample(abstractButton, jRadioButton2.isSelected());
                        if (jScrollPane != null) {
                            springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
                            springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
                            jPanel.add(jScrollPane);
                            break;
                        }
                        JLabel jLabel = new JLabel("No Example Available");
                        Font font = jLabel.getFont();
                        font = font.deriveFont(font.getStyle(), 20.0f);
                        jLabel.setFont(font);
                        jLabel.setForeground(Color.RED);
                        springLayout.putConstraint("East", (Component)jLabel, -75, "East", (Component)jPanel);
                        springLayout.putConstraint("North", (Component)jLabel, 50, "South", (Component)jRadioButton4);
                        jPanel.add(jLabel);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                    break;
                }
                jPanel.updateUI();
            }
        };
        jRadioButton3.setSelected(true);
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton3);
        jRadioButton3.setToolTipText(Messages.getMessage("PdfViewerRect.message"));
        springLayout.putConstraint("West", (Component)jRadioButton3, 10, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton3, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton3);
        jRadioButton4.setSelected(true);
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract as XHTML");
                jRadioButton.setText("Extract as CSV");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton4);
        jRadioButton4.setToolTipText(Messages.getMessage("PdfViewerTable.message"));
        springLayout.putConstraint("West", (Component)jRadioButton4, 50, "East", (Component)jRadioButton3);
        springLayout.putConstraint("North", (Component)jRadioButton4, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton4);
        jRadioButton5.setSelected(true);
        jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jRadioButton2.setText("Extract  as  XML");
                jRadioButton.setText("Extract as Text");
                SwingUtilities.invokeLater(runnable);
            }
        });
        buttonGroup.add(jRadioButton5);
        jRadioButton5.setToolTipText(Messages.getMessage("PdfViewerWordList.message"));
        springLayout.putConstraint("East", (Component)jRadioButton5, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jRadioButton5, 5, "North", (Component)jPanel);
        jPanel.add(jRadioButton5);
        jScrollPane.setPreferredSize(new Dimension(315, 150));
        jScrollPane.setMinimumSize(new Dimension(315, 150));
        springLayout.putConstraint("East", (Component)jScrollPane, -5, "East", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jRadioButton4);
        jPanel.add(jScrollPane);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        jRadioButton.setSelected(true);
        springLayout.putConstraint("West", (Component)jRadioButton2, 5, "West", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton2, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton2);
        springLayout.putConstraint("East", (Component)jRadioButton, -5, "East", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jRadioButton, -5, "North", (Component)jButton3);
        jPanel.add(jRadioButton);
        springLayout.putConstraint("South", (Component)jButton3, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton3, -5, "East", (Component)jPanel);
        jPanel.add(jButton3);
        springLayout.putConstraint("South", (Component)jButton2, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton2, -5, "West", (Component)jButton3);
        jPanel.add(jButton2);
        springLayout.putConstraint("South", (Component)jButton, -5, "North", (Component)jLabel);
        springLayout.putConstraint("East", (Component)jButton, -5, "West", (Component)jButton2);
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
                Commands.this.currentGUI.showMessageDialog(jTextArea);
                Commands.this.display = true;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block22: {
                    try {
                        Container container;
                        String string = "";
                        String string2 = "";
                        int n = 0;
                        boolean bl = true;
                        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                        while (enumeration.hasMoreElements() && !enumeration.nextElement().isSelected()) {
                            ++n;
                        }
                        for (int i = 0; i != rectangleArray2.length; ++i) {
                            int n2;
                            string2 = "";
                            rectangleArray2[i] = Commands.adjustHighlightForExtraction(rectangleArray2[i]);
                            int n3 = rectangleArray2[i].x;
                            int n4 = rectangleArray2[i].x + rectangleArray2[i].width;
                            int n5 = rectangleArray2[i].y + rectangleArray2[i].height;
                            int n6 = rectangleArray2[i].y;
                            if (n5 < n6) {
                                n2 = n6;
                                n6 = n5;
                                n5 = n2;
                            }
                            if (n3 > n4) {
                                n2 = n4;
                                n4 = n3;
                                n3 = n2;
                            }
                            if (n3 < ((Commands)Commands.this).currentGUI.cropX) {
                                n3 = ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n3 > ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX) {
                                n3 = ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n4 < ((Commands)Commands.this).currentGUI.cropX) {
                                n4 = ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n4 > ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX) {
                                n4 = ((Commands)Commands.this).currentGUI.cropW - ((Commands)Commands.this).currentGUI.cropX;
                            }
                            if (n5 < ((Commands)Commands.this).currentGUI.cropY) {
                                n5 = ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n5 > ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY) {
                                n5 = ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n6 < ((Commands)Commands.this).currentGUI.cropY) {
                                n6 = ((Commands)Commands.this).currentGUI.cropY;
                            }
                            if (n6 > ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY) {
                                n6 = ((Commands)Commands.this).currentGUI.cropH - ((Commands)Commands.this).currentGUI.cropY;
                            }
                            switch (n) {
                                case 0: {
                                    string2 = Commands.this.extractTextRectangle(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6) + '\r' + '\n';
                                    break;
                                }
                                case 1: {
                                    string2 = Commands.this.extractTextTable(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6);
                                    break;
                                }
                                case 2: {
                                    string2 = Commands.this.extractTextList(Commands.this.decode_pdf.getGroupingObject(), jRadioButton2.isSelected(), n3, n4, n5, n6);
                                    break;
                                }
                            }
                            string = string + string2;
                        }
                        if (string == null) break block22;
                        JScrollPane jScrollPane = new JScrollPane();
                        try {
                            container = new JTextPane();
                            jScrollPane = Commands.this.currentGUI.createPane((JTextPane)container, string, bl);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                        jScrollPane.setHorizontalScrollBarPolicy(31);
                        jScrollPane.setVerticalScrollBarPolicy(20);
                        jScrollPane.setPreferredSize(new Dimension(400, 400));
                        container = new JDialog((Frame)null, true);
                        if (Commands.this.commonValues.getModeOfOperation() != 1) {
                            Container container2 = Commands.this.currentGUI.getFrame();
                            ((Window)container).setLocation(container2.getLocationOnScreen().x + 10, container2.getLocationOnScreen().y + 10);
                        }
                        ((Window)container).setSize(450, 450);
                        ((Dialog)container).setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
                        ((JDialog)container).getContentPane().setLayout(new BorderLayout());
                        ((JDialog)container).getContentPane().add((Component)jScrollPane, "Center");
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BorderLayout());
                        ((JDialog)container).getContentPane().add((Component)jPanel, "South");
                        JButton jButton = new JButton(Messages.getMessage("PdfViewerMenu.return"));
                        jButton.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton, "West");
                        jButton.addActionListener(new ActionListener((JDialog)container){
                            private final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                Commands.this.display = true;
                                this.val$displayFrame.dispose();
                            }
                        });
                        JButton jButton2 = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
                        jButton2.setFont(new Font("SansSerif", 0, 12));
                        jPanel.add((Component)jButton2, "East");
                        jButton2.addActionListener(new ActionListener((JDialog)container){
                            private final /* synthetic */ JDialog val$displayFrame;
                            {
                                this.val$displayFrame = jDialog;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                this.val$displayFrame.dispose();
                            }
                        });
                        ((Dialog)container).setVisible(true);
                    }
                    catch (PdfException pdfException) {
                        pdfException.printStackTrace();
                    }
                }
            }
        });
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setSize(350, 300);
        SwingUtilities.invokeLater(runnable);
        jFrame.setLocationRelativeTo(this.currentGUI.getFrame());
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    private String extractTextList(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        Vector vector;
        int n5;
        String string = "";
        PdfGroupingAlgorithms.useUnrotatedCoords = true;
        PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
        int n6 = pdfPageData.getRotation(this.commonValues.getCurrentPage());
        if (n6 != 0 && (n5 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerRotatedCoords.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0)) == 0) {
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
        }
        if ((vector = pdfGroupingAlgorithms.extractTextAsWordlist(n, n3, n2, n4, this.commonValues.getCurrentPage(), true, null)) == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
        }
        if (vector != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!bl) {
                    string2 = Strip.convertToText(string2);
                }
                int n7 = (int)Float.parseFloat((String)iterator.next());
                int n8 = (int)Float.parseFloat((String)iterator.next());
                int n9 = (int)Float.parseFloat((String)iterator.next());
                int n10 = (int)Float.parseFloat((String)iterator.next());
                stringBuffer.append(string2).append(',').append(n7).append(',').append(n8).append(',').append(n9).append(',').append(n10).append('\n');
            }
            if (stringBuffer.toString() != null) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private String extractTextTable(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        Map map = !bl ? pdfGroupingAlgorithms.extractTextAsTable(n, n3, n2, n4, this.commonValues.getCurrentPage(), true, false, false, false, 0) : pdfGroupingAlgorithms.extractTextAsTable(n, n3, n2, n4, this.commonValues.getCurrentPage(), false, true, true, false, 1);
        if ((String)map.get("content") != null) {
            return (String)map.get("content");
        }
        return "";
    }

    private String extractTextRectangle(PdfGroupingAlgorithms pdfGroupingAlgorithms, boolean bl, int n, int n2, int n3, int n4) throws PdfException {
        String string = pdfGroupingAlgorithms.extractTextInRectangle(n, n3, n2, n4, this.commonValues.getCurrentPage(), false, true);
        if (string == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + n + " y1:" + n3 + " x2:" + n2 + " y2:" + n4);
            return "";
        }
        if (!bl) {
            string = Strip.stripXML(string).toString();
        }
        return string;
    }

    private void decodeImage(final boolean bl) {
        this.decode_pdf.clearHighlights();
        this.currentGUI.setRectangle(null);
        this.currentGUI.resetComboBoxes(false);
        this.currentGUI.setPageLayoutButtonsEnabled(false);
        this.decode_pdf.getDynamicRenderer().flush();
        this.decode_pdf.clearScreen();
        this.thumbnails.terminateDrawing();
        Values.setProcessing(true);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Commands.this.currentGUI.updateStatusMessage(Messages.getMessage("PdfViewerDecoding.page"));
                    if (Commands.this.img != null) {
                        Commands.this.decode_pdf.addImage(Commands.this.img);
                    }
                    PdfPageData pdfPageData = Commands.this.decode_pdf.getPdfPageData();
                    if (Commands.this.img != null) {
                        pdfPageData.setMediaBox(new float[]{0.0f, 0.0f, Commands.this.img.getWidth(), Commands.this.img.getHeight()});
                    }
                    pdfPageData.checkSizeSet(1);
                    Commands.this.currentGUI.resetRotationBox();
                    if (bl && Commands.this.thumbnails.isShownOnscreen()) {
                        Commands.this.currentGUI.zoom(false);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Commands.this.currentGUI.setPageNumber();
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                catch (Exception exception) {
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                Commands.this.currentGUI.setStatusProgress(100);
                Commands.this.currentGUI.resetComboBoxes(true);
                Commands.this.decode_pdf.repaint();
                Commands.this.openingTransferedFile = false;
                return null;
            }
        };
        swingWorker.start();
    }

    protected boolean openUpFile(String string) throws PdfException {
        this.commonValues.maxViewY = 0;
        this.commonValues.setMultiTiff(false);
        boolean bl = true;
        if (this.currentGUI.isSingle()) {
            this.decode_pdf.closePdfFile();
        }
        try {
            if (this.commonValues.isPDF()) {
                block44: {
                    if (this.inputStream != null || string.startsWith("http") || string.startsWith("file:") || string.startsWith("jar:")) {
                        try {
                            boolean bl2 = false;
                            if (this.inputStream != null) {
                                bl2 = true;
                            } else if (this.commonValues.getModeOfOperation() != 1) {
                                bl2 = this.decode_pdf.isPDFLinearized(this.commonValues.getSelectedFile());
                            }
                            if (!bl2) {
                                Point point = null;
                                if (this.commonValues.getModeOfOperation() != 1) {
                                    point = new Point(this.currentGUI.getFrame().getLocationOnScreen().x + this.currentGUI.getFrame().getWidth() / 2, this.currentGUI.getFrame().getLocationOnScreen().y + this.currentGUI.getFrame().getHeight() / 2);
                                }
                                if (this.commonValues.getSelectedFile().startsWith("jar:")) {
                                    InputStream inputStream = this.getClass().getResourceAsStream(this.commonValues.getSelectedFile().substring(4));
                                    this.decode_pdf.openPdfFileFromInputStream(inputStream, false);
                                } else {
                                    final DownloadProgress downloadProgress = new DownloadProgress(this.currentGUI, this.commonValues.getSelectedFile());
                                    Thread thread = new Thread(){

                                        public void run() {
                                            while (downloadProgress.isDownloading()) {
                                                Commands.this.currentGUI.setDownloadProgress("download", downloadProgress.getProgress());
                                                try {
                                                    Thread.sleep(500L);
                                                }
                                                catch (Exception exception) {}
                                            }
                                        }
                                    };
                                    thread.start();
                                    downloadProgress.startDownload();
                                    File file = downloadProgress.getFile();
                                    this.decode_pdf.openPdfFile(file.getCanonicalPath());
                                }
                                break block44;
                            }
                            this.currentGUI.setViewerTitle("Loading linearized PDF " + this.commonValues.getSelectedFile());
                            if (this.inputStream != null) {
                                this.decode_pdf.openPdfFileFromInputStream(this.inputStream, true);
                            } else {
                                this.decode_pdf.openPdfFileFromURL(this.commonValues.getSelectedFile(), true);
                            }
                            PdfObject pdfObject = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
                            int n = pdfObject.getInt(28);
                            String string2 = "Downloading ";
                            string2 = (n /= 1024) < 1024 ? string2 + n + " kB" : string2 + (n /= 1024) + " M";
                            final String string3 = string2;
                            Thread thread = new Thread(){

                                public void run() {
                                    PdfDecoder.LinearThread linearThread = (PdfDecoder.LinearThread)Commands.this.decode_pdf.getJPedalObject(-1276915978);
                                    while (linearThread.isAlive()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            interruptedException.printStackTrace();
                                        }
                                        Commands.this.currentGUI.setDownloadProgress(string3, linearThread.getPercentageLoaded());
                                    }
                                    Commands.this.currentGUI.setDownloadProgress(string3, 100);
                                    Commands.this.processPage();
                                }
                            };
                            thread.start();
                        }
                        catch (Exception exception) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError") + " file=" + string + "\n" + exception.getMessage());
                            string = null;
                            bl = false;
                        }
                    } else {
                        try {
                            this.decode_pdf.openPdfFile(this.commonValues.getSelectedFile());
                        }
                        catch (RuntimeException runtimeException) {
                            this.currentGUI.showMessageDialog("Exception in code " + runtimeException.getMessage() + " please send to IDRsolutions");
                            LogWriter.writeLog("Exception " + runtimeException.getMessage());
                        }
                        if (this.decode_pdf.getPageCount() > 1 && !this.commonValues.isContentExtractor()) {
                            this.currentGUI.setPageLayoutButtonsEnabled(true);
                        }
                    }
                }
                this.currentGUI.reinitThumbnails();
            } else {
                boolean bl3;
                boolean bl4;
                this.decode_pdf.resetForNonPDFPage();
                this.decode_pdf.setlastPageDecoded(1);
                boolean bl5 = bl4 = string.toLowerCase().indexOf(".tif") != -1;
                if (JAIHelper.isJAIused()) {
                    JAIHelper.confirmJAIOnClasspath();
                }
                boolean bl6 = bl3 = string.startsWith("http:") || string.startsWith("file:");
                if (bl4 && JAIHelper.isJAIused()) {
                    try {
                        this.tiffHelper = new JAITiffHelper(this.commonValues.getSelectedFile());
                        int n = this.tiffHelper.getTiffPageCount();
                        this.tiffImageToLoad = 0;
                        if (n > 1) {
                            this.decode_pdf.setPageCount(n);
                            this.commonValues.setPageCount(n);
                            this.decode_pdf.setlastPageDecoded(1);
                            this.commonValues.setMultiTiff(true);
                            this.decode_pdf.setMultiPageTiff(true);
                        }
                        this.drawMultiPageTiff();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        LogWriter.writeLog("Exception " + exception + Messages.getMessage("PdfViewerError.Loading") + this.commonValues.getSelectedFile());
                    }
                } else {
                    boolean bl7;
                    String string4 = this.properties.getValue("showtiffmessage");
                    boolean bl8 = bl7 = bl4 && string4.length() > 0 && string4.equals("true");
                    if (bl7) {
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new GridBagLayout());
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.anchor = 17;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 0;
                        String string5 = "<html>Some Tiff images do not display correctly without JAI support turned on.  <br>See <a href=\"http://www.jpedal.org/support_JVMOpt.php\"> http://www.jpedal.org/support_JVMOpt.php</a> for information on enabling JAI.";
                        JCheckBox jCheckBox = new JCheckBox();
                        jCheckBox.setText(Messages.getMessage("PdfViewerFormsWarning.CheckBox"));
                        Font font = jCheckBox.getFont();
                        JEditorPane jEditorPane = new JEditorPane();
                        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                    try {
                                        BrowserLauncher.openURL(hyperlinkEvent.getURL().toExternalForm());
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                        });
                        jEditorPane.setEditable(false);
                        jEditorPane.setContentType("text/html");
                        jEditorPane.setText(string5);
                        jEditorPane.setOpaque(false);
                        jEditorPane.setFont(font);
                        gridBagConstraints.ipady = 20;
                        jPanel.add((Component)jEditorPane, gridBagConstraints);
                        gridBagConstraints.ipady = 0;
                        gridBagConstraints.gridy = 1;
                        jPanel.add((Component)jCheckBox, gridBagConstraints);
                        JOptionPane.showMessageDialog(this.currentGUI.getFrame(), jPanel);
                        if (jCheckBox.isSelected()) {
                            this.properties.setValue("showtiffmessage", "false");
                        }
                    }
                    try {
                        this.img = bl3 ? ImageIO.read(new URL(string)) : ImageIO.read(new File(string));
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + "loading " + this.commonValues.getSelectedFile());
                    }
                }
            }
            this.currentGUI.updateStatusMessage("opening file");
            if (bl && this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                bl = false;
                String string6 = System.getProperty("org.jpedal.password");
                if (string6 == null) {
                    string6 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                }
                if (string6 != null) {
                    this.decode_pdf.setEncryptionPassword(string6);
                    if (this.decode_pdf.isFileViewable()) {
                        bl = true;
                    }
                }
                if (!bl) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            if (bl) {
                if (this.properties.getValue("Recentdocuments").equals("true")) {
                    this.properties.addRecentDocument(this.commonValues.getSelectedFile());
                    this.updateRecentDocuments(this.properties.getRecentDocuments());
                }
                this.recent.addToFileList(this.commonValues.getSelectedFile());
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (PdfException pdfException) {
            System.err.println("Exception " + pdfException + " opening file");
            if (this.currentGUI.isSingle()) {
                if (SimpleViewer.showMessages) {
                    ErrorDialog.showError(pdfException, Messages.getMessage("PdfViewerOpenerror"), this.currentGUI.getFrame(), this.commonValues.getSelectedFile());
                }
                if (SimpleViewer.exitOnClose) {
                    System.exit(1);
                } else {
                    this.currentGUI.getFrame().setVisible(false);
                    if (this.currentGUI.getFrame() instanceof JFrame) {
                        ((JFrame)this.currentGUI.getFrame()).dispose();
                    }
                }
            }
            throw pdfException;
        }
        if (!this.decode_pdf.isOpen() && this.commonValues.isPDF() && this.decode_pdf.getJPedalObject(2004845231) == null) {
            return false;
        }
        return bl;
    }

    public void openFile(String string) throws PdfException {
        String string2;
        this.decode_pdf.setPDF(false);
        this.decode_pdf.setMultiPageTiff(false);
        String string3 = System.getProperty("org.jpedal.hires");
        if (PdfDecoder.hires || string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.thumbnails.resetToDefault();
        this.currentGUI.setNoPagesDecoded();
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.commonValues.maxViewY = 0;
        String string4 = string.toLowerCase().trim();
        this.commonValues.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        this.decode_pdf.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        if (!this.commonValues.isPDF()) {
            this.decode_pdf.setDisplayView(1, 2);
        }
        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
        this.commonValues.setCurrentPage(1);
        try {
            boolean bl = this.openUpFile(this.commonValues.getSelectedFile());
            if (bl) {
                this.processPage();
            } else {
                this.currentGUI.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                this.decode_pdf.clearScreen();
                this.currentGUI.zoom(false);
                this.commonValues.setPageCount(1);
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    protected void processPage() {
        if (this.commonValues.isPDF() && (this.decode_pdf.isOpen() || !this.commonValues.isPDF() || this.decode_pdf.getJPedalObject(2004845231) != null)) {
            boolean bl;
            PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            String[] stringArray3 = new String[]{"TeleForm", "dgn2pdf"};
            for (bl = false; bl < stringArray2.length; bl += 1) {
                if (!stringArray2[bl].equals("Creator") && !stringArray2[bl].equals("Producer")) continue;
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (!stringArray[bl].equals(stringArray3[i])) continue;
                    this.decode_pdf.setRenderMode(2);
                }
                if (!stringArray[bl].equals("ABBYY FineReader 8.0 Professional Edition")) continue;
                this.decode_pdf.setRenderMode(35);
            }
            Commands commands = this;
            bl = commands.commonValues.isProcessing();
            Values.setProcessing(true);
            Values.setProcessing(bl);
        }
        if (this.commonValues.isPDF()) {
            this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        } else if (!this.commonValues.isMultiTiff()) {
            this.commonValues.setPageCount(1);
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage()) {
            this.commonValues.setCurrentPage(this.commonValues.getPageCount());
            System.err.println(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        this.decode_pdf.setExtractionMode(1, 72, this.currentGUI.getScaling());
        this.currentGUI.setPageNumber();
        this.currentGUI.resetRotationBox();
        if (this.commonValues.isPDF()) {
            this.currentGUI.messageShown = false;
            this.currentGUI.decodePage(true);
        } else {
            this.currentGUI.zoom(false);
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.decode_pdf.disableBorderForPrinting();
            this.decodeImage(true);
            Values.setProcessing(false);
        }
    }

    public void selectFile() {
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.currentGUI.resetNavBar();
        JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
        jFileChooser.setName("chooser");
        if (this.commonValues.getSelectedFile() != null) {
            jFileChooser.setSelectedFile(new File(this.commonValues.getSelectedFile()));
        }
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        String[] stringArray2 = new String[]{"fdf"};
        String[] stringArray3 = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Images (Tiff, Jpeg,Png)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "fdf (*.fdf)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = jFileChooser.showOpenDialog(this.currentGUI.getFrame());
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            boolean bl;
            String string = file.getName().toLowerCase();
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (bl) {
                try {
                    this.commonValues.setInputDir(jFileChooser.getCurrentDirectory().getCanonicalPath());
                    this.open(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    private String selectURL() {
        boolean bl;
        String string = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (string != null) {
            string = string.trim();
        }
        if (!(string == null || string.trim().startsWith("http://") || string.trim().startsWith("https://") || string.trim().startsWith("file:/"))) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            string = null;
        }
        if (string != null) {
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (!bl) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                string = null;
            }
        }
        if (string != null) {
            this.commonValues.setSelectedFile(string);
            bl = false;
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection.getContent() == null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                string = null;
                this.currentGUI.showMessageDialog("URL " + string + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (string != null) {
            try {
                this.commonValues.setFileSize(0L);
                this.currentGUI.setViewerTitle(null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (string != null) {
                Commands commands = this;
                if (!commands.commonValues.isProcessing()) {
                    this.thumbnails.terminateDrawing();
                    this.decode_pdf.flushObjectValues(true);
                    this.decode_pdf.resetViewableArea();
                    this.currentGUI.stopThumbnails();
                    if (!this.currentGUI.isSingle()) {
                        this.openNewMultiplePage(this.commonValues.getSelectedFile());
                    }
                    try {
                        this.openFile(this.commonValues.getSelectedFile());
                    }
                    catch (PdfException pdfException) {}
                }
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return string;
    }

    private void navigatePages(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.commonValues.getCurrentPage() + n;
        if (n > 0) {
            if (!this.decode_pdf.isPageAvailable(n2)) {
                this.currentGUI.showMessageDialog("Page " + n2 + " is not yet loaded");
                return;
            }
            if (this.decode_pdf.getDisplayView() == 5) {
                Display display = (Display)this.decode_pdf.getExternalHandler(16);
                display.stopGeneratingPage();
                display.drawBorder();
            }
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (n2 <= this.commonValues.getPageCount()) {
                    if (this.commonValues.isMultiTiff()) {
                        this.tiffImageToLoad = this.decode_pdf.getlastPageDecoded() - 1 + n;
                        this.drawMultiPageTiff();
                        this.commonValues.setCurrentPage(n2);
                        this.decode_pdf.setlastPageDecoded(this.tiffImageToLoad + 1);
                        this.currentGUI.setPageNumber();
                        this.decode_pdf.repaint();
                    } else {
                        if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
                            if (++n2 > this.commonValues.getPageCount()) {
                                n2 = this.commonValues.getPageCount();
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (this.decode_pdf.getDisplayView() == 3) {
                                n = n2 / 2 - this.commonValues.getCurrentPage() / 2;
                            }
                        }
                        if (n == 1 && this.decode_pdf.turnoverOn && this.decode_pdf.getPageCount() != 2 && this.currentGUI.getPageTurnScalingAppropriate() && this.decode_pdf.getDisplayView() == 3 && n2 / 2 != this.commonValues.getCurrentPage() / 2 && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().getPageTurnAnimating()) {
                            float f = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                            float f2 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                            if (this.decode_pdf.getPdfPageData().getRotation(1) % 180 == 90) {
                                float f3 = f;
                                f = f2;
                                f2 = f3;
                            }
                            final Point point = new Point();
                            point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f);
                            point.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                            final Point point2 = new Point();
                            point2.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f);
                            point2.y = (int)((float)this.decode_pdf.getInsetH() + f2);
                            final int n3 = n2;
                            Thread thread = new Thread(){

                                public void run() {
                                    int n = 1;
                                    if (point2.x <= point.x) {
                                        point2.x = point.x - 1;
                                    }
                                    double d = point.x - point2.x;
                                    while (point2.getX() >= point.getX()) {
                                        double d2 = (double)n * d * 0.001;
                                        if (d2 > -1.0) {
                                            d2 = -1.0;
                                        }
                                        point2.setLocation(point2.getX() + d2, point2.getY());
                                        Commands.this.decode_pdf.setUserOffsets((int)point2.getX(), (int)point2.getY(), 999);
                                        if (n < 32) {
                                            n *= 2;
                                        }
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(50L);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    Commands.this.commonValues.setCurrentPage(n3);
                                    Commands.this.currentGUI.setPageNumber();
                                    Commands.this.decode_pdf.setPageParameters(Commands.this.currentGUI.getScaling(), Commands.this.commonValues.getCurrentPage());
                                    Commands.this.currentGUI.decodePage(false);
                                    ((DefaultActionHandler)Commands.this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(false);
                                    Commands.this.decode_pdf.setUserOffsets(0, 0, 995);
                                }
                            };
                            ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(true);
                            thread.start();
                        } else {
                            this.commonValues.setCurrentPage(n2);
                            this.currentGUI.setPageNumber();
                            if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 5) {
                                this.currentGUI.decodePage(false);
                                return;
                            }
                            this.currentGUI.resetStatusMessage("Loading Page " + this.commonValues.getCurrentPage());
                            this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                            if (this.commonValues.isPDF()) {
                                this.currentGUI.decodePage(false);
                            }
                        }
                    }
                }
            } else {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            }
        } else {
            if (!this.decode_pdf.isPageAvailable(n2)) {
                this.currentGUI.showMessageDialog("Page " + n2 + " is not yet loaded");
                return;
            }
            if (this.decode_pdf.getDisplayView() == 5) {
                Display display = (Display)this.decode_pdf.getExternalHandler(16);
                display.stopGeneratingPage();
                display.drawBorder();
            }
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (n2 >= 1) {
                    if (this.commonValues.isMultiTiff()) {
                        this.tiffImageToLoad = this.decode_pdf.getlastPageDecoded() - 1 - n;
                        this.drawMultiPageTiff();
                        this.commonValues.setCurrentPage(n2);
                        this.decode_pdf.setlastPageDecoded(this.tiffImageToLoad + 1);
                        this.currentGUI.setPageNumber();
                        this.decode_pdf.repaint();
                    } else {
                        if (this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) {
                            if (--n2 < 1) {
                                n2 = 1;
                            }
                            if ((n2 & 1) == 1 && n2 != 1) {
                                --n2;
                            }
                            if (this.decode_pdf.getDisplayView() == 3) {
                                n = n2 / 2 - this.commonValues.getCurrentPage() / 2;
                            }
                        }
                        if (n == -1 && this.decode_pdf.turnoverOn && this.decode_pdf.getDisplayView() == 3 && this.currentGUI.getPageTurnScalingAppropriate() && this.decode_pdf.getPageCount() != 2 && (n2 != this.commonValues.getCurrentPage() - 1 || n2 == 1) && !this.decode_pdf.getPdfPageData().hasMultipleSizes() && !((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().getPageTurnAnimating()) {
                            float f = this.decode_pdf.getPdfPageData().getCropBoxWidth(1);
                            float f4 = this.decode_pdf.getPdfPageData().getCropBoxHeight(1);
                            if (this.decode_pdf.getPdfPageData().getRotation(1) % 180 == 90) {
                                float f5 = f;
                                f = f4;
                                f4 = f5;
                            }
                            final Point point = new Point();
                            point.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 + (double)f);
                            point.y = (int)((float)this.decode_pdf.getInsetH() + f4);
                            final Point point3 = new Point();
                            point3.x = (int)(this.decode_pdf.getVisibleRect().getWidth() / 2.0 - (double)f);
                            point3.y = (int)((float)this.decode_pdf.getInsetH() + f4);
                            final int n4 = n2;
                            Thread thread = new Thread(){

                                public void run() {
                                    int n = 1;
                                    if (point3.x >= point.x) {
                                        point3.x = point.x - 1;
                                    }
                                    double d = point.x - point3.x;
                                    while (point3.getX() <= point.getX()) {
                                        double d2 = (double)n * d * 0.001;
                                        if (d2 < 1.0) {
                                            d2 = 1.0;
                                        }
                                        point3.setLocation(point3.getX() + d2, point3.getY());
                                        Commands.this.decode_pdf.setUserOffsets((int)point3.getX(), (int)point3.getY(), 998);
                                        if (n < 32) {
                                            n *= 2;
                                        }
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(50L);
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    Commands.this.commonValues.setCurrentPage(n4);
                                    Commands.this.currentGUI.setPageNumber();
                                    Commands.this.decode_pdf.setPageParameters(Commands.this.currentGUI.getScaling(), Commands.this.commonValues.getCurrentPage());
                                    Commands.this.currentGUI.decodePage(false);
                                    Commands.this.decode_pdf.setUserOffsets(0, 0, 995);
                                    ((DefaultActionHandler)Commands.this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(false);
                                }
                            };
                            ((DefaultActionHandler)this.decode_pdf.getFormRenderer().getActionHandler()).getSwingMouseHandler().setPageTurnAnimating(true);
                            thread.start();
                        } else {
                            this.commonValues.setCurrentPage(n2);
                            this.currentGUI.setPageNumber();
                            if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 5) {
                                this.currentGUI.decodePage(false);
                                return;
                            }
                            this.currentGUI.resetStatusMessage("loading page " + this.commonValues.getCurrentPage());
                            this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                            if (this.commonValues.isPDF()) {
                                this.currentGUI.decodePage(false);
                            }
                        }
                    }
                }
            } else {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
            }
        }
    }

    public void gotoPage(String string) {
        int n;
        string = string.split("/")[0];
        try {
            n = Integer.parseInt(string);
            if (!this.decode_pdf.isPageAvailable(n)) {
                this.currentGUI.showMessageDialog("Page " + n + " is not yet loaded");
                this.currentGUI.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
                return;
            }
            if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (n & 1) == 1 && n != 1) {
                --n;
            }
            if (n > this.decode_pdf.getPageCount() | n < 1) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + string + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + this.decode_pdf.getPageCount());
                n = this.commonValues.getCurrentPage();
                this.currentGUI.setPageNumber();
            }
        }
        catch (Exception exception) {
            this.currentGUI.showMessageDialog('>' + string + "< " + Messages.getMessage("PdfViewerInvalidNumber.text"));
            n = this.commonValues.getCurrentPage();
            this.currentGUI.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
        }
        this.navigatePages(n - this.commonValues.getCurrentPage());
        if (this.decode_pdf.getDisplayView() == 6) {
            this.navigatePages(0);
        }
    }

    private void open(String string) {
        this.currentGUI.resetNavBar();
        boolean bl = string.startsWith("http:") || string.startsWith("file:");
        try {
            if (!bl) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(string).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(string);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(this.commonValues.getSelectedFile());
        if (!bl && !file.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null) {
            Commands commands = this;
            if (!commands.commonValues.isProcessing()) {
                if (this.currentGUI.isSingle()) {
                    this.decode_pdf.flushObjectValues(true);
                } else {
                    this.decode_pdf = this.openNewMultiplePage(this.commonValues.getSelectedFile());
                }
                this.decode_pdf.resetViewableArea();
                try {
                    this.openFile(this.commonValues.getSelectedFile());
                }
                catch (PdfException pdfException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateRecentDocuments(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = RecentDocuments.getShortenedFileName(stringArray[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new JMenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + string);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setName(stringArray[i]);
        }
    }

    public void enableRecentDocuments(boolean bl) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(bl);
            this.recentDocuments[i].setEnabled(bl);
        }
    }

    private void drawMultiPageTiff() {
        if (this.tiffHelper != null) {
            this.img = this.tiffHelper.getImage(this.tiffImageToLoad);
            if (this.img != null) {
                this.decode_pdf.getDynamicRenderer().flush();
                this.decode_pdf.addImage(this.img);
            }
        }
    }

    public void recentDocumentsOption(JMenu jMenu) {
        String[] stringArray = this.properties.getRecentDocuments();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "";
            }
            try {
                String string = stringArray[i];
                String string2 = RecentDocuments.getShortenedFileName(string);
                this.recentDocuments[i] = new JMenuItem(i + 1 + ": " + string2);
                if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                    this.recentDocuments[i].setVisible(false);
                }
                this.recentDocuments[i].setName(string);
                this.recentDocuments[i].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Commands.this.currentPrinter;
                        if (Printer.isPrinting()) {
                            Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                        } else {
                            Commands.this.commonValues;
                            if (Values.isProcessing() || Commands.this.isOpening) {
                                Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                            } else {
                                Commands.this.handleUnsaveForms();
                                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                                String string = jMenuItem.getName();
                                if (string.length() != 0) {
                                    Commands.this.open(string);
                                }
                            }
                        }
                    }
                });
                jMenu.add(this.recentDocuments[i]);
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Problem with file " + stringArray[i]);
            }
        }
    }

    private void saveFile() {
        File file = null;
        String string = "";
        boolean bl = false;
        while (!bl) {
            JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
            jFileChooser.setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                int n2;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
                if (!string.endsWith(".pdf")) {
                    string = string + ".pdf";
                    file = new File(string);
                }
                if (string.equals(this.commonValues.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int n3;
                    fileInputStream = new FileInputStream(this.commonValues.getSelectedFile());
                    fileOutputStream = new FileOutputStream(string);
                    byte[] byArray = new byte[4096];
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                }
                catch (Exception exception) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile"));
                }
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = true;
                continue;
            }
            return;
        }
    }

    private void exit() {
        this.thumbnails.terminateDrawing();
        this.handleUnsaveForms();
        this.currentGUI.showConfirmDialog(new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), -1, -1);
        this.decode_pdf.closePdfFile();
        this.flush();
        try {
            this.properties.setValue("lastDocumentPage", String.valueOf(this.commonValues.getCurrentPage()));
            this.properties.writeDoc();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!SimpleViewer.exitOnClose) {
            this.currentGUI.getFrame().setVisible(false);
            if (this.currentGUI.getFrame() instanceof JFrame) {
                ((JFrame)this.currentGUI.getFrame()).dispose();
            }
        } else {
            System.exit(1);
        }
    }

    public final void flush() {
        File file;
        String[] stringArray;
        String string = this.commonValues.getTarget();
        if (string != null && (stringArray = (file = new File(string)).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + this.commonValues.getSeparator() + stringArray[i]);
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdates(boolean bl) {
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            block9: {
                try {
                    String string = null;
                    string = "http://www.jpedal.org/version.txt";
                    if (string == null) break block9;
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    string2 = string2.substring(0, 7);
                    String string3 = "4.37b36-OS".substring(0, 7);
                    boolean bl4 = false;
                    String[] stringArray = string2.split("b");
                    String[] stringArray2 = string3.split("b");
                    if (Double.parseDouble(stringArray[0]) > Double.parseDouble(stringArray2[0]) || stringArray[0].equals(stringArray2[0]) && Integer.parseInt(stringArray[1]) > Integer.parseInt(stringArray2[1])) {
                        bl4 = true;
                    }
                    if (bl4) {
                        UpdateDialog updateDialog = new UpdateDialog(this.currentGUI.getFrame(), string3, string2);
                        updateDialog.setVisible(true);
                        bl3 = true;
                        break block9;
                    }
                    if (!bl) break block9;
                    this.currentGUI.showMessageDialog("The current version is up to date", "Up to date", 1);
                }
                catch (Exception exception) {
                    bl2 = false;
                    Object var15_16 = null;
                    if (!bl2 && bl) {
                        this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
                    }
                }
            }
            Object var15_15 = null;
            if (!bl2 && bl) {
                this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (!bl2 && bl) {
                this.currentGUI.showMessageDialog("Error making connection so unable to check for updates", "Error", 0);
            }
            throw throwable;
        }
        return bl3;
    }

    public void setPdfDecoder(PdfDecoder pdfDecoder) {
        this.decode_pdf = pdfDecoder;
    }

    public void setPageProperties(Object object, Object object2) {
        if (this.multiViewListener != null) {
            this.multiViewListener.setPageProperties(object, object2);
        }
    }

    public void clearRecentDocuments() {
        this.properties.removeRecentDocuments();
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    public SearchList getSearchList() {
        return this.searchFrame.getResults();
    }
}

