/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.PdfDecoder;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesFile {
    private String separator = System.getProperty("file.separator");
    private String userDir = System.getProperty("user.dir");
    private String configFile = this.userDir + this.separator + ".properties.xml";
    private boolean isTest = false;
    private boolean refactorProperties = false;
    private boolean isReadOnly = false;
    private Document doc;
    private int noOfRecentDocs = 6;
    private String[] properties = new String[]{"showfirsttimepopup", "true", "showrhinomessage", "false", "showsaveformsmessage", "true", "showitextmessage", "true", "showddmessage", "true", "searchWindowType", "2", "borderType", "1", "useHiResPrinting", "true", "showDownloadWindow", "true", "DPI", "110", "autoScroll", "true", "pageMode", "1", "displaytipsonstartup", "false", "automaticupdate", "true", "currentversion", "4.37b36-OS", "showtiffmessage", "true", "maxmultiviewers", "20", "MenuBarMenu", "true", "FileMenu", "true", "OpenMenu", "true", "Open", "true", "Openurl", "true", "ENDCHILDREN", "Save", "true", "Resaveasforms", "true", "Find", "true", "Documentproperties", "true", "Signpdf", "true", "Print", "true", "Recentdocuments", "true", "Exit", "true", "ENDCHILDREN", "EditMenu", "true", "Copy", "true", "Selectall", "true", "Deselectall", "true", "Preferences", "true", "ENDCHILDREN", "ViewMenu", "true", "GotoMenu", "true", "Firstpage", "true", "Backpage", "true", "Forwardpage", "true", "Lastpage", "true", "Goto", "true", "Previousdocument", "true", "Nextdocument", "true", "ENDCHILDREN", "PagelayoutMenu", "true", "Single", "true", "Continuous", "true", "Facing", "true", "Continuousfacing", "true", "PageFlow", "true", "ENDCHILDREN", "textSelect", "true", "panMode", "true", "Fullscreen", "true", "ENDCHILDREN", "WindowMenu", "true", "Cascade", "true", "Tile", "true", "ENDCHILDREN", "ExportMenu", "true", "PdfMenu", "true", "Oneperpage", "true", "Nup", "true", "Handouts", "true", "ENDCHILDREN", "ContentMenu", "true", "Images", "true", "Text", "true", "ENDCHILDREN", "Bitmap", "true", "ENDCHILDREN", "PagetoolsMenu", "true", "Rotatepages", "true", "Deletepages", "true", "Addpage", "true", "Addheaderfooter", "true", "Stamptext", "true", "Stampimage", "false", "Crop", "true", "ENDCHILDREN", "HelpMenu", "true", "Visitwebsite", "true", "Tipoftheday", "true", "Checkupdates", "true", "About", "true", "ENDCHILDREN", "ENDCHILDREN", "ButtonsMenu", "true", "Openfilebutton", "true", "Printbutton", "true", "Searchbutton", "true", "Propertiesbutton", "false", "Aboutbutton", "false", "Snapshotbutton", "true", "CursorButton", "true", "MouseModeButton", "true", "ENDCHILDREN", "DisplayOptionsMenu", "true", "Scalingdisplay", "true", "Rotationdisplay", "true", "Imageopdisplay", "false", "Progressdisplay", "true", "Downloadprogressdisplay", "true", "ENDCHILDREN", "NavigationBarMenu", "true", "Memorybottom", "true", "Firstbottom", "true", "Back10bottom", "true", "Backbottom", "true", "Gotobottom", "true", "Forwardbottom", "true", "Forward10bottom", "true", "Lastbottom", "true", "Singlebottom", "true", "Continuousbottom", "true", "Continuousfacingbottom", "true", "Facingbottom", "true", "PageFlowbottom", "true", "ENDCHILDREN", "SideTabBarMenu", "true", "Pagetab", "true", "Bookmarkstab", "true", "Layerstab", "true", "Signaturestab", "true", "ENDCHILDREN", "ShowMenubar", "true", "ShowButtons", "true", "ShowDisplayoptions", "true", "ShowNavigationbar", "true", "ShowSidetabbar", "true", "highlightBoxColor", "-16777216", "highlightTextColor", "16750900", "highlightComposite", "0.35", "invertHighlights", "false", "openLastDocument", "false", "lastDocumentPage", "1", "pageInsets", "25", "pageFlowPages", "8", "pageFlowExtraCache", "10", "pageFlowReflection", "true", "pageFlowSideSize", "0.75", "pageFlowReflectionHeight", "0.25", "sideTabBarCollapseLength", "30", "consistentTabBar", "false", "allowRightClick", "true", "allowScrollwheelZoom", "true", "readOnly", "false", "enhancedViewerMode", "true", "enhancedFacingMode", "true", "windowTitle", "", "confirmClose", "false", "iconLocation", "/org/jpedal/examples/simpleviewer/res/", "enhancedGUI", "true", "showpageflow3dsmessage", "true", "defaultPrinter", "", "defaultDPI", "600", "defaultPagesize", "", "printerBlacklist", "", "useHinting", "false", "voice", "kevin16(general domain)"};
    int position = 0;
    private boolean endMenu = false;

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public PropertiesFile() {
        try {
            String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.userDir = string.substring(0, string.lastIndexOf("/"));
            this.configFile = this.userDir + this.separator + ".properties.xml";
            if (PdfDecoder.isRunningOnWindows && this.configFile.length() > 1) {
                this.configFile = this.configFile.substring(1);
                this.configFile = this.configFile.replaceAll("\\\\", "/");
            }
        }
        catch (Exception exception) {
            this.userDir = System.getProperty("user.dir");
            this.configFile = this.userDir + this.separator + ".properties.xml";
        }
    }

    public PropertiesFile(String string) {
        this.configFile = string;
    }

    public void setupProperties() {
        this.loadProperties();
    }

    public void loadProperties() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File file = new File(this.configFile);
            if (file.exists() && file.length() > 0L) {
                try {
                    this.doc = documentBuilder.parse(file);
                }
                catch (Exception exception) {
                    this.doc = documentBuilder.newDocument();
                }
            } else {
                this.doc = documentBuilder.newDocument();
            }
            if ((file.canWrite() || !file.exists() && !file.canWrite()) && !this.getValue("readOnly").toLowerCase().equals("true")) {
                this.isReadOnly = false;
                boolean bl = this.checkAllElementsPresent();
                if (this.refactorProperties || bl) {
                    Object object;
                    int n;
                    this.position = 0;
                    file.delete();
                    Document document = (Document)this.doc.cloneNode(true);
                    this.doc = documentBuilder.newDocument();
                    this.checkAllElementsPresent();
                    NodeList nodeList = this.doc.getElementsByTagName("recentfiles");
                    Element element = (Element)nodeList.item(0);
                    NodeList nodeList2 = document.getElementsByTagName("recentfiles");
                    Element element2 = (Element)nodeList2.item(0);
                    NodeList nodeList3 = element2.getChildNodes();
                    for (n = 0; n != nodeList3.getLength(); ++n) {
                        if (nodeList3.item(n).getNodeName().equals("#text")) continue;
                        object = this.doc.createElement("file");
                        object.setAttribute("name", ((Element)nodeList3.item(n)).getAttribute("name"));
                        element.appendChild((Node)object);
                    }
                    for (n = 0; n != this.properties.length; ++n) {
                        if (this.properties[n].equals("ENDCHILDREN")) continue;
                        object = this.doc.getElementsByTagName(this.properties[n]);
                        Element element3 = (Element)object.item(0);
                        if (element3 == null) {
                            ShowGUIMessage.showGUIMessage("The property " + this.properties[n] + " was either not found in the properties file.", "Property not found.");
                        } else {
                            NodeList nodeList4 = document.getElementsByTagName(this.properties[n]);
                            Element element4 = (Element)nodeList4.item(0);
                            if (element4 != null) {
                                element3.setAttribute("value", element4.getAttribute("value"));
                            }
                        }
                        ++n;
                    }
                    if (!this.isTest) {
                        this.writeDoc();
                    }
                }
                if (!bl) {
                    this.writeDoc();
                }
                file = null;
            } else {
                this.isReadOnly = true;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " generating properties file");
        }
    }

    public void removeRecentDocuments() {
        NodeList nodeList = this.doc.getElementsByTagName("recentfiles");
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("*");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                nodeList.item(0).removeChild(node);
            }
        }
    }

    public String[] getRecentDocuments() {
        String[] stringArray = new String[this.noOfRecentDocs];
        try {
            NodeList nodeList = this.doc.getElementsByTagName("recentfiles");
            ArrayList<String> arrayList = new ArrayList<String>();
            if (nodeList != null && nodeList.getLength() > 0) {
                NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("*");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node = nodeList2.item(i);
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    arrayList.add(namedNodeMap.getNamedItem("name").getNodeValue());
                }
            }
            while (arrayList.size() > this.noOfRecentDocs) {
                arrayList.remove(0);
            }
            Collections.reverse(arrayList);
            stringArray = arrayList.toArray(new String[this.noOfRecentDocs]);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting recent documents");
            return null;
        }
        return stringArray;
    }

    public void addRecentDocument(String string) {
        try {
            Element element = (Element)this.doc.getElementsByTagName("recentfiles").item(0);
            PropertiesFile.checkExists(string, element);
            Element element2 = this.doc.createElement("file");
            element2.setAttribute("name", string);
            element.appendChild(element2);
            this.removeOldFiles(element);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " adding recent document to properties file");
        }
    }

    public void setValue(String string, String string2) {
        try {
            NodeList nodeList = this.doc.getElementsByTagName(string);
            Element element = (Element)nodeList.item(0);
            if (element == null || string2 == null) {
                ShowGUIMessage.showGUIMessage("The property " + string + " was either not found in the properties file or the value " + string2 + " was not set.", "Property not found.");
            } else {
                element.setAttribute("value", string2);
            }
            this.writeDoc();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting value in properties file");
        }
    }

    public String getGUIValue(String string) {
        String string2 = this.getValue(string);
        if (string2.length() == 0) {
            return "false";
        }
        return string2.toLowerCase();
    }

    public NodeList getChildren(String string) {
        return ((Element)this.doc.getElementsByTagName(string).item(0)).getChildNodes();
    }

    public String getValue(String string) {
        NamedNodeMap namedNodeMap = null;
        try {
            NodeList nodeList = this.doc.getElementsByTagName(string);
            Element element = (Element)nodeList.item(0);
            if (element == null) {
                return "";
            }
            namedNodeMap = element.getAttributes();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " generating properties file");
            return "";
        }
        return namedNodeMap.getNamedItem("value").getNodeValue();
    }

    private void removeOldFiles(Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("*");
        while (nodeList.getLength() > this.noOfRecentDocs) {
            element.removeChild(nodeList.item(0));
        }
    }

    private static void checkExists(String string, Element element) throws Exception {
        NodeList nodeList = element.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            String string2 = namedNodeMap.getNamedItem("name").getNodeValue();
            if (!string2.equals(string)) continue;
            element.removeChild(node);
        }
    }

    public void writeDoc() throws Exception {
        if (!this.isReadOnly && !this.getValue("readOnly").toLowerCase().equals("true")) {
            InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            StreamResult streamResult = new StreamResult(this.configFile);
            StreamSource streamSource = new StreamSource(inputStream);
            DOMSource dOMSource = new DOMSource(this.doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            transformer.transform(dOMSource, streamResult);
            transformer = null;
            inputStream.close();
            if (streamSource != null) {
                streamSource.getInputStream().close();
            }
            streamSource = null;
            streamResult = null;
            dOMSource = null;
        }
    }

    public void dispose() {
        this.doc = null;
        this.properties = null;
        this.configFile = null;
    }

    private boolean checkAllElementsPresent() throws Exception {
        Object object;
        boolean bl = true;
        NodeList nodeList = this.doc.getElementsByTagName("*");
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(nodeList.item(i).getNodeName());
        }
        Element element = null;
        if (arrayList.contains("properties")) {
            element = (Element)this.doc.getElementsByTagName("properties").item(0);
        } else {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            element = this.doc.createElement("properties");
            this.doc.appendChild(element);
            nodeList = this.doc.getElementsByTagName("*");
            arrayList = new ArrayList(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i).getNodeName());
            }
            bl = false;
        }
        if (!arrayList.contains("recentfiles")) {
            object = this.doc.createElement("recentfiles");
            element.appendChild((Node)object);
            bl = false;
        }
        bl = this.addProperties(arrayList, element);
        return bl;
    }

    private boolean addMenuElement(List list, Element element) {
        boolean bl = true;
        if (!list.contains(this.properties[this.position])) {
            Element element2 = this.doc.createElement(this.properties[this.position]);
            ++this.position;
            element2.setAttribute("value", this.properties[this.position]);
            element.appendChild(element2);
            ++this.position;
            this.addProperties(list, element2);
            bl = false;
        } else {
            Element element3 = (Element)this.doc.getElementsByTagName(this.properties[this.position]).item(0);
            ++this.position;
            ++this.position;
            this.addProperties(list, element3);
        }
        return bl;
    }

    private boolean addChildElements(List list, Element element) {
        boolean bl = true;
        if (!this.properties[this.position].equals("ENDCHILDREN")) {
            if (!list.contains(this.properties[this.position])) {
                Element element2 = this.doc.createElement(this.properties[this.position]);
                ++this.position;
                element2.setAttribute("value", this.properties[this.position]);
                element.appendChild(element2);
                bl = false;
            } else {
                if (this.properties[this.position].equals("currentversion")) {
                    NodeList nodeList = this.doc.getElementsByTagName(this.properties[this.position]);
                    Element element3 = (Element)nodeList.item(0);
                    if (element3 == null) {
                        ShowGUIMessage.showGUIMessage("The property " + this.properties[this.position] + " was either not found in the properties file.", "Property not found.");
                    } else if (!this.properties[this.position + 1].equals("4.37b36")) {
                        float f;
                        float f2 = Float.parseFloat("4.37b36-OS".substring(0, 4));
                        String string = "0";
                        String string2 = element3.getAttribute("value");
                        if (string2.length() > 3) {
                            string = string2.substring(0, 4);
                        }
                        if (f2 > (f = Float.parseFloat(string))) {
                            element3.setAttribute("value", "4.37b36-OS");
                            this.refactorProperties = true;
                        }
                    }
                }
                ++this.position;
            }
        } else {
            this.endMenu = true;
        }
        ++this.position;
        return bl;
    }

    private boolean addProperties(List list, Element element) {
        boolean bl = true;
        while (this.position < this.properties.length) {
            boolean bl2 = true;
            if (this.properties[this.position].endsWith("Menu")) {
                bl2 = this.addMenuElement(list, element);
            } else {
                bl2 = this.addChildElements(list, element);
                if (this.endMenu) {
                    this.endMenu = false;
                    return bl;
                }
            }
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public int getNoRecentDocumentsToDisplay() {
        return this.noOfRecentDocs;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String string) {
        this.loadProperties(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadProperties(String string) {
        if (string.startsWith("jar:")) {
            string = string.substring(4);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) throw new RuntimeException();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                File file = File.createTempFile("config", ".xml", new File(ObjectStore.temp_dir));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                while (bufferedReader.ready()) {
                    outputStreamWriter.write(bufferedReader.read());
                }
                inputStream.close();
                bufferedReader.close();
                inputStreamReader.close();
                outputStreamWriter.flush();
                fileOutputStream.flush();
                outputStreamWriter.close();
                fileOutputStream.close();
                this.configFile = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            File file = new File(string);
            if (file.canWrite() && !this.getValue("readOnly").toLowerCase().equals("true")) {
                this.isReadOnly = false;
                if (!file.exists() && (file.exists() || file.canWrite())) throw new RuntimeException();
                this.configFile = string;
            } else {
                this.isReadOnly = true;
            }
        }
        this.loadProperties();
    }
}

