/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jpedal.fonts.JFRFont;

public class JFRGlyphVector
extends GlyphVector {
    boolean debug = false;
    boolean useSuper = false;
    JFRFont f;
    FontRenderContext fontContext;
    char[] chars;

    public JFRGlyphVector() {
        if (this.debug) {
            System.out.println("JFRGlyphVector()");
            System.out.println();
        }
    }

    public JFRGlyphVector(JFRFont jFRFont, FontRenderContext fontRenderContext, char[] cArray) {
        if (this.debug) {
            System.out.println("JFRGlyphVector(JFRFont font, FontRenderContext frc, char[] chars)");
            System.out.println("font = " + jFRFont);
            System.out.println("frc = " + fontRenderContext);
            for (int i = 0; i != cArray.length; ++i) {
                System.out.println("chars[" + i + "]=" + cArray[i]);
            }
            System.out.println();
        }
        this.fontContext = fontRenderContext;
        this.chars = cArray;
        this.f = jFRFont;
    }

    public boolean equals(GlyphVector glyphVector) {
        boolean bl;
        if (this.debug) {
            System.out.println("equals(GlyphVector set)");
            System.out.println("set = " + glyphVector);
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.equals(glyphVector);
        }
        return false;
    }

    public Font getFont() {
        if (this.debug) {
            System.out.println("getFont()");
            System.out.println();
        }
        return this.f;
    }

    public int getGlyphCharIndex(int n) {
        boolean bl;
        if (this.debug) {
            System.out.println("getGlyphCharIndex(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.getGlyphCharIndex(n);
        }
        return 0;
    }

    public int[] getGlyphCharIndices(int n, int n2, int[] nArray) {
        int n3;
        if (this.debug) {
            System.out.println("getGlyphCharIndices(int beginGlyphIndex, int numEntries, int[] codeReturn)");
            System.out.println("beginGlyphIndex = " + n);
            System.out.println("numEntries = " + n2);
            for (n3 = 0; n3 != nArray.length; ++n3) {
                System.out.println("codeReturn[" + n3 + "]=" + nArray[n3]);
            }
            System.out.println();
        }
        if ((n3 = this.useSuper) != 0) {
            return super.getGlyphCharIndices(n, n2, nArray);
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            nArray[n4] = this.getGlyphCharIndex(n5);
            ++n4;
            ++n5;
        }
        return nArray;
    }

    public Shape getGlyphOutline(int n, float f, float f2) {
        boolean bl;
        if (this.debug) {
            System.out.println("getGlyphOutline(int glyphIndex, float x, float y)");
            System.out.println("glyphIndex = " + n);
            System.out.println("x = " + f);
            System.out.println("y = " + f2);
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.getGlyphOutline(n, f, f2);
        }
        Shape shape = this.getGlyphOutline(n);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        return affineTransform.createTransformedShape(shape);
    }

    public Rectangle getGlyphPixelBounds(int n, FontRenderContext fontRenderContext, float f, float f2) {
        boolean bl;
        if (this.debug) {
            System.out.println("getGlyphPixelBounds(int index, FontRenderContext renderFRC, float x, float y)");
            System.out.println("index = " + n);
            System.out.println("renderFRC = " + fontRenderContext);
            System.out.println("x = " + f);
            System.out.println("y = " + f2);
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.getGlyphPixelBounds(n, fontRenderContext, f, f2);
        }
        Rectangle2D rectangle2D = this.getGlyphVisualBounds(n).getBounds2D();
        int n2 = (int)Math.floor(rectangle2D.getX() + (double)f);
        int n3 = (int)Math.floor(rectangle2D.getY() + (double)f2);
        int n4 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f);
        int n5 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f2);
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    public int getLayoutFlags() {
        boolean bl;
        if (this.debug) {
            System.out.println("getLayoutFlags()");
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.getLayoutFlags();
        }
        return 0;
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        boolean bl;
        if (this.debug) {
            System.out.println("getPixelBounds(FontRenderContext renderFRC, float x, float y)");
            System.out.println("renderFRC = " + fontRenderContext);
            System.out.println("x = " + f);
            System.out.println("y = " + f2);
            System.out.println();
        }
        if (bl = this.useSuper) {
            return super.getPixelBounds(fontRenderContext, f, f2);
        }
        Rectangle2D rectangle2D = this.getVisualBounds();
        int n = (int)Math.floor(rectangle2D.getX() + (double)f);
        int n2 = (int)Math.floor(rectangle2D.getY() + (double)f2);
        int n3 = (int)Math.ceil(rectangle2D.getMaxX() + (double)f);
        int n4 = (int)Math.ceil(rectangle2D.getMaxY() + (double)f2);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public FontRenderContext getFontRenderContext() {
        if (this.debug) {
            System.out.println("getFontRenderContext()");
            System.out.println();
        }
        return this.fontContext;
    }

    public int getGlyphCode(int n) {
        if (this.debug) {
            System.out.println("getGlyphCode(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return 0;
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int n3;
        if (this.debug) {
            System.out.println("getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn)");
            System.out.println("beginGlyphIndex = " + n);
            System.out.println("numEntries = " + n2);
            for (n3 = 0; n3 != nArray.length; ++n3) {
                System.out.println("codeReturn[" + n3 + "] = " + nArray[n3]);
            }
            System.out.println();
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.getGlyphCode(n4);
            ++n3;
            ++n4;
        }
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (this.debug) {
            System.out.println("getGlyphJustificationInfo(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.debug) {
            System.out.println("getGlyphLogicalBounds(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        if (this.debug) {
            System.out.println("getGlyphMetrics(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public Shape getGlyphOutline(int n) {
        if (this.debug) {
            System.out.println("getGlyphOutline(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public Point2D getGlyphPosition(int n) {
        if (this.debug) {
            System.out.println("getGlyphPosition(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (this.debug) {
            System.out.println("getGlyphPositions(int beginGlyphIndex, int numEntries,float[] positionReturn)");
            System.out.println("beginGlyphIndex = " + n);
            System.out.println("numEntries = " + n2);
            for (int i = 0; i != fArray.length; ++i) {
                System.out.println("positionReturn[" + i + "] = " + fArray[i]);
            }
            System.out.println();
        }
        return null;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (this.debug) {
            System.out.println("getGlyphTransform(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return null;
    }

    public Shape getGlyphVisualBounds(int n) {
        if (this.debug) {
            System.out.println("getGlyphVisualBounds(int glyphIndex)");
            System.out.println("glyphIndex = " + n);
            System.out.println();
        }
        return new Rectangle(0, 0, 15, 15);
    }

    public Rectangle2D getLogicalBounds() {
        if (this.debug) {
            System.out.println("getLogicalBounds()");
            System.out.println();
        }
        return null;
    }

    public int getNumGlyphs() {
        if (this.debug) {
            System.out.println("getNumGlyphs()");
            System.out.println();
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.debug) {
            System.out.println("getOutline()");
            System.out.println();
        }
        return null;
    }

    public Shape getOutline(float f, float f2) {
        if (this.debug) {
            System.out.println("getOutline(float x, float y)");
            System.out.println("x = " + f);
            System.out.println("y = " + f2);
            System.out.println();
        }
        return null;
    }

    public Rectangle2D getVisualBounds() {
        if (this.debug) {
            System.out.println("getVisualBounds()");
            System.out.println();
        }
        return null;
    }

    public void performDefaultLayout() {
        if (this.debug) {
            System.out.println("performDefaultLayout()");
            System.out.println();
        }
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        if (this.debug) {
            System.out.println("setGlyphPosition(int glyphIndex, Point2D newPos)");
            System.out.println("glyphIndex = " + n);
            System.out.println("newPos = " + point2D);
            System.out.println();
        }
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (this.debug) {
            System.out.println("setGlyphTransform(int glyphIndex, AffineTransform newTX)");
            System.out.println("glyphIndex = " + n);
            System.out.println("newTX = " + affineTransform);
            System.out.println();
        }
    }
}

