/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.actions.ActionFactory;
import org.jpedal.objects.acroforms.actions.SwingDownIconListener;
import org.jpedal.objects.acroforms.actions.privateclasses.FieldsHideObject;
import org.jpedal.objects.acroforms.gui.Summary;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SwingActionFactory
implements ActionFactory {
    AcroRenderer acrorend;
    PdfDecoder decode_pdf = null;

    public void showMessageDialog(String string) {
        JOptionPane.showMessageDialog(this.decode_pdf, string);
    }

    public char getKeyPressed(Object object) {
        try {
            ComponentEvent componentEvent = (ComponentEvent)object;
            if (componentEvent instanceof KeyEvent) {
                return ((KeyEvent)componentEvent).getKeyChar();
            }
            return ' ';
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
            return ' ';
        }
    }

    public void setFieldVisibility(FieldsHideObject fieldsHideObject) {
        boolean[] blArray;
        String[] stringArray = fieldsHideObject.getFieldArray();
        if (stringArray.length != (blArray = fieldsHideObject.getHideArray()).length) {
            LogWriter.writeFormLog("{custommouselistener} number of fields and nuber of hides or not the same", false);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.acrorend.getCompData().hideComp(stringArray[i], !blArray[i]);
        }
    }

    public void print() {
        if (JOptionPane.showConfirmDialog(this.decode_pdf, Messages.getMessage("PdfViewerPrinting.ConfirmPrint"), Messages.getMessage("PdfViewerPrint.Printing"), 0) == 0) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            int n = this.decode_pdf.getPDFWidth() < this.decode_pdf.getPDFHeight() ? 1 : 0;
            pageFormat.setOrientation(n);
            Paper paper = new Paper();
            paper.setSize(595.0, 842.0);
            paper.setImageableArea(43.0, 43.0, 509.0, 756.0);
            pageFormat.setPaper(paper);
            printerJob.setPrintable(this.decode_pdf, pageFormat);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    public void reset(String[] stringArray) {
        this.acrorend.getCompData().reset(stringArray);
        this.resetComp(stringArray);
    }

    private void resetComp(String[] stringArray) {
        int n;
        Component[] componentArray;
        String[] stringArray2 = this.acrorend.getCompData().getDefaultValues();
        if (stringArray == null) {
            componentArray = (Component[])this.acrorend.getComponentsByName(null);
        } else {
            int n2;
            Component[][] componentArrayArray = new Component[stringArray.length][];
            int n3 = 0;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                componentArrayArray[n2] = (Component[])this.acrorend.getComponentsByName(stringArray[n2]);
                n3 += componentArrayArray[n2].length;
            }
            componentArray = new Component[n3];
            n2 = 0;
            for (int i = 0; i < componentArrayArray.length; ++i) {
                for (n = 0; n < componentArrayArray[i].length; ++n) {
                    componentArray[n2++] = componentArrayArray[i][n];
                }
            }
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            String string = FormUtils.removeStateToCheck(componentArray[i].getName(), false);
            String string2 = this.acrorend.getCompData().getnameToRef(string);
            String string3 = FormUtils.removeStateToCheck(componentArray[i].getName(), true);
            n = stringArray == null ? i : this.acrorend.getCompData().getIndexFromName(string);
            if (componentArray[i] instanceof JToggleButton) {
                Object object;
                JToggleButton jToggleButton = (JToggleButton)componentArray[i];
                if (stringArray2[n] == null && jToggleButton.isSelected()) {
                    jToggleButton.setSelected(false);
                    object = jToggleButton.getPressedIcon();
                    if (object != null && object instanceof FixImageIcon) {
                        ((FixImageIcon)object).swapImage(false);
                    }
                } else {
                    Icon icon;
                    object = string3;
                    int n4 = ((String)object).indexOf("-(");
                    if (n4 != -1) {
                        object = ((String)object).substring(n4 + 2, ((String)object).length() - 1);
                    }
                    if (((String)object).equals(stringArray2[n]) && !jToggleButton.isSelected()) {
                        jToggleButton.setSelected(true);
                        icon = jToggleButton.getPressedIcon();
                        if (icon != null && icon instanceof FixImageIcon) {
                            ((FixImageIcon)icon).swapImage(true);
                        }
                    } else if (jToggleButton.isSelected()) {
                        jToggleButton.setSelected(false);
                        icon = jToggleButton.getPressedIcon();
                        if (icon != null && icon instanceof FixImageIcon) {
                            ((FixImageIcon)icon).swapImage(false);
                        }
                    }
                }
            } else if (componentArray[i] instanceof JTextComponent) {
                boolean bl = true;
                boolean bl2 = true;
                this.acrorend.getCompData().setUnformattedValue(string2, stringArray2[n]);
                bl2 = false;
                this.acrorend.getCompData().setLastValidValue(string2, stringArray2[n]);
                bl = false;
                this.acrorend.getCompData().setValue(string2, stringArray2[n], bl, bl2);
                if (bl2) {
                    this.acrorend.getCompData().setValue(string2, stringArray2[n], bl, bl2);
                }
            } else if (componentArray[i] instanceof JComboBox) {
                ((JComboBox)componentArray[i]).setSelectedItem(stringArray2[n]);
            } else if (componentArray[i] instanceof JList) {
                ((JList)componentArray[i]).setSelectedValue(stringArray2[n], true);
            }
            this.acrorend.getCompData().flagLastUsedValue(componentArray[i], (FormObject)this.acrorend.getFormDataAsObject(string2));
            componentArray[i].repaint();
        }
        this.acrorend.getCompData().syncAllValues();
    }

    public void setPDF(PdfDecoder pdfDecoder, AcroRenderer acroRenderer) {
        this.decode_pdf = pdfDecoder;
        this.acrorend = acroRenderer;
    }

    public void setCursor(int n) {
        if (this.decode_pdf != null) {
            if (n == 4) {
                this.decode_pdf.setCursor(new Cursor(12));
            } else if (n == 5) {
                this.decode_pdf.setCursor(new Cursor(0));
            }
        }
    }

    public void showSig(PdfObject pdfObject) {
        JDialog jDialog = new JDialog((Frame)null, "Signature Properties", true);
        Summary summary = new Summary(jDialog, pdfObject);
        summary.setValues(pdfObject.getTextStreamValue(506543413), pdfObject.getTextStreamValue(826499443), pdfObject.getTextStreamValue(29), pdfObject.getTextStreamValue(1618506351));
        jDialog.getContentPane().add(summary);
        jDialog.setSize(550, 220);
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void submitURL(String[] var1_1, boolean var2_2, String var3_3) {
        if (var3_3 != null) {
            var4_4 = new Component[]{};
            var5_5 = new String[]{};
            if (var1_1 != null) {
                if (var2_2) {
                    try {
                        var6_6 /* !! */  = this.acrorend.getComponentNameList();
                        if (var6_6 /* !! */  == null) ** GOTO lbl18
                        for (var7_8 = 0; var7_8 < var1_1.length; ++var7_8) {
                            var6_6 /* !! */ .remove(var1_1[var7_8]);
                        }
                    }
                    catch (PdfException var6_7) {
                        LogWriter.writeFormLog("SwingFormFactory.setupMouseListener() get component name list exception", false);
                    }
                } else {
                    var5_5 = var1_1;
                }
lbl18:
                // 6 sources

                for (var8_11 = 0; var8_11 < var5_5.length; ++var8_11) {
                    var6_6 /* !! */  = (Component[])this.acrorend.getComponentsByName(var5_5[var8_11]);
                    if (var6_6 /* !! */  == null) continue;
                    var7_9 = new Component[var4_4.length + var6_6 /* !! */ .length];
                    if (var6_6 /* !! */ .length > 1) {
                        LogWriter.writeFormLog("(internal only) SubmitForm multipul components with same name", false);
                    }
                    var9_12 = 0;
                    while (var8_11 < var7_9.length) {
                        if (var9_12 < var4_4.length) {
                            var7_9[var9_12] = var4_4[var9_12];
                        } else if (var9_12 - var4_4.length < var6_6 /* !! */ .length) {
                            var7_9[var9_12] = var6_6 /* !! */ [var9_12 - var4_4.length];
                        }
                        ++var9_12;
                    }
                    var4_4 = var7_9;
                }
            } else {
                var4_4 = (Component[])this.acrorend.getComponentsByName(null);
            }
            var6_6 /* !! */  = "";
            for (var7_8 = 0; var7_8 < var4_4.length; ++var7_8) {
                if (var4_4[var7_8] instanceof JTextComponent) {
                    var6_6 /* !! */  = (String)var6_6 /* !! */  + ((JTextComponent)var4_4[var7_8]).getText();
                    continue;
                }
                if (var4_4[var7_8] instanceof AbstractButton) {
                    var6_6 /* !! */  = (String)var6_6 /* !! */  + ((AbstractButton)var4_4[var7_8]).getText();
                    continue;
                }
                if (var4_4[var7_8] == null) continue;
                LogWriter.writeFormLog("(internal only) SubmitForm field form type not accounted for", false);
            }
            try {
                BrowserLauncher.openURL(var3_3 + "?en&q=" + (String)var6_6 /* !! */ );
            }
            catch (IOException var7_10) {
                this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                var7_10.printStackTrace();
            }
        }
    }

    public Object getHoverCursor() {
        return new MouseListener(){

            public void mouseEntered(MouseEvent mouseEvent) {
                SwingActionFactory.this.setCursor(4);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SwingActionFactory.this.setCursor(5);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
    }

    public void popup(Object object, FormObject formObject, PdfObjectReader pdfObjectReader) {
        if (((MouseEvent)object).getClickCount() == 2) {
            this.acrorend.getCompData().popup(formObject, pdfObjectReader);
            ((JButton)((MouseEvent)object).getSource()).setFocusable(false);
        }
    }

    public Object getChangingDownIconListener(Object object, Object object2, int n) {
        return new SwingDownIconListener();
    }
}

