/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;
import org.jpedal.objects.raw.FormObject;

public class FixImageIcon
extends ImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    private int iconWidth = -1;
    private int iconHeight = -1;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private BufferedImage imageSelected = null;
    private BufferedImage imageUnselected = null;
    private int iconRotation = 0;
    private int iconOpp = 180;
    private int pageRotate = 0;
    private boolean displaySingle = false;

    public FixImageIcon(BufferedImage bufferedImage, int n) {
        this.imageSelected = bufferedImage != null ? bufferedImage : FormObject.getOpaqueImage();
        this.selected = -1;
        this.iconRotation = n;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }

    public FixImageIcon(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        this.imageSelected = bufferedImage;
        this.imageUnselected = bufferedImage2;
        this.selected = n2;
        this.iconRotation = n;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }

    public void setAttributes(int n, int n2, int n3, boolean bl) {
        int n4 = this.validateRotationValue(n3 - this.iconRotation);
        this.pageRotate = n3;
        if (n4 == this.iconRotation || n4 == this.iconOpp) {
            this.iconWidth = n;
            this.iconHeight = n2;
        } else {
            this.iconWidth = n2;
            this.iconHeight = n;
        }
        this.displaySingle = bl;
    }

    private int validateRotationValue(int n) {
        if ((n %= 360) < 0) {
            n += 360;
        }
        return n;
    }

    public int getIconHeight() {
        if (this.iconHeight == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getHeight(null);
        }
        return this.iconHeight;
    }

    public int getIconWidth() {
        if (this.iconWidth == -1) {
            Image image = this.getImage();
            if (image == null) {
                return -1;
            }
            return image.getWidth(null);
        }
        return this.iconWidth;
    }

    public Image getImage() {
        BufferedImage bufferedImage;
        switch (this.selected) {
            case 0: {
                bufferedImage = this.imageUnselected;
                break;
            }
            default: {
                bufferedImage = this.imageSelected;
            }
        }
        return bufferedImage;
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage == null) {
            return;
        }
        if (component.isEnabled()) {
            graphics.setColor(component.getBackground());
        } else {
            graphics.setColor(Color.gray);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int n3 = this.iconWidth;
            int n4 = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                n3 = this.iconHeight;
                n4 = this.iconWidth;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            n7 = this.displaySingle ? this.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate;
            if (n7 == 270) {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-n3, 0);
                graphics2D.drawImage(bufferedImage, -n5, n6, n3, n4, null);
            } else if (n7 == 90) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -n4);
                graphics2D.drawImage(bufferedImage, n5, -n6, n3, n4, null);
            } else if (n7 == 180) {
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-n3, -n4);
                graphics2D.drawImage(bufferedImage, -n5, -n6, n3, n4, null);
            } else {
                graphics2D.drawImage(bufferedImage, n5, n6, n3, n4, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.translate(-n, -n2);
    }

    public void swapImage(boolean bl) {
        if (this.selected == -1) {
            return;
        }
        this.selected = bl ? 1 : 0;
    }

    public void setPrinting(boolean bl, int n) {
    }

    public void setImageIcon(BufferedImage bufferedImage) {
        this.imageSelected = bufferedImage;
        this.selected = -1;
        this.iconRotation = 0;
        this.iconOpp = this.iconRotation - 180;
        if (this.iconOpp < 0) {
            this.iconOpp += 360;
        }
    }
}

