/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.raster.wcs.io.FMapWCSParameter;
import org.gvsig.raster.wcs.io.WCSLayerNode;
import org.gvsig.remoteclient.exceptions.ServerErrorException;
import org.gvsig.remoteclient.exceptions.WCSException;
import org.gvsig.remoteclient.utils.BoundaryBox;
import org.gvsig.remoteclient.wcs.WCSClient;
import org.gvsig.remoteclient.wcs.WCSCoverage;
import org.gvsig.remoteclient.wcs.WCSStatus;

public class WCSConnector {
    private WCSClient client;
    private Hashtable<String, WCSLayerNode> coverages;
    private WCSLayerNode[] layerList;

    public WCSConnector(URL url) throws ConnectException, IOException {
        this.client = new WCSClient(url.toString());
    }

    public String getName() {
        return "WCSDriver";
    }

    public void setHost(String host) throws IOException {
        this.client = new WCSClient(host);
    }

    public String getLabel() {
        return this.client.getServiceTitle();
    }

    public String getVersion() {
        return this.client.getVersion();
    }

    public String getDescription() {
        return this.client.getDescription();
    }

    public WCSLayerNode getLayer(String layerName) {
        this.getLayerList();
        return this.getCoverages().get(layerName);
    }

    private Hashtable<String, WCSLayerNode> getCoverages() {
        if (this.coverages == null || this.coverages.isEmpty()) {
            this.getLayerList();
        }
        return this.coverages;
    }

    public WCSLayerNode[] getLayerList() {
        if (this.coverages == null || this.coverages.isEmpty()) {
            this.coverages = new Hashtable();
            Hashtable wcsCoverages = this.client.getCoverageList();
            int sz = wcsCoverages.size();
            WCSCoverage[] coverageList = new WCSCoverage[sz];
            Iterator it = wcsCoverages.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                coverageList[i] = (WCSCoverage)wcsCoverages.get(it.next());
                ++i;
            }
            this.layerList = new WCSLayerNode[sz];
            for (int j = 0; j < this.layerList.length; ++j) {
                WCSLayerNode lyr = new WCSLayerNode();
                WCSCoverage cov = coverageList[j];
                lyr.setName(cov.getName());
                lyr.setTitle(cov.getTitle());
                lyr.setDescription(cov.getAbstract());
                lyr.addAllSrs(cov.getAllSrs());
                lyr.setNativeSRS(cov.getNativeSRS());
                Set k = cov.getBBoxes().keySet();
                if (!k.isEmpty()) {
                    for (String srs : k) {
                        BoundaryBox bBox = cov.getBbox(srs);
                        Rectangle2D.Double r = new Rectangle2D.Double(bBox.getXmin(), bBox.getYmin(), bBox.getXmax() - bBox.getXmin(), bBox.getYmax() - bBox.getYmin());
                        lyr.addExtent(srs, r);
                    }
                }
                lyr.setFormats(cov.getFormats());
                lyr.setTimePositions(cov.getTimePositions());
                WCSCoverage.RectifiedGrid rf = cov.getRectifiedGrid();
                if (rf != null) {
                    int w = rf.getHighGridEnvelopLimits()[0][0] - rf.getLowGridEnvelopLimits()[0][0];
                    int h = rf.getHighGridEnvelopLimits()[0][1] - rf.getLowGridEnvelopLimits()[0][1];
                    lyr.setWidth(w);
                    lyr.setHeight(h);
                }
                lyr.setMaxRes(new Point2D.Double(cov.getResX(), cov.getResY()));
                lyr.setInterpolationMethods(cov.getInterpolationMethods());
                k = cov.axisPool.keySet();
                if (!k.isEmpty()) {
                    it = k.iterator();
                    while (it.hasNext()) {
                        WCSCoverage.AxisDescription ad = (WCSCoverage.AxisDescription)cov.axisPool.get(it.next());
                        FMapWCSParameter p = new FMapWCSParameter();
                        p.setName(ad.getName());
                        p.setLabel(ad.getLabel());
                        p.setType(ad.getInterval() == null ? 0 : 1);
                        if (p.getType() == 0) {
                            p.setValueList(ad.getSingleValues());
                        }
                        lyr.addParameter(p);
                    }
                }
                this.layerList[j] = lyr;
                this.coverages.put(lyr.getName(), lyr);
            }
        }
        return this.layerList;
    }

    public boolean connect(boolean override, ICancellable cancel) throws IOException {
        this.coverages = null;
        this.setHost(this.client.getHost());
        return this.client.connect(override, cancel);
    }

    public void close() {
    }

    public String getLabel(String coverageName) {
        return this.client.getLabel(coverageName);
    }

    public Rectangle2D getFullExtent(String coverageName, String srs) throws IOException {
        return this.client.getExtent(coverageName, srs);
    }

    public Point2D getMaxResolution(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getMaxRes();
        }
        return null;
    }

    public int getWidth(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getWidth();
        }
        return 0;
    }

    public int getHeight(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getHeight();
        }
        return 0;
    }

    public ArrayList getSRSs(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getSRSs();
        }
        return null;
    }

    public String getCoverageDescription(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getDescription();
        }
        return null;
    }

    public ArrayList getTimes(String coverageName) {
        if (this.getCoverages().containsKey(coverageName)) {
            return this.getCoverages().get(coverageName).getTimePositions();
        }
        return null;
    }

    public File getCoverage(WCSStatus status, ICancellable cancel) throws RemoteServiceException {
        try {
            return this.client.getCoverage(status, cancel);
        }
        catch (ServerErrorException e) {
            throw new RemoteServiceException(this.getName(), (Throwable)e);
        }
        catch (WCSException e) {
            throw new RemoteServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void getCoverageURL(WCSStatus status, ICancellable cancel, File file) throws RemoteServiceException {
        try {
            URL url = this.client.getCoverageURL(status, cancel);
            this.downloadFile(url, file, cancel);
            String exceptionMessage = this.client.getExceptionMessage(file);
            if (exceptionMessage != null) {
                throw new RemoteServiceException(exceptionMessage);
            }
        }
        catch (IOException e) {
            throw new RemoteServiceException("WCS: error downloading the file. File:" + file.getAbsolutePath() + "...." + e.getMessage(), (Throwable)e);
        }
        catch (ServerErrorException e) {
            throw new RemoteServiceException("WCS Unexpected server error." + e.getMessage(), (Throwable)e);
        }
    }

    public void downloadFile(URL url, File dstFile, ICancellable cancel) throws IOException {
        Preferences prefs = Preferences.userRoot().node("gvsig.downloader");
        int timeout = prefs.getInt("timeout", 60000);
        OutputStreamWriter os = null;
        HttpURLConnection connection = null;
        if (url.getProtocol().equals("https")) {
            try {
                this.disableHttsValidation();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(timeout);
        DataInputStream is = new DataInputStream(url.openStream());
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dstFile)));
        byte[] buffer = new byte[4096];
        long readed = 0L;
        int i = is.read(buffer);
        while (i > 0) {
            dos.write(buffer, 0, i);
            readed += (long)i;
            if (cancel != null && cancel.isCanceled()) {
                return;
            }
            i = is.read(buffer);
        }
        if (os != null) {
            os.close();
        }
        dos.close();
        is.close();
        is = null;
        dos = null;
    }

    private void disableHttsValidation() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }
}

