/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.io;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.wcs.io.WCSDataParameters;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;

public class WCSDataParametersImpl
extends AbstractRasterDataParameters
implements WCSDataParameters {
    private static final String FIELD_TIME = "time";
    private static final String FIELD_MAXRES = "maxres";
    private static final String FIELD_PARAM = "parameter";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SRSSTR = "srsstr";
    private static final String FIELD_EXTENT = "extent";
    private static final String FIELD_WIDTH = "width";
    private static final String FIELD_HEIGHT = "height";
    private static final String FIELD_OVERRIDE = "override";
    private static final String FIELD_ONLINERESOURC = "onlineresources";
    private static final String FIELD_DEPTH = "depth";
    private static final String FIELD_DELETECACHE = "deletecache";
    private DelegatedDynObject delegatedDynObject = null;
    protected static DynClass DYNCLASS = null;
    private ICancellable cancel = null;

    public WCSDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(WCSDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WCSDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WCSDataParametersImpl.class, "WCSDataParameters_Persistent", "WCS DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldObject(FIELD_MAXRES).setClassOfValue(Point2D.class).setMandatory(false);
        definition.addDynFieldString(FIELD_PARAM).setMandatory(false);
        definition.addDynFieldString(FIELD_DEPTH).setMandatory(false);
        definition.addDynFieldString(FIELD_TIME).setMandatory(false);
        definition.addDynFieldObject(FIELD_EXTENT).setDescription("Bounding box").setClassOfValue(Rectangle2D.class).setMandatory(false);
        definition.addDynFieldInt(FIELD_WIDTH).setDescription("Width").setMandatory(false);
        definition.addDynFieldInt(FIELD_HEIGHT).setDescription("Height").setMandatory(false);
        definition.addDynFieldString(FIELD_FORMAT).setDescription("Format").setMandatory(false);
        definition.addDynFieldString(FIELD_NAME).setDescription("Name").setMandatory(false);
        definition.addDynFieldString(FIELD_SRSSTR).setDescription("String that represents the SRS").setMandatory(false);
        definition.addDynFieldBoolean(FIELD_OVERRIDE).setDescription("Override a host capabilities").setMandatory(false);
        definition.addDynFieldMap(FIELD_ONLINERESOURC).setDescription("online resources").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldBoolean(FIELD_DELETECACHE).setDescription("Flag to delete cache the next request").setMandatory(false);
        return definition;
    }

    @Override
    public void setMaxResolution(Point2D res) {
        this.setDynValue(FIELD_MAXRES, res);
    }

    @Override
    public Point2D getMaxResolution() {
        return (Point2D)this.getDynValue(FIELD_MAXRES);
    }

    @Override
    public void setParameter(String parameter) {
        this.setDynValue(FIELD_PARAM, parameter);
    }

    @Override
    public String getParameter() {
        return (String)this.getDynValue(FIELD_PARAM);
    }

    @Override
    public String getFormat() {
        return (String)this.getDynValue(FIELD_FORMAT);
    }

    @Override
    public void setFormat(String format) {
        this.setDynValue(FIELD_FORMAT, format);
    }

    @Override
    public String getSRSCode() {
        return (String)this.getDynValue(FIELD_SRSSTR);
    }

    @Override
    public void setSRS(String m_srs) {
        this.setDynValue(FIELD_SRSSTR, m_srs);
        if (m_srs.equals("CRS:84")) {
            m_srs = "EPSG:4326";
        }
        this.setSRS(CRSFactory.getCRS((String)m_srs));
    }

    public void setSRSID(String srsid) {
        if (srsid == null) {
            this.setDynValue(FIELD_SRSSTR, null);
        } else {
            this.setDynValue(FIELD_SRSSTR, CRSFactory.getCRS((String)srsid));
        }
    }

    @Override
    public String getCoverageName() {
        return (String)this.getDynValue(FIELD_NAME);
    }

    @Override
    public void setCoverageName(String name) {
        this.setDynValue(FIELD_NAME, name);
    }

    @Override
    public void setCancellable(ICancellable cancel) {
        this.cancel = cancel;
    }

    public ICancellable getCancellable() {
        return this.cancel;
    }

    @Override
    public void setExtent(Rectangle2D bBox) {
        this.setDynValue(FIELD_EXTENT, bBox);
    }

    public void setWidth(int w) {
        this.setDynValue(FIELD_WIDTH, new Integer(w));
    }

    public void setHeight(int h) {
        this.setDynValue(FIELD_HEIGHT, new Integer(h));
    }

    @Override
    public Rectangle2D getExtent() {
        return (Rectangle2D)this.getDynValue(FIELD_EXTENT);
    }

    @Override
    public int getWidth() {
        Integer b = (Integer)this.getDynValue(FIELD_WIDTH);
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        Integer b = (Integer)this.getDynValue(FIELD_HEIGHT);
        if (b != null) {
            return b;
        }
        return 0;
    }

    public String getDataStoreName() {
        return WCSProvider.NAME;
    }

    public String getDescription() {
        return WCSProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return WCSProvider.NAME;
    }

    public boolean isValid() {
        return this.getURI() != null;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public WCSDataParametersImpl clone() {
        WCSDataParametersImpl p = new WCSDataParametersImpl();
        p.setFormat(this.getFormat());
        p.setHeight(this.getHeight());
        p.setWidth(this.getWidth());
        p.setExtent(this.getExtent());
        p.setCoverageName(this.getCoverageName());
        p.setOverrideHost(this.isOverridingHost());
        p.setSRS(this.getSRS());
        p.setSRS(this.getSRSCode());
        p.setURI(this.getURI());
        p.setCancellable(this.getCancellable());
        p.setOnlineResources((Hashtable)this.getDynValue(FIELD_ONLINERESOURC));
        p.setTime(this.getTime());
        return p;
    }

    public void assignFields(RasterDataParameters par, RasterDataServerExplorer explorer) {
        super.assignFields(par, explorer);
        WCSDataParametersImpl p = null;
        if (!(par instanceof WCSDataParametersImpl)) {
            return;
        }
        p = (WCSDataParametersImpl)par;
        this.setFormat(p.getFormat());
        this.setHeight(p.getHeight());
        this.setWidth(p.getWidth());
        this.setExtent(p.getExtent());
        this.setCoverageName(p.getCoverageName());
        this.setOverrideHost(p.isOverridingHost());
        this.setSRS(p.getSRS());
        this.setSRS(p.getSRSCode());
        this.setURI(p.getURI());
        this.setCancellable(p.getCancellable());
        this.setOnlineResources((Hashtable)p.getDynValue(FIELD_ONLINERESOURC));
        this.setTime(p.getTime());
    }

    @Override
    public String getTime() {
        return (String)this.getDynValue(FIELD_TIME);
    }

    @Override
    public void setTime(String time) {
        this.setDynValue(FIELD_TIME, time);
    }

    @Override
    public boolean isOverridingHost() {
        Boolean b = (Boolean)this.getDynValue(FIELD_OVERRIDE);
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public void setOverrideHost(boolean over) {
        this.setDynValue(FIELD_OVERRIDE, new Boolean(over));
    }

    @Override
    public void setOnlineResources(Hashtable<String, String> onlineResources) {
        this.setDynValue(FIELD_ONLINERESOURC, onlineResources);
    }

    @Override
    public Map<String, String> getOnlineResource() {
        return (Map)this.getDynValue(FIELD_ONLINERESOURC);
    }

    public String getOnlineResource(String operation) {
        return this.getOnlineResource().get(operation);
    }

    @Override
    public String getDepth() {
        return (String)this.getDynValue(FIELD_DEPTH);
    }

    @Override
    public void setDepth(String depth) {
        this.setDynValue(FIELD_DEPTH, depth);
    }

    public boolean isSizeFixed() {
        return true;
    }

    public void deleteCache(boolean deleteCache) {
        this.setDynValue(FIELD_DELETECACHE, new Boolean(deleteCache));
    }

    public boolean isDeletingCache() {
        return (Boolean)this.getDynValue(FIELD_DELETECACHE);
    }
}

