/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl.xmlinfo;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.feature.DataTypeDetector;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLAttributeInfo;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLTableInfoImpl;

public class XMLAttributeInfoImpl
implements XMLAttributeInfo {
    private String path = null;
    private String name = null;
    private int type = 8;
    private boolean pk = false;
    private boolean fk = false;
    private String fk_codeName;
    private String fk_tableName;
    private Map<String, MutableInt> childCounts = new HashMap<String, MutableInt>();
    private Map<String, Integer> childCountsMax;
    private Map<String, String> childIds = new HashMap<String, String>();
    private boolean aggregate = false;
    private DataTypeDetector dataTypeDetector;
    private XMLTableInfoImpl table;

    protected XMLAttributeInfoImpl(Locale locale) {
        this.childCountsMax = new HashMap<String, Integer>();
        this.dataTypeDetector = DALLocator.getDataManager().createDataTypeDetector(locale);
    }

    public XMLAttributeInfoImpl(Locale locale, String path) {
        this(locale);
        this.path = path;
        this.name = FilenameUtils.getBaseName((String)path);
    }

    public XMLAttributeInfoImpl(Locale locale, String name, int type) {
        this(locale);
        this.name = name;
        this.setType(type);
    }

    public void setTable(XMLTableInfoImpl table) {
        this.table = table;
    }

    public XMLTableInfoImpl getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setType(int type) {
        this.type = type;
        this.dataTypeDetector = null;
    }

    public XMLAttributeInfoImpl setPk(boolean pk) {
        this.pk = pk;
        return this;
    }

    public XMLAttributeInfoImpl setFk(boolean fk) {
        this.fk = fk;
        return this;
    }

    public int getType() {
        if (this.dataTypeDetector == null) {
            return this.type;
        }
        int x = this.dataTypeDetector.getDataType().getType();
        if (x == 0) {
            return 8;
        }
        return x;
    }

    public int getPrecision() {
        if (this.dataTypeDetector == null) {
            return -1;
        }
        return this.dataTypeDetector.getDataType().getPrecision();
    }

    public int getScale() {
        if (this.dataTypeDetector == null) {
            return -1;
        }
        return this.dataTypeDetector.getDataType().getScale();
    }

    public int getSize() {
        if (this.dataTypeDetector == null) {
            return 0;
        }
        if (this.getType() != 8) {
            return 0;
        }
        int size = this.dataTypeDetector.getDataType().getDisplaySize();
        if (size > 0) {
            size = (size + 10) / 10 * 10;
        }
        return size;
    }

    public GeometryType getGeometryType() {
        if (this.dataTypeDetector == null) {
            return null;
        }
        return this.dataTypeDetector.getDataType().getGeometryType();
    }

    public String toString() {
        DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(" ");
        if (this.aggregate) {
            builder.append("VIRTUAL ");
            builder.append(dataTypeManager.getTypeName(this.getType()));
            builder.append(" OF ");
            builder.append(this.fk_tableName);
            builder.append("(");
            builder.append(this.fk_codeName);
            builder.append(")");
        } else {
            builder.append(dataTypeManager.getTypeName(this.getType()));
            switch (this.getType()) {
                case 8: {
                    builder.append("(");
                    builder.append(this.getSize());
                    builder.append(")");
                    break;
                }
                case 19: {
                    builder.append("(");
                    builder.append(this.getPrecision());
                    builder.append(",");
                    builder.append(this.getScale());
                    builder.append(")");
                    break;
                }
                case 66: {
                    builder.append("(");
                    builder.append(this.getGeometryType().getFullName());
                    builder.append(")");
                }
            }
            if (this.pk) {
                builder.append(" PRIMARY KEY");
            }
            if (this.fk) {
                builder.append(" FOREIGN KEY REFERENCES ");
                builder.append(this.fk_tableName);
                builder.append("(");
                builder.append(this.fk_codeName);
                builder.append(")");
            }
        }
        return builder.toString();
    }

    public XMLAttributeInfoImpl setFkCodeName(String codeName) {
        this.fk_codeName = codeName;
        return this;
    }

    public XMLAttributeInfoImpl setFkTableName(String tableName) {
        this.fk_tableName = tableName;
        return this;
    }

    public void incrChildCount(String childName) {
        MutableInt count = this.childCounts.get(childName);
        if (count == null) {
            count = new MutableInt(0);
            this.childCounts.put(childName, count);
        }
        count.increment();
    }

    public void setLastChildID(String childName, String idvalue) {
        this.childIds.put(childName, idvalue);
    }

    public String getLastChildID(String childName) {
        return this.childIds.get(childName);
    }

    public void consolidateChildCounters() {
        for (Map.Entry<String, MutableInt> entry : this.childCounts.entrySet()) {
            String childName = entry.getKey();
            MutableInt count = entry.getValue();
            int countmax = this.childCountsMax.getOrDefault(childName, -1);
            if (countmax < count.getValue() || countmax < 0) {
                this.childCountsMax.put(childName, count.getValue());
            }
            this.childCounts.get(childName).setValue(0);
        }
    }

    public int getMaxChildCount(String childName) {
        int countmax = this.childCountsMax.getOrDefault(childName, 0);
        return countmax;
    }

    public XMLAttributeInfoImpl setAggregate(boolean b) {
        this.aggregate = b;
        return this;
    }

    public void setSize(int size) {
        if (this.dataTypeDetector == null) {
            return;
        }
        DataTypeDetector.DataTypeDetected detectedType = this.dataTypeDetector.getDataType();
        detectedType.setDisplaySize(size);
    }

    public void addValue(String value) {
        if (this.dataTypeDetector == null) {
            return;
        }
        this.dataTypeDetector.addValue(value);
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public boolean isPk() {
        return this.pk;
    }

    public boolean isFk() {
        return this.fk;
    }

    public String getFkTableName() {
        return this.fk_tableName;
    }

    public String getFkCodeName() {
        return this.fk_codeName;
    }

    public boolean hasChilds() {
        return !this.childCounts.isEmpty();
    }

    public int getChildsCount(String name) {
        MutableInt count = this.childCounts.get(name);
        if (count == null) {
            return 0;
        }
        return count.getValue();
    }
}

