/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.DerivedUnit;
import javax.units.MultiplyConverter;
import javax.units.Unit;

public final class ProductUnit
extends DerivedUnit {
    private final Element[] _elements;
    private transient Unit _systemUnitCache;

    ProductUnit() {
        super(null);
        this._elements = new Element[0];
    }

    private ProductUnit(Element[] elements) {
        super(null);
        this._elements = elements;
    }

    static Unit getInstance(Element[] leftElems, Element[] rightElems) {
        Unit unit;
        int i;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        for (i = 0; i < leftElems.length; ++i) {
            unit = leftElems[i]._unit;
            int p1 = leftElems[i]._pow;
            int r1 = leftElems[i]._root;
            int p2 = 0;
            int r2 = 1;
            for (int j = 0; j < rightElems.length; ++j) {
                if (unit != rightElems[j]._unit) continue;
                p2 = rightElems[j]._pow;
                r2 = rightElems[j]._root;
                break;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow == 0) continue;
            int gcd = ProductUnit.gcd(Math.abs(pow), root);
            result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
        }
        for (i = 0; i < rightElems.length; ++i) {
            unit = rightElems[i]._unit;
            boolean hasBeenMerged = false;
            for (int j = 0; j < leftElems.length; ++j) {
                if (unit != leftElems[j]._unit) continue;
                hasBeenMerged = true;
                break;
            }
            if (hasBeenMerged) continue;
            result[resultIndex++] = rightElems[i];
        }
        if (resultIndex == 0) {
            return ONE;
        }
        if (resultIndex == 1 && result[0]._pow == result[0]._root) {
            return result[0]._unit;
        }
        Element[] elems = new Element[resultIndex];
        for (int i2 = 0; i2 < resultIndex; ++i2) {
            elems[i2] = result[i2];
        }
        return ProductUnit.getInstance(new ProductUnit(elems));
    }

    static Unit getProductInstance(Unit left, Unit right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right)._elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit getQuotientInstance(Unit left, Unit right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left)._elements : new Element[]{new Element(left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right)._elements;
            rightElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                rightElems[i] = new Element(elems[i]._unit, -elems[i]._pow, elems[i]._root);
            }
        } else {
            rightElems = new Element[]{new Element(right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    static Unit getRootInstance(Unit unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow), elems[i]._root * n);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow / gcd, elems[i]._root * n / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    static Unit getPowInstance(Unit unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit)._elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i]._pow * n), elems[i]._root);
                unitElems[i] = new Element(elems[i]._unit, elems[i]._pow * n / gcd, elems[i]._root / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int size() {
        return this._elements.length;
    }

    public Element get(int index) {
        return this._elements[index];
    }

    public Unit getSystemUnit() {
        if (this._systemUnitCache == null) {
            Unit systemUnit = ONE;
            for (int i = 0; i < this._elements.length; ++i) {
                Unit unit = this._elements[i]._unit.getSystemUnit();
                unit = unit.pow(this._elements[i]._pow);
                unit = unit.root(this._elements[i]._root);
                systemUnit = systemUnit.multiply(unit);
            }
            this._systemUnitCache = systemUnit;
        }
        return this._systemUnitCache;
    }

    public boolean equals(Object that) {
        Element[] elems;
        if (this == that) {
            return true;
        }
        if (that instanceof ProductUnit && this._elements.length == (elems = ((ProductUnit)that)._elements).length) {
            for (int i = 0; i < this._elements.length; ++i) {
                boolean unitFound = false;
                for (int j = 0; j < elems.length; ++j) {
                    if (this._elements[i]._unit != elems[j]._unit) continue;
                    if (this._elements[i]._pow != elems[j]._pow || this._elements[i]._root != elems[j]._root) {
                        return false;
                    }
                    unitFound = true;
                    break;
                }
                if (unitFound) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    int calculateHashCode() {
        int code = 0;
        for (int i = 0; i < this._elements.length; ++i) {
            code += this._elements[i]._unit.hashCode() * (this._elements[i]._pow * 3 - this._elements[i]._root * 2);
        }
        return code;
    }

    Unit getCtxDimension() {
        Unit dimension = ONE;
        for (int i = 0; i < this._elements.length; ++i) {
            Unit unit = this._elements[i]._unit.getCtxDimension();
            unit = unit.pow(this._elements[i]._pow);
            unit = unit.root(this._elements[i]._root);
            dimension = dimension.multiply(unit);
        }
        return dimension;
    }

    Converter getCtxToDimension() {
        double factor = 1.0;
        for (int i = 0; i < this._elements.length; ++i) {
            Converter toDimension = this._elements[i]._unit.getCtxToDimension();
            if (toDimension.isLinear()) {
                factor *= Math.pow(toDimension.derivative(0.0), (double)this._elements[i]._pow / (double)this._elements[i]._root);
                continue;
            }
            throw new ConversionException(this._elements[i]._unit + " is non-linear, cannot convert");
        }
        if (Math.abs(factor - 1.0) < 1.0E-9) {
            return Converter.IDENTITY;
        }
        return new MultiplyConverter(factor);
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    public static final class Element
    implements Serializable {
        private final Unit _unit;
        private final int _pow;
        private final int _root;

        private Element(Unit unit, int pow, int root) {
            this._unit = unit;
            this._pow = pow;
            this._root = root;
        }

        public Unit getUnit() {
            return this._unit;
        }

        public int getPow() {
            return this._pow;
        }

        public int getRoot() {
            return this._root;
        }
    }
}

