/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.layers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.dal.coverage.exception.FileNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.OperationNotSupportedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.IStatusRaster;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class StatusLayerRaster
implements IStatusRaster {
    public static String defaultClass = "org.gvsig.fmap.raster.layers.StatusLayerRaster";
    public int transparency = 255;
    public ArrayList<TransparencyRange> ranges = new ArrayList();
    public int bandR = 0;
    public int bandG = 1;
    public int bandB = 2;
    public List<File> files = new ArrayList<File>();
    public List<String> filters = new ArrayList<String>();
    private DefaultFLyrRaster layer = null;
    private int alphaBandNumber = -1;
    private boolean loadClass = false;
    String nameClass = null;

    public void loadFromState(PersistentState state, DefaultFLyrRaster layer) throws PersistenceException {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.transparency = state.getInt("transparency");
        this.bandR = state.getInt("bandR");
        this.bandG = state.getInt("bandG");
        this.bandB = state.getInt("bandB");
        this.alphaBandNumber = state.getInt("alphaBandNumber");
        this.loadClass = state.getBoolean("loadClass");
        this.layer = (DefaultFLyrRaster)state.get("layer");
        this.ranges = new ArrayList(state.getList("ranges"));
        this.files = new ArrayList<File>(state.getList("files"));
        this.filters = new ArrayList<String>(state.getList("filters"));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("transparency", this.transparency);
        state.set("bandR", this.bandR);
        state.set("bandG", this.bandG);
        state.set("bandB", this.bandB);
        state.set("alphaBandNumber", this.alphaBandNumber);
        state.set("loadClass", this.loadClass);
        state.set("layer", (Persistent)this.layer);
        state.set("ranges", this.ranges);
        state.set("files", this.files);
        state.set("filters", this.filters);
    }

    @Override
    public void setStateProperties(boolean loadClass, DefaultFLyrRaster layer) throws PersistenceException {
        this.layer = layer;
        this.loadClass = loadClass;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(StatusLayerRaster.class, "StatusLayerRaster_Persistent", "StatusLayerRaster Persistent definition (FIXME loadClass)", null, null);
        definition.addDynFieldInt("transparency");
        definition.addDynFieldInt("bandR").setMandatory(true);
        definition.addDynFieldInt("bandG").setMandatory(true);
        definition.addDynFieldInt("bandB").setMandatory(true);
        definition.addDynFieldInt("alphaBandNumber");
        definition.addDynFieldBoolean("loadClass");
        definition.addDynFieldObject("layer").setClassOfValue(DefaultFLyrRaster.class);
        definition.addDynFieldList("ranges").setClassOfItems(TransparencyRange.class);
        definition.addDynFieldList("files").setClassOfItems(String.class);
        definition.addDynFieldList("filters").setClassOfItems(String.class);
    }

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    public void applyStatus(DefaultFLyrRaster layer) throws NotSupportedExtensionException, RasterDriverException, FilterTypeException, FileNotFoundInListException, OperationNotSupportedException, FilterManagerException, InvalidSourceException {
        Transparency transp;
        if (layer instanceof DefaultFLyrRaster && this.files != null && this.files.size() != 0) {
            for (int i = 1; i < this.files.size(); ++i) {
                layer.addFile(this.files.get(i));
            }
        }
        String[] valuesCI = new String[layer.getDataStore().getBandCount()];
        valuesCI[this.bandR] = "Red";
        valuesCI[this.bandG] = "Green";
        valuesCI[this.bandB] = "Blue";
        ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(valuesCI);
        if (layer.getRender() != null) {
            layer.getRender().setRenderColorInterpretation(ci);
        }
        if ((transp = layer.getRender().getRenderingTransparency()) != null && this.transparency != 255) {
            transp.setOpacity(this.transparency);
            transp.activeTransparency();
        }
        if (transp != null && this.ranges != null) {
            transp.setTransparencyRangeList(this.ranges);
            transp.activeTransparency();
        }
        if (transp != null && this.alphaBandNumber != -1) {
            transp.setTransparencyBand(this.alphaBandNumber);
            transp.activeTransparency();
        }
        layer.getMapContext().invalidate();
    }

    public static void enhancedCompV10(ArrayList<String> filterArguments, DefaultFLyrRaster layer) throws FilterTypeException, FilterManagerException {
        RasterFilterList filterList = layer.getRender().getFilterList();
        filterList.remove("enhanced_stretch");
        filterList.remove("tailTrim");
        for (int i = 0; i < filterArguments.size(); ++i) {
            if (!filterArguments.get(i).startsWith("filter.enhanced.active=true")) continue;
            RasterFilterListManager enhancementManager = filterList.getManagerByID("EnhancementStretch");
            Params params = filterList.createEmptyFilterParams();
            params.setParam("stats", (Object)layer.getDataStore().getStatistics());
            params.setParam("remove", (Object)new Boolean(false));
            params.setParam("renderBands", (Object)layer.getRender().getRenderColorInterpretation().buildRenderBands());
            params.setParam("stretchs", null);
            enhancementManager.addFilter(params);
        }
    }

    @Override
    public int[] getRenderBands() {
        return new int[]{this.bandR, this.bandG, this.bandB};
    }

    @Override
    public RasterFilterList getFilterList() throws FilterTypeException {
        return null;
    }

    @Override
    public ColorTable getColorTable() throws FilterTypeException {
        return this.layer.getRender().getColorTable();
    }

    @Override
    public List<String> getFilterArguments() {
        return this.filters;
    }

    public void setNameClass(String nameClass) {
        this.nameClass = nameClass;
    }
}

