/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.legend;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class ColorTableLegend
implements IClassifiedLegend,
ILegend {
    public static final String COLOR_TABLE_LEGEND_DYNCLASS_NAME = "ColorTableLegend";
    private static final String FIELD_SYMBOLS = "symbols";
    private static final String FIELD_DESCRIPTIONS = "descriptions";
    private ISymbol[] symbols = null;
    private String[] desc = null;

    public static ColorTableLegend createLegend(ColorTable colorTable) {
        if (colorTable == null || colorTable.getColorItems() == null) {
            return null;
        }
        MathUtils math = RasterLocator.getManager().getMathUtils();
        ISimpleLineSymbol line = SymbologyLocator.getSymbologyManager().createSimpleLineSymbol();
        line.setLineColor(Color.BLACK);
        ISymbol[] symbol = new ISymbol[colorTable.getColorItems().size()];
        String[] desc = new String[colorTable.getColorItems().size()];
        String nameClass = null;
        for (int i = 0; i < colorTable.getColorItems().size(); ++i) {
            ISimpleFillSymbol s = SymbologyLocator.getSymbologyManager().createSimpleFillSymbol();
            s.setOutline((ILineSymbol)line);
            s.setFillColor(((ColorItem)colorTable.getColorItems().get(i)).getColor());
            nameClass = ((ColorItem)colorTable.getColorItems().get(i)).getNameClass();
            desc[i] = nameClass == null || nameClass.equals("") ? (i < colorTable.getColorItems().size() - 1 ? "[" + math.format(((ColorItem)colorTable.getColorItems().get(i)).getValue(), 2) + " , " + math.format(((ColorItem)colorTable.getColorItems().get(i + 1)).getValue(), 2) + "[ " : "[" + math.format(((ColorItem)colorTable.getColorItems().get(i)).getValue(), 2) + "] ") : ((ColorItem)colorTable.getColorItems().get(i)).getNameClass();
            symbol[i] = s;
        }
        return new ColorTableLegend(symbol, desc);
    }

    public ColorTableLegend(ISymbol[] s, String[] d) {
        this.symbols = s;
        this.desc = d;
    }

    public ColorTableLegend() {
    }

    public String[] getDescriptions() {
        return this.desc;
    }

    public ISymbol[] getSymbols() {
        return this.symbols;
    }

    public Object[] getValues() {
        return this.desc;
    }

    public ILegend cloneLegend() {
        return null;
    }

    public ISymbol getDefaultSymbol() {
        return null;
    }

    public String getSLDString(String layerName) {
        return null;
    }

    public String getClassName() {
        return null;
    }

    public void addLegendListener(LegendContentsChangedListener listener) {
    }

    public void fireDefaultSymbolChangedEvent(SymbolLegendEvent event) {
    }

    public LegendContentsChangedListener[] getListeners() {
        return null;
    }

    public void removeLegendListener(LegendContentsChangedListener listener) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void setDescriptions(String[] descriptions) {
        this.desc = descriptions;
    }

    private void setSymbols(ISymbol[] symbols) {
        this.symbols = symbols;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List symbols = (List)state.get(FIELD_SYMBOLS);
        this.setSymbols(symbols.toArray(new ISymbol[symbols.size()]));
        List descriptions = (List)state.get(FIELD_DESCRIPTIONS);
        this.setDescriptions(descriptions.toArray(new String[descriptions.size()]));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_SYMBOLS, Arrays.asList(this.getSymbols()));
        state.set(FIELD_DESCRIPTIONS, Arrays.asList(this.getDescriptions()));
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(ColorTableLegend.class, COLOR_TABLE_LEGEND_DYNCLASS_NAME, "ColorTableLegend Persistence definition", null, null);
        definition.addDynFieldList(FIELD_SYMBOLS).setClassOfItems(ISymbol.class).setMandatory(true);
        definition.addDynFieldList(FIELD_DESCRIPTIONS).setClassOfItems(String.class).setMandatory(true);
    }
}

