/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.tool.behavior;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformedRectangleBehavior
extends Behavior {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeometryManager.class);
    private Point2D m_FirstPoint = null;
    private Point2D m_LastPoint = null;
    private RectangleListener listener = null;
    private AffineTransform at = null;
    private BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f}, 0.0f);

    public TransformedRectangleBehavior(RectangleListener zili) {
        this.listener = zili;
    }

    public void setAffineTransform(AffineTransform at) {
        this.at = at;
    }

    public Image getImageCursor() {
        return IconThemeHelper.getImage((String)"rectangle-select-cursor");
    }

    public void paintComponent(MapControlDrawer mapControlDrawer) {
        BufferedImage img = this.getMapControl().getImage();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        mapControlDrawer.setRenderingHints(hints);
        mapControlDrawer.drawImage((Image)img, 0, 0);
        mapControlDrawer.setColor(Color.black);
        Rectangle r = new Rectangle();
        if (this.m_FirstPoint != null && this.m_LastPoint != null) {
            r.setFrameFromDiagonal(this.m_FirstPoint, this.m_LastPoint);
            mapControlDrawer.drawRect(r.x, r.y, r.width, r.height);
        }
        if (this.at != null) {
            Point2D.Double ul = new Point2D.Double(r.x, r.y);
            Point2D.Double ur = new Point2D.Double(r.x + r.width, r.y);
            Point2D.Double ll = new Point2D.Double(r.x, r.y + r.height);
            Point2D.Double lr = new Point2D.Double(r.x + r.width, r.y + r.height);
            Point2D.Double center = new Point2D.Double((double)r.width / 2.0, (double)r.height / 2.0);
            AffineTransform T1 = new AffineTransform(1.0, 0.0, 0.0, 1.0, -((Point2D)center).getX(), -((Point2D)center).getY());
            AffineTransform R1 = new AffineTransform(1.0, this.at.getShearY() / this.at.getScaleY(), this.at.getShearX() / this.at.getScaleX(), 1.0, 0.0, 0.0);
            AffineTransform T2 = new AffineTransform(1.0, 0.0, 0.0, 1.0, ((Point2D)center).getX(), ((Point2D)center).getY());
            T2.concatenate(R1);
            T2.concatenate(T1);
            try {
                T2.inverseTransform(ul, ul);
                T2.inverseTransform(ll, ll);
                T2.inverseTransform(ur, ur);
                T2.inverseTransform(lr, lr);
                Point2D.Double ptMin = new Point2D.Double(Math.min(Math.min(ul.getX(), ur.getX()), Math.min(ll.getX(), lr.getX())), Math.min(Math.min(ul.getY(), ur.getY()), Math.min(ll.getY(), lr.getY())));
                Point2D.Double ptMax = new Point2D.Double(Math.max(Math.max(ul.getX(), ur.getX()), Math.max(ll.getX(), lr.getX())), Math.max(Math.max(ul.getY(), ur.getY()), Math.max(ll.getY(), lr.getY())));
                double w = ptMax.getX() - ptMin.getX();
                double h = ptMax.getY() - ptMin.getY();
                mapControlDrawer.setStroke((Stroke)this.stroke);
                mapControlDrawer.transform(T2);
                mapControlDrawer.drawRect((int)ptMin.getX(), (int)ptMin.getY(), (int)w, (int)h);
                mapControlDrawer.transform(this.at.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                return;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.m_FirstPoint = e.getPoint();
            this.getMapControl().repaint();
        }
        if (this.listener.cancelDrawing()) {
            this.getMapControl().cancelDrawing();
            this.getMapControl().repaint();
        }
    }

    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (this.m_FirstPoint == null) {
            return;
        }
        Point pScreen = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint((Point2D)pScreen);
        if (e.getButton() == 1) {
            double minX = Math.min(p1.getX(), p2.getX());
            double minY = Math.min(p1.getY(), p2.getY());
            double maxX = Math.max(p1.getX(), p2.getX());
            double maxY = Math.max(p1.getY(), p2.getY());
            Envelope env = null;
            try {
                env = geomManager.createEnvelope(minX, minY, maxX, maxY, 0);
            }
            catch (CreateEnvelopeException e1) {
                logger.error("Error creating the envelope", (Object)e);
            }
            Rectangle rectPixel = new Rectangle();
            rectPixel.setFrameFromDiagonal(this.m_FirstPoint, pScreen);
            EnvelopeEvent event = new EnvelopeEvent(env, e, (Rectangle2D)rectPixel);
            this.listener.rectangle(event);
        }
        this.m_FirstPoint = null;
        this.m_LastPoint = null;
    }

    public void mouseDragged(MouseEvent e) {
        this.m_LastPoint = e.getPoint();
        this.getMapControl().repaint();
    }

    public void setListener(ToolListener listener) {
        this.listener = (RectangleListener)listener;
    }

    public ToolListener getListener() {
        return this.listener;
    }
}

