/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;

public class LayerVisualStatusList {
    private ArrayList<LayerVisualStatus> list = new ArrayList();

    public void clear() {
        this.list.clear();
    }

    public void add(LayerVisualStatus status) {
        this.list.add(status);
    }

    public LayerVisualStatus getLast() {
        return this.list.get(this.list.size() - 1);
    }

    public LayerVisualStatus get(int i) {
        return this.list.get(i);
    }

    public void restoreVisualStatus(FLyrRaster lyr) {
        Render rendering = lyr.getRender();
        LayerVisualStatus status = this.getLast();
        if (status != null) {
            if (rendering.getFilterList() != null) {
                rendering.getFilterList().setStatus(status.filterStatus);
            }
            lyr.getRender().setLastTransparency(status.transparency);
            if (((IRasterLayerActions)((Object)lyr)).isActionEnabled(20)) {
                lyr.getRender().getFilterList().setStatus(status.filterStatus);
            }
        }
    }

    public void getVisualStatus(FLyrRaster lyr) {
        LayerVisualStatus status = new LayerVisualStatus();
        status.transparency = lyr.getRender().getRenderingTransparency();
        status.filterStatus = lyr.getRender().getFilterList().getStatusCloned();
        this.add(status);
    }

    public class LayerVisualStatus {
        private List<RasterFilter> filterStatus = null;
        private Transparency transparency = null;

        public List<RasterFilter> getFilterStatus() {
            return this.filterStatus;
        }

        public void setFilterStatus(List<RasterFilter> filterStatus) {
            this.filterStatus = filterStatus;
        }

        public Transparency getTransparency() {
            return this.transparency;
        }

        public void setTransparency(Transparency transparency) {
            this.transparency = transparency;
        }
    }
}

