/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import sun.rmi.server.Util;
import sun.rmi.transport.ObjectTable;

public abstract class RemoteObject
implements Remote,
Serializable {
    protected transient RemoteRef ref;
    private static final long serialVersionUID = -3215090123894869218L;

    protected RemoteObject() {
        this.ref = null;
    }

    protected RemoteObject(RemoteRef remoteRef) {
        this.ref = remoteRef;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        if (remote instanceof RemoteStub || remote != null && Proxy.isProxyClass(remote.getClass()) && Proxy.getInvocationHandler(remote) instanceof RemoteObjectInvocationHandler) {
            return remote;
        }
        return ObjectTable.getStub(remote);
    }

    public int hashCode() {
        return this.ref == null ? super.hashCode() : this.ref.remoteHashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof RemoteObject) {
            if (this.ref == null) {
                return object == this;
            }
            return this.ref.remoteEquals(((RemoteObject)object).ref);
        }
        if (object != null) {
            return object.equals(this);
        }
        return false;
    }

    public String toString() {
        String string = Util.getUnqualifiedName(this.getClass());
        return this.ref == null ? string : string + "[" + this.ref.remoteToString() + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException("Invalid remote object");
        }
        String string = this.ref.getRefClass(objectOutputStream);
        if (string == null || string.length() == 0) {
            objectOutputStream.writeUTF("");
            objectOutputStream.writeObject(this.ref);
        } else {
            objectOutputStream.writeUTF(string);
            this.ref.writeExternal(objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        if (string == null || string.length() == 0) {
            this.ref = (RemoteRef)objectInputStream.readObject();
        } else {
            String string2 = "sun.rmi.server." + string;
            Class<?> clazz = Class.forName(string2);
            try {
                this.ref = (RemoteRef)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ClassNotFoundException(string2, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ClassNotFoundException(string2, illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                throw new ClassNotFoundException(string2, classCastException);
            }
            this.ref.readExternal(objectInputStream);
        }
    }
}

