/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.AbstractLabelingMethodPanel;
import org.gvsig.labeling.gui.layerproperties.LabelClassPreview;
import org.gvsig.labeling.gui.layerproperties.LabelClassProperties;
import org.gvsig.labeling.gui.styling.LayerPreview;
import org.gvsig.labeling.label.GeneralLabelingStrategy;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.DefaultLabelingMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLabeling
extends AbstractLabelingMethodPanel
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLabeling.class);
    private static final long serialVersionUID = 7100208944546698724L;
    private ILabelClass defaultLabel;
    private IPlacementConstraints placementConstraints;
    private LayerPreview layerPrev;
    private JCheckBox enableLayerPrev;
    private LabelClassPreview labelPrev;
    private JButton btnProperties;
    private FeatureAttributeDescriptor[] fieldDescs;
    private boolean allowOverlap;
    private IZoomConstraints zoomConstraints;
    private LabelClassProperties lcProp;
    private JSplitPane scrl;
    private JPanel aux;
    private JPanel aux2;

    @Override
    public Class<? extends ILabelingMethod> getLabelingMethodClass() {
        return DefaultLabelingMethod.class;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"label_features_in_the_same_way") + ".";
    }

    @Override
    public void fillPanel(FeatureType fty) {
        try {
            if (this.getEnableLayerPreview().isSelected()) {
                this.layerPrev.setLayer((FLayer)this.layer);
            } else {
                this.layerPrev.setLayer(null);
            }
            this.fieldDescs = fty.getAttributeDescriptors();
            ILabelingStrategy labeling = this.layer.getLabelingStrategy();
            if (!(labeling instanceof GeneralLabelingStrategy)) {
                labeling = new GeneralLabelingStrategy();
                labeling.setLayer((FLayer)this.layer);
                this.layer.setLabelingStrategy(labeling);
            }
        }
        catch (Exception e) {
            NotificationManager.addWarning((String)e.getMessage(), (Throwable)e);
        }
        ILabelClass lc = null;
        lc = this.method.getLabelClasses() != null && this.method.getLabelClasses().length > 0 ? this.method.getLabelClasses()[0] : SymbologyLocator.getSymbologyManager().createDefaultLabel();
        this.setLabel(lc);
        this.getLcProp();
    }

    private JButton getBtnProperties() {
        if (this.btnProperties == null) {
            this.btnProperties = new JButton(Messages.getText((String)"properties"));
            this.btnProperties.addActionListener(this);
        }
        return this.btnProperties;
    }

    private LabelClassPreview getLabelPrev() {
        if (this.labelPrev == null) {
            this.labelPrev = new LabelClassPreview();
        }
        return this.labelPrev;
    }

    private JCheckBox getEnableLayerPreview() {
        if (this.enableLayerPrev == null) {
            this.enableLayerPrev = new JCheckBox(Messages.getText((String)"Enable_layer_preview"));
            this.enableLayerPrev.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        if (e.getStateChange() == 1) {
                            DefaultLabeling.this.layerPrev.setLayer((FLayer)DefaultLabeling.this.layer);
                            DefaultLabeling.this.updatePreview();
                        } else if (e.getStateChange() == 2) {
                            DefaultLabeling.this.layerPrev.setLayer(null);
                        }
                    }
                    catch (ReadException e1) {
                        logger.error("While setting changing layer in preview", (Throwable)e1);
                    }
                }
            });
        }
        return this.enableLayerPrev;
    }

    private LayerPreview getLayerPreview() {
        if (this.layerPrev == null) {
            this.layerPrev = new LayerPreview();
        }
        return this.layerPrev;
    }

    @Override
    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrl(), "Center");
        this.scrl.setDividerLocation(500);
        this.getEnableLayerPreview().setSelected(false);
        this.add((Component)this.getEnableLayerPreview(), "South");
    }

    private JSplitPane getScrl() {
        if (this.scrl == null) {
            this.scrl = new JSplitPane(1);
        }
        this.scrl.add((Component)((Object)this.getLayerPreview()), "left");
        this.scrl.add((Component)this.getAuxPanel(), "right");
        this.add((Component)this.scrl, "Center");
        return this.scrl;
    }

    JPanel getAuxPanel() {
        if (this.aux == null) {
            this.aux = new JPanel(new BorderLayout());
            this.aux.add((Component)new JBlank(10, 10), "North");
            this.aux.add((Component)new JBlank(10, 10), "West");
            this.aux.add((Component)this.getLabelPrev(), "Center");
            this.aux.add((Component)new JBlank(10, 10), "East");
            this.aux.add((Component)this.getAux2Panel(), "South");
        }
        return this.aux;
    }

    JPanel getAux2Panel() {
        if (this.aux2 == null) {
            this.aux2 = new JPanel(new FlowLayout(2, 10, 10));
            this.aux2.add(this.getBtnProperties());
        }
        return this.aux2;
    }

    private LabelClassProperties getLcProp() {
        if (this.lcProp == null) {
            int n = this.fieldDescs.length;
            String[] fnames = new String[n];
            int[] ftypes = new int[n];
            for (int i = 0; i < n; ++i) {
                fnames[i] = this.fieldDescs[i].getName();
                ftypes[i] = this.fieldDescs[i].getType();
            }
            this.lcProp = new LabelClassProperties(this.layer.getFeatureStore());
            this.lcProp.setLabelClass(this.method.getLabelClasses()[0]);
        }
        return this.lcProp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.getBtnProperties())) {
            LabelClassProperties lcProp = this.getLcProp();
            ILabelClass lc = this.defaultLabel;
            lcProp.setLabelClass(lc);
            boolean eval = false;
            while (!eval) {
                ApplicationLocator.getManager().getUIManager().addWindow((IWindow)lcProp);
                if (!lcProp.isAccepted()) break;
                lc = lcProp.getLabelClass();
                eval = this.checkValidSQL(lc);
                if (!eval) continue;
                this.checkRectangles(lc);
            }
            this.setLabel(lc);
        }
    }

    private void checkRectangles(ILabelClass lc) {
        ILabelStyle lbl_sty = lc.getLabelStyle();
        if (lbl_sty != null) {
            String[] lbl_exps = lc.getLabelExpressions();
            Rectangle2D[] lbl_rects = lbl_sty.getTextBounds();
            int empty = this.countEmpty(lbl_exps);
            if (lbl_exps != null && lbl_rects != null && (empty > 0 || lbl_exps.length != lbl_rects.length)) {
                String[] pars = new String[]{Integer.toString(lbl_exps.length), Integer.toString(empty), Integer.toString(lbl_rects.length)};
                JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_There_are_N_expressions_N_are_empty_and_N_rectangles_Check_label_expressions_and_background_image_properties", (String[])pars), Messages.getText((String)"label_expression_editor"), 2);
            }
        }
    }

    private int countEmpty(String[] strs) {
        if (strs == null || strs.length == 0) {
            return 0;
        }
        int resp = 0;
        for (int i = 0; i < strs.length; ++i) {
            if (strs[i] != null && strs[i].trim().length() != 0) continue;
            ++resp;
        }
        return resp;
    }

    private boolean checkValidSQL(ILabelClass lc) {
        String sqlQuery = lc.getSQLQuery();
        if (sqlQuery != null && sqlQuery.trim().length() > 0) {
            return LabelClassUtils.validExpression(sqlQuery, this.layer.getFeatureStore(), true);
        }
        return true;
    }

    private void setLabel(ILabelClass labelClass) {
        this.defaultLabel = labelClass;
        this.labelPrev.setLabelClass(this.defaultLabel);
        this.method = this.newMethodForThePreview(this.defaultLabel);
        this.updatePreview();
    }

    protected ILabelingMethod newMethodForThePreview(ILabelClass defaultLabel) {
        ILabelingMethod resp = SymbologyLocator.getSymbologyManager().createDefaultLabelingMethod();
        resp.addLabelClass(defaultLabel);
        return resp;
    }

    private void updatePreview() {
        ILabelingStrategy stra = this.layer.getLabelingStrategy();
        if (this.method == null) {
            stra.setLabelingMethod(this.newMethodForThePreview(this.defaultLabel));
        } else {
            stra.setLabelingMethod(this.method);
        }
        this.layer.setIsLabeled(true);
        try {
            Rectangle r = this.layerPrev.getBounds();
            r.setLocation(this.layerPrev.getLocationOnScreen());
            this.layerPrev.paintImmediately(r);
            this.layerPrev.doLayout();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        ILabelingStrategy strat = this.layer.getLabelingStrategy();
        if ("PLACEMENT_CONSTRAINTS".equals(prop)) {
            this.placementConstraints = (IPlacementConstraints)evt.getNewValue();
            strat.setPlacementConstraints(this.placementConstraints);
        } else if (strat instanceof GeneralLabelingStrategy && "ALLOW_OVERLAP".equals(prop)) {
            this.allowOverlap = (Boolean)evt.getNewValue();
            ((GeneralLabelingStrategy)strat).setAllowOverlapping(this.allowOverlap);
        } else if ("ZOOM_CONSTRAINTS".equals(prop)) {
            this.zoomConstraints = (IZoomConstraints)evt.getNewValue();
            strat.setZoomConstraints(this.zoomConstraints);
        }
        this.updatePreview();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.layerPrev != null) {
            this.layerPrev.setEnabled(enabled);
        }
        if (this.labelPrev != null) {
            this.labelPrev.setEnabled(enabled);
        }
        if (this.btnProperties != null) {
            this.btnProperties.setEnabled(enabled);
        }
    }
}

