/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.ILabelingStrategyPanel;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.gui.layerproperties.AbstractLabelingMethodPanel;
import org.gvsig.labeling.gui.layerproperties.IPlacementProperties;
import org.gvsig.labeling.gui.layerproperties.LabelScaleRange;
import org.gvsig.labeling.gui.layerproperties.PlacementProperties;
import org.gvsig.labeling.label.GeneralLabelingFactory;
import org.gvsig.labeling.label.GeneralLabelingStrategy;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.persistence.Persistent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLabeling
extends JPanel
implements ILabelingStrategyPanel,
ActionListener {
    private static final long serialVersionUID = 8864709758980903351L;
    private static final Logger logger = LoggerFactory.getLogger(GeneralLabeling.class);
    private static Comparator<Class<? extends ILabelingMethod>> comparator = new Comparator<Class<? extends ILabelingMethod>>(){

        @Override
        public int compare(Class<? extends ILabelingMethod> o1, Class<? extends ILabelingMethod> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static TreeMap<Class<? extends ILabelingMethod>, Class<? extends AbstractLabelingMethodPanel>> methods = new TreeMap(comparator);
    private JButton btnVisualization;
    private JButton btnPlacement;
    private JComboBox<?> cmbMethod;
    private JPanel methodPanel;
    private IPlacementConstraints placementConstraints;
    private IZoomConstraints zoomConstraints;
    private boolean noEvent;
    private FLyrVect targetLayer;
    private JCheckBox chkAllowLabelOverlapping;
    private FLyrVect auxLayer;
    private GeneralLabelingStrategy gStr;

    public GeneralLabeling() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel center = new JPanel(new BorderLayout(10, 10));
        center.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"classes")));
        JPanel aux = new JPanel(new FlowLayout(3, 5, 0));
        aux.add(new JLabel(Messages.getText((String)"method") + ":"));
        aux.add(this.getCmbMethod());
        aux.setPreferredSize(new Dimension(605, 40));
        center.add((Component)aux, "North");
        this.methodPanel = this.getMethodPanel();
        center.add((Component)this.methodPanel, "Center");
        this.add((Component)center, "Center");
        JPanel south = new JPanel(new FlowLayout(3, 5, 0));
        south.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"options")));
        south.add(this.getBtnVisualization());
        south.add(this.getBtnPlacement());
        south.add(this.getChkAllowLabelOverlapping());
        south.setPreferredSize(new Dimension(612, 60));
        this.add((Component)south, "South");
    }

    private JPanel getMethodPanel() {
        if (this.methodPanel == null) {
            this.methodPanel = new JPanel(new BorderLayout(10, 0));
        }
        return this.methodPanel;
    }

    private JCheckBox getChkAllowLabelOverlapping() {
        if (this.chkAllowLabelOverlapping == null) {
            this.chkAllowLabelOverlapping = new JCheckBox(Messages.getText((String)"allow_label_overlapping"));
            this.chkAllowLabelOverlapping.addActionListener(this);
        }
        return this.chkAllowLabelOverlapping;
    }

    private void refreshControls() {
        this.actionPerformed(new ActionEvent(this.getCmbMethod(), 0, null));
    }

    private JButton getBtnVisualization() {
        if (this.btnVisualization == null) {
            this.btnVisualization = new JButton(Messages.getText((String)"visualization") + "...");
            this.btnVisualization.setName("BTNVISUALIZATION");
            this.btnVisualization.addActionListener(this);
        }
        return this.btnVisualization;
    }

    private JButton getBtnPlacement() {
        if (this.btnPlacement == null) {
            this.btnPlacement = new JButton(Messages.getText((String)"placement") + "...");
            this.btnPlacement.setName("BTNPLACEMENT");
            this.btnPlacement.addActionListener(this);
        }
        return this.btnPlacement;
    }

    private JComboBox getCmbMethod() {
        if (this.cmbMethod == null) {
            Iterator<Class<? extends AbstractLabelingMethodPanel>> it = methods.values().iterator();
            ArrayList<AbstractLabelingMethodPanel> panels = new ArrayList<AbstractLabelingMethodPanel>();
            while (it.hasNext()) {
                try {
                    panels.add(it.next().newInstance());
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            this.cmbMethod = new JComboBox<Object>(panels.toArray());
            this.cmbMethod.setSize(new Dimension(300, 22));
            this.cmbMethod.setName("CMBMETHOD");
            this.cmbMethod.addActionListener(this);
        }
        return this.cmbMethod;
    }

    public ILabelingStrategy getLabelingStrategy() {
        GeneralLabelingStrategy resp = GeneralLabelingFactory.createStrategy((FLayer)this.targetLayer, this.getMethod(), this.getPlacementConstraints(), this.getZoomConstraints());
        resp.setAllowOverlapping(this.getChkAllowLabelOverlapping().isSelected());
        return resp;
    }

    public void setModel(FLayer layer, ILabelingStrategy str) {
        if (layer instanceof FLyrVect) {
            try {
                this.targetLayer = (FLyrVect)layer;
                if (this.auxLayer != null) {
                    DisposeUtils.disposeQuietly((Disposable)this.auxLayer);
                }
                this.auxLayer = (FLyrVect)this.targetLayer.cloneLayer();
                this.auxLayer.setParentLayer(layer.getParentLayer());
                this.auxLayer.setLegend((IVectorLegend)this.targetLayer.getLegend());
                this.auxLayer.setProjection(this.targetLayer.getProjection());
                if (str == null) {
                    str = new GeneralLabelingStrategy();
                    str.setLayer(layer);
                }
                if (str instanceof GeneralLabelingStrategy) {
                    GeneralLabelingStrategy gls = (GeneralLabelingStrategy)str;
                    this.gStr = (GeneralLabelingStrategy)gls.clone();
                    this.auxLayer.setLabelingStrategy((ILabelingStrategy)this.gStr);
                    this.gStr.setLayer((FLayer)this.auxLayer);
                    this.setMethod(this.gStr.getLabelingMethod(), this.auxLayer);
                    this.placementConstraints = this.gStr.getPlacementConstraints();
                    this.zoomConstraints = this.gStr.getZoomConstraints();
                    this.getChkAllowLabelOverlapping().setSelected(this.gStr.isAllowingOverlap());
                } else {
                    ILabelingStrategy ils = ((FLyrVect)layer).getLabelingStrategy();
                    if (ils != null) {
                        ils = (ILabelingStrategy)LabelClassUtils.clone((Persistent)ils);
                        this.auxLayer.setLabelingStrategy(ils);
                    }
                }
            }
            catch (Exception e) {
                NotificationManager.addError((String)Messages.getText((String)"While setting model."), (Throwable)e);
            }
            this.refreshControls();
        }
    }

    public static void addLabelingMethod(Class<? extends AbstractLabelingMethodPanel> iLabelingMethodClass) {
        try {
            methods.put(iLabelingMethodClass.newInstance().getLabelingMethodClass(), iLabelingMethodClass);
        }
        catch (Exception e) {
            NotificationManager.addError((String)Messages.getText((String)"cannot_install_labeling_method"), (Throwable)e);
        }
    }

    private void setMethod(ILabelingMethod labelingMethod, FLyrVect srcLayer) {
        this.getMethodPanel().removeAll();
        try {
            AbstractLabelingMethodPanel p = methods.get(labelingMethod.getClass()).newInstance();
            this.cmbMethod.setSelectedItem(p);
        }
        catch (Exception e) {
            NotificationManager.addWarning((String)e.getLocalizedMessage());
        }
    }

    private ILabelingMethod getMethod() {
        AbstractLabelingMethodPanel p = (AbstractLabelingMethodPanel)this.cmbMethod.getSelectedItem();
        if (p != null) {
            return p.getMethod();
        }
        return SymbologyLocator.getSymbologyManager().createDefaultLabelingMethod();
    }

    private IZoomConstraints getZoomConstraints() {
        if (this.zoomConstraints == null) {
            this.zoomConstraints = SymbologyLocator.getSymbologyManager().createDefaultZoomConstraints();
        }
        return this.zoomConstraints;
    }

    private IPlacementConstraints getPlacementConstraints() {
        return this.placementConstraints;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.noEvent) {
            return;
        }
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.btnPlacement)) {
            try {
                IPlacementConstraints oldValue = this.getPlacementConstraints();
                IPlacementProperties pp = PlacementProperties.createPlacementProperties(this.getPlacementConstraints(), this.auxLayer.getShapeType());
                ApplicationLocator.getManager().getUIManager().addWindow((IWindow)pp);
                this.placementConstraints = pp.getPlacementConstraints();
                ((AbstractLabelingMethodPanel)this.cmbMethod.getSelectedItem()).propertyChange(new PropertyChangeEvent(this, "PLACEMENT_CONSTRAINTS", oldValue, this.placementConstraints));
            }
            catch (ClassCastException ccEx) {
                NotificationManager.addError((String)("Placement constraints not prepared for:" + this.auxLayer.getClass().getName()), (Throwable)ccEx);
            }
            catch (ReadException dEx) {
                NotificationManager.addError((String)"While getting layer type", (Throwable)dEx);
            }
        } else if (c.equals(this.btnVisualization)) {
            IZoomConstraints oldValue = this.getZoomConstraints();
            LabelScaleRange lsr = new LabelScaleRange(oldValue.getMinScale(), oldValue.getMaxScale());
            ApplicationLocator.getManager().getUIManager().addWindow((IWindow)lsr);
            this.zoomConstraints = SymbologyLocator.getSymbologyManager().createDefaultZoomConstraints();
            this.zoomConstraints.setMaxScale(lsr.getMaxScale());
            this.zoomConstraints.setMinScale(lsr.getMinScale());
            this.zoomConstraints.setMode(lsr.getMaxScale() == -1L && lsr.getMinScale() == -1L ? 0 : 1);
            ((AbstractLabelingMethodPanel)this.cmbMethod.getSelectedItem()).propertyChange(new PropertyChangeEvent(this, "ZOOM_CONSTRAINTS", oldValue, this.getZoomConstraints()));
        } else if (c.equals(this.chkAllowLabelOverlapping)) {
            boolean newValue = this.chkAllowLabelOverlapping.isSelected();
            ((AbstractLabelingMethodPanel)this.cmbMethod.getSelectedItem()).propertyChange(new PropertyChangeEvent(this, "ALLOW_OVERLAP", !newValue, newValue));
        } else if (c.equals(this.getCmbMethod())) {
            AbstractLabelingMethodPanel p = (AbstractLabelingMethodPanel)this.cmbMethod.getSelectedItem();
            Container cont = this.methodPanel.getParent();
            cont.remove(this.methodPanel);
            this.emptyContainer(this.methodPanel);
            try {
                if (this.gStr != null) {
                    if (this.gStr.getLabelingMethod() != null) {
                        p.setModel(this.gStr.getLabelingMethod(), this.auxLayer);
                    }
                } else {
                    p.setModel(this.getMethod(), this.auxLayer);
                }
                this.methodPanel.add((Component)p, "Center");
                this.methodPanel.repaint();
                this.setVisible(false);
                this.setVisible(true);
            }
            catch (Exception e1) {
                NotificationManager.addError((String)new Date(System.currentTimeMillis()).toString(), (Throwable)e1);
            }
            cont.add((Component)this.methodPanel, "Center");
        }
    }

    private void emptyContainer(Container c) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            c.remove(i);
        }
    }

    public String getLabelingStrategyName() {
        return Messages.getText((String)"user_defined_labels");
    }

    public Class<? extends ILabelingStrategy> getLabelingStrategyClass() {
        return GeneralLabelingStrategy.class;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getBtnPlacement().setEnabled(enabled);
        this.getBtnVisualization().setEnabled(enabled);
        this.getChkAllowLabelOverlapping().setEnabled(enabled);
        this.getCmbMethod().setEnabled(enabled);
        JPanel mp = this.getMethodPanel();
        mp.setEnabled(enabled);
        for (int i = 0; i < mp.getComponentCount(); ++i) {
            Component c = mp.getComponent(i);
            c.setEnabled(enabled);
        }
    }
}

