/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.JComboBoxUnitsReferenceSystem;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JComboBoxFonts;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;

public class LabelTextStylePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8351591938535233138L;
    private ITextSymbol symbol;
    private JComboBoxFonts cmbFont;
    private ColorChooserPanel colorFont;
    private JRadioButton rdBtnTextHeight;
    private JRadioButton rdBtnFitOnTextArea;
    private JNumberSpinner incrTextSize;
    private JComboBoxUnits units;
    private JComboBoxUnitsReferenceSystem referenceSystem;
    private JCheckBox chkWithHalo;
    private ColorChooserPanel colorHaloChooser;
    private JNumberSpinner txtHaloWidth;
    private ArrayList<ActionListener> listeners = new ArrayList();
    private boolean performAction = true;

    private JCheckBox getCheckHalo() {
        if (this.chkWithHalo == null) {
            this.chkWithHalo = new JCheckBox(Messages.getText((String)"_Use_halo") + ": ");
            this.chkWithHalo.setSelected(false);
            this.chkWithHalo.setName("CHECK_HALO");
        }
        return this.chkWithHalo;
    }

    private ColorChooserPanel getHaloColorChooser() {
        if (this.colorHaloChooser == null) {
            this.colorHaloChooser = new ColorChooserPanel(true);
            this.colorHaloChooser.setColor(Color.WHITE);
        }
        return this.colorHaloChooser;
    }

    private JNumberSpinner getTxtHaloWidth() {
        if (this.txtHaloWidth == null) {
            this.txtHaloWidth = new JNumberSpinner(3);
        }
        return this.txtHaloWidth;
    }

    public LabelTextStylePanel() {
        this.setLayout(new BorderLayout(5, 0));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel aux = new JPanel();
        aux.setLayout(new BoxLayout(aux, 1));
        JPanel auxA = new JPanel();
        aux.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"font")));
        auxA.add(new JLabel(Messages.getText((String)"font")));
        this.cmbFont = new JComboBoxFonts();
        auxA.add((Component)this.cmbFont, "North");
        JPanel auxB = new JPanel();
        auxB.add(new JLabel(Messages.getText((String)"color")));
        this.colorFont = new ColorChooserPanel(true);
        auxB.add((Component)this.colorFont, "South");
        this.cmbFont.addActionListener((ActionListener)this);
        this.colorFont.addActionListener((ActionListener)this);
        aux.add(auxA);
        aux.add(auxB);
        this.add((Component)aux, "West");
        aux = new JPanel(new FlowLayout(0, 5, 2));
        aux.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"format")));
        this.rdBtnTextHeight = new JRadioButton(Messages.getText((String)"fixed_text_size"));
        this.rdBtnFitOnTextArea = new JRadioButton(Messages.getText((String)"fit_on_text_area"));
        this.rdBtnFitOnTextArea.addActionListener(this);
        this.rdBtnTextHeight.addActionListener(this);
        ButtonGroup g = new ButtonGroup();
        g.add(this.rdBtnFitOnTextArea);
        g.add(this.rdBtnTextHeight);
        this.incrTextSize = new JNumberSpinner(1.0, 7, 0.0, Double.POSITIVE_INFINITY, 1.0);
        this.incrTextSize.addActionListener((ActionListener)this);
        this.units = new JComboBoxUnits();
        this.referenceSystem = new JComboBoxUnitsReferenceSystem();
        this.units.addActionListener((ActionListener)this);
        this.referenceSystem.addActionListener((ActionListener)this);
        GridBagLayoutPanel aux2 = new GridBagLayoutPanel();
        JPanel aux3 = new JPanel(new FlowLayout(0, 3, 0));
        aux3.add(this.rdBtnTextHeight);
        aux3.add((Component)this.incrTextSize);
        aux3.add((Component)this.units);
        aux3.add((Component)this.referenceSystem);
        aux2.addComponent((Component)aux3);
        GridBagLayoutPanel aux4 = new GridBagLayoutPanel();
        aux4.addComponent((Component)this.rdBtnFitOnTextArea);
        this.getCheckHalo().addActionListener(this);
        this.getHaloColorChooser().addActionListener((ActionListener)this);
        this.getTxtHaloWidth().addActionListener((ActionListener)this);
        aux4.addComponent((Component)this.getCheckHalo(), (Component)this.getHaloColorChooser());
        aux4.addComponent(Messages.getText((String)"_Halo_width") + ": ", (Component)this.getTxtHaloWidth());
        aux2.addComponent((Component)aux4);
        aux.add((Component)aux2);
        this.add((Component)aux, "Center");
    }

    public void setModel(ITextSymbol textSymbol, int unit, int referenceSystem) {
        this.incrTextSize.setDouble((double)textSymbol.getFont().getSize());
        this.rdBtnTextHeight.setSelected(!textSymbol.isAutoresizeEnabled());
        this.rdBtnFitOnTextArea.setSelected(textSymbol.isAutoresizeEnabled());
        this.getCheckHalo().setSelected(textSymbol.isDrawWithHalo());
        if (textSymbol.isDrawWithHalo()) {
            this.getHaloColorChooser().setColor(textSymbol.getHaloColor());
            this.getTxtHaloWidth().setDouble((double)textSymbol.getHaloWidth());
        }
        this.performAction = false;
        this.cmbFont.setSelectedItem((Object)textSymbol.getFont().getName());
        this.colorFont.setColor(textSymbol.getTextColor());
        this.units.setSelectedUnitIndex(unit);
        this.referenceSystem.setSelectedIndex(referenceSystem);
        boolean enableSize = this.rdBtnTextHeight.isSelected();
        this.units.setEnabled(enableSize);
        this.referenceSystem.setEnabled(enableSize);
        this.incrTextSize.setEnabled(enableSize);
        this.performAction = true;
        this.symbol = textSymbol;
    }

    public ITextSymbol getTextSymbol() {
        this.symbol.setDrawWithHalo(this.chkWithHalo.isSelected());
        if (this.symbol.isDrawWithHalo()) {
            this.symbol.setHaloColor(this.colorHaloChooser.getColor());
            this.symbol.setHaloWidth((float)this.txtHaloWidth.getDouble());
        }
        return this.symbol;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.performAction) {
            boolean enableSize = this.rdBtnTextHeight.isSelected();
            this.incrTextSize.setEnabled(enableSize);
            this.units.setEnabled(enableSize);
            this.referenceSystem.setEnabled(enableSize);
            if (this.symbol != null) {
                this.symbol.setAutoresizeEnabled(this.rdBtnFitOnTextArea.isSelected());
                this.symbol.setFont(new Font((String)this.cmbFont.getSelectedItem(), 0, (int)this.incrTextSize.getDouble()));
                this.symbol.setTextColor(this.colorFont.getColor());
                this.symbol.setFontSize(this.incrTextSize.getDouble());
                this.symbol.setDrawWithHalo(this.chkWithHalo.isSelected());
                if (this.symbol.isDrawWithHalo()) {
                    this.symbol.setHaloColor(this.colorHaloChooser.getColor());
                    this.symbol.setHaloWidth((float)this.txtHaloWidth.getDouble());
                }
            }
            for (ActionListener l : this.listeners) {
                l.actionPerformed(new ActionEvent(this, 0, null));
            }
        }
    }

    public int getUnit() {
        return this.units.getSelectedUnitIndex();
    }

    public int getReferenceSystem() {
        return this.referenceSystem.getSelectedIndex();
    }
}

