/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JComboBoxFontSizes;
import org.gvsig.gui.beans.swing.JComboBoxFonts;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.symbol.CharacterMarkerSymbol;

public class CharacterMarker
extends AbstractTypeSymbolEditor
implements ActionListener {
    private ArrayList<JPanel> tabs = new ArrayList();
    private JList jListSymbols;
    private JScrollPane jScrollPane;
    private JComboBoxFonts cmbFonts;
    private JComboBoxFontSizes cmbFontSize;
    private JNumberSpinner numberAngle;
    private ColorChooserPanel jcc;
    private JNumberSpinner txtYOffset;
    private JNumberSpinner txtXOffset;
    private Font font;
    private int unicode;
    private JCheckBox chkAdjustGlyph;

    public CharacterMarker(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        JPanel myTab = new JPanel(new BorderLayout(10, 10));
        myTab.setName(Messages.getText((String)"character_marker"));
        myTab.setLayout(new BorderLayout(15, 15));
        JPanel aux = new JPanel(new BorderLayout(15, 15));
        aux.add((Component)new JLabel(Messages.getText((String)"font") + ":"), "North");
        aux.add((Component)this.getCmbFonts(), "North");
        this.getJListSymbols().setModel(new CharacterListModel(new Font((String)this.getCmbFonts().getSelectedItem(), 0, 14)));
        aux.add((Component)this.getJScrollPane(), "Center");
        myTab.add((Component)aux, "Center");
        GridBagLayoutPanel aux1 = new GridBagLayoutPanel();
        aux1.addComponent(Messages.getText((String)"size") + ":", (Component)this.getCmbFontSize());
        aux1.addComponent(Messages.getText((String)"angle") + ":", (Component)this.getNumberAngle());
        aux1.addComponent(Messages.getText((String)"color") + ":", (Component)this.getColorChooser());
        GridBagLayoutPanel aux2 = new GridBagLayoutPanel();
        aux2.addComponent("X:", (Component)this.getTxtXOffset());
        aux2.addComponent("Y:", (Component)this.getTxtYOffset());
        aux2.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"offset")));
        aux1.addComponent((Component)aux2);
        myTab.add((Component)aux1, "East");
        myTab.add((Component)this.getChkAdjustGlyph(), "South");
        this.tabs.add(myTab);
        this.jListSymbols.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CharacterMarker.this.fireSymbolChangedEvent();
            }
        });
    }

    private JCheckBox getChkAdjustGlyph() {
        if (this.chkAdjustGlyph == null) {
            this.chkAdjustGlyph = new JCheckBox(Messages.getText((String)"apply_visual_correction_to_glyph_for_precise_size_and_position"));
            this.chkAdjustGlyph.addActionListener(this);
        }
        return this.chkAdjustGlyph;
    }

    private JNumberSpinner getTxtYOffset() {
        if (this.txtYOffset == null) {
            this.txtYOffset = new JNumberSpinner(0, 7);
            this.txtYOffset.addActionListener((ActionListener)this);
        }
        return this.txtYOffset;
    }

    private JNumberSpinner getTxtXOffset() {
        if (this.txtXOffset == null) {
            this.txtXOffset = new JNumberSpinner(0, 7);
            this.txtXOffset.addActionListener((ActionListener)this);
        }
        return this.txtXOffset;
    }

    private ColorChooserPanel getColorChooser() {
        if (this.jcc == null) {
            this.jcc = new ColorChooserPanel();
            this.jcc.setAlpha(255);
            this.jcc.addActionListener((ActionListener)this);
        }
        return this.jcc;
    }

    private JComboBoxFontSizes getCmbFontSize() {
        if (this.cmbFontSize == null) {
            this.cmbFontSize = new JComboBoxFontSizes();
            this.cmbFontSize.addActionListener((ActionListener)this);
        }
        return this.cmbFontSize;
    }

    private JNumberSpinner getNumberAngle() {
        if (this.numberAngle == null) {
            this.numberAngle = new JNumberSpinner(0);
            this.numberAngle.addActionListener((ActionListener)this);
        }
        return this.numberAngle;
    }

    private JComboBoxFonts getCmbFonts() {
        if (this.cmbFonts == null) {
            this.cmbFonts = new JComboBoxFonts();
            this.cmbFonts.addActionListener((ActionListener)this);
        }
        return this.cmbFonts;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJListSymbols());
            this.jScrollPane.setPreferredSize(new Dimension(300, 180));
        }
        return this.jScrollPane;
    }

    private JList getJListSymbols() {
        if (this.jListSymbols == null) {
            this.jListSymbols = new JList();
            this.jListSymbols.setSelectionMode(0);
            this.jListSymbols.setLayoutOrientation(2);
            this.jListSymbols.setVisibleRowCount(-1);
            this.jListSymbols.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CharacterItem theChar = (CharacterItem)CharacterMarker.this.jListSymbols.getSelectedValue();
                    if (theChar == null) {
                        return;
                    }
                    CharacterMarker.this.font = theChar.font;
                    CharacterMarker.this.unicode = theChar.glyph;
                    CharacterMarker.this.fireSymbolChangedEvent();
                }
            });
            ListCellRenderer renderer = new ListCellRenderer(){
                private Color mySelectedBGColor = new Color(255, 145, 100, 255);

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    CharacterItem theChar = (CharacterItem)value;
                    CharacterMarkerSymbol sym = new CharacterMarkerSymbol(theChar.font, theChar.glyph, Color.BLACK);
                    JPanel pnl = new JPanel();
                    BoxLayout layout = new BoxLayout(pnl, 1);
                    pnl.setLayout(layout);
                    Color bgColor = isSelected ? this.mySelectedBGColor : CharacterMarker.this.getJListSymbols().getBackground();
                    pnl.setBackground(bgColor);
                    SymbolPreviewer sp = new SymbolPreviewer(true);
                    sp.setAlignmentX(0.5f);
                    int prevSize = 30;
                    sp.setPreferredSize(new Dimension(prevSize, prevSize));
                    sp.setSymbol((ISymbol)sym);
                    sp.setBackground(bgColor);
                    sym.setSize((double)prevSize * 0.8);
                    pnl.add((Component)sp);
                    JLabel lbl = new JLabel(sym.getDescription());
                    lbl.setBackground(bgColor);
                    lbl.setAlignmentX(0.5f);
                    pnl.add(lbl);
                    return pnl;
                }
            };
            this.jListSymbols.setCellRenderer(renderer);
        }
        return this.jListSymbols;
    }

    public String getName() {
        return Messages.getText((String)"character_marker_symbol");
    }

    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[0]);
    }

    public void refreshControls(ISymbol layer) {
        try {
            CharacterMarkerSymbol sym = (CharacterMarkerSymbol)layer;
            this.font = sym.getFont();
            this.unicode = sym.getUnicode();
            this.getTxtXOffset().setDouble(sym.getOffset().getX());
            this.getTxtYOffset().setDouble(-sym.getOffset().getY());
            this.getColorChooser().setColor(sym.getColor());
            this.getCmbFonts().setSelectedItem((Object)sym.getFont().getName());
            this.getCmbFontSize().setSelectedItem((Object)sym.getFont().getSize());
            this.getJListSymbols().setSelectedIndex(sym.getUnicode());
            this.getNumberAngle().setDouble(sym.getRotation() * 180.0 / Math.PI);
            this.getChkAdjustGlyph().setSelected(sym.isVisuallyCorrected());
        }
        catch (IndexOutOfBoundsException ioEx) {
            NotificationManager.addWarning((String)"Symbol layer index out of bounds", (Throwable)ioEx);
        }
        catch (ClassCastException ccEx) {
            NotificationManager.addWarning((String)ccEx.getMessage(), (Throwable)ccEx);
        }
    }

    public Class<? extends ISymbol> getSymbolClass() {
        return CharacterMarkerSymbol.class;
    }

    public ISymbol getLayer() {
        CharacterMarkerSymbol layer = new CharacterMarkerSymbol();
        if (this.font == null) {
            this.font = new Font((String)this.getCmbFonts().getSelectedItem(), 0, (int)this.getCmbFontSize().getSelectedValue());
        }
        layer.setFont(this.font);
        layer.setUnicode(this.unicode);
        layer.setColor(this.getColorChooser().getColor());
        layer.setSize(this.getCmbFontSize().getSelectedValue());
        layer.setOffset(new Point2D.Double(this.getTxtXOffset().getDouble(), -this.getTxtYOffset().getDouble()));
        layer.setRotation(this.getNumberAngle().getDouble() * Math.PI / 180.0);
        layer.setUnit(this.owner.getUnit());
        layer.setReferenceSystem(this.owner.getUnitsReferenceSystem());
        layer.setVisuallyCorrected(this.getChkAdjustGlyph().isSelected());
        return layer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.getCmbFonts())) {
            String fontName = (String)this.getCmbFonts().getSelectedItem();
            this.getJListSymbols().setModel(new CharacterListModel(new Font(fontName, 0, 10)));
            return;
        }
        this.fireSymbolChangedEvent();
    }

    public EditorTool[] getEditorTools() {
        return null;
    }

    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof CharacterMarkerSymbol;
    }

    private class CharacterItem {
        int glyph;
        Font font;

        public CharacterItem(Font font, int glyph) {
            this.font = font;
            this.glyph = glyph;
        }
    }

    private class CharacterListModel
    implements ListModel {
        private Font font;
        private ArrayList<ListDataListener> listeners;

        public CharacterListModel(Font font) {
            this.font = font;
        }

        @Override
        public int getSize() {
            return this.font.getNumGlyphs();
        }

        public Object getElementAt(int index) {
            return new CharacterItem(this.font, index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }
    }
}

