/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling.editortools;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.StyleEditor;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.i18n.Messages;

public class LabelStylePanTool
extends EditorTool {
    private int NO_SELECTION_ON_STYLE = -1;
    private int TEXT_FIELD_SELECTED = 0;
    private int MARKER_POINT_SELECTED = 1;
    private JToggleButton btnPan;
    private Cursor cursor;
    private Point pIni;
    private Point pEnd;
    private ILabelStyle style;
    private int toolSelected = this.NO_SELECTION_ON_STYLE;
    private int textFieldSelected = this.NO_SELECTION_ON_STYLE;
    private Dimension bounds;
    private int ownerHgap;
    private int ownerVgap;

    public LabelStylePanTool(JComponent owner) {
        super(owner);
    }

    private void getBounds() {
        this.bounds = ((StyleEditor)this.owner).getStylePreviewer().getSize();
        this.ownerHgap = ((StyleEditor)this.owner).getStylePreviewer().getHGap();
        this.ownerVgap = ((StyleEditor)this.owner).getStylePreviewer().getVGap();
    }

    public Cursor getCursor() {
        if (this.cursor == null) {
            ImageIcon cursorImage = IconThemeHelper.getImageIcon((String)"cursor-pan");
            this.cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage.getImage(), new Point(cursorImage.getIconWidth() / 2, cursorImage.getIconHeight() / 2), "");
        }
        return this.cursor;
    }

    public void mousePressed(MouseEvent e) {
        this.getBounds();
        Point2D marker = this.style.getMarkerPoint();
        this.pIni = new Point((int)(marker.getX() * (double)(this.bounds.width - this.ownerHgap)), (int)(marker.getY() * (double)(this.bounds.height - this.ownerVgap)));
        this.pEnd = e.getPoint();
        Point selectedPoint = new Point((int)(this.pEnd.getX() - (double)this.ownerHgap), (int)(this.pEnd.getY() - (double)this.ownerVgap));
        if (Math.abs(this.pIni.x - selectedPoint.x) < this.ownerHgap && Math.abs(this.pIni.y - selectedPoint.y) < this.ownerVgap) {
            this.toolSelected = this.MARKER_POINT_SELECTED;
            return;
        }
        Point2D selPoint = this.screenPointToLabelPoint(this.pEnd);
        for (int i = this.style.getTextBounds().length - 1; i >= 0; --i) {
            Rectangle2D rectangle = this.style.getTextBounds()[i];
            if (!(selPoint.getX() >= rectangle.getMinX()) || !(selPoint.getX() <= rectangle.getMaxX()) || !(selPoint.getY() >= rectangle.getMinY()) || !(selPoint.getY() <= rectangle.getMaxY())) continue;
            this.toolSelected = this.TEXT_FIELD_SELECTED;
            this.textFieldSelected = i;
            this.pIni = this.pEnd;
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.toolSelected = this.NO_SELECTION_ON_STYLE;
        this.textFieldSelected = this.NO_SELECTION_ON_STYLE;
    }

    public void mouseDragged(MouseEvent e) {
        this.pEnd = e.getPoint();
        if (this.pEnd.getX() > (double)(this.bounds.width - this.ownerHgap) || this.pEnd.getY() > this.bounds.getHeight() - (double)this.ownerVgap || this.pEnd.getX() < (double)this.ownerHgap || this.pEnd.getY() < (double)this.ownerVgap) {
            return;
        }
        Point2D labelEndPoint = this.screenPointToLabelPoint(this.pEnd);
        if (this.toolSelected == this.TEXT_FIELD_SELECTED) {
            if (this.textFieldSelected != this.NO_SELECTION_ON_STYLE) {
                double y;
                Rectangle2D rectangle = this.style.getTextBounds()[this.textFieldSelected];
                Point2D labelIniPoint = this.screenPointToLabelPoint(this.pIni);
                Point maxPoint = new Point((int)this.bounds.getWidth(), (int)this.bounds.getHeight());
                Point2D labelMaxPoint = this.screenPointToLabelPoint(maxPoint);
                Point2D labelZero = this.screenPointToLabelPoint(new Point(0, 0));
                double x = rectangle.getX() + labelEndPoint.getX() - labelIniPoint.getX();
                if (x < labelZero.getX()) {
                    x = labelZero.getX();
                }
                if (x + rectangle.getWidth() >= labelMaxPoint.getX()) {
                    x = labelMaxPoint.getX() - rectangle.getWidth();
                }
                if ((y = rectangle.getY() + labelEndPoint.getY() - labelIniPoint.getY()) < labelZero.getY()) {
                    y = labelZero.getY();
                }
                if (y + rectangle.getHeight() >= labelMaxPoint.getY()) {
                    y = labelMaxPoint.getY() - rectangle.getHeight();
                }
                rectangle.setRect(x, y, rectangle.getWidth(), rectangle.getHeight());
                this.style.setTextFieldArea(this.textFieldSelected, rectangle);
                this.pIni = this.pEnd;
            }
        } else if (this.toolSelected == this.MARKER_POINT_SELECTED) {
            double xOffset = this.pEnd.getX() / (this.bounds.getWidth() - (double)this.ownerHgap);
            double yOffset = this.pEnd.getY() / (this.bounds.getHeight() - (double)this.ownerVgap);
            if (xOffset > 1.0) {
                xOffset = 1.0;
            }
            if (xOffset < 0.0) {
                xOffset = 0.0;
            }
            if (yOffset > 1.0) {
                yOffset = 1.0;
            }
            if (yOffset < 0.0) {
                yOffset = 0.0;
            }
            Point2D marker = this.style.getMarkerPoint();
            marker.setLocation(xOffset, yOffset);
        }
        this.owner.repaint();
    }

    private Point2D screenPointToLabelPoint(Point pIni) {
        Point2D.Double p;
        int minx = pIni.x;
        int miny = pIni.y;
        StylePreviewer sp = ((StyleEditor)this.owner).getStylePreviewer();
        Dimension bounds = sp.getSize();
        IStyle style = sp.getStyle();
        Dimension backgroundBounds = null;
        if (style instanceof ILabelStyle) {
            backgroundBounds = ((ILabelStyle)style).getSize();
        }
        if (backgroundBounds == null) {
            p = new Point2D.Double((double)pIni.x / (bounds.getWidth() - (double)(sp.getHGap() / 2)), (double)pIni.y / (bounds.getHeight() - (double)(sp.getVGap() / 2)));
        } else {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double scale = 1.0;
            if (backgroundBounds.getWidth() > backgroundBounds.getHeight()) {
                scale = (bounds.getWidth() - (double)sp.getHGap()) / backgroundBounds.getWidth();
                yOffset = 0.5 * (bounds.getHeight() - (double)sp.getVGap() - backgroundBounds.getHeight() * scale);
            } else {
                scale = (bounds.getHeight() - (double)sp.getVGap()) / backgroundBounds.getHeight();
                xOffset = 0.5 * (bounds.getWidth() - (double)sp.getHGap() - backgroundBounds.getWidth() * scale);
            }
            p = new Point2D.Double(((double)(minx - sp.getHGap() / 2) - xOffset) / scale / backgroundBounds.getWidth(), ((double)(miny - sp.getVGap() / 2) - yOffset) / scale / backgroundBounds.getHeight());
        }
        return p;
    }

    public AbstractButton getButton() {
        return this.getBtnPan();
    }

    private JToggleButton getBtnPan() {
        if (this.btnPan == null) {
            this.btnPan = new JToggleButton(IconThemeHelper.getImageIcon((String)"edit-shift-component"));
            this.btnPan.setToolTipText(Messages.getText((String)"_Set_label_offset"));
            this.btnPan.setPreferredSize(EditorTool.SMALL_BTN_SIZE);
            this.btnPan.setSize(EditorTool.SMALL_BTN_SIZE);
        }
        return this.btnPan;
    }

    public String getID() {
        return "1";
    }

    public boolean isSuitableFor(Object obj) {
        return obj instanceof ILabelStyle;
    }

    public void setModel(Object objectToBeEdited) {
        this.style = (ILabelStyle)objectToBeEdited;
    }
}

