/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.label;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.labeling.lang.EvaluatorCreator;
import org.gvsig.labeling.lang.LabelClassUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.AndEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureDependentLabeled
implements ILabelingMethod {
    public static final String FEATURE_DEP_LABELED_PERSISTENCE_NAME = "FEATURE_DEP_LABELED_PERSISTENCE_NAME";
    private static Logger logger = LoggerFactory.getLogger(FeatureDependentLabeled.class);
    private boolean flagDefinesPriorities;
    private List<ILabelClass> classes = new ArrayList<ILabelClass>();

    public void addLabelClass(ILabelClass lbl) throws IllegalArgumentException {
        if (this.getLabelClassByName(lbl.getName()) != null) {
            throw new IllegalArgumentException("A class with the same name already exists!");
        }
        this.classes.add(lbl);
    }

    public void deleteLabelClass(ILabelClass lbl) {
        this.classes.remove(lbl);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public ILabelClass[] getLabelClasses() {
        return this.classes.toArray(new ILabelClass[0]);
    }

    public boolean allowsMultipleClass() {
        return true;
    }

    public void renameLabelClass(ILabelClass lbl, String newName) {
        ILabelClass label = this.classes.get(this.classes.indexOf(lbl));
        label.setName(newName);
    }

    public FeatureSet getFeatureIteratorByLabelClass(FLyrVect layer, ILabelClass lc, ViewPort viewPort, String[] usedFields) throws DataException {
        Envelope vp_env = viewPort.getAdjustedEnvelope();
        IProjection ipro = layer.getProjection();
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(vp_env, ipro, layer.getFeatureStore());
        FeatureStore fsto = layer.getFeatureStore();
        FeatureQuery fq = fsto.createFeatureQuery();
        if (usedFields != null) {
            fq.setAttributeNames(usedFields);
        }
        if (!LabelClassUtils.isUseSqlQuery(lc)) {
            fq.addFilter(iee);
            return fsto.getFeatureSet(fq);
        }
        String sql_str = lc.getSQLQuery();
        if (!LabelClassUtils.validExpression(sql_str, fsto, true)) {
            logger.warn("SQL for labeling exists but is not valid: " + sql_str);
        }
        EvaluatorWithDescriptions eval = EvaluatorCreator.getEvaluator(sql_str);
        AndEvaluator and_ev = new AndEvaluator(iee);
        and_ev.addEvaluator((Evaluator)eval);
        fq.addFilter((Evaluator)and_ev);
        return fsto.getFeatureSet(fq);
    }

    public boolean definesPriorities() {
        return this.flagDefinesPriorities;
    }

    public void setDefinesPriorities(boolean flag) {
        if (!flag) {
            ILabelClass[] lcs = this.getLabelClasses();
            for (int i = 0; i < lcs.length; ++i) {
                lcs[i].setPriority(0);
            }
        }
        this.flagDefinesPriorities = flag;
    }

    public void clearAllClasses() {
        this.classes.clear();
    }

    public ILabelClass getLabelClassByName(String labelName) {
        ILabelClass[] classes = this.getLabelClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(labelName)) continue;
            return classes[i];
        }
        return null;
    }

    public ILabelingMethod cloneMethod() {
        ILabelingMethod resp = (ILabelingMethod)LabelClassUtils.clone((Persistent)this);
        return resp;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(FEATURE_DEP_LABELED_PERSISTENCE_NAME) == null) {
            DynStruct definition = manager.addDefinition(FeatureDependentLabeled.class, FEATURE_DEP_LABELED_PERSISTENCE_NAME, "FEATURE_DEP_LABELED_PERSISTENCE_NAME Persistence definition", null, null);
            definition.addDynFieldBoolean("definesPriorities").setMandatory(true);
            definition.addDynFieldList("classes").setClassOfItems(ILabelClass.class).setMandatory(true);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDefinesPriorities(state.getBoolean("definesPriorities"));
        List aux = state.getList("classes");
        ILabelClass item = null;
        Iterator iter = aux.iterator();
        try {
            while (iter.hasNext()) {
                item = (ILabelClass)iter.next();
                this.addLabelClass(item);
            }
        }
        catch (IllegalArgumentException exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("definesPriorities", this.flagDefinesPriorities);
        state.set("classes", this.classes);
    }
}

