/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.label;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelLocationMetrics;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.labeling.symbol.SmartTextSymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartTextSymbolLabelClass
extends AbstractCartographicSupport
implements ILabelClass {
    private static Logger logger = LoggerFactory.getLogger(SmartTextSymbolLabelClass.class);
    public static final String SMART_LABEL_CLASS_PERSISTENCE_DEFINITION_NAME = "Smart LabelClass";
    private ILabelClass defLabelClass = SymbologyLocator.getSymbologyManager().createDefaultLabel();
    private SmartTextSymbol smartTextSymbol;

    public void draw(Graphics2D graphics, ILabelLocationMetrics llm, Geometry geo) {
        this.getTextSymbol().draw(graphics, null, geo, null, null);
    }

    public void drawInsideRectangle(Graphics2D graphics, Rectangle bounds) throws SymbolDrawingException {
        this.getTextSymbol().drawInsideRectangle(graphics, null, bounds);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public ILabelStyle getLabelStyle() {
        return null;
    }

    public ITextSymbol getTextSymbol() {
        if (this.smartTextSymbol == null) {
            this.smartTextSymbol = new SmartTextSymbol();
        }
        return this.smartTextSymbol;
    }

    public void setLabelStyle(ILabelStyle labelStyle) {
    }

    public void setTextSymbol(ITextSymbol textSymbol) {
        if (textSymbol instanceof SmartTextSymbol) {
            this.smartTextSymbol = (SmartTextSymbol)textSymbol;
        } else {
            logger.error("While setting text symbol in label class", (Throwable)new Exception("Text symbol must be a SmartTextSymbol here"));
        }
        this.defLabelClass.setTextSymbol(textSymbol);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.defLabelClass.loadFromState(state);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        this.defLabelClass.saveToState(state);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(SMART_LABEL_CLASS_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(SmartTextSymbolLabelClass.class, SMART_LABEL_CLASS_PERSISTENCE_DEFINITION_NAME, "Smart LabelClass Persistence definition", null, null);
            definition.extend(manager.getDefinition("LabelClass"));
        }
    }

    public boolean isVisible() {
        return this.defLabelClass.isVisible();
    }

    public boolean isVisible(double scale) {
        return this.isVisible();
    }

    public void setVisible(boolean isVisible) {
        this.defLabelClass.setVisible(isVisible);
    }

    public String getName() {
        return this.defLabelClass.getName();
    }

    public void setName(String name) {
        this.defLabelClass.setName(name);
    }

    public void setTexts(String[] texts) {
        this.defLabelClass.setTexts(texts);
    }

    public String[] getTexts() {
        return this.defLabelClass.getTexts();
    }

    public int getPriority() {
        return this.defLabelClass.getPriority();
    }

    public void setPriority(int priority) {
        this.defLabelClass.setPriority(priority);
    }

    public Geometry getShape(ILabelLocationMetrics llm) throws CreateGeometryException {
        return this.defLabelClass.getShape(llm);
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        super.setCartographicContext(ctx);
        this.defLabelClass.setCartographicContext(ctx);
    }

    public Rectangle getBounds() {
        return this.defLabelClass.getBounds();
    }

    public String getSQLQuery() {
        return this.defLabelClass.getSQLQuery();
    }

    public void setSQLQuery(String sqlQuery) {
        this.defLabelClass.setSQLQuery(sqlQuery);
    }

    public String[] getLabelExpressions() {
        return this.defLabelClass.getLabelExpressions();
    }

    public void setLabelExpressions(String[] lbl_exps) {
        this.defLabelClass.setLabelExpressions(lbl_exps);
    }

    public void setUseSqlQuery(boolean use_sql) {
        this.defLabelClass.setUseSqlQuery(use_sql);
    }

    public boolean isUseSqlQuery() {
        return this.defLabelClass.isUseSqlQuery();
    }

    public String getStringLabelExpression() {
        return this.defLabelClass.getStringLabelExpression();
    }

    public Object clone() throws CloneNotSupportedException {
        PersistenceManager persman = ToolsLocator.getPersistenceManager();
        PersistentContext context = null;
        Object resp = null;
        PersistentState state = null;
        try {
            state = persman.getState((Object)this, true);
        }
        catch (PersistenceException e) {
            logger.warn("Can't clone, return me !!!!!!!!!!!!!!", (Throwable)e);
            return this;
        }
        context = state.getContext();
        if (context instanceof PersistentContextServices) {
            ((PersistentContextServices)context).clear();
        }
        try {
            resp = persman.create(state);
        }
        catch (Exception e) {
            logger.warn("Can't clone, return me !!!!!!!!!!!!!!", (Throwable)e);
            return this;
        }
        return resp;
    }
}

