/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.lang;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.labeling.lang.EvaluatorCreator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelClassUtils {
    private static Logger logger = LoggerFactory.getLogger(LabelClassUtils.class);
    private static PersistenceManager persman = ToolsLocator.getPersistenceManager();

    public static boolean isUseSqlQuery(ILabelClass lbl) {
        String str = lbl.getSQLQuery();
        return str != null && str.trim().length() > 0;
    }

    public static Object clone(Persistent persi) {
        PersistentContext context = null;
        Object resp = null;
        PersistentState state = null;
        try {
            state = persman.getState((Object)persi, true);
        }
        catch (PersistenceException e) {
            logger.error("While cloning ILabelClass", (Throwable)e);
            return persi;
        }
        context = state.getContext();
        if (context instanceof PersistentContextServices) {
            ((PersistentContextServices)context).clear();
        }
        try {
            resp = persman.create(state);
        }
        catch (Exception e) {
            logger.error("While cloning ILabelClass", (Throwable)e);
            return persi;
        }
        return resp;
    }

    public static Object evaluate(String expr, EvaluatorData data) {
        EvaluatorWithDescriptions ev = EvaluatorCreator.getEvaluator(expr);
        Object resp_obj = null;
        try {
            resp_obj = ev.evaluate(data);
        }
        catch (EvaluatorException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return resp_obj;
    }

    public static boolean validExpression(String str, FeatureStore sto, boolean must_be_boolean) {
        EditableFeature dummyfeat = null;
        try {
            dummyfeat = sto.createNewFeature(true);
        }
        catch (DataException e1) {
            logger.warn("While getting dummy feature in labeling expression.", (Throwable)e1);
            return false;
        }
        EvaluatorWithDescriptions evde = EvaluatorCreator.getEvaluator(str);
        Object resp_obj = null;
        try {
            resp_obj = evde.evaluate(dummyfeat.getEvaluatorData());
        }
        catch (EvaluatorException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
        if (must_be_boolean) {
            return resp_obj.getClass() == Boolean.class;
        }
        return true;
    }
}

