/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.geom.PathLength;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.AbstractLinePlacement;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinePlacementAtExtremities
extends AbstractLinePlacement {
    private static Logger logger = LoggerFactory.getLogger(LinePlacementAtExtremities.class);

    @Override
    public LabelLocationMetrics initialLocation(ILabelClass lc, IPlacementConstraints pc, PathLength pathLen, Cancellable cancel) {
        if (cancel.isCanceled()) {
            return null;
        }
        float distance = 0.0f;
        if (pc.isAtTheEndOfLine()) {
            distance = pathLen.lengthOfPath();
        }
        Point2D p = pathLen.pointAtLength(distance);
        double theta = 0.0;
        if (pc.isParallel()) {
            theta = pathLen.angleAtLength(distance);
        } else if (pc.isPerpendicular()) {
            theta = (double)pathLen.angleAtLength(distance) + 1.5707963267948966;
        }
        double x = p.getX();
        double y = p.getY();
        double halfHeight = lc.getBounds().getHeight() * 0.5;
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double xOffset = halfHeight * sinTheta;
        double yOffset = halfHeight * cosTheta;
        if (pc.isAtTheEndOfLine()) {
            double width = lc.getBounds().getWidth();
            xOffset -= width * cosTheta;
            yOffset += width * sinTheta;
        }
        p.setLocation(x + xOffset, y - yOffset);
        return new LabelLocationMetrics(p, theta, true);
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(2, shapeType) || geomManager.isSubtype(8, shapeType)) {
            return placementConstraints != null && (placementConstraints.isAtTheBeginingOfLine() || placementConstraints.isAtTheEndOfLine());
        }
        return false;
    }
}

