/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.labeling.placements.CannotPlaceLabel;
import org.gvsig.labeling.placements.ILabelPlacement;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelLocationMetrics;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerPlacementOnPoint
implements ILabelPlacement {
    private Logger logger = LoggerFactory.getLogger(MarkerPlacementOnPoint.class);

    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry shp, IPlacementConstraints placementConstraints, double cartographicSymbolSize, Cancellable cancel) {
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        ArrayList<LabelLocationMetrics> guessed = new ArrayList<LabelLocationMetrics>();
        Point cen = null;
        try {
            cen = shp.centroid();
        }
        catch (Exception ex) {
            this.logger.error("While getting centroid", (Throwable)ex);
        }
        Point2D.Double p = new Point2D.Double(cen.getX(), cen.getY());
        Rectangle bounds = lc.getBounds();
        ((Point2D)p).setLocation(((Point2D)p).getX() - ((RectangularShape)bounds).getWidth() * 0.5, ((Point2D)p).getY() - ((RectangularShape)bounds).getHeight() * 0.5);
        guessed.add(new LabelLocationMetrics((Point2D)p, 0.0, true));
        return guessed;
    }

    @Override
    public ArrayList<LabelLocationMetrics> guess(ILabelClass lc, Geometry geom, IPlacementConstraints placementConstraints, double cartographicSymbolSize, Cancellable cancel, ViewPort vp) {
        if (cancel.isCanceled()) {
            return CannotPlaceLabel.NO_PLACES;
        }
        Geometry shp = geom.cloneGeometry();
        shp.transform(vp.getAffineTransform());
        ArrayList<LabelLocationMetrics> guessed = new ArrayList<LabelLocationMetrics>();
        Point cen = null;
        try {
            cen = shp.centroid();
        }
        catch (Exception ex) {
            this.logger.error("While getting centroid", (Throwable)ex);
        }
        Point2D.Double p = new Point2D.Double(cen.getX(), cen.getY());
        Rectangle bounds = lc.getBounds();
        ((Point2D)p).setLocation(((Point2D)p).getX() - ((RectangularShape)bounds).getWidth() * 0.5, ((Point2D)p).getY() - ((RectangularShape)bounds).getHeight() * 0.5);
        guessed.add(new LabelLocationMetrics((Point2D)p, 0.0, true));
        return guessed;
    }

    @Override
    public boolean isSuitableFor(IPlacementConstraints placementConstraints, int shapeType) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(1, shapeType)) {
            return placementConstraints != null && placementConstraints.isOnTopOfThePoint();
        }
        return false;
    }
}

