/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.placements;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointLabelPositioner
extends AbstractStyle {
    private static Logger logger = LoggerFactory.getLogger(PointLabelPositioner.class);
    public static final String POINT_LABEL_POSITIONER_PERSISTENCE_NAME = "POINT_LABEL_POSITIONER_PERSISTENCE_NAME";
    private static Geometry sampleGeometry = null;
    private int[] preferenceVector = new int[8];
    private static final Color[] colorVector = new Color[]{new Color(140, 140, 140), new Color(140, 245, 130), new Color(130, 170, 245), new Color(100, 100, 255)};
    public static final byte FORBIDDEN = 0;
    public static final byte PREFERENCE_HIGH = 1;
    public static final byte PREFERENCE_NORMAL = 2;
    public static final byte PREFERENCE_LOW = 3;

    public PointLabelPositioner() {
    }

    public PointLabelPositioner(int[] preferenceVector, String description) {
        this.preferenceVector = preferenceVector;
        this.setDescription(description);
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle r) {
        int size = Math.min(r.width, r.height) / 3;
        int j = -1;
        int fontSize = (int)((double)size * 0.8);
        Font font = new Font("Arial", 0, fontSize);
        RenderingHints old = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            int value = Math.abs(this.preferenceVector[++j] % colorVector.length);
            int col = i % 3;
            int row = i / 3;
            g.setColor(colorVector[value]);
            g.fillRect(size * col, size * row, size, size);
            g.setColor(Color.BLACK);
            g.drawRect(size * col, size * row, size, size);
            g.setFont(font);
            g.drawString(String.valueOf(value), (float)(size / 2 - fontSize / 4) + (float)(size * col), (float)((double)size * 0.8) + (float)(size * row));
        }
        g.setRenderingHints(old);
    }

    public boolean isSuitableFor(ISymbol sym) {
        return sym.isSuitableFor(PointLabelPositioner.getSampleGeometry());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.preferenceVector = state.getIntArray("preferenceVector");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("preferenceVector", this.preferenceVector);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(POINT_LABEL_POSITIONER_PERSISTENCE_NAME) == null) {
            DynStruct definition = manager.addDefinition(PointLabelPositioner.class, POINT_LABEL_POSITIONER_PERSISTENCE_NAME, "POINT_LABEL_POSITIONER_PERSISTENCE_NAME Persistence definition", null, null);
            definition.extend(manager.getDefinition("Style"));
            definition.addDynFieldArray("preferenceVector").setClassOfItems(Integer.TYPE).setMandatory(true);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void drawOutline(Graphics2D g, Rectangle r) {
        this.drawInsideRectangle(g, r);
    }

    public int[] getPreferenceVector() {
        return this.preferenceVector;
    }

    private static Geometry getSampleGeometry() {
        if (sampleGeometry == null) {
            try {
                sampleGeometry = GeometryLocator.getGeometryManager().createPoint(0.0, 0.0, 0);
            }
            catch (Exception e) {
                logger.error("While getting sample geometry.", (Throwable)e);
            }
        }
        return sampleGeometry;
    }
}

