/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.symbol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.labeling.placements.PointPlacementConstraints;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.TextPath;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartTextSymbol
extends AbstractSymbol
implements ISimpleTextSymbol {
    private static final Logger logger = LoggerFactory.getLogger(SmartTextSymbol.class);
    public static final String SMART_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SMART_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME";
    private static final String FIELD_UNIT = "unit";
    private static final String FIELD_REFERENCE_SYSTEM = "referenceSystem";
    private static final String FIELD_IS_SHAPE_VISIBLE = "isShapeVisible";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_TEXT = "text";
    private static final String FIELD_FONT = "font";
    private static final String FIELD_TEXT_COLOR = "textColor";
    private static final String FIELD_ROTATION = "rotation";
    private static final String FIELD_AUTO_RESIZE = "autoResize";
    private static final String FIELD_HAS_HALO = "hasHalo";
    private static final String FIELD_HALO_COLOR = "haloColor";
    private static final String FIELD_HALO_WIDTH = "haloWidth";
    private static GeometryManager geoman = GeometryLocator.getGeometryManager();
    private String text;
    private FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, true);
    private double characterSpacing;
    private double characterWidth;
    private double leading;
    private double wordSpacing;
    private boolean rightToLeft;
    private double margin;
    private int alignment;
    private boolean kerning = false;
    private TextPath tp;
    private final IPlacementConstraints constraints;
    private double rotation = 0.0;
    private Color textColor = Color.BLACK;
    private Font font;
    private boolean autoresize = false;
    private boolean hasHalo = false;
    private Color haloColor = Color.WHITE;
    private float haloWidth = 3.0f;
    private BasicStroke haloStroke = new BasicStroke(6.0f, 1, 1);

    public SmartTextSymbol(ITextSymbol sym, IPlacementConstraints constraints) {
        this.setAutoresizeEnabled(sym.isAutoresizeEnabled());
        this.setDescription(sym.getDescription());
        this.setFont(sym.getFont());
        this.setFontSize(sym.getFont().getSize());
        this.setIsShapeVisible(sym.isShapeVisible());
        this.setText(sym.getText());
        this.setTextColor(sym.getTextColor());
        this.setDrawWithHalo(sym.isDrawWithHalo());
        this.setHaloColor(sym.getHaloColor());
        this.setHaloWidth(sym.getHaloWidth());
        this.constraints = constraints;
        this.setCharacterSpacing(2.0);
        this.setWordSpacing(-2.147483648E9);
        boolean rtl = false;
        if (constraints.isAtTheBeginingOfLine()) {
            if (rtl) {
                this.setAlignment(95);
            } else {
                this.setAlignment(94);
            }
        } else if (constraints.isAtTheEndOfLine()) {
            if (rtl) {
                this.setAlignment(94);
            } else {
                this.setAlignment(95);
            }
        } else {
            this.setAlignment(96);
        }
        this.setKerning(false);
        this.setRightToLeft(rtl);
    }

    public SmartTextSymbol() {
        PointPlacementConstraints pc = new PointPlacementConstraints();
        this.constraints = pc;
        SymbolPreferences preferences = MapContextLocator.getSymbolManager().getSymbolPreferences();
        this.font = preferences.getDefaultSymbolFont();
        this.textColor = preferences.getDefaultSymbolColor();
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel) {
        this.draw(g, affineTransform, geom, f, cancel, null);
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        if (!this.isShapeVisible()) {
            return;
        }
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        this.setMargin(0.0);
        if (StringUtils.isEmpty((CharSequence)this.text)) {
            return;
        }
        char[] text_chars = this.text.toCharArray();
        this.tp = new TextPath(g, geom, text_chars, this.getFont(), (float)this.characterSpacing, (float)this.characterWidth, this.kerning, (float)this.leading, this.alignment, (float)this.wordSpacing, (float)this.margin, this.rightToLeft);
        Font font = this.getFont();
        g.setFont(font);
        FontRenderContext frc = g.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics(this.getText(), frc);
        double cons = 0.0;
        if (this.constraints.isAboveTheLine()) {
            cons = lineMetrics.getDescent() + lineMetrics.getLeading() / 2.0f;
        } else if (this.constraints.isBelowTheLine()) {
            cons = -(lineMetrics.getAscent() + lineMetrics.getLeading() / 2.0f);
        } else if (this.constraints.isOnTheLine()) {
            cons = lineMetrics.getDescent() + lineMetrics.getLeading() - lineMetrics.getHeight() / 2.0f;
        }
        double[] coords = null;
        for (int i = 0; i < this.tp.getGlyphCount(); ++i) {
            coords = this.tp.nextPosForGlyph(i);
            if (coords[0] == -2.147483648E9 || coords[1] == -2.147483648E9) continue;
            double xOffset = cons * Math.sin(coords[2]);
            double yOffset = cons * Math.cos(coords[2]);
            g.translate(coords[0] + xOffset, coords[1] - yOffset);
            g.rotate(coords[2]);
            char[] aux = new char[]{text_chars[i]};
            if (this.isDrawWithHalo()) {
                GlyphVector glyph = font.createGlyphVector(frc, aux);
                Shape outlineChar = glyph.getOutline();
                g.setStroke(this.haloStroke);
                g.setColor(this.getHaloColor());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.draw(outlineChar);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g.setColor(this.getTextColor());
            g.drawString(String.valueOf(text_chars[i]), 0, 0);
            g.rotate(-coords[2]);
            g.translate(-coords[0] - xOffset, -coords[1] + yOffset);
        }
    }

    public void getPixExtentPlus(Geometry shp, float[] distances, ViewPort viewPort, int dpi) {
        distances[0] = 0.0f;
        distances[1] = 0.0f;
    }

    public int getOnePointRgb() {
        return this.getTextColor().getRGB();
    }

    public int getSymbolType() {
        return 0;
    }

    public boolean isSuitableFor(Geometry geom) {
        return geom.getGeometryType().isTypeOf(2);
    }

    public Geometry getSampleGeometry(Rectangle r) {
        Surface surf = null;
        try {
            surf = geoman.createSurface(0);
        }
        catch (CreateGeometryException e) {
            logger.warn("Error while creating surface.", (Throwable)e);
            throw new RuntimeException("Can't create sample geometry.", e);
        }
        surf.addVertex(r.getX(), r.getY());
        surf.addVertex(r.getX() + r.getWidth(), r.getY());
        return surf;
    }

    public void drawInsideRectangle(Graphics2D g, AffineTransform scaleInstance, Rectangle r) throws SymbolDrawingException {
        this.draw(g, scaleInstance, null, null, null, r);
    }

    public void setText(String txt) {
        this.text = txt;
    }

    public String getText() {
        return this.text;
    }

    public void setCharacterSpacing(double charSpacing) {
        this.characterSpacing = charSpacing;
    }

    public void setWordSpacing(double wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setKerning(boolean kerning) {
        this.kerning = kerning;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public void setRightToLeft(boolean rightToLeft) {
        this.rightToLeft = rightToLeft;
    }

    public ISymbol getSymbolForSelection() {
        return this;
    }

    public boolean isOneDotOrPixel(Geometry geom, double[] positionOfDotOrPixel, ViewPort viewPort, int dpi) {
        boolean onePoint;
        int type = geom.getType();
        switch (type) {
            case 1: 
            case 7: 
            case 16: {
                return false;
            }
        }
        Envelope geomBounds = geom.getEnvelope();
        double dist1Pixel = viewPort.getDist1pixel();
        float[] distances = new float[2];
        this.getPixExtentPlus(geom, distances, viewPort, dpi);
        boolean bl = onePoint = geomBounds.getLength(0) + (double)distances[0] <= dist1Pixel && geomBounds.getLength(1) + (double)distances[1] <= dist1Pixel;
        if (onePoint) {
            positionOfDotOrPixel[0] = geomBounds.getMinimum(0);
            positionOfDotOrPixel[1] = geomBounds.getMinimum(1);
        }
        return onePoint;
    }

    public Color getColor() {
        return this.getTextColor();
    }

    public void setColor(Color color) {
        this.setTextColor(color);
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.draw(g, at, geom, null, null, null);
    }

    public void setFont(Font fnt) {
        this.font = fnt;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setFontSize(double d) {
        Font newFont;
        this.font = newFont = new Font(this.font.getName(), this.font.getStyle(), Math.round((float)d));
    }

    public Geometry getTextWrappingShape(Point p) {
        Font font = this.getFont();
        GlyphVector gv = font.createGlyphVector(this.frc, this.text);
        Shape shape = gv.getOutline((float)p.getX(), (float)p.getY());
        try {
            Surface myFShape = geoman.createSurface(new GeneralPathX(shape.getBounds2D().getPathIterator(null)), 0);
            myFShape.transform(AffineTransform.getTranslateInstance(p.getX(), p.getY()));
            if (this.rotation != 0.0) {
                myFShape.transform(AffineTransform.getRotateInstance(this.rotation));
            }
            return myFShape;
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a surface", (Throwable)e);
            return null;
        }
    }

    public Rectangle getBounds() {
        Rectangle bounds = null;
        try {
            Geometry aux = this.getTextWrappingShape(geoman.createPoint(0.0, 0.0, 0));
            Envelope env = aux.getEnvelope();
            bounds = new Rectangle((int)env.getMinimum(0), (int)env.getMinimum(1), (int)env.getLength(0), (int)env.getLength(1));
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a point", (Throwable)e);
        }
        return bounds;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rot) {
        this.rotation = rot;
    }

    public void setAutoresizeEnabled(boolean ar) {
        this.autoresize = ar;
    }

    public boolean isAutoresizeEnabled() {
        return this.autoresize;
    }

    public Color getHaloColor() {
        return this.haloColor;
    }

    public void setHaloColor(Color co) {
        this.haloColor = co;
    }

    public float getHaloWidth() {
        return this.haloWidth;
    }

    public void setHaloWidth(float w) {
        this.haloWidth = w;
        this.haloStroke = new BasicStroke(2.0f * this.haloWidth, 1, 1);
    }

    public boolean isDrawWithHalo() {
        return this.hasHalo;
    }

    public void setDrawWithHalo(boolean h) {
        this.hasHalo = h;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(SMART_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(SmartTextSymbol.class, SMART_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SMART_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME Persistence definition", null, null);
            definition.addDynFieldString(FIELD_DESCRIPTION).setMandatory(true);
            definition.addDynFieldBoolean(FIELD_IS_SHAPE_VISIBLE).setMandatory(true);
            definition.addDynFieldInt(FIELD_REFERENCE_SYSTEM).setMandatory(true);
            definition.addDynFieldInt(FIELD_UNIT).setMandatory(true);
            definition.addDynFieldBoolean(FIELD_AUTO_RESIZE).setMandatory(true);
            definition.addDynFieldObject(FIELD_FONT).setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldDouble(FIELD_ROTATION).setMandatory(true);
            definition.addDynFieldString(FIELD_TEXT).setMandatory(true);
            definition.addDynFieldObject(FIELD_TEXT_COLOR).setClassOfValue(Color.class).setMandatory(true);
            definition.addDynFieldBoolean(FIELD_HAS_HALO).setMandatory(true);
            definition.addDynFieldObject(FIELD_HALO_COLOR).setClassOfValue(Color.class).setMandatory(true);
            definition.addDynFieldFloat(FIELD_HALO_WIDTH).setMandatory(true);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDescription(state.getString(FIELD_DESCRIPTION));
        this.setIsShapeVisible(state.getBoolean(FIELD_IS_SHAPE_VISIBLE));
        this.setReferenceSystem(state.getInt(FIELD_REFERENCE_SYSTEM));
        this.setUnit(state.getInt(FIELD_UNIT));
        this.setAutoresizeEnabled(state.getBoolean(FIELD_AUTO_RESIZE));
        this.setFont((Font)state.get(FIELD_FONT));
        this.setRotation(state.getDouble(FIELD_ROTATION));
        this.setText(state.getString(FIELD_TEXT));
        this.setTextColor((Color)state.get(FIELD_TEXT_COLOR));
        this.setDrawWithHalo(state.getBoolean(FIELD_HAS_HALO));
        this.setHaloColor((Color)state.get(FIELD_HALO_COLOR));
        this.setHaloWidth(state.getFloat(FIELD_HALO_WIDTH));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_DESCRIPTION, this.getDescription());
        state.set(FIELD_IS_SHAPE_VISIBLE, this.isShapeVisible());
        state.set(FIELD_REFERENCE_SYSTEM, this.getReferenceSystem());
        state.set(FIELD_UNIT, this.getUnit());
        state.set(FIELD_AUTO_RESIZE, this.isAutoresizeEnabled());
        state.set(FIELD_FONT, (Object)this.getFont());
        state.set(FIELD_ROTATION, this.getRotation());
        state.set(FIELD_TEXT, this.getText());
        state.set(FIELD_TEXT_COLOR, (Object)this.getTextColor());
        state.set(FIELD_HAS_HALO, this.isDrawWithHalo());
        state.set(FIELD_HALO_COLOR, (Object)this.getHaloColor());
        state.set(FIELD_HALO_WIDTH, this.getHaloWidth());
    }
}

