/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddToLocatorExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(AddToLocatorExtension.class);

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view != null) {
            FLayer[] layers = view.getMapContext().getLayers().getActives();
            return layers != null && layers.length > 0;
        }
        return false;
    }

    public void postInitialize() {
        super.postInitialize();
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("layer-addtolocator");
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String command, Object[] args) {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if ("layer-addtolocator".equalsIgnoreCase(command)) {
            FLayer[] layers;
            ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (view == null) {
                return;
            }
            MapContext mapOverViewContext = view.getMapOverViewContext();
            for (FLayer layer : layers = view.getMapContext().getLayers().getActives()) {
                try {
                    mapOverViewContext.getLayers().addLayer(layer.cloneLayer());
                    try {
                        if (mapOverViewContext.getViewPort().getEnvelope() == null && layer.getFullEnvelope() != null) {
                            mapOverViewContext.getViewPort().setEnvelope(layer.getFullEnvelope());
                        }
                    }
                    catch (ReadException ex) {
                        logger.warn("Not able to set Envelope for the overview.", (Throwable)ex);
                    }
                    mapOverViewContext.invalidate();
                    view.setModified(true);
                }
                catch (Exception ex) {
                    logger.warn("Can't add layer '" + layer.getName() + "' to the overview.", (Throwable)ex);
                    application.messageDialog(i18nManager.getTranslation("_Add_to_locator"), i18nManager.getTranslation("_Cant_add_layer_{0}_to_locator", new String[]{layer.getName()}) + "\n\n" + i18nManager.getTranslation("_See_the_error_log_for_more_information"), 2);
                }
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-addtolocator", (Object)((Object)this));
    }
}

