/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.extension.InitializeApplicationExtension;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.complements.RelatedFeatures;
import org.gvsig.fmap.dal.feature.AbstractFeatureTypeDefinitionsManager;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.FeatureTypeDefinitionsManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.util.HasAFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureTypeDefinitionsManager
extends AbstractFeatureTypeDefinitionsManager
implements FeatureTypeDefinitionsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureTypeDefinitionsManager.class);
    private static final String FILE_EXTENSION = "form";
    private File definitionsFolder = null;
    private final Map<String, DynClass> dynClasses = new HashMap<String, DynClass>();

    protected Map<String, DynClass> getDynClasses() {
        return this.dynClasses;
    }

    protected File getDefinitionsFolder() throws IOException {
        if (this.definitionsFolder == null) {
            PluginsManager pluginManager = PluginsLocator.getManager();
            PluginServices plugin = pluginManager.getPlugin(InitializeApplicationExtension.class);
            File homeFolder = plugin.getPluginHomeFolder();
            File theDefinitionsFolder = new File(homeFolder, "schemas");
            if (!theDefinitionsFolder.exists()) {
                FileUtils.forceMkdir((File)theDefinitionsFolder);
            }
            this.definitionsFolder = theDefinitionsFolder;
        }
        return this.definitionsFolder;
    }

    protected long getCRC(FeatureType type) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < type.size(); ++i) {
            FeatureAttributeDescriptor x = type.getAttributeDescriptor(i);
            if (x.isComputed()) continue;
            buffer.append(x.getName());
            buffer.append(x.getDataTypeName());
            buffer.append(x.getSize());
        }
        CRC32 crc = new CRC32();
        byte[] data = buffer.toString().getBytes();
        crc.update(data);
        return crc.getValue();
    }

    protected String getKey(FeatureStore store, FeatureType featureType) {
        if (store == null) {
            return null;
        }
        return store.getName() + "_" + Long.toHexString(this.getCRC(featureType));
    }

    protected String getKey(FeatureStore store, FeatureType featureType, String name) {
        CRC32 crc = new CRC32();
        crc.update(name.getBytes());
        crc.getValue();
        if (!StringUtils.isAlphanumeric((CharSequence)name)) {
            name = StringUtils.removeAll((String)name, (String)"[^a-zA-Z0-9_]");
        }
        return store.getName() + name + "_" + Long.toHexString(this.getCRC(featureType)) + Long.toHexString(crc.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getDefinitionFile(String key) {
        File folder;
        try {
            folder = this.getDefinitionsFolder();
        }
        catch (IOException ex) {
            return null;
        }
        File f = new File(folder, key + "." + FILE_EXTENSION);
        if (f.exists()) {
            return f;
        }
        Properties prop = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(new File(folder, "index.properties"));
            prop.load(fin);
            IOUtils.closeQuietly((InputStream)fin);
        }
        catch (IOException ex) {
            File file = null;
            return file;
        }
        finally {
            IOUtils.closeQuietly(fin);
        }
        String s = prop.getProperty(key, null);
        if (s == null) {
            return null;
        }
        f = new File(folder, s);
        if (f.exists()) {
            return f;
        }
        f = new File(s);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public DynClass get(FeatureStore store, FeatureType featureType) {
        block14: {
            key = this.getKey(store, featureType);
            if (key == null) {
                return this.getDynClass(store, featureType);
            }
            dynClass = this.getDynClasses().get(key);
            if (dynClass != null) {
                return dynClass;
            }
            xml = null;
            resource = null;
            dynObjectManager = ToolsLocator.getDynObjectManager();
            definitionFile = this.getDefinitionFile(key);
            if (store != null && definitionFile == null) {
                resourcesStorage = null;
                try {
                    resourcesStorage = store.getResourcesStorage();
                    if (resourcesStorage == null || (resource = resourcesStorage.getResource("form")) == null || !resource.exists()) ** GOTO lbl24
                    xml = IOUtils.toString((InputStream)resource.asInputStream(), (Charset)StandardCharsets.UTF_8);
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)resourcesStorage);
                }
            } else {
                xml = FileUtils.readFileToString((File)definitionFile, (Charset)StandardCharsets.UTF_8);
                xml = xml.replaceAll("[$][{]CWD[}]", definitionFile.getParentFile().getAbsolutePath());
            }
lbl24:
            // 3 sources

            if (!StringUtils.isEmpty((CharSequence)xml)) {
                is = IOUtils.toInputStream((String)xml, (Charset)StandardCharsets.UTF_8);
                theDynClasses = dynObjectManager.importDynClassDefinitions(is, this.getClass().getClassLoader());
                for (DynClass aDynClass : theDynClasses.values()) {
                    this.getDynClasses().put(aDynClass.getName(), aDynClass);
                }
            }
            if ((dynClass = this.getDynClasses().get(key)) == null) break block14;
            is = dynClass;
            IOUtils.closeQuietly((Closeable)resource);
            return is;
        }
        try {
            is = this.getDynClass(store, featureType);
        }
        catch (Exception ex) {
            try {
                DefaultFeatureTypeDefinitionsManager.LOGGER.warn("Can't retrieve definition of '" + key + "'.", (Throwable)ex);
                var10_12 = null;
            }
            catch (Throwable var13_15) {
                IOUtils.closeQuietly(resource);
                throw var13_15;
            }
            IOUtils.closeQuietly((Closeable)resource);
            return var10_12;
        }
        IOUtils.closeQuietly((Closeable)resource);
        return is;
    }

    public boolean contains(FeatureStore store, FeatureType featureType) {
        String key = this.getKey(store, featureType);
        return this.getDynClasses().containsKey(key);
    }

    public void add(FeatureStore store, FeatureType featureType, DynClass dynClass) {
        try {
            if (dynClass instanceof FeatureType) {
                dynClass = this.getDynClass(store, (FeatureType)dynClass);
            }
            String key = this.getKey(store, featureType);
            File f = new File(this.getDefinitionsFolder(), key + "." + FILE_EXTENSION);
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            String xml = dynObjectManager.exportSimpleDynClassDefinitions(dynClass);
            FileUtils.write((File)f, (CharSequence)xml);
            this.getDynClasses().put(key, dynClass);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void remove(FeatureStore store, FeatureType featureType) {
        String key = this.getKey(store, featureType);
        this.getDynClasses().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addModel(File model) {
        block13: {
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            try {
                File folder;
                FileInputStream is = FileUtils.openInputStream((File)model);
                Map theDynClasses = dynObjectManager.importDynClassDefinitions((InputStream)is, ((Object)((Object)this)).getClass().getClassLoader());
                try {
                    folder = this.getDefinitionsFolder();
                }
                catch (IOException ex) {
                    return;
                }
                Properties prop = new Properties();
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(new File(folder, "index.properties"));
                    prop.load(fin);
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(fin);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fin);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fin);
                for (DynClass aDynClass : theDynClasses.values()) {
                    String className = aDynClass.getName();
                    prop.setProperty(className, model.getAbsolutePath());
                }
                FileOutputStream fout = null;
                try {
                    fout = new FileOutputStream(new File(folder, "index.properties"));
                    prop.store(fout, "");
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(fout);
                    break block13;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fout);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fout);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't parse xml definition.", (Throwable)ex);
            }
        }
    }

    private DynClass getDynClass(FeatureStore store, FeatureType featureType) {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        DynClass_v2 definition = (DynClass_v2)manager.createCopy((DynClass)featureType);
        String label = featureType.getLabel();
        if (!StringUtils.isEmpty((CharSequence)label)) {
            definition.setLabel(label);
        }
        File path = null;
        if (store != null) {
            try {
                File f;
                DataStoreParameters params;
                if (StringUtils.isEmpty((CharSequence)label)) {
                    definition.setLabel(store.getName());
                }
                if ((params = store.getParameters()) instanceof HasAFile && (f = ((HasAFile)params).getFile()) != null) {
                    path = f.getParentFile();
                }
            }
            catch (Exception params) {
                // empty catch block
            }
        }
        boolean calculateLayout = true;
        if (featureType.getTags().has("dynform.layoutmode")) {
            calculateLayout = false;
        }
        for (FeatureAttributeDescriptor descriptor : featureType) {
            RelatedFeatures complement;
            Tags tags;
            String profileName;
            DynField_v2 definitionField = (DynField_v2)definition.getDynField(descriptor.getName());
            if (descriptor.isComputed()) {
                definitionField.setReadOnly(true);
            }
            if (!StringUtils.isBlank((CharSequence)(profileName = descriptor.getDataProfileName()))) {
                definitionField.setSubtype(profileName);
            }
            if (path != null && definitionField.getType() == 13 && !(tags = definitionField.getTags()).has("path")) {
                tags.set("path", (Object)path);
            }
            if (!calculateLayout || !(complement = (RelatedFeatures)ToolsLocator.getComplementsManager().get("DAL.RelatedFeatures", (Object)descriptor)).isRelatedFeatures()) continue;
            definition.getTags().set("dynform.layoutmode", (Object)1);
            definitionField.setGroup(descriptor.getLabel());
        }
        return definition;
    }
}

