/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Dimension;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.webbrowser.WebBrowserFactory;
import org.gvsig.webbrowser.WebBrowserPanel;

public class HelpExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"help-contents", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"help-search", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        WindowManager winmanager = ToolsSwingLocator.getWindowManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        LocaleManager localeManager = PluginsLocator.getLocaleManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        String baseHelpURL = (String)plugin.getPluginProperties().getDynValue("baseHelpURL");
        if (!baseHelpURL.endsWith("/")) {
            baseHelpURL = baseHelpURL + "/";
        }
        Locale locale = localeManager.getCurrentLocale();
        String localeid = locale.getLanguage();
        Object[] localeAlternatives = localeManager.getLocaleAlternatives(locale);
        if (!ArrayUtils.isEmpty((Object[])localeAlternatives)) {
            localeid = ((Locale)localeAlternatives[0]).getLanguage();
        }
        switch (((String)StringUtils.defaultIfEmpty((CharSequence)actionCommand, (CharSequence)"")).toLowerCase()) {
            case "help-contents": {
                WebBrowserPanel webbrowser = WebBrowserFactory.createWebBrowserPanel();
                webbrowser.asJComponent().setPreferredSize(new Dimension(900, 500));
                webbrowser.setPage(baseHelpURL + localeid + "/build/html/user_manual/2.3/index.html");
                winmanager.showWindow(webbrowser.asJComponent(), i18n.getTranslation("_Help_contents"), WindowManager.MODE.WINDOW);
                break;
            }
            case "help-search": {
                WebBrowserPanel webbrowser = WebBrowserFactory.createWebBrowserPanel();
                webbrowser.asJComponent().setPreferredSize(new Dimension(900, 500));
                webbrowser.setPage(baseHelpURL + localeid + "/build/html/gvsigsearch_all.html");
                winmanager.showWindow(webbrowser.asJComponent(), i18n.getTranslation("_Help_contents"), WindowManager.MODE.WINDOW);
                break;
            }
            case "help-showpdf": {
                this.showLocalManual();
            }
        }
    }

    public void showLocalManual() {
        File f;
        LocaleManager localeManager = PluginsLocator.getLocaleManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        String prefix = this.getManPrefix();
        if (prefix == null) {
            return;
        }
        Locale locale = localeManager.getCurrentLocale();
        String localeid = locale.getLanguage();
        Object[] localeAlternatives = localeManager.getLocaleAlternatives(locale);
        if (!ArrayUtils.isEmpty((Object[])localeAlternatives)) {
            localeid = ((Locale)localeAlternatives[0]).getLanguage();
        }
        if (!(f = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man", prefix + "-" + localeid + ".pdf"})).exists()) {
            f = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man", prefix + "-es.pdf"});
        }
        DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
        desktop.open(f);
    }

    private String getManPrefix() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        final Pattern p = Pattern.compile("(gvsig-[0-9.]+-doc-[0-9.]+)-[a-z]+[.]pdf");
        final MutableObject prefix = new MutableObject();
        File folder = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man"});
        Object[] ff = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = p.matcher(name);
                if (m == null || !m.matches()) {
                    return false;
                }
                prefix.setValue((Object)m.group(1));
                return true;
            }
        });
        if (ArrayUtils.isEmpty((Object[])ff)) {
            return null;
        }
        return (String)prefix.getValue();
    }

    public boolean canQueryByAction() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public boolean isEnabled(String action) {
        switch (((String)StringUtils.defaultIfEmpty((CharSequence)action, (CharSequence)"")).toLowerCase()) {
            case "help-showpdf": {
                return this.getManPrefix() != null;
            }
        }
        return true;
    }

    public boolean isVisible(String action) {
        return true;
    }
}

