/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.editedfeatures.EditedFeaturesPanel;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ShowEditedFeatures
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        if ("layer-show-editedfeatures".equalsIgnoreCase(actionCommand)) {
            FLayer layer = application.getCurrentLayer();
            if (layer == null || !(layer instanceof FLyrVect)) {
                return;
            }
            FLyrVect vectLayer = (FLyrVect)layer;
            FeatureStore featureStore = vectLayer.getFeatureStore();
            if (!featureStore.isEditing()) {
                return;
            }
            try {
                FeatureType type = featureStore.getDefaultFeatureType();
                if (!type.supportReferences()) {
                    return;
                }
                I18nManager i18n = ToolsLocator.getI18nManager();
                EditedFeaturesPanel panel = new EditedFeaturesPanel(featureStore);
                WindowManager windowManager = ToolsSwingLocator.getWindowManager();
                String title = ToolsSwingUtils.makeTitle((String)"_Edited_features", (String)layer.getName(), (String)featureStore.getName());
                windowManager.showWindow(panel.asJComponent(), title, WindowManager.MODE.WINDOW);
            }
            catch (Exception ex) {
                logger.warn("Can't show form of edited features", (Throwable)ex);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        FLayer layer = application.getCurrentLayer();
        if (layer == null || !(layer instanceof FLyrVect)) {
            return false;
        }
        return ((FLyrVect)layer).getFeatureStore().isEditing();
    }
}

