/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.extension.ViewInvertSelection;
import org.gvsig.app.gui.preferencespage.ViewPage;
import org.gvsig.app.gui.preferencespage.dal.DALPage;
import org.gvsig.app.gui.preferencespage.databaseworkspace.DatabaseWorkspacePage;
import org.gvsig.app.gui.preferencespage.dialogreminder.DialogReminderPage;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.Encuadrator;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.ExtentListSelectorModel;
import org.gvsig.app.project.documents.view.gui.FPanelExtentSelector;
import org.gvsig.app.project.documents.view.gui.FPanelLocConfig;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toc.gui.FPopupMenu;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewControls
extends Extension
implements IPreferenceExtension {
    private static final Logger logger = LoggerFactory.getLogger(ViewInvertSelection.class);
    private static ViewPage viewPropertiesPage = null;

    public void execute(String s) {
        this.execute(s, null);
    }

    public void execute(String command, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        MapControl mapCtrl = view.getMapControl();
        if (command.equalsIgnoreCase("view-navigation-zoom-all")) {
            Envelope all = mapa.getLayers().getFullEnvelope();
            if (all != null && !all.isEmpty()) {
                mapa.getViewPort().setEnvelope(all);
                document.setModified(true);
            }
        } else if (command.equalsIgnoreCase("view-navigation-frame-manager")) {
            FPanelExtentSelector l = new FPanelExtentSelector();
            ProjectExtension p = (ProjectExtension)PluginServices.getExtension(ProjectExtension.class);
            Project project = p.getProject();
            ExtentListSelectorModel modelo = new ExtentListSelectorModel(project);
            project.addPropertyChangeListener(modelo);
            l.setModel(modelo);
            l.addSelectionListener(new Encuadrator(project, mapa, view));
            document.setModified(true);
            PluginServices.getMDIManager().addWindow((IWindow)l);
        } else if (command.equalsIgnoreCase("view-locator-setup")) {
            FPanelLocConfig m_panelLoc = new FPanelLocConfig(view.getMapOverview());
            PluginServices.getMDIManager().addCentredWindow((IWindow)m_panelLoc);
            document.setModified(true);
        } else if (command.equalsIgnoreCase("view-navigation-pan")) {
            mapCtrl.setTool("pan");
            document.setModified(true);
        } else if (command.equalsIgnoreCase("view-navigation-zoom-in-topoint")) {
            mapCtrl.setTool("zoomIn");
            document.setModified(true);
        } else if (command.equalsIgnoreCase("view-navigation-zoom-out-topoint")) {
            mapCtrl.setTool("zoomOut");
            document.setModified(true);
        } else if (command.equalsIgnoreCase("layer-set-visible")) {
            this.setVisibles(true, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-set-hide")) {
            ViewControls.setActivesVisibles(false, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-set-visible")) {
            ViewControls.setActivesVisibles(true, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-bring-front")) {
            FLayers layers = mapa.getLayers();
            List<FLayer> orderedLayers = this.bringToFront(layers);
            if (orderedLayers != null) {
                layers.clearLayers();
                layers.addAll(orderedLayers);
            }
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-send-back")) {
            FLayers layers = mapa.getLayers();
            List<FLayer> orderedLayers = this.sendToBack(layers);
            if (orderedLayers != null) {
                layers.clearLayers();
                layers.addAll(orderedLayers);
            }
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-move-ahead")) {
            this.moveAhead(mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("active-layer-move-behind")) {
            this.moveBehind(mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("layer-set-hide")) {
            this.setVisibles(false, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("layer-set-active")) {
            this.setActives(true, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("layer-set-inactive")) {
            this.setActives(false, mapa.getLayers());
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("group-set-active-all-layers")) {
            for (FLayer active : mapa.getLayers().getActives()) {
                if (!(active instanceof FLayers)) continue;
                ((FLayers)active).setActive(true, true);
            }
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("group-set-inactive-all-layers")) {
            for (FLayer active : mapa.getLayers().getActives()) {
                if (!(active instanceof FLayers)) continue;
                ((FLayers)active).setActive(false, true);
                ((FLayers)active).setActive(true, false);
            }
            document.setModified(true);
            application.refreshMenusAndToolBars();
        } else if (command.equalsIgnoreCase("view-navigation-zoom-in-center")) {
            mapCtrl.zoomIn();
            document.setModified(true);
        } else if (command.equalsIgnoreCase("view-navigation-zoom-out-center")) {
            mapCtrl.zoomOut();
            document.setModified(true);
        } else if (command.equalsIgnoreCase("view-change-scale")) {
            try {
                Double newscale = (Double)ToolsLocator.getDataTypesManager().coerce(7, arguments.get(0));
                double prevscale = mapa.getScaleView();
                mapa.setScaleView(newscale.doubleValue());
                if (prevscale != newscale) {
                    document.setModified(true);
                }
            }
            catch (Throwable ex) {
                logger.info("Can't change scale of view.", ex);
                application.message("Can't change scale of view.", 0);
            }
        }
    }

    private ViewPage getViewPropertiesPage() {
        if (viewPropertiesPage == null) {
            viewPropertiesPage = new ViewPage();
        }
        return viewPropertiesPage;
    }

    private void setVisibles(boolean visible, FLayers layers) {
        int layerCount = layers.getLayersCount();
        for (int i = 0; i < layerCount; ++i) {
            FLayer layer = layers.getLayer(i);
            layer.setVisible(visible);
            if (!(layer instanceof FLayers)) continue;
            this.setVisibles(visible, (FLayers)layer);
        }
    }

    public static void setActivesVisibles(boolean visible, FLayers layers) {
        int layerCount = layers.getLayersCount();
        for (int i = 0; i < layerCount; ++i) {
            FLayer layer = layers.getLayer(i);
            if (layer.isActive()) {
                layer.setVisible(visible);
            }
            if (!(layer instanceof FLayers)) continue;
            ViewControls.setActivesVisibles(visible, (FLayers)layer);
        }
    }

    private void setActives(boolean active, FLayers layers) {
        int layerCount = layers.getLayersCount();
        for (int i = 0; i < layerCount; ++i) {
            FLayer layer = layers.getLayer(i);
            layer.setActive(active);
            if (!(layer instanceof FLayers)) continue;
            this.setActives(active, (FLayers)layer);
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public void initialize() {
        this.registerIcons();
    }

    public void postInitialize() {
        FPopupMenu.registerExtensionPoint();
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("view-layer-add");
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-in-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-out-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-all", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-in-center", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-out-center", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-pan", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-frame-manager", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo-redo-actions-modify", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo-redo-actions-add", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo-redo-actions-delete", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"dialog-remember-preferences", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"dal-preferences", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"preferences", (String)"databaseworkspace-preferences", (Object)((Object)this));
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        FLayers layers = mapa.getLayers();
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (!layers.getLayer(i).isAvailable()) continue;
            return true;
        }
        return false;
    }

    public IPreference[] getPreferencesPages() {
        ArrayList<AbstractPreferencePage> prefs = new ArrayList<AbstractPreferencePage>();
        prefs.add(this.getViewPropertiesPage());
        prefs.add(new DialogReminderPage());
        prefs.add(new DALPage());
        prefs.add(new DatabaseWorkspacePage());
        return prefs.toArray(new IPreference[prefs.size()]);
    }

    private List<FLayer> bringToFront(FLayers groupLayers) {
        ArrayList<FLayer> res = new ArrayList<FLayer>();
        ArrayList<FLayer> activeLayers = new ArrayList<FLayer>();
        ArrayList<FLayer> nonActiveLayers = new ArrayList<FLayer>();
        for (FLayer layer : groupLayers) {
            FLayers group;
            List<FLayer> layers;
            if (layer.isActive()) {
                activeLayers.add(layer);
            } else {
                nonActiveLayers.add(layer);
            }
            if (!(layer instanceof FLayers) || (layers = this.bringToFront(group = (FLayers)layer)) == null) continue;
            group.clearLayers();
            group.addAll(layers);
        }
        if (activeLayers.isEmpty() || nonActiveLayers.isEmpty()) {
            return null;
        }
        res.addAll(nonActiveLayers);
        res.addAll(activeLayers);
        return res;
    }

    private List<FLayer> sendToBack(FLayers groupLayers) {
        ArrayList<FLayer> res = new ArrayList<FLayer>();
        ArrayList<FLayer> activeLayers = new ArrayList<FLayer>();
        ArrayList<FLayer> nonActiveLayers = new ArrayList<FLayer>();
        for (FLayer layer : groupLayers) {
            FLayers group;
            List<FLayer> layers;
            if (layer.isActive()) {
                activeLayers.add(layer);
            } else {
                nonActiveLayers.add(layer);
            }
            if (!(layer instanceof FLayers) || (layers = this.sendToBack(group = (FLayers)layer)) == null) continue;
            group.clearLayers();
            group.addAll(layers);
        }
        if (activeLayers.isEmpty() || nonActiveLayers.isEmpty()) {
            return null;
        }
        res.addAll(activeLayers);
        res.addAll(nonActiveLayers);
        return res;
    }

    private int getPositionInFlayersGroup(FLayers groupLayers, FLayer layer) {
        for (int i = 0; i < groupLayers.getLayersCount(); ++i) {
            FLayer actualLayer = groupLayers.getLayer(i);
            if (!actualLayer.equals(layer)) continue;
            int correction = groupLayers.getLayersCount() - 1 - i;
            return correction;
        }
        return -1;
    }

    private int getValidTocPosition(int position, FLayers groupLayers, int move) {
        int totalSize = groupLayers.getLayersCount();
        int newPosition = position + move;
        if (newPosition <= 0) {
            return 0;
        }
        if (newPosition >= totalSize) {
            return totalSize - 1;
        }
        return newPosition;
    }

    private List<FLayer> getFirstLevelActivesFromLayers(FLayers groupLayers, boolean reverse) {
        ArrayList<FLayer> actives = new ArrayList<FLayer>();
        for (FLayer layer : groupLayers) {
            if (!layer.isActive()) continue;
            actives.add(layer);
        }
        if (reverse) {
            Collections.reverse(actives);
        }
        return actives;
    }

    private List<FLayers> getFirstLevelGroupsFromLayers(FLayers groupLayers) {
        ArrayList<FLayers> flayers = new ArrayList<FLayers>();
        for (FLayer layer : groupLayers) {
            if (!(layer instanceof FLayers)) continue;
            flayers.add((FLayers)layer);
        }
        Collections.reverse(flayers);
        return flayers;
    }

    private void moveAhead(FLayers groupLayers) {
        List<FLayer> actives = this.getFirstLevelActivesFromLayers(groupLayers, true);
        for (FLayer layer : actives) {
            FLayers layers = layer.getParentLayer();
            int position = this.getPositionInFlayersGroup(layers, layer);
            if (position < 1) {
                FLayers layersParent = layers.getParentLayer();
                if (layersParent == null) continue;
                int layersPosition = this.getPositionInFlayersGroup(layersParent, (FLayer)layers);
                layersParent.add(layersParent.size() - layersPosition, layer);
                layers.remove((Object)layer);
                continue;
            }
            int newPosition = this.getValidTocPosition(position, layers, -1);
            layers.moveTo(position, newPosition);
        }
        List<FLayers> flayersGroup = this.getFirstLevelGroupsFromLayers(groupLayers);
        for (FLayers fLayer : flayersGroup) {
            this.moveAhead(fLayer);
        }
    }

    private void moveBehind(FLayers groupLayers) {
        List<FLayer> actives = this.getFirstLevelActivesFromLayers(groupLayers, false);
        for (FLayer layer : actives) {
            FLayers layers = layer.getParentLayer();
            int position = this.getPositionInFlayersGroup(layers, layer);
            if (position >= layers.size() - 1) {
                FLayers layersParent = layers.getParentLayer();
                if (layersParent == null) continue;
                int layersPosition = this.getPositionInFlayersGroup(layersParent, (FLayer)layers);
                layersParent.add(layersParent.size() - layersPosition - 1, layer);
                layers.remove((Object)layer);
                continue;
            }
            int newPosition = this.getValidTocPosition(position, layers, 1);
            layers.moveTo(position, newPosition);
        }
        List<FLayers> flayersGroup = this.getFirstLevelGroupsFromLayers(groupLayers);
        for (FLayers fLayer : flayersGroup) {
            this.moveBehind(fLayer);
        }
    }
}

