/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewInvertSelection
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewInvertSelection.class);
    private DefaultViewPanel vista;

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-reverse", (Object)((Object)this));
    }

    public void postInitialize() {
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        if (actionCommand.equalsIgnoreCase("selection-reverse-view")) {
            FLayer[] actives;
            for (FLayer lyr : actives = mapa.getLayers().getActives()) {
                SingleLayer lyrSingle;
                DataStore ds;
                if (!lyr.isAvailable() || !(lyr instanceof SingleLayer) || !((ds = (lyrSingle = (SingleLayer)lyr).getDataStore()) instanceof FeatureStore)) continue;
                try {
                    ((FeatureStore)ds).getFeatureSelection().reverse();
                    document.setModified(true);
                }
                catch (DataException e) {
                    NotificationManager.addError((Throwable)e);
                }
            }
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        if (document == null) {
            return false;
        }
        List layers = document.getMapContext().getLayers().getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_SELECTION_AVAILABLE));
        return layers.size() >= 1;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasVectorLayers();
    }
}

