/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.clipboard;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Predicate;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteAlphanumericValuesFromClipboardExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasteAlphanumericValuesFromClipboardExtension.class);
    private static final String TAG_COPYVALUE_LABEL = "PasteAlphanumericValuesFromClipboard.copyValue";

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-clipboard-paste-alphanumeric", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag(TAG_COPYVALUE_LABEL, "Boolean value indicating whether the field's contents should be pasted. True copies the field's value, false does not.");
    }

    public void execute(String actionCommand) {
        FeatureSelection selectionFeatures;
        JsonArray jsonArray;
        if (actionCommand.compareToIgnoreCase("layer-modify-clipboard-paste-alphanumeric") != 0) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        String clipboardValue = application.getFromClipboard();
        if (StringUtils.isBlank((CharSequence)clipboardValue)) {
            application.messageDialog(i18n.getTranslation("_Clipboard_has_no_valid_info_or_is_empty"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 1, "ClipboardEmptyWhenPasteFeatures");
            return;
        }
        try {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(clipboardValue));
            jsonArray = jsonReader.readArray();
            jsonReader.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get JSON from the clipboard.", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Clipboard_has_no_valid_info_or_is_empty"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotValidWhenPasteFeatures");
            return;
        }
        if (jsonArray.size() < 1) {
            application.messageDialog(i18n.getTranslation("_No_features_found_in_clipboard"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotHasElementsWhenPasteFeatures");
            return;
        }
        MapContext mapContext = viewdoc.getMapContext();
        List layers = mapContext.getLayers().getLayers(layer -> layer instanceof FLyrVect && layer.isActive() && layer.isAvailable() && layer.isEditing());
        if (layers.isEmpty()) {
            return;
        }
        FLyrVect layer2 = (FLyrVect)layers.get(0);
        final FeatureStore store = layer2.getFeatureStore();
        try {
            selectionFeatures = store.getFeatureSelection();
        }
        catch (DataException ex) {
            return;
        }
        try {
            if (selectionFeatures.isEmpty()) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        FilteredLogger theLogger = new FilteredLogger(LOGGER, "PasteFeatures", 10);
        Object obj = jsonArray.get(0);
        if (!(obj instanceof JsonObject)) {
            return;
        }
        JsonObject fjson = (JsonObject)obj;
        try {
            boolean hasPk = false;
            FeatureType ft = store.getDefaultFeatureTypeQuietly();
            for (String name : fjson.keySet()) {
                FeatureAttributeDescriptor attr = ft.getAttributeDescriptor(name);
                if (attr == null || !attr.isPrimaryKey()) continue;
                hasPk = true;
                break;
            }
            final boolean copyPk = hasPk && application.confirmDialog(i18n.getTranslation("_Copy_primary_key_values_XQuestionX"), i18n.getTranslation("_Pasting_features_from_clipboard"), 0, 3, "_CopyPrimaryKeyWhenPasteAlphanumericValuesFromClipboard") == 0;
            EditableFeature f = store.createNewFeature(fjson);
            for (Feature selectionFeature : selectionFeatures) {
                EditableFeature eds = selectionFeature.getEditable();
                eds.copyFrom((Feature)f, (Predicate)new Predicate<FeatureAttributeDescriptor>(){

                    @Override
                    public boolean test(FeatureAttributeDescriptor attr) {
                        String nameGeom;
                        try {
                            nameGeom = store.getDefaultFeatureType().getDefaultGeometryAttributeName();
                        }
                        catch (DataException ex) {
                            nameGeom = null;
                        }
                        if (StringUtils.equals((CharSequence)attr.getName(), (CharSequence)nameGeom)) {
                            return false;
                        }
                        if (!copyPk && attr.isPrimaryKey()) {
                            return false;
                        }
                        Tags tags = attr.getTags();
                        if (tags != null && tags.has(PasteAlphanumericValuesFromClipboardExtension.TAG_COPYVALUE_LABEL)) {
                            return tags.getBoolean(PasteAlphanumericValuesFromClipboardExtension.TAG_COPYVALUE_LABEL, true);
                        }
                        return true;
                    }
                });
                selectionFeatures.update(eds);
            }
        }
        catch (Exception ex) {
            theLogger.warn("Can't create feature from JSON.", (Throwable)ex);
        }
        mapContext.invalidate();
    }

    public boolean isEnabled() {
        JsonArray jsonArray;
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return false;
        }
        String clipboardValue = application.getFromClipboard();
        if (StringUtils.isBlank((CharSequence)clipboardValue)) {
            return false;
        }
        try {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(clipboardValue));
            jsonArray = jsonReader.readArray();
            jsonReader.close();
        }
        catch (Exception ex) {
            return false;
        }
        if (jsonArray.size() != 1) {
            return false;
        }
        MapContext mapContext = viewdoc.getMapContext();
        final MutableInt numActiveVectorial = new MutableInt(0);
        final MutableInt numActiveVectorialEditable = new MutableInt(0);
        final MutableInt hasSelection = new MutableInt(0);
        List layers = mapContext.getLayers().getLayers((Predicate)new Predicate<FLayer>(){

            @Override
            public boolean test(FLayer layer) {
                if (layer instanceof FLyrVect && layer.isActive() && layer.isAvailable()) {
                    numActiveVectorial.increment();
                    if (layer.isEditing()) {
                        numActiveVectorialEditable.increment();
                    }
                    if (!((FLyrVect)layer).getFeatureStore().isFeatureSelectionEmpty()) {
                        hasSelection.increment();
                    }
                }
                return false;
            }
        });
        return numActiveVectorialEditable.intValue() == 1 && numActiveVectorial.intValue() == 1 && hasSelection.intValue() > 0;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        Document activeDocument = application.getActiveDocument(ViewManager.TYPENAME);
        return activeDocument != null;
    }
}

