/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.copytable;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.copytable.CopyTable2Process;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParameters;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParametersImpl;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTable2ProcessImpl
implements CopyTable2Process {
    protected final Logger LOGGER = LoggerFactory.getLogger(CopyTable2ProcessImpl.class);
    private CopyTable2ProcessParameters parameters;
    private SimpleTaskStatus status;
    private Runnable postprocess;
    private DataTransaction transaction;
    private FeatureSymbolTable featureSymbolTable;
    private MutableSymbolTable out;

    public CopyTable2ProcessImpl() {
    }

    public CopyTable2ProcessImpl(CopyTable2ProcessParameters parameters, SimpleTaskStatus status, Runnable postprocess) {
        this();
        this.parameters = parameters;
        this.status = status;
        this.postprocess = postprocess;
    }

    @Override
    public void start() {
        Thread th = new Thread(() -> {
            try {
                this.run();
            }
            catch (Exception ex) {
                this.LOGGER.warn("Can't copy table.");
            }
        }, "CopyTableProcess");
        th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            this.transaction = dataManager.createTransaction();
            this.transaction.begin();
            FeatureStore sourceStore = this.parameters.getSourceStore();
            this.transaction.add((DataStore)sourceStore, false);
            FeatureStore targetStore = this.parameters.getTargetStore();
            this.transaction.add((DataStore)targetStore, false);
            this.featureSymbolTable = dataManager.createFeatureSymbolTable();
            this.status.setTitle("Copy table '" + sourceStore.getName() + "'");
            this.status.setIndeterminate();
            this.copy_all();
            this.transaction.commit();
            this.status.terminate();
            this.output();
            this.out.setVar("targetstore", (Object)targetStore);
        }
        catch (Exception ex) {
            this.LOGGER.warn("Can't copy features", (Throwable)ex);
            DataTransaction.rollbackQuietly((DataTransaction)this.transaction);
            this.status.abort();
            String msgStack = BaseException.getHTMLMessageStack((Throwable)ex);
            this.status.message("<html>Can't copy features.<br>\n" + msgStack + "</html>");
        }
        finally {
            if (this.postprocess != null) {
                this.postprocess.run();
            }
            DisposeUtils.dispose((Disposable)this.transaction);
        }
    }

    public void copy_all() throws DataException {
        DataManager dataManager = DALLocator.getDataManager();
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        try {
            FeatureStore source = this.parameters.getSourceStore();
            FeatureStore target = this.parameters.getTargetStore();
            Expression sourceFilter = this.parameters.getSourceFilter();
            String targetFieldJoin = this.parameters.getTargetFieldForJoin();
            String sourceFieldJoin = this.parameters.getSourceFieldForJoin();
            boolean updateIfExistsTarget = this.parameters.isUpdateIfExistsTargetActive();
            Expression updateIfExistsInTargetCondition = this.parameters.getUpdateIfExistsInTargetCondition();
            boolean insertIfNotExistsTarget = this.parameters.isInsertIfNotExistsTargetActive();
            Expression joinExpression = this.parameters.getJoinExpression();
            this.beginEditing();
            FeatureSet sourceSet = source.getFeatureSet(sourceFilter);
            this.status.restart();
            this.status.setRangeOfValues(0L, sourceSet.size64());
            this.status.setCurValue(0L);
            FeatureSymbolTable targetSymbolTable = dataManager.createFeatureSymbolTable();
            MutableSymbolTable symbolTable = targetSymbolTable.createParent();
            FeatureSymbolTable sourceSymbolTable = dataManager.createFeatureSymbolTable();
            symbolTable.addSymbolTable((SymbolTable)sourceSymbolTable);
            boolean copyall = joinExpression == null && (StringUtils.isBlank((CharSequence)sourceFieldJoin) || StringUtils.isBlank((CharSequence)targetFieldJoin));
            for (Feature sourceFeature : sourceSet) {
                EditableFeature targetEditableFeature;
                if (copyall) {
                    targetEditableFeature = target.createNewFeature();
                    this.copyData(sourceFeature, targetEditableFeature);
                    target.insert(targetEditableFeature);
                } else {
                    Feature targetFeature = null;
                    sourceSymbolTable.setFeature(sourceFeature);
                    if (joinExpression != null) {
                        Expression exp = expressionManager.resolveHostExpressions(joinExpression, (SymbolTable)sourceSymbolTable);
                        targetFeature = target.findFirst(exp);
                    } else if (StringUtils.isNotBlank((CharSequence)sourceFieldJoin) && StringUtils.isNotBlank((CharSequence)targetFieldJoin)) {
                        ExpressionBuilder builder = target.createExpressionBuilder();
                        String s = builder.eq((ExpressionBuilder.Value)builder.column(targetFieldJoin), (ExpressionBuilder.Value)builder.constant(sourceFeature.get(sourceFieldJoin))).toString();
                        targetFeature = target.findFirst(s);
                    }
                    if (targetFeature == null) {
                        if (insertIfNotExistsTarget) {
                            targetEditableFeature = target.createNewFeature();
                            this.copyData(sourceFeature, targetEditableFeature);
                            target.insert(targetEditableFeature);
                        }
                    } else if (updateIfExistsTarget) {
                        boolean update = true;
                        if (this.parameters.isMustUpdateWhenSourceAndTargetAreNotEquals()) {
                            update = !sourceFeature.toString().equals(targetFeature.toString());
                        } else if (updateIfExistsInTargetCondition != null) {
                            targetSymbolTable.setFeature(targetFeature);
                            targetSymbolTable.setVar("$SOURCE", (Object)sourceFeature);
                            targetSymbolTable.setVar("$TARGET", (Object)targetFeature);
                            update = DataTypeUtils.toBoolean((Object)updateIfExistsInTargetCondition.execute((SymbolTable)symbolTable), (boolean)false);
                        }
                        if (update) {
                            targetEditableFeature = targetFeature.getEditable();
                            this.copyData(sourceFeature, targetEditableFeature);
                            target.update(targetEditableFeature);
                        }
                    }
                }
                this.status.incrementCurrentValue();
                this.restart_editing();
            }
            this.endEditing();
            ApplicationLocator.getManager().refreshDocument(target);
            this.status.terminate();
        }
        catch (Exception ex) {
            this.status.abort();
            this.LOGGER.warn("Can't copy data.", (Throwable)ex);
        }
    }

    private void copyData(Feature sourceFeature, EditableFeature targetFeature) {
        FeatureType ft = targetFeature.getType();
        for (CopyTable2ProcessParameters.ProcessFieldParameters field : this.parameters) {
            FeatureAttributeDescriptor attr;
            if (!field.isCopyThisFieldActive() || (attr = ft.getAttributeDescriptor(field.getName())).isComputed() || targetFeature.isUpdatable() && attr.isReadOnly()) continue;
            Expression expression = field.getExpression();
            if (ExpressionUtils.isPhraseEmpty((Expression)expression)) {
                targetFeature.set(field.getName(), null);
                continue;
            }
            this.featureSymbolTable.setFeature(sourceFeature);
            Object x = expression.execute((SymbolTable)this.featureSymbolTable);
            targetFeature.set(field.getName(), x);
        }
    }

    private void beginEditing() throws DataException {
        if (!this.parameters.isBeginEditIfNeed()) {
            return;
        }
        FeatureStore store = this.parameters.getTargetStore();
        if (store.getMode() != 0 && this.parameters.isFinishAndRestarEdit()) {
            store.finishEditing();
        }
        store.edit(this.parameters.getEditMode());
    }

    private void endEditing() throws DataException {
        if (this.parameters.isFinishEditAfterTerminate()) {
            FeatureStore store = this.parameters.getTargetStore();
            store.finishEditing();
        }
    }

    private void restart_editing() throws DataException {
        int n = this.parameters.getFinishAndRestarEditEach();
        if (n < 1) {
            return;
        }
        FeatureStore store = this.parameters.getTargetStore();
        switch (store.getMode()) {
            case 2: 
            case 3: {
                return;
            }
        }
        if (store.getMode() != 1) {
            return;
        }
        if (store.getPendingChangesCount() < (long)n) {
            return;
        }
        store.finishEditing();
        store.edit(this.parameters.getEditMode());
    }

    @Override
    public SymbolTable output() {
        if (this.out == null) {
            this.out = ExpressionUtils.createSymbolTable();
        }
        return this.out;
    }

    @Override
    public CopyTable2Process setParameters(CopyTable2ProcessParameters params) {
        this.parameters = params;
        return this;
    }

    @Override
    public CopyTable2Process setStatus(SimpleTaskStatus taskStatus) {
        this.status = taskStatus;
        return this;
    }

    @Override
    public CopyTable2Process setPostProcess(Runnable postProcess) {
        this.postprocess = postProcess;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters createParameters() {
        return new CopyTable2ProcessParametersImpl();
    }

    @Override
    public CopyTable2ProcessParameters getParameters() {
        return this.parameters;
    }

    @Override
    public SimpleTaskStatus getStatus() {
        return this.status;
    }
}

