/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.develtools;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.andami.ui.mdiFrame.SelectableToolBar;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.develtools.IconThemeDevelTool;
import org.gvsig.app.extension.develtools.InfoPanel;
import org.gvsig.app.extension.develtools.MenusDevelTool;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class ActionsInfoDevelTool {
    public void showActions() {
        String html = "<html>\n<body>\n" + this.getActionsInformation(null) + "</body>\n</html>\n";
        InfoPanel.save2file("actions-report", html);
        InfoPanel.showPanel("Actions information", WindowManager.MODE.WINDOW, html);
    }

    public void showToolBars() {
        ActionInfoManager actionsManager = PluginsLocator.getActionInfoManager();
        MainFrame mainFrame = ApplicationLocator.getManager().getMainFrame();
        SelectableToolBar[] toolbars = mainFrame.getToolbars();
        Arrays.sort(toolbars, new Comparator<SelectableToolBar>(){

            @Override
            public int compare(SelectableToolBar o1, SelectableToolBar o2) {
                return Integer.compare(o1.getPosition(), o2.getPosition());
            }
        });
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>\n");
        buffer.append("<body>\n");
        buffer.append("<div>\n");
        buffer.append("<h2>Toolbars information</h2>\n");
        buffer.append("<br>\n");
        buffer.append("<table border=\"0\">\n");
        buffer.append("  <tr>\n");
        buffer.append("    <td>Position</td>\n");
        buffer.append("    <td>Name</td>\n");
        buffer.append("    <td></td>\n");
        buffer.append("    <td>Plugin</td>\n");
        buffer.append("  </tr>\n");
        for (SelectableToolBar toolBar : toolbars) {
            Component item;
            buffer.append("  <tr valign=\"top\">\n");
            buffer.append("    <td>").append(toolBar.getPosition()).append("</td>\n");
            buffer.append("    <td colspan=\"3\"><b>").append(toolBar.getName()).append("</b> - ").append(toolBar.getDescription()).append("</td>\n");
            buffer.append("  </tr>\n");
            int i = 0;
            while ((item = toolBar.getComponentAtIndex(i)) != null) {
                String name = item.getName();
                ActionInfo action = null;
                if (name != null) {
                    action = actionsManager.getAction(name);
                }
                buffer.append("  <tr valign=\"top\">\n");
                buffer.append("    <td></td>\n");
                buffer.append("    <td>");
                buffer.append(name);
                buffer.append("    </td>\n");
                if (action != null) {
                    buffer.append("    <td>");
                    buffer.append(action.getPosition());
                    buffer.append("</td>\n");
                    buffer.append("    <td>");
                    buffer.append(action.getPluginName());
                    buffer.append("</td>\n");
                } else {
                    buffer.append("    <td></td>\n");
                    buffer.append("    <td></td>\n");
                }
                buffer.append("  </tr>\n");
                ++i;
            }
        }
        buffer.append("</table>\n");
        buffer.append("</div>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        String html = buffer.toString();
        InfoPanel.save2file("toolbars-report", html);
        InfoPanel.showPanel("Toolbars report", WindowManager.MODE.WINDOW, html);
    }

    public void showReportOfPlugin() {
        ApplicationManager application = ApplicationLocator.getManager();
        String pluginName = null;
        pluginName = application.inputDialog("Introduzca el nombre del plugin del que desea el informe", "Plugin actions report");
        if (pluginName == null) {
            return;
        }
        String actionsHtml = this.getActionsInformation(pluginName);
        String menusHtml = new MenusDevelTool().getMenusOfPlugin(pluginName);
        String iconsHtml = new IconThemeDevelTool().getIconThemeInformationOfPlugin(pluginName);
        String html = "<html>\n<body>\n" + actionsHtml + "<br>" + menusHtml + "<br>" + iconsHtml + "</body>\n</html>\n";
        InfoPanel.showInBrowser("report-byplugin", "Report " + pluginName, html);
    }

    public String getActionsInformation(String pluginName) {
        String previousPluginName = null;
        String warning_open = "<b>";
        String warning_close = "</b>";
        String error_open = "<b><font color=\"red\">";
        String error_close = "</font></b>";
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<body>\n");
        buffer.append("<div>\n");
        buffer.append("<h2>Actions information </h2>\n");
        buffer.append("<br>\n");
        buffer.append("<table border=\"0\">\n");
        buffer.append("  <tr>\n");
        buffer.append("    <td>Plugin</td>\n");
        buffer.append("    <td>Extension</td>\n");
        buffer.append("    <td>Name</td>\n");
        buffer.append("    <td>Position</td>\n");
        buffer.append("    <td>Text</td>\n");
        buffer.append("    <td>Command</td>\n");
        buffer.append("    <td>Icon</td>\n");
        buffer.append("    <td>Tip</td>\n");
        buffer.append("    <td>Accelerator</td>\n");
        buffer.append("  </tr>\n");
        Iterator actions = PluginsLocator.getActionInfoManager().getActions();
        while (actions.hasNext()) {
            ActionInfo action = (ActionInfo)actions.next();
            if (pluginName != null && !pluginName.equalsIgnoreCase(action.getPluginName())) continue;
            if (previousPluginName != null && !action.getPluginName().equals(previousPluginName)) {
                buffer.append("  <tr>\n").append("    <td colspan=\"9\"><hr></td>\n").append("  </tr>\n");
                previousPluginName = action.getPluginName();
            }
            buffer.append("  <tr valign=\"top\">\n");
            buffer.append("    <td>").append(action.getPluginName()).append("</td>\n");
            buffer.append("    <td>").append(action.getExtensionName()).append("</td>\n");
            if (action.getName().startsWith("anonymous__")) {
                buffer.append("    <td title=\"Missing action name, asigned one by default\">").append(error_open).append(action.getName()).append(error_close).append("</td>\n");
            } else if (!action.getName().contains("-")) {
                buffer.append("    <td title=\"Name don't have recomended syntax\">").append(warning_open).append(action.getName()).append(warning_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getName()).append("</td>\n");
            }
            if (action.getPosition() < 100000000L) {
                buffer.append("    <td title=\"Incorrect position\">").append(error_open).append(MenusDevelTool.formatPosition(action.getPosition())).append(error_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(MenusDevelTool.formatPosition(action.getPosition())).append("</td>\n");
            }
            if (action.getLabel() == null) {
                buffer.append("    <td title=\"Missing label of action\">").append(error_open).append("(missing)").append(error_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getLabel()).append("</td>\n");
            }
            if (action.getCommand() == null) {
                buffer.append("    <td title=\"Missing command of action\">").append(error_open).append(action.getCommand()).append(error_close).append("</td>\n");
            } else if (!action.getCommand().contains("-") && !action.getCommand().equals(action.getName())) {
                buffer.append("    <td title=\"Command don't have recomended syntax and differ fron action name\">").append(warning_open).append(action.getCommand()).append(warning_close).append("</td>\n");
            } else if (!action.getCommand().contains("-")) {
                buffer.append("    <td title=\"Command don't have recomended syntax\">").append(warning_open).append(action.getCommand()).append(warning_close).append("</td>\n");
            } else if (!action.getCommand().equals(action.getName())) {
                buffer.append("    <td title=\"Command differ fron action name\">").append(warning_open).append(action.getCommand()).append(warning_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getCommand()).append("</td>\n");
            }
            if (action.getIconName() == null) {
                buffer.append("    <td title=\"Missing icon name\">").append(error_open).append("(missing)").append(error_close).append("</td>\n");
            } else if (action.getIcon() == null) {
                buffer.append("    <td title=\"Missing icon\">").append(error_open).append(action.getIconName()).append(error_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getIconName()).append("</td>\n");
            }
            if (action.getTooltip() == null) {
                buffer.append("    <td title=\"Missing tooltip\">").append(error_open).append(action.getTooltip()).append(error_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getTooltip()).append("</td>\n");
            }
            if (action.getAccelerator() != null && action.getKeyStroke() == null) {
                buffer.append("    <td title=\"Incorrect syntax of the accelerator key\">").append(error_open).append(action.getAccelerator()).append(error_close).append("</td>\n");
            } else {
                buffer.append("    <td>").append(action.getAccelerator()).append("</td>\n");
            }
            buffer.append("  </tr>\n");
        }
        buffer.append("</table>\n");
        buffer.append("</div>\n");
        return buffer.toString();
    }
}

