/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.evalexpression.notifierfactory;

import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.evalexpression.notifierfactory.AbstractUpdaterFactory;
import org.gvsig.app.extension.evalexpression.notifierfactory.UpdaterFactory;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class CurrentLayerSelectionChangedFactory
extends AbstractUpdaterFactory {
    public CurrentLayerSelectionChangedFactory() {
        super("CurrentLayerSelectionChanged", "Actualizar cuando cambie la seleccion de la capa activa");
    }

    @Override
    public UpdaterFactory.Updater create(Observer observer) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc != null) {
            FLyrVect layer = viewdoc.getMapContext().getLayers().getFirstActiveVectorLayer();
            CurrentLayerSelectionChangedUpdater updater = new CurrentLayerSelectionChangedUpdater(this, observer, layer);
            return updater;
        }
        return null;
    }

    private static class CurrentLayerSelectionChangedUpdater
    extends AbstractUpdaterFactory.AbstractUpdater {
        private final Observer selectionListener;
        private FLyrVect layer;

        public CurrentLayerSelectionChangedUpdater(UpdaterFactory factory, Observer observer, FLyrVect layer) {
            super(factory, observer);
            if (layer == null) {
                throw new IllegalArgumentException();
            }
            final CurrentLayerSelectionChangedUpdater updater = this;
            this.layer = layer;
            this.selectionListener = new Observer(){

                public void update(Observable observable, Object notification) {
                    FeatureStoreNotification n = (FeatureStoreNotification)notification;
                    if (n.isOfType("after_SelectionChange_DataStore")) {
                        updater.update();
                    }
                }
            };
        }

        @Override
        public void add() {
            FeatureStore store = this.layer.getFeatureStore();
            if (store != null) {
                store.deleteObserver(this.selectionListener);
                store.addObserver(this.selectionListener);
            }
        }

        @Override
        public void remove() {
            FeatureStore store = this.layer.getFeatureStore();
            if (store != null) {
                store.deleteObserver(this.selectionListener);
            }
        }
    }
}

