/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.evalexpression.notifierfactory;

import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.evalexpression.notifierfactory.AbstractUpdaterFactory;
import org.gvsig.app.extension.evalexpression.notifierfactory.UpdaterFactory;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.observer.Observer;

public class ViewExtentChangedFactory
extends AbstractUpdaterFactory {
    public ViewExtentChangedFactory() {
        super("ViewExtentChanged", "Actualizar cuando cambie el encuadre de la Vista activa");
    }

    @Override
    public UpdaterFactory.Updater create(Observer observer) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        IWindow window = doc.getMainWindow();
        if (window instanceof IView) {
            MapControl mapControl = ((IView)window).getMapControl();
            ViewPort viewPort = mapControl.getMapContext().getViewPort();
            ViewExtentChangedUpdater notifier = new ViewExtentChangedUpdater(this, observer, viewPort);
            return notifier;
        }
        return null;
    }

    private static class ViewExtentChangedUpdater
    extends AbstractUpdaterFactory.AbstractUpdater {
        private final ViewPort viewPort;
        private final ViewPortListener viewPortListener;

        public ViewExtentChangedUpdater(UpdaterFactory factory, Observer observer, ViewPort viewPort) {
            super(factory, observer);
            if (viewPort == null) {
                throw new IllegalArgumentException();
            }
            this.viewPort = viewPort;
            final ViewExtentChangedUpdater updater = this;
            this.viewPortListener = new ViewPortListener(){

                public void extentChanged(ExtentEvent e) {
                    updater.update();
                }

                public void backColorChanged(ColorEvent e) {
                }

                public void projectionChanged(ProjectionEvent e) {
                }
            };
        }

        @Override
        public void add() {
            this.viewPort.removeViewPortListener(this.viewPortListener);
            this.viewPort.addViewPortListener(this.viewPortListener);
        }

        @Override
        public void remove() {
            this.viewPort.removeViewPortListener(this.viewPortListener);
        }
    }
}

