/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.geometriespalette;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.addlayer.AddLayerDialog;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.extension.geometriespalette.GeometriesPalettePanel;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class GeometriesPaletteExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"tools-open-geometriespalette", (CharSequence)actionCommand)) {
            this.doOpenGeometriesPalette();
        }
    }

    public void execute(String command, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        if (StringUtils.equalsIgnoreCase((CharSequence)"tools-open-geometriespalette", (CharSequence)command)) {
            String labelattr = (String)arguments.get("label", String.class, null);
            String tableName = (String)arguments.get("tableName", String.class, null);
            String title = (String)arguments.get("title", String.class, null);
            String filter = (String)arguments.get("filter", String.class, null);
            if (StringUtils.isBlank((CharSequence)tableName)) {
                this.doOpenGeometriesPalette();
                return;
            }
            this.doOpenGeometriesPalette(tableName, labelattr, title, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doOpenGeometriesPalette() {
        MapControl mapControl;
        MapContext mapContext;
        AddLayerDialog addLayerDialog;
        block13: {
            block12: {
                block11: {
                    addLayerDialog = null;
                    WindowManager windowManager = ToolsSwingLocator.getWindowManager();
                    MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
                    MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
                    mapContext = mapContextManager.createMapContext();
                    mapControl = null;
                    try {
                        ApplicationManager application = ApplicationLocator.getApplicationManager();
                        ViewDocument view = (ViewDocument)application.getCurrentProject().getFirstDocument(ViewDocument.class);
                        if (view == null || view.getProjection() == null) {
                            mapContext.setProjection(CRSFactory.getCRS((String)"EPSG:4326"));
                        } else {
                            mapContext.setProjection(view.getProjection());
                        }
                        mapControl = mapControlManager.createJMapControlPanel(mapContext);
                        addLayerDialog = AddLayer.createAddLayerDialog(mapControl, mapContext, null);
                        Dimension screensize = ToolsSwingUtils.getCurrentScreenSize();
                        ToolsSwingUtils.ensureHeightWitdh((JComponent)addLayerDialog, (int)(3 * (screensize.height / 4)), (int)(2 * (screensize.width / 4)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
                        windowManager.showWindow((JComponent)addLayerDialog, "Select palette layer", WindowManager.MODE.DIALOG);
                        if (!addLayerDialog.isAccepted()) {
                            DisposeUtils.disposeQuietly((Disposable)mapContext);
                            DisposeUtils.disposeQuietly((Disposable)addLayerDialog);
                            break block11;
                        }
                        if (!(addLayerDialog.getSelectedTab() instanceof WizardPanel)) {
                            DisposeUtils.disposeQuietly((Disposable)mapContext);
                            DisposeUtils.disposeQuietly((Disposable)addLayerDialog);
                            break block12;
                        }
                        WizardPanel panel = (WizardPanel)addLayerDialog.getSelectedTab();
                        panel.executeWizard();
                        DisposeUtils.disposeQuietly((Disposable)addLayerDialog);
                        break block13;
                    }
                    catch (Exception ex) {
                        logger.warn("Can't open palete from layer", (Throwable)ex);
                        DisposeUtils.disposeQuietly((Disposable)mapContext);
                        return;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)mapControl);
                return;
            }
            DisposeUtils.disposeQuietly((Disposable)mapControl);
            return;
        }
        DisposeUtils.disposeQuietly((Disposable)mapControl);
        Thread task = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < 30; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (mapContext.getLayers().isEmpty()) continue;
                        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
                        FeatureStore store = layer.getFeatureStore();
                        DisposeUtils.bind((Disposable)store);
                        SwingUtilities.invokeLater(() -> GeometriesPalettePanel.showPalette(store, null, layer.getName(), null));
                        return;
                    }
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)mapContext);
                }
            }
        }, "GeometriesPaletteLayerLoader");
        task.start();
        return;
        finally {
            DisposeUtils.disposeQuietly(addLayerDialog);
            DisposeUtils.disposeQuietly(mapControl);
        }
    }

    private void doOpenGeometriesPalette(String tableName, String labelattr, String title, String filter) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStore store = dataManager.getStoresRepository().getStore(tableName);
        if (!(store instanceof FeatureStore)) {
            logger.warn("The table name '" + tableName + "' is not valid.");
            return;
        }
        FeatureStore featureStore = (FeatureStore)store;
        GeometriesPalettePanel.showPalette(featureStore, labelattr, title, filter);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

