/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.updatetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.updatetable.UpdateTablePanelView;
import org.gvsig.app.extension.updatetable.UpdateTableProcessParameters;
import org.gvsig.app.extension.updatetable.UpdateTableProcessParametersImpl;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.expressionevaluator.swing.JExpressionPicker;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributesSelectionPanel;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.documentfilters.IntegerDocumentFilter;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.ToolsUtilLocator;

public class UpdateTablePanelImpl
extends UpdateTablePanelView {
    private static final String BOOKMARKSANDHISTORY_NAME = "UpdateTablePanel";
    private static final String CONFIGURABLE_PANEL_ID = "UpdateTablePanel";
    private FeatureStore table;
    private ExpressionPickerController pickerTableFilter;
    private DefaultTableColumnModel fieldsColumnModel;
    private SimpleTaskStatus taskStatus;
    private TaskStatusController status;
    private List<String> previewColumns;
    private final Bookmarks bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup("UpdateTablePanel");
    private final History history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup("UpdateTablePanel");
    private BookmarksController bookmarksController;
    private HistoryController historyController;
    private StoresRepositoryController treeTableController;
    private DataSwingManager dataSwingManager;

    public UpdateTablePanelImpl() {
        this.initComponents();
    }

    private DataSwingManager getDataSwingManager() {
        if (this.dataSwingManager == null) {
            this.dataSwingManager = DALSwingLocator.getSwingManager();
        }
        return this.dataSwingManager;
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblEditMode);
        toolsSwingManager.translate(this.lblFieldsFieldsToCopy);
        toolsSwingManager.translate(this.lblNumberOfChanges);
        toolsSwingManager.translate(this.lblRecordsLabel1);
        toolsSwingManager.translate(this.lblRecordsLabel11);
        toolsSwingManager.translate(this.lblSourceTable);
        toolsSwingManager.translate((AbstractButton)this.rdoOptionsFulledit);
        toolsSwingManager.translate((AbstractButton)this.rdoOptionsPassthrought);
        toolsSwingManager.translate((AbstractButton)this.rdoRecordsAll);
        toolsSwingManager.translate((AbstractButton)this.rdoRecordsEditeds);
        toolsSwingManager.translate((AbstractButton)this.rdoRecordsSelecteds);
        toolsSwingManager.translate((AbstractButton)this.chkOptionsBeginEditIfNeed);
        toolsSwingManager.translate((AbstractButton)this.chkOptionsFinishAndRestarEditEach);
        toolsSwingManager.translate((AbstractButton)this.chkOptionsFinishEditAfterTerminate);
        toolsSwingManager.translate((AbstractButton)this.chkOptionsNotifyUserIfNeedBeginEditing);
        toolsSwingManager.translate((AbstractButton)this.btnFieldsDeselectAll);
        toolsSwingManager.translate((AbstractButton)this.btnFieldsSelectAll);
        toolsSwingManager.translate((AbstractButton)this.btnRecordsConfigurePreviewColumns);
        toolsSwingManager.translate((AbstractButton)this.btnRecordsUpdatePreview);
        toolsSwingManager.translate(this.tabMain);
    }

    private void initComponents() {
        this.translate();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        cfgActionsManager.addConfigurableActions("UpdateTablePanel", (Object)this, (JComponent)this.btnConfigurableActions);
        this.bookmarksController = ToolsSwingLocator.getToolsSwingManager().createBookmarksController(this.bookmarks, this.btnBookmarks);
        this.historyController = ToolsSwingLocator.getToolsSwingManager().createHistoryController(this.history, this.btnHistory);
        this.historyController.setFilter(null);
        ActionListener bookmarksAndHistoryListener = e -> {
            ActionEventWithCurrentValue event = (ActionEventWithCurrentValue)e;
            switch (event.getID()) {
                case 1002: {
                    event.setCurrentValue((Object)this.fetch(null));
                    break;
                }
                case 1001: {
                    this.put((UpdateTableProcessParameters)event.getCurrentValue());
                }
            }
        };
        this.historyController.addActionListener(bookmarksAndHistoryListener);
        this.bookmarksController.addActionListener(bookmarksAndHistoryListener);
        this.rdoOptionsFulledit.setSelected(true);
        this.rdoOptionsFulledit.addActionListener(e -> this.doChangeSelectedEditMode());
        this.rdoOptionsPassthrought.setSelected(false);
        this.rdoOptionsPassthrought.addActionListener(e -> this.doChangeSelectedEditMode());
        this.rdoRecordsAll.setSelected(true);
        this.rdoRecordsEditeds.setSelected(false);
        this.rdoRecordsSelecteds.setSelected(false);
        this.status = ToolsSwingLocator.getTaskStatusSwingManager().createTaskStatusController(null, this.lblStatusLabel, this.lblStatusMessage, this.pbStatus, this.btnCancelStatus, null);
        this.treeTableController = this.getDataSwingManager().createStoresRepositoryController(this.treeTable);
        this.treeTable.addTreeSelectionListener(e -> this.doChangeTable());
        this.pickerTableFilter = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtRecordFilter, this.btnRecordFilter, this.btnRecordFilterBookmarks, this.btnRecordFilterHistory);
        this.pickerTableFilter.addChangeListener(e -> this.doUpdatePreviewTable());
        this.tableFields.setAutoCreateColumnsFromModel(false);
        this.tableFields.setSelectionMode(0);
        this.fieldsColumnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setHeaderValue(i18n.getTranslation("_Update"));
        column.setCellRenderer(null);
        column.setResizable(true);
        column.setModelIndex(0);
        this.fieldsColumnModel.addColumn(column);
        column = new TableColumn();
        column.setHeaderValue(i18n.getTranslation("_Field"));
        column.setCellRenderer(null);
        column.setCellEditor(null);
        column.setResizable(true);
        column.setModelIndex(1);
        this.fieldsColumnModel.addColumn(column);
        column = new TableColumn();
        column.setHeaderValue(i18n.getTranslation("_Expression"));
        column.setCellRenderer(new ExpressionCellRenderer());
        column.setCellEditor(new ExpressionCellEditor());
        column.setResizable(true);
        column.setModelIndex(2);
        this.fieldsColumnModel.addColumn(column);
        this.tableFields.setColumnModel(this.fieldsColumnModel);
        this.btnRecordsUpdatePreview.addActionListener(e -> this.doUpdatePreviewTable());
        this.btnRecordsConfigurePreviewColumns.addActionListener(e -> this.doConfigurePreviewColumns());
        this.btnRecordsUpdatePreview.setEnabled(false);
        this.btnRecordsConfigurePreviewColumns.setVisible(false);
        this.tblRecordsPreview.setVisible(false);
        this.btnFieldsDeselectAll.addActionListener(e -> {
            MyTableModel model = (MyTableModel)this.tableFields.getModel();
            for (MyTableModel.Row row : model) {
                row.update = false;
            }
            model.fireTableDataChanged();
        });
        this.btnFieldsSelectAll.addActionListener(e -> {
            MyTableModel model = (MyTableModel)this.tableFields.getModel();
            for (MyTableModel.Row row : model) {
                row.update = true;
            }
            model.fireTableDataChanged();
        });
        IntegerDocumentFilter.install((JTextField)this.txtOptionsFinishAndRestarEditEach);
        toolsSwingManager.removeBorder((JComponent)this.tblRecordsPreview);
        this.rdoRecordsAll.addActionListener(e -> this.doUpdateRecordsPreview());
        this.rdoRecordsEditeds.addActionListener(e -> this.doUpdateRecordsPreview());
        this.rdoRecordsSelecteds.addActionListener(e -> this.doUpdateRecordsPreview());
        this.tableFields.setModel(new MyTableModel());
        SwingUtilities.invokeLater(() -> {
            this.lblStatusLabel.setText("");
            this.lblStatusMessage.setText("");
            this.status.setVisible(false);
        });
        this.chkOptionsFinishEditAfterTerminate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateTablePanelImpl.this.doChangeFinishEditAfterTerminate();
            }
        });
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)this, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
    }

    private void doUpdateRecordsPreview() {
        if (this.table == null) {
            this.tblRecordsPreview.setVisible(false);
            this.btnRecordsConfigurePreviewColumns.setVisible(false);
            this.btnRecordsUpdatePreview.setVisible(false);
            return;
        }
        SimpleFeaturesTableModel model = this.rdoRecordsAll.isSelected() ? this.getDataSwingManager().createSimpleFeaturesTableModel(this.table, this.pickerTableFilter.get()) : (this.rdoRecordsEditeds.isSelected() ? this.getDataSwingManager().createSimpleEditedFeaturesTableModel(this.table, this.pickerTableFilter.get()) : (this.rdoRecordsSelecteds.isSelected() ? this.getDataSwingManager().createSimpleSelectedFeaturesTableModel(this.table, this.pickerTableFilter.get()) : this.getDataSwingManager().createSimpleFeaturesTableModel(this.table, this.pickerTableFilter.get())));
        model.setCellRenderers(this.tblRecordsPreview);
        this.tblRecordsPreview.setModel((TableModel)model);
        this.tblRecordsPreview.setVisible(true);
        this.btnRecordsConfigurePreviewColumns.setVisible(false);
        this.btnRecordsUpdatePreview.setVisible(false);
        this.btnRecordsUpdatePreview.setEnabled(true);
    }

    private void doChangeTable() {
        this.table = this.treeTableController.getSelectedFeatureStore();
        if (this.table == null) {
            return;
        }
        this.getDataSwingManager().configureExpressionBuilder(this.pickerTableFilter.getConfig(), this.table);
        this.tableFields.setModel(new MyTableModel());
        this.doUpdateRecordsPreview();
        FeatureStoreProviderFactory providerFactory = (FeatureStoreProviderFactory)this.getTable().getProviderFactory();
        switch (providerFactory.supportPassthroughMode()) {
            case 2: {
                this.rdoOptionsPassthrought.setSelected(false);
                this.rdoOptionsFulledit.setSelected(true);
                break;
            }
        }
    }

    private void doUpdatePreviewTable() {
        FeatureType ftype = this.table.getDefaultFeatureTypeQuietly();
        SimpleFeaturesTableModel model = this.getDataSwingManager().createSimpleFeaturesTableModel(ftype, this.previewColumns, this.table.getFeatures(this.pickerTableFilter.get()));
        this.tblRecordsPreview.setModel((TableModel)model);
        this.btnRecordsConfigurePreviewColumns.setVisible(true);
        this.tblRecordsPreview.setVisible(true);
        if (this.previewColumns == null) {
            this.previewColumns = model.getColumnNames();
        }
    }

    private void doConfigurePreviewColumns() {
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        FeatureType ftype = this.table.getDefaultFeatureTypeQuietly();
        FeatureAttributesSelectionPanel panelSelectColumns = DALSwingLocator.getManager().createFeatureAttributeSelectionPanel();
        panelSelectColumns.allowCalculatedAttributes(false);
        panelSelectColumns.setFeatureType(ftype);
        panelSelectColumns.setSelectedNames(this.previewColumns);
        Dialog dialog = winmanager.createDialog(panelSelectColumns.asJComponent(), i18n.getTranslation("_Select_the_columns_to_display"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                this.previewColumns = panelSelectColumns.getSelectedNames();
                this.doUpdatePreviewTable();
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public FeatureStore getTable() {
        return this.table;
    }

    public Expression getTableFilter() {
        return this.pickerTableFilter.get();
    }

    public SimpleTaskStatus getStatus() {
        if (this.taskStatus == null) {
            this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Copy table");
            this.status.bind((TaskStatus)this.taskStatus);
        }
        this.status.setVisible(true);
        return this.taskStatus;
    }

    public void put(UpdateTableProcessParameters params) {
        this.table = null;
        switch (params.getEditMode()) {
            default: {
                this.rdoOptionsFulledit.setSelected(true);
                this.rdoOptionsPassthrought.setSelected(false);
                break;
            }
            case 3: {
                this.rdoOptionsFulledit.setSelected(false);
                this.rdoOptionsPassthrought.setSelected(true);
            }
        }
        this.chkOptionsBeginEditIfNeed.setSelected(params.isBeginEditIfNeed());
        this.chkOptionsFinishAndRestarEditEach.setSelected(params.isFinishAndRestarEdit());
        this.chkOptionsNotifyUserIfNeedBeginEditing.setSelected(params.isNotifyUserIfNeedBeginEditing());
        this.chkOptionsFinishEditAfterTerminate.setSelected(params.isFinishEditAfterTerminate());
        IntegerDocumentFilter.setValue((JTextField)this.txtOptionsFinishAndRestarEditEach, (int)params.getFinishAndRestarEditEach());
        switch (params.getRowsToProcess()) {
            case 1: {
                this.rdoRecordsSelecteds.setSelected(true);
                this.rdoRecordsEditeds.setSelected(false);
                this.rdoRecordsAll.setSelected(false);
                break;
            }
            case 2: {
                this.rdoRecordsSelecteds.setSelected(false);
                this.rdoRecordsEditeds.setSelected(true);
                this.rdoRecordsAll.setSelected(false);
                break;
            }
            case 0: {
                this.rdoRecordsSelecteds.setSelected(false);
                this.rdoRecordsEditeds.setSelected(false);
                this.rdoRecordsAll.setSelected(true);
            }
        }
        this.doChangeFinishEditAfterTerminate();
        this.table = params.getStore();
        MyTableModel fieldsModel = new MyTableModel();
        this.tableFields.setModel(fieldsModel);
        for (MyTableModel.Row row : fieldsModel.rows) {
            UpdateTableProcessParameters.ProcessFieldParameters paramfield = params.get(row.getAttrname());
            row.setExpression(paramfield.getExpression().getPhrase());
            row.setUpdate(paramfield.isUpdate());
        }
        fieldsModel.fireTableDataChanged();
    }

    public UpdateTableProcessParameters fetch(UpdateTableProcessParameters params) {
        if (this.tableFields.isEditing()) {
            this.tableFields.getCellEditor().stopCellEditing();
        }
        if (params == null) {
            params = new UpdateTableProcessParametersImpl();
        }
        params.setStore(this.table);
        if (this.rdoRecordsSelecteds.isSelected()) {
            params.setRowsToProcess(1);
        }
        if (this.rdoRecordsEditeds.isSelected()) {
            params.setRowsToProcess(2);
        }
        if (this.rdoRecordsAll.isSelected()) {
            params.setRowsToProcess(0);
        }
        MyTableModel model = (MyTableModel)this.tableFields.getModel();
        for (MyTableModel.Row row : model) {
            Expression exp = null;
            if (StringUtils.isNotBlank((String)row.getExpression())) {
                exp = ExpressionUtils.createExpression((String)row.getExpression());
            }
            params.add(row.getAttrname(), row.isUpdate(), exp);
        }
        if (this.rdoOptionsFulledit.isSelected()) {
            params.setEditMode(1);
        } else {
            params.setEditMode(3);
        }
        params.setBeginEditIfNeed(this.chkOptionsBeginEditIfNeed.isSelected());
        params.setFinishAndRestarEdit(this.chkOptionsFinishAndRestarEditEach.isSelected() && this.chkOptionsFinishEditAfterTerminate.isSelected());
        params.setNotifyUserIfNeedBeginEditing(this.chkOptionsNotifyUserIfNeedBeginEditing.isSelected());
        params.setFinishEditAfterTerminate(this.chkOptionsFinishEditAfterTerminate.isSelected());
        params.setFinishAndRestarEditEach(IntegerDocumentFilter.getValue((JTextField)this.txtOptionsFinishAndRestarEditEach));
        params.setFilter(this.pickerTableFilter.get());
        this.history.add((Object)params);
        return params;
    }

    public void postProcess() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::postProcess);
            return;
        }
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        return null;
    }

    private void doChangeSelectedEditMode() {
        if (this.rdoOptionsPassthrought.isSelected()) {
            this.chkOptionsBeginEditIfNeed.setEnabled(false);
            this.chkOptionsFinishAndRestarEditEach.setEnabled(false);
            this.chkOptionsFinishEditAfterTerminate.setEnabled(false);
            this.chkOptionsNotifyUserIfNeedBeginEditing.setEnabled(false);
            this.txtOptionsFinishAndRestarEditEach.setEnabled(false);
            this.rdoOptionsFulledit.setSelected(false);
        }
        if (this.rdoOptionsFulledit.isSelected()) {
            this.chkOptionsBeginEditIfNeed.setEnabled(true);
            this.chkOptionsFinishAndRestarEditEach.setEnabled(true);
            this.chkOptionsFinishEditAfterTerminate.setEnabled(true);
            this.chkOptionsNotifyUserIfNeedBeginEditing.setEnabled(true);
            this.txtOptionsFinishAndRestarEditEach.setEnabled(true);
        }
    }

    public static int confirmUpdateTableParameters(UpdateTableProcessParameters params) {
        int n;
        if (params.getStore() == null) {
            return 1;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        for (UpdateTableProcessParameters.ProcessFieldParameters param : params) {
            int n2;
            if (!param.isUpdate() || !ExpressionUtils.isEmpty((Expression)param.getExpression()) || (n2 = dialogs.confirmDialog(i18n.getTranslation("_There_is_some_selected_field_whose_expression_is_empty") + "\n" + i18n.getTranslation("_The_values_for_that_field_will_be_deleted_from_the_selected_records") + "\n" + i18n.getTranslation("_Do_you_want_to_continue_executing_the_table_update_process"), i18n.getTranslation("_Update_table"), 0, 3, "_Execute_the_table_update_process_even_when_has_empty_expressions")) == 0) continue;
            return n2;
        }
        if (params.getStore() instanceof FeatureStore && params.getStore().getMode() != 0 && params.isNotifyUserIfNeedBeginEditing() && (n = dialogs.confirmDialog(i18n.getTranslation("_The_data_source_is_currently_being_edited") + "\n" + i18n.getTranslation("_If_you_run_this_process_and_any_problem_occurs_the_data_that_has_not_yet_been_saved_will_be_lost") + "\n" + i18n.getTranslation("_It_is_recommended_to_finish_editing_before_running_this_process") + "\n" + i18n.getTranslation("_Do_you_want_to_continue_executing_the_table_update_process"), i18n.getTranslation("_Update_table"), 0, 3, "_Execute_the_table_update_process_even_when_the_data_source_is_being_edited")) != 0) {
            return n;
        }
        return 0;
    }

    void setColumnNames(String names) {
        if (StringUtils.isBlank((String)names)) {
            return;
        }
        MyTableModel model = (MyTableModel)this.tableFields.getModel();
        if (StringUtils.isBlank((String)names)) {
            for (MyTableModel.Row row : model) {
                row.update = false;
            }
            model.fireTableDataChanged();
            return;
        }
        List<String> columnNames = Arrays.asList(StringUtils.split((String)names, (String)","));
        int currow = 0;
        int numrow = 0;
        for (MyTableModel.Row row : model) {
            if (ContainerUtils.contains(columnNames, (Object)row.getAttrname(), (Comparator)ContainerUtils.EQUALS_IGNORECASE_COMPARATOR)) {
                row.update = true;
                numrow = currow;
            } else {
                row.update = false;
            }
            ++currow;
        }
        model.fireTableDataChanged();
        SwingUtilities.invokeLater(() -> this.tabMain.setSelectedIndex(2));
        int n = numrow;
        SwingUtilities.invokeLater(() -> {
            this.tableFields.changeSelection(n, 2, false, false);
            this.tableFields.requestFocusInWindow();
            this.tableFields.editCellAt(n, 2);
            ExpressionCellEditor editor = (ExpressionCellEditor)this.tableFields.getCellEditor(n, 2);
            if (editor != null) {
                editor.picker.asJComponent().requestFocusInWindow();
            }
        });
    }

    void setUseSelection(Boolean useSelection) {
        if (useSelection == null) {
            return;
        }
        if (useSelection.booleanValue()) {
            this.rdoRecordsSelecteds.setSelected(true);
            this.rdoRecordsAll.setSelected(false);
            this.rdoRecordsEditeds.setSelected(false);
        } else {
            this.rdoRecordsSelecteds.setSelected(false);
            this.rdoRecordsAll.setSelected(true);
            this.rdoRecordsEditeds.setSelected(false);
        }
        this.doUpdateRecordsPreview();
        SwingUtilities.invokeLater(() -> this.tabMain.setSelectedIndex(2));
    }

    void setStore(FeatureStore store) {
        if (store == null) {
            return;
        }
        this.treeTableController.setSelectedStore(store);
        this.doChangeTable();
        SwingUtilities.invokeLater(() -> this.tabMain.setSelectedIndex(1));
    }

    private void doChangeFinishEditAfterTerminate() {
        boolean enable = this.chkOptionsFinishEditAfterTerminate.isSelected();
        this.chkOptionsFinishAndRestarEditEach.setEnabled(enable);
        this.txtOptionsFinishAndRestarEditEach.setEnabled(enable);
    }

    private class MyTableModel
    extends AbstractTableModel
    implements Iterable<Row> {
        private final List<Row> rows;
        private final String[] columnNames;
        private final Class[] columnClass;
        private final FeatureType tableType;

        public MyTableModel() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.rows = new ArrayList<Row>();
            if (UpdateTablePanelImpl.this.table != null) {
                this.tableType = UpdateTablePanelImpl.this.table.getDefaultFeatureTypeQuietly();
                for (FeatureAttributeDescriptor targetAttr : this.tableType) {
                    Row row = new Row(UpdateTablePanelImpl.this.getDataSwingManager().getAttributeDescriptorLabel(targetAttr), targetAttr.getName(), null, !targetAttr.isAutomatic() && !targetAttr.isReadOnly() && !targetAttr.isPrimaryKey());
                    this.rows.add(row);
                }
            } else {
                this.tableType = null;
            }
            this.columnNames = new String[]{i18n.getTranslation("_Update"), i18n.getTranslation("_Field"), i18n.getTranslation("_Expression")};
            this.columnClass = new Class[]{Boolean.class, String.class, String.class};
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClass[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex).get(columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.rows.get(rowIndex).set(columnIndex, aValue);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (this.tableType == null) {
                return false;
            }
            FeatureAttributeDescriptor attrdesc = this.tableType.getAttributeDescriptor(rowIndex);
            if (attrdesc == null) {
                return false;
            }
            if (attrdesc.isAutomatic() || attrdesc.isReadOnly() || attrdesc.isPrimaryKey()) {
                return false;
            }
            switch (columnIndex) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return this.rows.get(rowIndex).isUpdate();
                }
            }
            return false;
        }

        @Override
        public Iterator<Row> iterator() {
            return this.rows.iterator();
        }

        private class Row {
            String attrname;
            String attrlabel;
            String expression;
            boolean update;

            public Row(String attrlabel, String attrname, String expression, boolean update) {
                this.attrlabel = attrlabel;
                this.attrname = attrname;
                this.expression = expression;
                this.update = update;
            }

            public Object get(int index) {
                switch (index) {
                    case 0: {
                        return this.update;
                    }
                    case 1: {
                        return this.attrlabel;
                    }
                    case 2: {
                        return this.expression;
                    }
                }
                return null;
            }

            public void set(int index, Object value) {
                switch (index) {
                    case 0: {
                        this.update = (Boolean)value;
                        break;
                    }
                    case 1: {
                        this.attrlabel = (String)value;
                        break;
                    }
                    case 2: {
                        this.expression = (String)value;
                        break;
                    }
                }
            }

            public String getAttrname() {
                return this.attrname;
            }

            public String getExpression() {
                return this.expression;
            }

            public boolean isUpdate() {
                return this.update;
            }

            private void setExpression(String expression) {
                this.expression = expression;
            }

            private void setUpdate(boolean update) {
                this.update = update;
            }
        }
    }

    private class ExpressionCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JExpressionPicker picker;

        public ExpressionCellEditor() {
            ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
            this.picker = manager.createJExpressionPicker();
            this.picker.removeBorder();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
            try {
                DataSwingManager manager = DALSwingLocator.getDataSwingManager();
                manager.configureExpressionBuilder(this.picker.getConfig(), UpdateTablePanelImpl.this.table);
                if (value == null) {
                    this.picker.setExpression(null);
                } else {
                    this.picker.setExpression(ExpressionUtils.createExpression((String)((String)value)));
                }
                return this.picker.asJComponent();
            }
            catch (Exception ex) {
                return new JLabel();
            }
        }

        @Override
        public Object getCellEditorValue() {
            Expression exp = this.picker.getExpression();
            if (exp == null) {
                return null;
            }
            return exp.getPhrase();
        }
    }

    private class ExpressionCellRenderer
    extends DefaultTableCellRenderer {
        private final JExpressionPicker picker;

        public ExpressionCellRenderer() {
            ExpressionEvaluatorSwingManager manager = ExpressionEvaluatorSwingLocator.getManager();
            this.picker = manager.createJExpressionPicker();
            this.picker.removeBorder();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                MyTableModel model = (MyTableModel)table.getModel();
                if (model.isCellEditable(row, column)) {
                    if (value == null) {
                        this.picker.setExpression(null);
                    } else {
                        this.picker.setExpression(ExpressionUtils.createExpression((String)((String)value)));
                    }
                    JComponent comp = this.picker.asJComponent();
                    if (isSelected) {
                        comp.setForeground(table.getSelectionForeground());
                        comp.setBackground(table.getSelectionBackground());
                    } else {
                        Color alternateColor;
                        Color background = table.getBackground();
                        if ((background == null || background instanceof UIResource) && (alternateColor = UIManager.getColor("Table.alternateRowColor")) != null && row % 2 != 0) {
                            background = alternateColor;
                        }
                        comp.setForeground(table.getForeground());
                        comp.setBackground(background);
                    }
                    return comp;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            catch (Exception ex) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }

    private class FeatureAttributeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final AttributeDescriptorPickerController picker;
        private final JComboBox combo;

        public FeatureAttributeCellEditor() {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            this.combo = new JComboBox();
            this.picker = dataSwingManager.createAttributeDescriptorPickerController(this.combo);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.picker.clean();
                return this.combo;
            }
            this.picker.setFeatureType(UpdateTablePanelImpl.this.table.getDefaultFeatureTypeQuietly());
            this.picker.setAllowNull(true);
            this.picker.set(Objects.toString(value, ""));
            return this.combo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.picker.getName();
        }
    }
}

